/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkPaymentCheckEntity;
import com.bringspring.contract.entity.RkPaymentCheckRelationEntity;
import com.bringspring.contract.mapper.RkPaymentCheckMapper;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckPagination;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckUpForm;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentVo;
import com.bringspring.contract.service.RkPaymentCheckRelationService;
import com.bringspring.contract.service.RkPaymentCheckService;
import com.bringspring.contract.service.RkProcurePaymentRelationService;
import com.bringspring.contract.service.RkProcurePaymentService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkPaymentCheckServiceImpl
extends ServiceImpl<RkPaymentCheckMapper, RkPaymentCheckEntity>
implements RkPaymentCheckService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProcurePaymentRelationService rkProcurePaymentRelationService;
    @Autowired
    private RkPaymentCheckRelationService rkPaymentCheckRelationService;
    @Autowired
    private RkProcurePaymentService rkProcurePaymentService;

    @Override
    public List<RkPaymentCheckEntity> getList(RkPaymentCheckPagination rkPaymentCheckPagination) {
        Long sec;
        Long fir;
        Object rkPaymentCheckObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkPaymentCheckNum = 0;
        QueryWrapper rkPaymentCheckQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkPaymentCheckObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkPaymentCheckQueryWrapper, rkPaymentCheckPagination.getMenuId(), "rkPaymentCheck"));
            if (ObjectUtil.isEmpty((Object)rkPaymentCheckObj)) {
                return new ArrayList<RkPaymentCheckEntity>();
            }
            rkPaymentCheckQueryWrapper = (QueryWrapper)rkPaymentCheckObj;
            ++rkPaymentCheckNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkPaymentCheckObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkPaymentCheckQueryWrapper, rkPaymentCheckPagination.getMenuId(), "rkPaymentCheck"));
            if (ObjectUtil.isEmpty((Object)rkPaymentCheckObj)) {
                return new ArrayList<RkPaymentCheckEntity>();
            }
            rkPaymentCheckQueryWrapper = (QueryWrapper)rkPaymentCheckObj;
            ++rkPaymentCheckNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkPaymentCheckPagination.getCheckCode())) {
            ++rkPaymentCheckNum;
            rkPaymentCheckQueryWrapper.lambda().like(RkPaymentCheckEntity::getCheckCode, (Object)rkPaymentCheckPagination.getCheckCode());
        }
        if (ObjectUtil.isNotEmpty(rkPaymentCheckPagination.getCheckDate())) {
            ++rkPaymentCheckNum;
            List<String> CheckDateList = rkPaymentCheckPagination.getCheckDate();
            fir = Long.valueOf(CheckDateList.get(0));
            sec = Long.valueOf(CheckDateList.get(1));
            ((LambdaQueryWrapper)rkPaymentCheckQueryWrapper.lambda().ge(RkPaymentCheckEntity::getCheckDate, (Object)new Date(fir))).le(RkPaymentCheckEntity::getCheckDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty(rkPaymentCheckPagination.getCheckPaymentDate())) {
            ++rkPaymentCheckNum;
            List<String> CheckPaymentDateList = rkPaymentCheckPagination.getCheckPaymentDate();
            fir = Long.valueOf(CheckPaymentDateList.get(0));
            sec = Long.valueOf(CheckPaymentDateList.get(1));
            ((LambdaQueryWrapper)rkPaymentCheckQueryWrapper.lambda().ge(RkPaymentCheckEntity::getCheckPaymentDate, (Object)new Date(fir))).le(RkPaymentCheckEntity::getCheckPaymentDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkPaymentCheckQueryWrapper.lambda().in(RkPaymentCheckEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkPaymentCheckPagination.getSidx())) {
            rkPaymentCheckQueryWrapper.lambda().orderByDesc(RkPaymentCheckEntity::getId);
        } else {
            try {
                String sidx = rkPaymentCheckPagination.getSidx();
                RkPaymentCheckEntity rkPaymentCheckEntity = new RkPaymentCheckEntity();
                Field declaredField = rkPaymentCheckEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkPaymentCheckQueryWrapper = "asc".equals(rkPaymentCheckPagination.getSort().toLowerCase()) ? (QueryWrapper)rkPaymentCheckQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkPaymentCheckQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkPaymentCheckPagination.getCurrentPage(), rkPaymentCheckPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkPaymentCheckQueryWrapper);
            return rkPaymentCheckPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkPaymentCheckPagination.setData(list, list.size());
    }

    @Override
    public List<RkPaymentCheckEntity> getTypeList(RkPaymentCheckPagination rkPaymentCheckPagination, String dataType) {
        Long sec;
        Long fir;
        Object rkPaymentCheckObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkPaymentCheckNum = 0;
        QueryWrapper rkPaymentCheckQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkPaymentCheckObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkPaymentCheckQueryWrapper, rkPaymentCheckPagination.getMenuId(), "rkPaymentCheck"));
            if (ObjectUtil.isEmpty((Object)rkPaymentCheckObj)) {
                return new ArrayList<RkPaymentCheckEntity>();
            }
            rkPaymentCheckQueryWrapper = (QueryWrapper)rkPaymentCheckObj;
            ++rkPaymentCheckNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkPaymentCheckObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkPaymentCheckQueryWrapper, rkPaymentCheckPagination.getMenuId(), "rkPaymentCheck"));
            if (ObjectUtil.isEmpty((Object)rkPaymentCheckObj)) {
                return new ArrayList<RkPaymentCheckEntity>();
            }
            rkPaymentCheckQueryWrapper = (QueryWrapper)rkPaymentCheckObj;
            ++rkPaymentCheckNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkPaymentCheckPagination.getCheckCode())) {
            ++rkPaymentCheckNum;
            rkPaymentCheckQueryWrapper.lambda().like(RkPaymentCheckEntity::getCheckCode, (Object)rkPaymentCheckPagination.getCheckCode());
        }
        if (ObjectUtil.isNotEmpty(rkPaymentCheckPagination.getCheckDate())) {
            ++rkPaymentCheckNum;
            List<String> CheckDateList = rkPaymentCheckPagination.getCheckDate();
            fir = Long.valueOf(CheckDateList.get(0));
            sec = Long.valueOf(CheckDateList.get(1));
            ((LambdaQueryWrapper)rkPaymentCheckQueryWrapper.lambda().ge(RkPaymentCheckEntity::getCheckDate, (Object)new Date(fir))).le(RkPaymentCheckEntity::getCheckDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty(rkPaymentCheckPagination.getCheckPaymentDate())) {
            ++rkPaymentCheckNum;
            List<String> CheckPaymentDateList = rkPaymentCheckPagination.getCheckPaymentDate();
            fir = Long.valueOf(CheckPaymentDateList.get(0));
            sec = Long.valueOf(CheckPaymentDateList.get(1));
            ((LambdaQueryWrapper)rkPaymentCheckQueryWrapper.lambda().ge(RkPaymentCheckEntity::getCheckPaymentDate, (Object)new Date(fir))).le(RkPaymentCheckEntity::getCheckPaymentDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkPaymentCheckQueryWrapper.lambda().in(RkPaymentCheckEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkPaymentCheckPagination.getSidx())) {
            rkPaymentCheckQueryWrapper.lambda().orderByDesc(RkPaymentCheckEntity::getId);
        } else {
            try {
                String sidx = rkPaymentCheckPagination.getSidx();
                RkPaymentCheckEntity rkPaymentCheckEntity = new RkPaymentCheckEntity();
                Field declaredField = rkPaymentCheckEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkPaymentCheckQueryWrapper = "asc".equals(rkPaymentCheckPagination.getSort().toLowerCase()) ? (QueryWrapper)rkPaymentCheckQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkPaymentCheckQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkPaymentCheckPagination.getCurrentPage(), rkPaymentCheckPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkPaymentCheckQueryWrapper);
                return rkPaymentCheckPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkPaymentCheckPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkPaymentCheckQueryWrapper);
    }

    @Override
    public RkPaymentCheckEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkPaymentCheckEntity::getId, (Object)id);
        return (RkPaymentCheckEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkPaymentCheckEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkPaymentCheckEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateCheck(String id, RkPaymentCheckUpForm rkPaymentCheckUpForm) {
        List<RkPaymentVo> payList = rkPaymentCheckUpForm.getPayList();
        List jsonToList = JsonUtil.getJsonToList(payList, RkPaymentCheckRelationEntity.class);
        jsonToList.stream().forEach(payment -> {
            payment.setCheckId(id);
            payment.setCreatorTime(DateUtil.daFormatDate((Long)rkPaymentCheckUpForm.getCreatorTime()));
            payment.setCreatorUserId(rkPaymentCheckUpForm.getCreatorUserId());
        });
        this.rkPaymentCheckRelationService.saveOrUpdateBatch(jsonToList);
        List<RkPaymentCheckRelationEntity> listByPayId = this.rkPaymentCheckRelationService.listByPayId(id);
        List collect = listByPayId.stream().map(RkPaymentCheckRelationEntity::getPayId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect)) {
            List list = this.rkProcurePaymentService.listByIds(collect);
            list.stream().forEach(payment -> {
                RkPaymentCheckRelationEntity checkInfo = this.rkPaymentCheckRelationService.getInfoByCheckId(id, payment.getId());
                payment.setCheckAmount(MathUtils.substract(payment.getPaymentAmount(), checkInfo.getCheckAmount()));
            });
            this.rkProcurePaymentService.saveOrUpdateBatch(list);
        }
        RkPaymentCheckEntity entity = (RkPaymentCheckEntity)JsonUtil.getJsonToBean((Object)((Object)rkPaymentCheckUpForm), RkPaymentCheckEntity.class);
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        RkPaymentCheckEntity entity = this.getInfo(id);
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 3 || enableMark == 5) {
            entity.setAccumulatePaymentAmount(BigDecimal.ZERO);
            List<RkPaymentCheckRelationEntity> listByPayId = this.rkPaymentCheckRelationService.listByPayId(id);
            List collect = listByPayId.stream().map(RkPaymentCheckRelationEntity::getPayId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                List list = this.rkProcurePaymentService.listByIds(collect);
                list.stream().forEach(payment -> {
                    RkPaymentCheckRelationEntity checkInfo = this.rkPaymentCheckRelationService.getInfoByCheckId(id, payment.getId());
                    payment.setCheckAmount(MathUtils.add(payment.getCheckAmount(), checkInfo.getCheckAmount()));
                });
                this.rkProcurePaymentService.saveOrUpdateBatch(list);
            }
        }
        if (enableMark == 2) {
            Date nowDate = DateUtil.getNowDate();
            List<RkPaymentCheckRelationEntity> listByPayId = this.rkPaymentCheckRelationService.listByPayId(id);
            if (CollectionUtil.isNotEmpty(listByPayId)) {
                listByPayId.forEach(a -> a.setActualPayDate(nowDate));
                this.rkPaymentCheckRelationService.updateBatchById(listByPayId);
                List ids = listByPayId.stream().map(RkPaymentCheckRelationEntity::getPayId).distinct().collect(Collectors.toList());
                List paymentList = this.rkProcurePaymentService.listByIds(ids);
                paymentList.forEach(b -> {
                    if (ObjectUtil.isEmpty((Object)b.getActualPayDate())) {
                        b.setActualPayDate(nowDate);
                    }
                });
                this.rkProcurePaymentService.updateBatchById(paymentList);
            }
            entity.setEnableMark("complete");
            entity.setCheckPaymentDate(nowDate);
        }
        return this.updateById(entity);
    }

    @Override
    public void delete(RkPaymentCheckEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<RkPaymentCheckEntity> getListByProcureId(String procureId) {
        QueryWrapper rkPaymentCheckQueryWrapper = new QueryWrapper();
        return this.list((Wrapper)rkPaymentCheckQueryWrapper);
    }
}

