/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProcureChangeEntity;
import com.bringspring.contract.entity.RkProcureChangeRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.mapper.RkProcureChangeMapper;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractprocure.OaRecordSubitemCrCrmForm;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangePagination;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangeUpForm;
import com.bringspring.contract.service.OaFileCrmServic;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProcureChangeRelationService;
import com.bringspring.contract.service.RkProcureChangeService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProcureChangeServiceImpl
extends ServiceImpl<RkProcureChangeMapper, RkProcureChangeEntity>
implements RkProcureChangeService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProcureChangeRelationService rkProcureChangeRelationService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private OaFileCrmServic oaFileCrmServic;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public List<RkProcureChangeEntity> getList(RkProcureChangePagination rkProcureChangePagination) {
        Object rkProcureChangeObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcureChangeNum = 0;
        QueryWrapper rkProcureChangeQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureChangeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureChangeQueryWrapper, rkProcureChangePagination.getMenuId(), "rkProcureChange"));
            if (ObjectUtil.isEmpty((Object)rkProcureChangeObj)) {
                return new ArrayList<RkProcureChangeEntity>();
            }
            rkProcureChangeQueryWrapper = (QueryWrapper)rkProcureChangeObj;
            ++rkProcureChangeNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureChangeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureChangeQueryWrapper, rkProcureChangePagination.getMenuId(), "rkProcureChange"));
            if (ObjectUtil.isEmpty((Object)rkProcureChangeObj)) {
                return new ArrayList<RkProcureChangeEntity>();
            }
            rkProcureChangeQueryWrapper = (QueryWrapper)rkProcureChangeObj;
            ++rkProcureChangeNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureChangePagination.getChangeCode())) {
            ++rkProcureChangeNum;
            rkProcureChangeQueryWrapper.lambda().like(RkProcureChangeEntity::getChangeCode, (Object)rkProcureChangePagination.getChangeCode());
        }
        if (ObjectUtil.isNotEmpty(rkProcureChangePagination.getChangeDate())) {
            ++rkProcureChangeNum;
            List<String> ChangeDateList = rkProcureChangePagination.getChangeDate();
            Long fir = Long.valueOf(ChangeDateList.get(0));
            Long sec = Long.valueOf(ChangeDateList.get(1));
            ((LambdaQueryWrapper)rkProcureChangeQueryWrapper.lambda().ge(RkProcureChangeEntity::getChangeDate, (Object)new Date(fir))).le(RkProcureChangeEntity::getChangeDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureChangePagination.getProcureName())) {
            ++rkProcureChangeNum;
            rkProcureChangeQueryWrapper.lambda().like(RkProcureChangeEntity::getProcureName, (Object)rkProcureChangePagination.getProcureName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureChangePagination.getSupplierId())) {
            ++rkProcureChangeNum;
            rkProcureChangeQueryWrapper.lambda().like(RkProcureChangeEntity::getSupplierId, (Object)rkProcureChangePagination.getSupplierId());
        }
        if (AllIdList.size() > 0) {
            rkProcureChangeQueryWrapper.lambda().in(RkProcureChangeEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkProcureChangePagination.getSidx())) {
            rkProcureChangeQueryWrapper.lambda().orderByDesc(RkProcureChangeEntity::getId);
        } else {
            try {
                String sidx = rkProcureChangePagination.getSidx();
                RkProcureChangeEntity rkProcureChangeEntity = new RkProcureChangeEntity();
                Field declaredField = rkProcureChangeEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcureChangeQueryWrapper = "asc".equals(rkProcureChangePagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcureChangeQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcureChangeQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProcureChangePagination.getCurrentPage(), rkProcureChangePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProcureChangeQueryWrapper);
            return rkProcureChangePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkProcureChangePagination.setData(list, list.size());
    }

    @Override
    public List<RkProcureChangeEntity> getTypeList(RkProcureChangePagination rkProcureChangePagination, String dataType) {
        Object rkProcureChangeObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcureChangeNum = 0;
        QueryWrapper rkProcureChangeQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureChangeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureChangeQueryWrapper, rkProcureChangePagination.getMenuId(), "rkProcureChange"));
            if (ObjectUtil.isEmpty((Object)rkProcureChangeObj)) {
                return new ArrayList<RkProcureChangeEntity>();
            }
            rkProcureChangeQueryWrapper = (QueryWrapper)rkProcureChangeObj;
            ++rkProcureChangeNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureChangeObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureChangeQueryWrapper, rkProcureChangePagination.getMenuId(), "rkProcureChange"));
            if (ObjectUtil.isEmpty((Object)rkProcureChangeObj)) {
                return new ArrayList<RkProcureChangeEntity>();
            }
            rkProcureChangeQueryWrapper = (QueryWrapper)rkProcureChangeObj;
            ++rkProcureChangeNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureChangePagination.getChangeCode())) {
            ++rkProcureChangeNum;
            rkProcureChangeQueryWrapper.lambda().like(RkProcureChangeEntity::getChangeCode, (Object)rkProcureChangePagination.getChangeCode());
        }
        if (ObjectUtil.isNotEmpty(rkProcureChangePagination.getChangeDate())) {
            ++rkProcureChangeNum;
            List<String> ChangeDateList = rkProcureChangePagination.getChangeDate();
            Long fir = Long.valueOf(ChangeDateList.get(0));
            Long sec = Long.valueOf(ChangeDateList.get(1));
            ((LambdaQueryWrapper)rkProcureChangeQueryWrapper.lambda().ge(RkProcureChangeEntity::getChangeDate, (Object)new Date(fir))).le(RkProcureChangeEntity::getChangeDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureChangePagination.getProcureName())) {
            ++rkProcureChangeNum;
            rkProcureChangeQueryWrapper.lambda().like(RkProcureChangeEntity::getProcureName, (Object)rkProcureChangePagination.getProcureName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureChangePagination.getSupplierId())) {
            ++rkProcureChangeNum;
            rkProcureChangeQueryWrapper.lambda().like(RkProcureChangeEntity::getSupplierId, (Object)rkProcureChangePagination.getSupplierId());
        }
        if (AllIdList.size() > 0) {
            rkProcureChangeQueryWrapper.lambda().in(RkProcureChangeEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkProcureChangePagination.getSidx())) {
            rkProcureChangeQueryWrapper.lambda().orderByDesc(RkProcureChangeEntity::getId);
        } else {
            try {
                String sidx = rkProcureChangePagination.getSidx();
                RkProcureChangeEntity rkProcureChangeEntity = new RkProcureChangeEntity();
                Field declaredField = rkProcureChangeEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcureChangeQueryWrapper = "asc".equals(rkProcureChangePagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcureChangeQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcureChangeQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkProcureChangePagination.getCurrentPage(), rkProcureChangePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkProcureChangeQueryWrapper);
                return rkProcureChangePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkProcureChangePagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkProcureChangeQueryWrapper);
    }

    @Override
    public RkProcureChangeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProcureChangeEntity::getId, (Object)id);
        return (RkProcureChangeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProcureChangeEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkProcureChangeEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateChange(String id, RkProcureChangeUpForm rkProcureChangeUpForm) {
        UserInfo userInfo = this.userProvider.get();
        String procureId = rkProcureChangeUpForm.getProcureId();
        RkContractProcureEntity procureInfo = this.rkContractProcureService.getInfo(procureId);
        if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
            procureInfo.setProcureStatus("changing");
            this.rkContractProcureService.updateById(procureInfo);
        }
        this.rkProcureChangeRelationService.removeByChangeId(id);
        RkProcureChangeRelationEntity changeRelationEntity = new RkProcureChangeRelationEntity();
        changeRelationEntity.setProcureId(procureId);
        changeRelationEntity.setChangeId(id);
        changeRelationEntity.setId(RandomUtil.uuId());
        changeRelationEntity.setCreatorUserId(userInfo.getUserId());
        changeRelationEntity.setCreatorTime(new Date());
        this.rkProcureChangeRelationService.save(changeRelationEntity);
        if (CollectionUtil.isNotEmpty(rkProcureChangeUpForm.getPaymentMethodList())) {
            List<RkContractPaymentVO> paymentMethodList = rkProcureChangeUpForm.getPaymentMethodList();
            paymentMethodList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentMethodList);
            rkProcureChangeUpForm.setPaymentJson(objectToString);
            rkProcureChangeUpForm.setEnableMark(rkProcureChangeUpForm.getEnableMark());
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentMethodList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentMethodList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkProcureChangeUpForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        RkProcureChangeEntity entity = (RkProcureChangeEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureChangeUpForm), RkProcureChangeEntity.class);
        String objectToString1 = JsonUtil.getObjectToString((Object)rkProcureChangeUpForm.getEditNewForm());
        entity.setEditNewForm(objectToString1);
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        RkProcureManageEntity info;
        String procureId;
        RkProcureChangeRelationEntity byProcureId;
        RkProcureChangeEntity entity = this.getInfo(id);
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 2) {
            byProcureId = this.rkProcureChangeRelationService.getByProcureId(entity.getId());
            procureId = byProcureId.getProcureId();
            info = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)procureId));
            info.setProcureStatus("execute");
            this.rkProcureManageService.updateById(info);
            entity.setEnableMark("complete");
            entity.setId(procureId);
            RkProcureManageEntity procureManageEntity = (RkProcureManageEntity)JsonUtil.getJsonToBean((Object)entity, RkProcureManageEntity.class);
            this.rkProcureManageService.updateById(procureManageEntity);
            RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(entity.getProjectId());
            OaRecordSubitemCrCrmForm oaRecordSubitemCrForm = new OaRecordSubitemCrCrmForm();
            oaRecordSubitemCrForm.setRemark("\u91c7\u8d2d\u5408\u540c\u53f7\uff1a" + entity.getProcureCode() + "\uff0c\u91c7\u8d2d\u5408\u540c\u540d\u79f0\uff1a" + entity.getProcureName() + ",\u4f9b\u5e94\u5546\u540d\u79f0\uff1a" + entity.getSupplierName());
            if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
                oaRecordSubitemCrForm.setRemark(oaRecordSubitemCrForm.getRemark() + "\uff0c\u9500\u552e\u5408\u540c\u53f7\uff1a" + projectEntity.getProjectCode());
            }
            oaRecordSubitemCrForm.setBusinessId(id);
            oaRecordSubitemCrForm.setBusinessType("purchaseChange");
            oaRecordSubitemCrForm.setRecordSubitemName(entity.getProcureName());
            oaRecordSubitemCrForm.setSubitemType("paper");
            oaRecordSubitemCrForm.setNumber(1);
            oaRecordSubitemCrForm.setPages(1);
            oaRecordSubitemCrForm.setCreatorUserId(entity.getCreatorUserId());
            oaRecordSubitemCrForm.setBusinessCompanyId(entity.getCompanyId());
            this.oaFileCrmServic.businessRecordSonAddCrm(oaRecordSubitemCrForm);
        }
        if (enableMark == 5 && model.getRejectAgreeStep().equals("0") || enableMark == 3) {
            byProcureId = this.rkProcureChangeRelationService.getByProcureId(entity.getId());
            procureId = byProcureId.getProcureId();
            info = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)procureId));
            info.setProcureStatus("execute");
            info.setEnableMark("complete");
            info.setProcureAmount(entity.getCProcureAmount());
            this.rkProcureManageService.updateById(info);
            entity.setId(procureId);
        }
        return this.updateById(entity);
    }

    @Override
    public void delete(RkProcureChangeEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

