/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.PurchaseGoodsListEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProcureInvoiceDetailRelEntity;
import com.bringspring.contract.entity.RkProcureInvoiceEntity;
import com.bringspring.contract.entity.RkProcureInvoiceManageEntity;
import com.bringspring.contract.entity.RkProcureInvoiceRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.mapper.RkProcureInvoiceMapper;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.model.rkcontract.ContractImportVO;
import com.bringspring.contract.model.rkprocureinvoice.RkInvoiceDetailVO;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoiceImportReturnVO;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoiceImportVO;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoicePagination;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoiceUpForm;
import com.bringspring.contract.service.PurchaseGoodsListService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProcureInvoiceDetailRelService;
import com.bringspring.contract.service.RkProcureInvoiceManageService;
import com.bringspring.contract.service.RkProcureInvoiceRelationService;
import com.bringspring.contract.service.RkProcureInvoiceService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProcureEncodeEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProcureInvoiceServiceImpl
extends ServiceImpl<RkProcureInvoiceMapper, RkProcureInvoiceEntity>
implements RkProcureInvoiceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProcureInvoiceDetailRelService rkProcureInvoiceDetailRelService;
    @Autowired
    private RkProcureInvoiceRelationService rkProcureInvoiceRelationService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkProcureInvoiceService rkProcureInvoiceService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private PurchaseGoodsListService purchaseGoodsListService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProcureInvoiceManageService rkProcureInvoiceManageService;
    @Autowired
    private RkProcureManageService rkProcureManageService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<RkProcureInvoiceEntity> getList(RkProcureInvoicePagination rkProcureInvoicePagination) {
        List collect;
        List list;
        LambdaQueryWrapper relationList;
        List procureIdList;
        List<RkContractProcureEntity> byCode;
        Long sec;
        Long fir;
        Object rkProcureInvoiceObj;
        String userId = this.userProvider.get().getUserId();
        String company = this.userProvider.get().getOrganizeId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcureInvoiceNum = 0;
        QueryWrapper rkProcureInvoiceQueryWrapper = new QueryWrapper();
        QueryWrapper rkInvoiceRelationQueryWrapper = new QueryWrapper();
        QueryWrapper rkContractProcureWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureInvoiceQueryWrapper, rkProcureInvoicePagination.getMenuId(), "rk_procure_invoice"));
            if (ObjectUtil.isEmpty((Object)rkProcureInvoiceObj)) {
                return new ArrayList<RkProcureInvoiceEntity>();
            }
            rkProcureInvoiceQueryWrapper = (QueryWrapper)rkProcureInvoiceObj;
            ++rkProcureInvoiceNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureInvoiceQueryWrapper, rkProcureInvoicePagination.getMenuId(), "rk_procure_invoice"));
            if (ObjectUtil.isEmpty((Object)rkProcureInvoiceObj)) {
                return new ArrayList<RkProcureInvoiceEntity>();
            }
            rkProcureInvoiceQueryWrapper = (QueryWrapper)rkProcureInvoiceObj;
            ++rkProcureInvoiceNum;
        }
        rkProcureInvoiceQueryWrapper.lambda().orderByDesc(RkProcureInvoiceEntity::getApplyDate);
        if (ObjectUtil.isNotEmpty(rkProcureInvoicePagination.getApplyDate())) {
            ++rkProcureInvoiceNum;
            List<String> ApplyDateList = rkProcureInvoicePagination.getApplyDate();
            fir = Long.valueOf(ApplyDateList.get(0));
            sec = Long.valueOf(ApplyDateList.get(1));
            ((LambdaQueryWrapper)rkProcureInvoiceQueryWrapper.lambda().ge(RkProcureInvoiceEntity::getApplyDate, (Object)new Date(fir))).le(RkProcureInvoiceEntity::getApplyDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty(rkProcureInvoicePagination.getCompanyIdList())) {
            rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getCompanyId, rkProcureInvoicePagination.getCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getInvoiceCode())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().like(RkProcureInvoiceEntity::getInvoiceCode, (Object)rkProcureInvoicePagination.getInvoiceCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getCompanyId())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getCompanyId, (Object)rkProcureInvoicePagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getInvoiceStatus())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getInvoiceStatus, (Object)rkProcureInvoicePagination.getInvoiceStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getInvoiceType())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getInvoiceType, (Object)rkProcureInvoicePagination.getInvoiceType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getEnableMark())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getEnableMark, (Object)rkProcureInvoicePagination.getEnableMark());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getBillNumber())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().like(RkProcureInvoiceEntity::getBillNumber, (Object)rkProcureInvoicePagination.getBillNumber());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getProcureCode())) {
            byCode = this.rkContractProcureService.getByCode(rkProcureInvoicePagination.getProcureCode());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcureInvoiceEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcureInvoiceEntity>();
            relationList = (LambdaQueryWrapper)rkInvoiceRelationQueryWrapper.lambda().in(RkProcureInvoiceRelationEntity::getProcureId, procureIdList);
            list = this.rkProcureInvoiceRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getInvoiceId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getProcureName())) {
            byCode = this.rkContractProcureService.getByName(rkProcureInvoicePagination.getProcureName());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcureInvoiceEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcureInvoiceEntity>();
            relationList = (LambdaQueryWrapper)rkInvoiceRelationQueryWrapper.lambda().in(RkProcureInvoiceRelationEntity::getProcureId, procureIdList);
            list = this.rkProcureInvoiceRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getInvoiceId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getSupplierName())) {
            byCode = this.rkContractProcureService.getBySupplierName(rkProcureInvoicePagination.getSupplierName());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcureInvoiceEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcureInvoiceEntity>();
            relationList = (LambdaQueryWrapper)rkInvoiceRelationQueryWrapper.lambda().in(RkProcureInvoiceRelationEntity::getProcureId, procureIdList);
            list = this.rkProcureInvoiceRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getInvoiceId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getProjectCode())) {
            List<RkContractProjectEntity> listByCode = this.rkContractProjectService.getListByCode(rkProcureInvoicePagination.getProjectCode());
            if (!CollectionUtil.isNotEmpty(listByCode)) return new ArrayList<RkProcureInvoiceEntity>();
            List projectIdList = listByCode.stream().map(RkContractProjectEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(projectIdList)) {
                LambdaQueryWrapper in = (LambdaQueryWrapper)rkContractProcureWrapper.lambda().in(RkContractProcureEntity::getProjectId, projectIdList);
                List procureList = this.rkContractProcureService.list((Wrapper)in);
                collect = procureList.stream().map(procure -> procure.getId()).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(collect)) return new ArrayList<RkProcureInvoiceEntity>();
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getProcureId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty(rkProcureInvoicePagination.getInvoiceDate())) {
            ++rkProcureInvoiceNum;
            List<String> InvoiceDateList = rkProcureInvoicePagination.getInvoiceDate();
            fir = Long.valueOf(InvoiceDateList.get(0));
            sec = Long.valueOf(InvoiceDateList.get(1));
            ((LambdaQueryWrapper)rkProcureInvoiceQueryWrapper.lambda().ge(RkProcureInvoiceEntity::getInvoiceDate, (Object)new Date(fir))).le(RkProcureInvoiceEntity::getInvoiceDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkProcureInvoicePagination.getSidx())) {
            rkProcureInvoiceQueryWrapper.lambda().orderByDesc(RkProcureInvoiceEntity::getCreatorTime);
        } else {
            try {
                String sidx = rkProcureInvoicePagination.getSidx();
                RkProcureInvoiceEntity rkProcureInvoiceEntity = new RkProcureInvoiceEntity();
                Field declaredField = rkProcureInvoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcureInvoiceQueryWrapper = "asc".equals(rkProcureInvoicePagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcureInvoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcureInvoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProcureInvoicePagination.getCurrentPage(), rkProcureInvoicePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProcureInvoiceQueryWrapper);
            return rkProcureInvoicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list2 = new ArrayList();
        return rkProcureInvoicePagination.setData(list2, list2.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<RkProcureInvoiceEntity> getTypeList(RkProcureInvoicePagination rkProcureInvoicePagination, String dataType) {
        List collect;
        List list;
        LambdaQueryWrapper relationList;
        List procureIdList;
        List<RkContractProcureEntity> byCode;
        Long sec;
        Long fir;
        Object rkProcureInvoiceObj;
        String userId = this.userProvider.get().getUserId();
        String company = this.userProvider.get().getOrganizeId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcureInvoiceNum = 0;
        QueryWrapper rkProcureInvoiceQueryWrapper = new QueryWrapper();
        QueryWrapper rkInvoiceRelationQueryWrapper = new QueryWrapper();
        QueryWrapper rkContractEntityQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureInvoiceQueryWrapper, rkProcureInvoicePagination.getMenuId(), "rkProcureInvoice"));
            if (ObjectUtil.isEmpty((Object)rkProcureInvoiceObj)) {
                return new ArrayList<RkProcureInvoiceEntity>();
            }
            rkProcureInvoiceQueryWrapper = (QueryWrapper)rkProcureInvoiceObj;
            ++rkProcureInvoiceNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcureInvoiceObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcureInvoiceQueryWrapper, rkProcureInvoicePagination.getMenuId(), "rkProcureInvoice"));
            if (ObjectUtil.isEmpty((Object)rkProcureInvoiceObj)) {
                return new ArrayList<RkProcureInvoiceEntity>();
            }
            rkProcureInvoiceQueryWrapper = (QueryWrapper)rkProcureInvoiceObj;
            ++rkProcureInvoiceNum;
        }
        rkProcureInvoiceQueryWrapper.lambda().orderByDesc(RkProcureInvoiceEntity::getCreatorTime);
        if (ObjectUtil.isNotEmpty(rkProcureInvoicePagination.getApplyDate())) {
            ++rkProcureInvoiceNum;
            List<String> ApplyDateList = rkProcureInvoicePagination.getApplyDate();
            fir = Long.valueOf(ApplyDateList.get(0));
            sec = Long.valueOf(ApplyDateList.get(1));
            ((LambdaQueryWrapper)rkProcureInvoiceQueryWrapper.lambda().ge(RkProcureInvoiceEntity::getApplyDate, (Object)new Date(fir))).le(RkProcureInvoiceEntity::getApplyDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty(rkProcureInvoicePagination.getCompanyIdList())) {
            rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getCompanyId, rkProcureInvoicePagination.getCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getInvoiceCode())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().like(RkProcureInvoiceEntity::getInvoiceCode, (Object)rkProcureInvoicePagination.getInvoiceCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getInvoiceStatus())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getInvoiceStatus, (Object)rkProcureInvoicePagination.getInvoiceStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getInvoiceType())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getInvoiceType, (Object)rkProcureInvoicePagination.getInvoiceType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getEnableMark())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().eq(RkProcureInvoiceEntity::getEnableMark, (Object)rkProcureInvoicePagination.getEnableMark());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getBillNumber())) {
            ++rkProcureInvoiceNum;
            rkProcureInvoiceQueryWrapper.lambda().like(RkProcureInvoiceEntity::getBillNumber, (Object)rkProcureInvoicePagination.getBillNumber());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getProcureCode())) {
            byCode = this.rkContractProcureService.getByCode(rkProcureInvoicePagination.getProcureCode());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcureInvoiceEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcureInvoiceEntity>();
            relationList = (LambdaQueryWrapper)rkInvoiceRelationQueryWrapper.lambda().in(RkProcureInvoiceRelationEntity::getProcureId, procureIdList);
            list = this.rkProcureInvoiceRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getInvoiceId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty(rkProcureInvoicePagination.getInvoiceDate())) {
            ++rkProcureInvoiceNum;
            List<String> InvoiceDateList = rkProcureInvoicePagination.getInvoiceDate();
            fir = Long.valueOf(InvoiceDateList.get(0));
            sec = Long.valueOf(InvoiceDateList.get(1));
            ((LambdaQueryWrapper)rkProcureInvoiceQueryWrapper.lambda().ge(RkProcureInvoiceEntity::getInvoiceDate, (Object)new Date(fir))).le(RkProcureInvoiceEntity::getInvoiceDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getProcureName())) {
            byCode = this.rkContractProcureService.getByName(rkProcureInvoicePagination.getProcureName());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcureInvoiceEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcureInvoiceEntity>();
            relationList = (LambdaQueryWrapper)rkInvoiceRelationQueryWrapper.lambda().in(RkProcureInvoiceRelationEntity::getProcureId, procureIdList);
            list = this.rkProcureInvoiceRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getInvoiceId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcureInvoicePagination.getSupplierName())) {
            byCode = this.rkContractProcureService.getBySupplierName(rkProcureInvoicePagination.getSupplierName());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcureInvoiceEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcureInvoiceEntity>();
            relationList = (LambdaQueryWrapper)rkInvoiceRelationQueryWrapper.lambda().in(RkProcureInvoiceRelationEntity::getProcureId, procureIdList);
            list = this.rkProcureInvoiceRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getInvoiceId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, collect);
            }
        }
        if (AllIdList.size() > 0) {
            rkProcureInvoiceQueryWrapper.lambda().in(RkProcureInvoiceEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkProcureInvoicePagination.getSidx())) {
            rkProcureInvoiceQueryWrapper.lambda().orderByDesc(RkProcureInvoiceEntity::getCreatorTime);
        } else {
            try {
                String sidx = rkProcureInvoicePagination.getSidx();
                RkProcureInvoiceEntity rkProcureInvoiceEntity = new RkProcureInvoiceEntity();
                Field declaredField = rkProcureInvoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcureInvoiceQueryWrapper = "asc".equals(rkProcureInvoicePagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcureInvoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcureInvoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (!"0".equals(dataType)) return this.list((Wrapper)rkProcureInvoiceQueryWrapper);
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProcureInvoicePagination.getCurrentPage(), rkProcureInvoicePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProcureInvoiceQueryWrapper);
            return rkProcureInvoicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list2 = new ArrayList();
        return rkProcureInvoicePagination.setData(list2, list2.size());
    }

    @Override
    public RkProcureInvoiceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProcureInvoiceEntity::getId, (Object)id);
        return (RkProcureInvoiceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProcureInvoiceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkProcureInvoiceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateInvoice(String id, RkProcureInvoiceUpForm rkProcureInvoiceUpForm) {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkProcureInvoiceUpForm.setCompanyId(organizeId);
        if (CollectionUtil.isNotEmpty(rkProcureInvoiceUpForm.getInvoiceDetailList())) {
            List<RkInvoiceDetailVO> invoiceDetailList = rkProcureInvoiceUpForm.getInvoiceDetailList();
            List<RkProcureInvoiceDetailRelEntity> listByInvoiceId = this.rkProcureInvoiceDetailRelService.listByInvoiceId(id);
            List oldIdList = listByInvoiceId.stream().map(RkProcureInvoiceDetailRelEntity::getId).collect(Collectors.toList());
            List newIdList = invoiceDetailList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkInvoiceDetailVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.rkProcureInvoiceDetailRelService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(invoiceDetailList, RkProcureInvoiceDetailRelEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setInvoiceId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.rkProcureInvoiceDetailRelService.saveOrUpdateBatch(jsonToList);
        }
        String procureId = rkProcureInvoiceUpForm.getProcureId();
        String payId = rkProcureInvoiceUpForm.getPayId();
        RkProcureInvoiceRelationEntity relationEntity = new RkProcureInvoiceRelationEntity();
        relationEntity.setId(RandomUtil.uuId());
        relationEntity.setInvoiceId(id);
        relationEntity.setPayId(payId);
        relationEntity.setProcureId(procureId);
        relationEntity.setCreatorTime(new Date());
        relationEntity.setCreatorUserId(userInfo.getUserId());
        this.rkProcureInvoiceRelationService.updateById(relationEntity);
        if (CollectionUtil.isNotEmpty(rkProcureInvoiceUpForm.getAttachmentList())) {
            this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
            List<RkAttachmentUpForm> attachmentList = rkProcureInvoiceUpForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
        }
        RkProcureInvoiceEntity entity = (RkProcureInvoiceEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureInvoiceUpForm), RkProcureInvoiceEntity.class);
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        RkProcureInvoiceEntity entity = this.rkProcureInvoiceService.getInfo(id);
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 2) {
            RkProcureManageEntity procureManage;
            RkContractProcureEntity procureInfo = (RkContractProcureEntity)this.rkContractProcureService.getById((Serializable)((Object)entity.getProcureId()));
            if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
                if (ObjectUtil.isNotEmpty((Object)procureInfo.getAccumulateInvoiceAmount())) {
                    procureInfo.setAccumulateInvoiceAmount(procureInfo.getAccumulateInvoiceAmount().add(entity.getInvoiceAmount()));
                } else {
                    procureInfo.setAccumulateInvoiceAmount(entity.getInvoiceAmount());
                }
                this.rkContractProcureService.updateById(procureInfo);
            }
            if (ObjectUtil.isNotEmpty((Object)(procureManage = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)entity.getProcureId()))))) {
                if (ObjectUtil.isNotEmpty((Object)procureManage.getAccumulateInvoiceAmount())) {
                    procureManage.setAccumulateInvoiceAmount(procureManage.getAccumulateInvoiceAmount().add(entity.getInvoiceAmount()));
                } else {
                    procureManage.setAccumulateInvoiceAmount(entity.getInvoiceAmount());
                }
                this.rkProcureManageService.updateById(procureManage);
            }
            entity.setEnableMark("complete");
            RkProcureInvoiceManageEntity jsonToBean = (RkProcureInvoiceManageEntity)JsonUtil.getJsonToBean((Object)entity, RkProcureInvoiceManageEntity.class);
            this.rkProcureInvoiceManageService.save(jsonToBean);
        }
        return this.updateById(entity);
    }

    @Override
    public void delete(RkProcureInvoiceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            this.rkProcureInvoiceDetailRelService.removeById(entity.getId());
            this.rkProcureInvoiceRelationService.removeByProcureId(entity.getId());
        }
    }

    @Override
    public Map<String, Object> importPreview(List<RkProcureInvoiceImportVO> fileImportList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < fileImportList.size(); ++i) {
            Map dataRowMap = new HashMap();
            RkProcureInvoiceImportVO rkProcureInvoiceImportVO = fileImportList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)rkProcureInvoiceImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= fileImportList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", fileImportList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7");
        map.put(2, "\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0");
        map.put(3, "\u89c4\u683c\u578b\u53f7");
        map.put(4, "\u8ba1\u91cf\u5355\u4f4d");
        map.put(5, "\u6570\u91cf");
        map.put(6, "\u5355\u4ef7\uff08\u542b\u7a0e\uff09");
        map.put(7, "\u7a0e\u7387\uff08%\uff09");
        map.put(8, "\u672a\u7a0e\u5408\u8ba1");
        map.put(9, "\u7a0e\u989d");
        map.put(10, "\u4ef7\u7a0e\u5408\u8ba1");
        map.put(11, "\u7968\u53f7");
        map.put(12, "\u767b\u8bb0\u65e5\u671f");
        map.put(13, "\u767b\u8bb0\u4eba");
        map.put(14, "\u5f00\u7968\u65e5\u671f");
        map.put(15, "\u53d1\u7968\u7c7b\u578b");
        return (String)map.get(key);
    }

    @Override
    public RkProcureInvoiceImportReturnVO importData(List<RkProcureInvoiceImportVO> dataList) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userInfo.getDepartmentId());
        String[] departmentTree = organizeEntity.getOrganizeIdTree().split(",");
        List<String> o1 = Arrays.asList(departmentTree);
        String ApplyDepartmentTree = o1.toString();
        String ApplyDepartmentTreeName = this.baseDataUtil.comSelectValues(organizeEntity.getOrganizeIdTree());
        String ApplyDepartmentOne = departmentTree[departmentTree.length - 2];
        String ApplyDepartmentOneName = this.baseDataUtil.comSelectValues(ApplyDepartmentOne);
        String ApplyDepartment = departmentTree[departmentTree.length - 1];
        String ApplyDepartmentName = this.baseDataUtil.comSelectValues(ApplyDepartment);
        HashMap dictMap = MapUtil.newHashMap();
        List<ProcureEncodeEnum> allToList = ProcureEncodeEnum.getAllToList();
        allToList.stream().forEach(fileEncodeEnum -> {
            String encode = fileEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
            dictMap.put(encode, collect);
        });
        List rkProcureInvoiceEntityList = CollectionUtil.list((boolean)false);
        List rkProcureInvoiceDetailRelEntityList = CollectionUtil.list((boolean)false);
        List rkProcureInvoiceRelationEntityList = CollectionUtil.list((boolean)false);
        List organizeList = this.organizeService.getList();
        List errorList = CollectionUtil.list((boolean)false);
        boolean successNum = false;
        int errorNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (RkProcureInvoiceImportVO ImportVO : dataList) {
            String applyCode = "";
            String procureId = "";
            if (StringUtil.isNotEmpty((String)ImportVO.getApplyCode())) {
                ImportVO.setApplyCode(StrUtil.trim((CharSequence)ImportVO.getApplyCode()));
                List<PurchaseGoodsListEntity> tempGoodsList = this.purchaseGoodsListService.getListByApplyCode(ImportVO.getApplyCode());
                if (CollectionUtil.isEmpty(tempGoodsList)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    applyCode = tempGoodsList.get(0).getId();
                    procureId = tempGoodsList.get(0).getHtId();
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getInvoiceDetailName())) {
                ++errorNum;
                ImportVO.setErrMsg("\u8d27\u7269\u6216\u5e94\u7a0e\u52b3\u52a1\u3001\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getSpecificationModel())) {
                ++errorNum;
                ImportVO.setErrMsg("\u89c4\u683c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getUnitMeasurement())) {
                ++errorNum;
                ImportVO.setErrMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getNumber())) {
                ++errorNum;
                ImportVO.setErrMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)ImportVO.getNumber())) {
                ++errorNum;
                ImportVO.setErrMsg("\u6570\u91cf\u8bf7\u586b\u5199\u6570\u5b57\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getUnitPrice())) {
                ++errorNum;
                ImportVO.setErrMsg("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)ImportVO.getUnitPrice())) {
                ++errorNum;
                ImportVO.setErrMsg("\u542b\u7a0e\u5355\u4ef7\u8bf7\u586b\u5199\u6570\u5b57\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getTotalUntax())) {
                ++errorNum;
                ImportVO.setErrMsg("\u672a\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)ImportVO.getTotalUntax())) {
                ++errorNum;
                ImportVO.setErrMsg("\u672a\u7a0e\u5408\u8ba1\u8bf7\u586b\u5199\u6570\u5b57\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getTaxAmount())) {
                ++errorNum;
                ImportVO.setErrMsg("\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)ImportVO.getTaxAmount())) {
                ++errorNum;
                ImportVO.setErrMsg("\u7a0e\u989d\u8bf7\u586b\u5199\u6570\u5b57\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getBillNumber())) {
                ++errorNum;
                ImportVO.setErrMsg("\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)ImportVO.getApplyDate())) {
                ++errorNum;
                ImportVO.setErrMsg("\u767b\u8bb0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)ImportVO.getInvoiceDate())) {
                ++errorNum;
                ImportVO.setErrMsg("\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            String invoiceTax = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getInvoiceTax())) {
                Map stringStringMap = (Map)dictMap.get(ProcureEncodeEnum.INVOICE_TAX_ENCODE.getEncode());
                String s = (String)stringStringMap.get(ImportVO.getInvoiceTax().concat("%"));
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u7a0e\u7387\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    invoiceTax = s;
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            String invoiceType = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getInvoiceType())) {
                Map stringStringMap = (Map)dictMap.get(ProcureEncodeEnum.INVOICE_INVOICE_TYPE_ENCODE.getEncode());
                String s = (String)stringStringMap.get(ImportVO.getInvoiceType());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u53d1\u7968\u7c7b\u578b\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    invoiceType = s;
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                ImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                ImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(ImportVO);
                continue;
            }
            String invoiceId = RandomUtil.uuId();
            String invoiceDetailId = RandomUtil.uuId();
            String invoiceRelationId = RandomUtil.uuId();
            RkProcureInvoiceImportVO rkProcureInvoiceImportVO = RkProcureInvoiceServiceImpl.setRkProcureInvoiceImportVO(ImportVO, applyCode, invoiceTax);
            RkProcureInvoiceDetailRelEntity rkProcureInvoiceDetailRelEntity = (RkProcureInvoiceDetailRelEntity)JsonUtil.getJsonToBean((Object)rkProcureInvoiceImportVO, RkProcureInvoiceDetailRelEntity.class);
            rkProcureInvoiceDetailRelEntity.setInvoiceId(invoiceId);
            rkProcureInvoiceDetailRelEntity.setId(invoiceDetailId);
            rkProcureInvoiceDetailRelEntityList.add(rkProcureInvoiceDetailRelEntity);
            RkProcureInvoiceImportVO rkProcureInvoiceImportVO1 = new RkProcureInvoiceImportVO();
            rkProcureInvoiceImportVO1.setBillNumber(ImportVO.getBillNumber());
            rkProcureInvoiceImportVO1.setApplyDate(ImportVO.getApplyDate());
            rkProcureInvoiceImportVO1.setApplyName(ImportVO.getApplyName());
            rkProcureInvoiceImportVO1.setInvoiceDate(ImportVO.getInvoiceDate());
            rkProcureInvoiceImportVO1.setInvoiceType(invoiceType);
            RkProcureInvoiceEntity rkProcureInvoiceEntity = (RkProcureInvoiceEntity)JsonUtil.getJsonToBean((Object)rkProcureInvoiceImportVO1, RkProcureInvoiceEntity.class);
            rkProcureInvoiceEntity.setId(invoiceId);
            rkProcureInvoiceEntity.setInvoiceAmount(new BigDecimal(ImportVO.getTotalPriceTax()));
            rkProcureInvoiceEntity.setCheckInvoice(rkProcureInvoiceEntity.getInvoiceAmount());
            rkProcureInvoiceEntity.setInvoiceCode(this.baseDataUtil.getBillNumber("InvoiceCode", Boolean.valueOf(false)));
            rkProcureInvoiceEntity.setInvoiceTypeName(ImportVO.getInvoiceType());
            rkProcureInvoiceEntity.setInvoiceDetailJson(((RkProcureInvoiceDetailRelEntity)JsonUtil.getJsonToBean((Object)rkProcureInvoiceDetailRelEntity, RkProcureInvoiceDetailRelEntity.class)).toString());
            rkProcureInvoiceEntityList.add(rkProcureInvoiceEntity);
            rkProcureInvoiceEntityList.stream().forEach(a -> {
                a.setInvoiceStatus("1");
                a.setApplyId(userInfo.getUserId());
                a.setApplyName(userInfo.getRealName());
                a.setApplyDepartment(userInfo.getDepartmentId());
                a.setApplyDepartmentName(ApplyDepartmentName);
                a.setApplyDepartmentOne(ApplyDepartmentOne);
                a.setApplyDepartmentOneName(ApplyDepartmentOneName);
                a.setApplyDepartmentTree(ApplyDepartmentTree);
                a.setApplyDepartmentTreeName(ApplyDepartmentTreeName);
                a.setCompanyId(companyId);
                a.setEnableMark("history");
                a.setCreatorTime(new Date());
                a.setCreatorUserId(userInfo.getUserId());
            });
            RkProcureInvoiceRelationEntity rkProcureInvoiceRelationEntity = new RkProcureInvoiceRelationEntity();
            rkProcureInvoiceRelationEntity.setInvoiceId(invoiceId);
            rkProcureInvoiceRelationEntity.setProcureId(procureId);
            rkProcureInvoiceRelationEntity.setId(invoiceRelationId);
            rkProcureInvoiceRelationEntityList.add(rkProcureInvoiceRelationEntity);
            rkProcureInvoiceRelationEntityList.stream().forEach(a -> {
                a.setCreatorTime(new Date());
                a.setCreatorUserId(userInfo.getUserId());
            });
        }
        this.saveBatch(rkProcureInvoiceEntityList);
        this.rkProcureInvoiceRelationService.saveBatch(rkProcureInvoiceRelationEntityList);
        this.rkProcureInvoiceDetailRelService.saveBatch(rkProcureInvoiceDetailRelEntityList);
        rkProcureInvoiceRelationEntityList.stream().forEach(a -> {
            RkContractProcureEntity procureEntity = this.rkContractProcureService.getInfo(a.getProcureId());
            RkProcureInvoiceEntity temp1 = (RkProcureInvoiceEntity)rkProcureInvoiceEntityList.stream().filter(b -> b.getId().equals(a.getInvoiceId())).collect(Collectors.toList()).get(0);
            procureEntity.setAccumulateInvoiceAmount(MathUtils.add(procureEntity.getAccumulateInvoiceAmount(), temp1.getInvoiceAmount()));
            this.rkContractProcureService.updateById(procureEntity);
        });
        RkProcureInvoiceImportReturnVO vo = new RkProcureInvoiceImportReturnVO();
        vo.setSnum(rkProcureInvoiceEntityList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, RkProcureInvoiceImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @NotNull
    private static RkProcureInvoiceImportVO setRkProcureInvoiceImportVO(RkProcureInvoiceImportVO ImportVO, String applyCode, String invoiceTax) {
        RkProcureInvoiceImportVO rkProcureInvoiceImportVO = new RkProcureInvoiceImportVO();
        rkProcureInvoiceImportVO.setApplyCode(ImportVO.getApplyCode());
        rkProcureInvoiceImportVO.setGoodsId(applyCode);
        rkProcureInvoiceImportVO.setInvoiceDetailName(ImportVO.getInvoiceDetailName());
        rkProcureInvoiceImportVO.setSpecificationModel(ImportVO.getSpecificationModel());
        rkProcureInvoiceImportVO.setUnitMeasurement(ImportVO.getUnitMeasurement());
        rkProcureInvoiceImportVO.setNumber(ImportVO.getNumber());
        rkProcureInvoiceImportVO.setUnitPrice(ImportVO.getUnitPrice());
        rkProcureInvoiceImportVO.setInvoiceTax(invoiceTax);
        rkProcureInvoiceImportVO.setTotalUntax(ImportVO.getTotalUntax());
        rkProcureInvoiceImportVO.setTaxAmount(ImportVO.getTaxAmount());
        rkProcureInvoiceImportVO.setTotalPriceTax(ImportVO.getTotalPriceTax());
        return rkProcureInvoiceImportVO;
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, ContractImportVO contractImportVO) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)contractImportVO, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }
}

