/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkProcurePaymentPlanEntity;
import com.bringspring.contract.mapper.RkProcurePaymentPlanMapper;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanCrForm;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanPagination;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanUpForm;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcurePaymentPlanService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProcurePaymentPlanServiceImpl
extends ServiceImpl<RkProcurePaymentPlanMapper, RkProcurePaymentPlanEntity>
implements RkProcurePaymentPlanService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkProcurePaymentPlanService rkProcurePaymentPlanService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public List<RkProcurePaymentPlanEntity> getList(RkProcurePaymentPlanPagination rkProcurePaymentPlanPagination) {
        Long sec;
        Long fir;
        List<String> startApplyDateList;
        Object rkProcurePaymentPlanObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcurePaymentPlanNum = 0;
        int rkProcureManageNum = 0;
        QueryWrapper rkProcurePaymentPlanQueryWrapper = new QueryWrapper();
        QueryWrapper rkProcureManageEntityQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentPlanQueryWrapper, rkProcurePaymentPlanPagination.getMenuId(), "rk_procure_payment_plan"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentPlanObj)) {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
            rkProcurePaymentPlanQueryWrapper = (QueryWrapper)rkProcurePaymentPlanObj;
            ++rkProcurePaymentPlanNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentPlanQueryWrapper, rkProcurePaymentPlanPagination.getMenuId(), "rk_procure_payment_plan"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentPlanObj)) {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
            rkProcurePaymentPlanQueryWrapper = (QueryWrapper)rkProcurePaymentPlanObj;
            ++rkProcurePaymentPlanNum;
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProcureId())) {
            ++rkProcurePaymentPlanNum;
            rkProcurePaymentPlanQueryWrapper.lambda().like(RkProcurePaymentPlanEntity::getProcureId, (Object)rkProcurePaymentPlanPagination.getProcureId());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProcureCode())) {
            ++rkProcureManageNum;
            rkProcureManageEntityQueryWrapper.lambda().like(RkProcureManageEntity::getProcureCode, (Object)rkProcurePaymentPlanPagination.getProcureCode());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProcureName())) {
            ++rkProcureManageNum;
            rkProcureManageEntityQueryWrapper.lambda().like(RkProcureManageEntity::getProcureName, (Object)rkProcurePaymentPlanPagination.getProcureName());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getSupplierName())) {
            ++rkProcureManageNum;
            rkProcureManageEntityQueryWrapper.lambda().like(RkProcureManageEntity::getSupplierName, (Object)rkProcurePaymentPlanPagination.getSupplierName());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProjectCode())) {
            ++rkProcureManageNum;
            List<RkContractProjectEntity> listByCode = this.rkContractProjectService.getListByCode(rkProcurePaymentPlanPagination.getProjectCode());
            if (CollectionUtil.isNotEmpty(listByCode)) {
                List projectIdList = listByCode.stream().map(project -> project.getId()).collect(Collectors.toList());
                rkProcureManageEntityQueryWrapper.lambda().in(RkProcureManageEntity::getProjectId, projectIdList);
            } else {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
        }
        if (StringUtils.isNotEmpty(rkProcurePaymentPlanPagination.getApplyDate())) {
            ++rkProcureManageNum;
            startApplyDateList = rkProcurePaymentPlanPagination.getApplyDate();
            fir = Long.valueOf(startApplyDateList.get(0));
            sec = Long.valueOf(startApplyDateList.get(1));
            ((LambdaQueryWrapper)rkProcureManageEntityQueryWrapper.lambda().ge(RkProcureManageEntity::getApplyDate, (Object)new Date(fir))).le(RkProcureManageEntity::getApplyDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (rkProcureManageNum > 0) {
            List procureIdList = this.rkProcureManageService.list((Wrapper)rkProcureManageEntityQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)procureIdList)) {
                List ids = procureIdList.stream().map(RkProcureManageEntity::getId).collect(Collectors.toList());
                rkProcurePaymentPlanQueryWrapper.lambda().in(RkProcurePaymentPlanEntity::getProcureId, ids);
            } else {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
        }
        if (ObjectUtil.isNotEmpty(rkProcurePaymentPlanPagination.getCompanyIdList())) {
            ++rkProcurePaymentPlanNum;
            rkProcurePaymentPlanQueryWrapper.lambda().in(RkProcurePaymentPlanEntity::getCompanyId, rkProcurePaymentPlanPagination.getCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty(rkProcurePaymentPlanPagination.getPayStatusList())) {
            ++rkProcurePaymentPlanNum;
            if (rkProcurePaymentPlanPagination.getPayStatusList().size() == 2) {
                if (rkProcurePaymentPlanPagination.getPayStatusList().contains("over")) {
                    if (rkProcurePaymentPlanPagination.getPayStatusList().contains("ing")) {
                        rkProcurePaymentPlanQueryWrapper.lambda().ne(RkProcurePaymentPlanEntity::getPaidAmount, (Object)BigDecimal.ZERO);
                    } else {
                        rkProcurePaymentPlanQueryWrapper.lambda().and(a -> {
                            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(RkProcurePaymentPlanEntity::getPaidAmount, (Object)BigDecimal.ZERO)).or()).ge(RkProcurePaymentPlanEntity::getPaidRatio, (Object)"99.99");
                        });
                    }
                } else {
                    rkProcurePaymentPlanQueryWrapper.lambda().and(a -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.le(RkProcurePaymentPlanEntity::getPaidRatio, (Object)"99.99");
                    });
                }
            } else if (rkProcurePaymentPlanPagination.getPayStatusList().contains("over")) {
                rkProcurePaymentPlanQueryWrapper.lambda().gt(RkProcurePaymentPlanEntity::getPaidRatio, (Object)99.99);
            } else if (rkProcurePaymentPlanPagination.getPayStatusList().contains("ing")) {
                ((LambdaQueryWrapper)rkProcurePaymentPlanQueryWrapper.lambda().le(RkProcurePaymentPlanEntity::getPaidRatio, (Object)99.99)).gt(RkProcurePaymentPlanEntity::getPaidRatio, (Object)0.01);
            } else {
                rkProcurePaymentPlanQueryWrapper.lambda().le(RkProcurePaymentPlanEntity::getPaidRatio, (Object)0.01);
            }
        }
        if (StringUtils.isNotEmpty(rkProcurePaymentPlanPagination.getArchivedDate())) {
            ++rkProcurePaymentPlanNum;
            startApplyDateList = rkProcurePaymentPlanPagination.getArchivedDate();
            fir = Long.valueOf(startApplyDateList.get(0));
            sec = Long.valueOf(startApplyDateList.get(1));
            ((LambdaQueryWrapper)rkProcurePaymentPlanQueryWrapper.lambda().ge(RkProcurePaymentPlanEntity::getPayDate, (Object)new Date(fir))).le(RkProcurePaymentPlanEntity::getPayDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkProcurePaymentPlanQueryWrapper.lambda().in(RkProcurePaymentPlanEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkProcurePaymentPlanPagination.getSidx())) {
            rkProcurePaymentPlanQueryWrapper.lambda().orderByDesc(RkProcurePaymentPlanEntity::getPayDate);
        } else {
            try {
                String sidx = rkProcurePaymentPlanPagination.getSidx();
                RkProcurePaymentPlanEntity rkProcurePaymentPlanEntity = new RkProcurePaymentPlanEntity();
                Field declaredField = rkProcurePaymentPlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcurePaymentPlanQueryWrapper = "asc".equals(rkProcurePaymentPlanPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcurePaymentPlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcurePaymentPlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProcurePaymentPlanPagination.getCurrentPage(), rkProcurePaymentPlanPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProcurePaymentPlanQueryWrapper);
            return rkProcurePaymentPlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkProcurePaymentPlanPagination.setData(list, list.size());
    }

    @Override
    public List<RkProcurePaymentPlanEntity> getTypeList(RkProcurePaymentPlanPagination rkProcurePaymentPlanPagination, String dataType) {
        Long sec;
        Long fir;
        List<String> startApplyDateList;
        Object rkProcurePaymentPlanObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcurePaymentPlanNum = 0;
        int rkProcureManageNum = 0;
        QueryWrapper rkProcurePaymentPlanQueryWrapper = new QueryWrapper();
        QueryWrapper rkProcureManageEntityQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentPlanQueryWrapper, rkProcurePaymentPlanPagination.getMenuId(), "rkProcurePaymentPlan"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentPlanObj)) {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
            rkProcurePaymentPlanQueryWrapper = (QueryWrapper)rkProcurePaymentPlanObj;
            ++rkProcurePaymentPlanNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentPlanQueryWrapper, rkProcurePaymentPlanPagination.getMenuId(), "rkProcurePaymentPlan"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentPlanObj)) {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
            rkProcurePaymentPlanQueryWrapper = (QueryWrapper)rkProcurePaymentPlanObj;
            ++rkProcurePaymentPlanNum;
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProcureId())) {
            ++rkProcurePaymentPlanNum;
            rkProcurePaymentPlanQueryWrapper.lambda().like(RkProcurePaymentPlanEntity::getProcureId, (Object)rkProcurePaymentPlanPagination.getProcureId());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProcureCode())) {
            ++rkProcureManageNum;
            rkProcureManageEntityQueryWrapper.lambda().like(RkProcureManageEntity::getProcureCode, (Object)rkProcurePaymentPlanPagination.getProcureCode());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProcureName())) {
            ++rkProcureManageNum;
            rkProcureManageEntityQueryWrapper.lambda().like(RkProcureManageEntity::getProcureName, (Object)rkProcurePaymentPlanPagination.getProcureName());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getSupplierName())) {
            ++rkProcureManageNum;
            rkProcureManageEntityQueryWrapper.lambda().like(RkProcureManageEntity::getSupplierName, (Object)rkProcurePaymentPlanPagination.getSupplierName());
        }
        if (StringUtil.isNotEmpty((String)rkProcurePaymentPlanPagination.getProjectCode())) {
            ++rkProcureManageNum;
            List<RkContractProjectEntity> listByCode = this.rkContractProjectService.getListByCode(rkProcurePaymentPlanPagination.getProjectCode());
            if (CollectionUtil.isNotEmpty(listByCode)) {
                List projectIdList = listByCode.stream().map(project -> project.getId()).collect(Collectors.toList());
                rkProcureManageEntityQueryWrapper.lambda().in(RkProcureManageEntity::getProjectId, projectIdList);
            } else {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
        }
        if (StringUtils.isNotEmpty(rkProcurePaymentPlanPagination.getApplyDate())) {
            ++rkProcureManageNum;
            startApplyDateList = rkProcurePaymentPlanPagination.getApplyDate();
            fir = Long.valueOf(startApplyDateList.get(0));
            sec = Long.valueOf(startApplyDateList.get(1));
            ((LambdaQueryWrapper)rkProcureManageEntityQueryWrapper.lambda().ge(RkProcureManageEntity::getApplyDate, (Object)new Date(fir))).le(RkProcureManageEntity::getApplyDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (rkProcureManageNum > 0) {
            List procureIdList = this.rkProcureManageService.list((Wrapper)rkProcureManageEntityQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)procureIdList)) {
                List ids = procureIdList.stream().map(RkProcureManageEntity::getId).collect(Collectors.toList());
                rkProcurePaymentPlanQueryWrapper.lambda().in(RkProcurePaymentPlanEntity::getProcureId, ids);
            } else {
                return new ArrayList<RkProcurePaymentPlanEntity>();
            }
        }
        if (ObjectUtil.isNotEmpty(rkProcurePaymentPlanPagination.getCompanyIdList())) {
            ++rkProcurePaymentPlanNum;
            rkProcurePaymentPlanQueryWrapper.lambda().in(RkProcurePaymentPlanEntity::getCompanyId, rkProcurePaymentPlanPagination.getCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty(rkProcurePaymentPlanPagination.getPayStatusList())) {
            ++rkProcurePaymentPlanNum;
            if (rkProcurePaymentPlanPagination.getPayStatusList().size() == 2) {
                if (rkProcurePaymentPlanPagination.getPayStatusList().contains("over")) {
                    if (rkProcurePaymentPlanPagination.getPayStatusList().contains("ing")) {
                        rkProcurePaymentPlanQueryWrapper.lambda().ne(RkProcurePaymentPlanEntity::getPaidAmount, (Object)BigDecimal.ZERO);
                    } else {
                        rkProcurePaymentPlanQueryWrapper.lambda().and(a -> {
                            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(RkProcurePaymentPlanEntity::getPaidAmount, (Object)BigDecimal.ZERO)).or()).ge(RkProcurePaymentPlanEntity::getPaidRatio, (Object)"99.99");
                        });
                    }
                } else {
                    rkProcurePaymentPlanQueryWrapper.lambda().and(a -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.le(RkProcurePaymentPlanEntity::getPaidRatio, (Object)"99.99");
                    });
                }
            } else if (rkProcurePaymentPlanPagination.getPayStatusList().contains("over")) {
                rkProcurePaymentPlanQueryWrapper.lambda().gt(RkProcurePaymentPlanEntity::getPaidRatio, (Object)99.99);
            } else if (rkProcurePaymentPlanPagination.getPayStatusList().contains("ing")) {
                ((LambdaQueryWrapper)rkProcurePaymentPlanQueryWrapper.lambda().le(RkProcurePaymentPlanEntity::getPaidRatio, (Object)99.99)).gt(RkProcurePaymentPlanEntity::getPaidRatio, (Object)0.01);
            } else {
                rkProcurePaymentPlanQueryWrapper.lambda().le(RkProcurePaymentPlanEntity::getPaidRatio, (Object)0.01);
            }
        }
        if (StringUtils.isNotEmpty(rkProcurePaymentPlanPagination.getArchivedDate())) {
            ++rkProcurePaymentPlanNum;
            startApplyDateList = rkProcurePaymentPlanPagination.getArchivedDate();
            fir = Long.valueOf(startApplyDateList.get(0));
            sec = Long.valueOf(startApplyDateList.get(1));
            ((LambdaQueryWrapper)rkProcurePaymentPlanQueryWrapper.lambda().ge(RkProcurePaymentPlanEntity::getPayDate, (Object)new Date(fir))).le(RkProcurePaymentPlanEntity::getPayDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkProcurePaymentPlanQueryWrapper.lambda().in(RkProcurePaymentPlanEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkProcurePaymentPlanPagination.getSidx())) {
            rkProcurePaymentPlanQueryWrapper.lambda().orderByDesc(RkProcurePaymentPlanEntity::getId);
        } else {
            try {
                String sidx = rkProcurePaymentPlanPagination.getSidx();
                RkProcurePaymentPlanEntity rkProcurePaymentPlanEntity = new RkProcurePaymentPlanEntity();
                Field declaredField = rkProcurePaymentPlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcurePaymentPlanQueryWrapper = "asc".equals(rkProcurePaymentPlanPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcurePaymentPlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcurePaymentPlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkProcurePaymentPlanPagination.getCurrentPage(), rkProcurePaymentPlanPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkProcurePaymentPlanQueryWrapper);
                return rkProcurePaymentPlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkProcurePaymentPlanPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkProcurePaymentPlanQueryWrapper);
    }

    @Override
    @DSTransactional
    public HashMap createPlan(RkProcurePaymentPlanCrForm rkProcurePaymentPlanCrForm) {
        HashMap map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProcurePaymentPlanEntity::getProcureId, (Object)rkProcurePaymentPlanCrForm.getProcureId());
        List list = this.list((Wrapper)queryWrapper);
        BigDecimal reduce = list.stream().filter(payment -> ObjectUtil.isNotEmpty((Object)payment.getPaymentAmount())).map(RkProcurePaymentPlanEntity::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal add = MathUtils.add(reduce, rkProcurePaymentPlanCrForm.getPaymentAmount());
        RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(rkProcurePaymentPlanCrForm.getProcureId());
        if (!StrUtil.equals((CharSequence)procureInfo.getIsTrustSettlement(), (CharSequence)"1") && add.compareTo(procureInfo.getProcureAmount()) == 1) {
            map.put("error", "\u4ed8\u6b3e\u8ba1\u5212\u603b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u603b\u91d1\u989d");
            return map;
        }
        String mainId = RandomUtil.uuId();
        RkProcurePaymentPlanEntity entity = (RkProcurePaymentPlanEntity)JsonUtil.getJsonToBean((Object)rkProcurePaymentPlanCrForm, RkProcurePaymentPlanEntity.class);
        entity.setId(mainId);
        entity.setPaidAmount(BigDecimal.ZERO);
        entity.setPaidRatio(BigDecimal.ZERO);
        entity.setPaymentPlanFlag("0");
        this.save(entity);
        return map;
    }

    @Override
    public RkProcurePaymentPlanEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProcurePaymentPlanEntity::getId, (Object)id);
        return (RkProcurePaymentPlanEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProcurePaymentPlanEntity> getListByProcureId(String procureId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkProcurePaymentPlanEntity::getProcureId, (Object)procureId)).orderByAsc(RkProcurePaymentPlanEntity::getPayDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProcurePaymentPlanEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkProcurePaymentPlanEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public HashMap updatePlan(List<RkProcurePaymentPlanUpForm> list) {
        HashMap map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        BigDecimal reduce = list.stream().filter(payment -> ObjectUtil.isNotEmpty((Object)payment.getPaymentAmount())).map(RkProcurePaymentPlanUpForm::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        List idList = list.stream().map(RkProcurePaymentPlanUpForm::getId).collect(Collectors.toList());
        List<RkProcurePaymentPlanEntity> listByProcureId = this.getListByProcureId(list.get(0).getProcureId());
        BigDecimal otherAmount = listByProcureId.stream().filter(plan -> !idList.contains(plan.getId())).map(RkProcurePaymentPlanEntity::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = MathUtils.add(otherAmount, reduce);
        RkProcureManageEntity byId = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)list.get(0).getProcureId()));
        if (!StrUtil.equals((CharSequence)byId.getIsTrustSettlement(), (CharSequence)"1") && totalAmount.compareTo(byId.getProcureAmount()) == 1) {
            map.put("error", "\u603b\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u989d");
            return map;
        }
        List jsonToList = JsonUtil.getJsonToList(list, RkProcurePaymentPlanEntity.class);
        for (RkProcurePaymentPlanEntity entity : jsonToList) {
            if (ObjectUtil.isEmpty((Object)entity.getPaymentAmount())) continue;
            BigDecimal multiply = MathUtils.multiply(entity.getPaymentAmount(), new BigDecimal(100));
            String divide = MathUtils.divide(multiply.toString(), byId.getProcureAmount().toString(), 2);
            entity.setPaymentRatio(new BigDecimal(divide));
        }
        this.saveOrUpdateBatch(jsonToList);
        return map;
    }

    @Override
    @DSTransactional
    public HashMap deleteBatch(List<String> idList) {
        HashMap map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(RkProcurePaymentPlanEntity::getId, idList);
        List list = this.list((Wrapper)queryWrapper);
        List collect = list.stream().filter(plan -> plan.getPaidAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect)) {
            map.put("error", "\u5b58\u5728\u5df2\u7ecf\u52fe\u9009\u4e2d\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u8ba1\u5212,\u4e0d\u80fd\u5220\u9664");
            return map;
        }
        this.rkProcurePaymentPlanService.removeBatchByIds(idList);
        return map;
    }

    @Override
    public void delete(RkProcurePaymentPlanEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

