/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkProcureInvoiceEntity;
import com.bringspring.contract.entity.RkProcureInvoiceRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkProcurePaymentEntity;
import com.bringspring.contract.entity.RkProcurePaymentPlanEntity;
import com.bringspring.contract.entity.RkProcurePaymentRelationEntity;
import com.bringspring.contract.mapper.RkProcurePaymentMapper;
import com.bringspring.contract.model.rkprocurepayment.RkInvoiceVo;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentImportReturnVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentImportVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentPagination;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentUpForm;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanCrForm;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkProcureInvoiceManageService;
import com.bringspring.contract.service.RkProcureInvoiceRelationService;
import com.bringspring.contract.service.RkProcureInvoiceService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcurePaymentPlanService;
import com.bringspring.contract.service.RkProcurePaymentRelationService;
import com.bringspring.contract.service.RkProcurePaymentService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProcureEncodeEnum;
import com.bringspring.ecs.model.ecspaymentcategories.PaymentCategoriesVO;
import com.bringspring.ecs.service.EcsPaymentCategoriesService;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProcurePaymentServiceImpl
extends ServiceImpl<RkProcurePaymentMapper, RkProcurePaymentEntity>
implements RkProcurePaymentService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProcurePaymentRelationService rkProcurePaymentRelationService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkProcurePaymentService rkProcurePaymentService;
    @Autowired
    private RkProcureInvoiceService rkProcureInvoiceService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkProcureInvoiceRelationService rkProcureInvoiceRelationService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private RkProcurePaymentPlanService rkProcurePaymentPlanService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkProcureInvoiceManageService rkProcureInvoiceManageService;
    @Autowired
    private SupplierService supplierService;
    @Autowired
    private EcsPaymentCategoriesService paymentCategoriesService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<RkProcurePaymentEntity> getList(RkProcurePaymentPagination rkProcurePaymentPagination) {
        List collect;
        List list;
        LambdaQueryWrapper relationList;
        List procureIdList;
        Object rkProcurePaymentObj;
        QueryWrapper<RkProcurePaymentEntity> queryWrapper = this.appendWrapper(rkProcurePaymentPagination);
        if (ObjectUtil.isEmpty(queryWrapper)) {
            ArrayList list2 = new ArrayList();
            return rkProcurePaymentPagination.setData(list2, list2.size());
        }
        QueryWrapper rkProcurePaymentRelationQueryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcurePaymentNum = 0;
        QueryWrapper rkProcurePaymentQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentQueryWrapper, rkProcurePaymentPagination.getMenuId(), "rkProcurePayment"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentObj)) {
                return new ArrayList<RkProcurePaymentEntity>();
            }
            rkProcurePaymentQueryWrapper = (QueryWrapper)rkProcurePaymentObj;
            ++rkProcurePaymentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentQueryWrapper, rkProcurePaymentPagination.getMenuId(), "rkProcurePayment"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentObj)) {
                return new ArrayList<RkProcurePaymentEntity>();
            }
            rkProcurePaymentQueryWrapper = (QueryWrapper)rkProcurePaymentObj;
            ++rkProcurePaymentNum;
        }
        rkProcurePaymentQueryWrapper.lambda().orderByDesc(RkProcurePaymentEntity::getCreatorTime);
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getPaymentCode())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().like(RkProcurePaymentEntity::getPaymentCode, (Object)rkProcurePaymentPagination.getPaymentCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getPaymentAmount())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().eq(RkProcurePaymentEntity::getPaymentAmount, (Object)rkProcurePaymentPagination.getPaymentAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getCompanyId())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().eq(RkProcurePaymentEntity::getCompanyId, (Object)rkProcurePaymentPagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getUserId())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().eq(RkProcurePaymentEntity::getCreatorUserId, (Object)rkProcurePaymentPagination.getUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getSource()) && rkProcurePaymentPagination.getSource().equals("check")) {
            ((LambdaQueryWrapper)rkProcurePaymentQueryWrapper.lambda().ne(RkProcurePaymentEntity::getCheckAmount, (Object)BigDecimal.ZERO)).and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(RkProcurePaymentEntity::getEnableMark, (Object)"complete")).or()).eq(RkProcurePaymentEntity::getEnableMark, (Object)"unpaid");
            });
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getProcureName())) {
            List<RkProcureManageEntity> byName = this.rkProcureManageService.getByName(rkProcurePaymentPagination.getProcureName());
            if (!CollectionUtil.isNotEmpty(byName)) return new ArrayList<RkProcurePaymentEntity>();
            procureIdList = byName.stream().map(name -> name.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcurePaymentEntity>();
            relationList = (LambdaQueryWrapper)rkProcurePaymentRelationQueryWrapper.lambda().in(RkProcurePaymentRelationEntity::getProcureId, procureIdList);
            list = this.rkProcurePaymentRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getPayId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcurePaymentQueryWrapper.lambda().in(RkProcurePaymentEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getProcureCode())) {
            List<RkProcureManageEntity> byCode = this.rkProcureManageService.getByCode(rkProcurePaymentPagination.getProcureCode());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcurePaymentEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcurePaymentEntity>();
            relationList = (LambdaQueryWrapper)rkProcurePaymentRelationQueryWrapper.lambda().in(RkProcurePaymentRelationEntity::getProcureId, procureIdList);
            list = this.rkProcurePaymentRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getPayId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcurePaymentQueryWrapper.lambda().in(RkProcurePaymentEntity::getId, collect);
            }
        }
        if (AllIdList.size() > 0) {
            rkProcurePaymentQueryWrapper.lambda().in(RkProcurePaymentEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkProcurePaymentPagination.getSidx())) {
            rkProcurePaymentQueryWrapper.lambda().orderByDesc(RkProcurePaymentEntity::getPayDate);
        } else {
            try {
                String sidx = rkProcurePaymentPagination.getSidx();
                RkProcurePaymentEntity rkProcurePaymentEntity = new RkProcurePaymentEntity();
                Field declaredField = rkProcurePaymentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcurePaymentQueryWrapper = "asc".equals(rkProcurePaymentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcurePaymentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcurePaymentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProcurePaymentPagination.getCurrentPage(), rkProcurePaymentPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProcurePaymentQueryWrapper);
            return rkProcurePaymentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list3 = new ArrayList();
        return rkProcurePaymentPagination.setData(list3, list3.size());
    }

    private QueryWrapper<RkProcurePaymentEntity> appendWrapper(RkProcurePaymentPagination rkProcurePaymentPagination) {
        QueryWrapper rkProcurePaymentQueryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(rkProcurePaymentPagination.getPayDate())) {
            rkProcurePaymentQueryWrapper.lambda().between(RkProcurePaymentEntity::getPayDate, (Object)rkProcurePaymentPagination.getPayDate().get(0), (Object)rkProcurePaymentPagination.getPayDate().get(1));
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getPayId())) {
            rkProcurePaymentQueryWrapper.lambda().like(RkProcurePaymentEntity::getPayId, (Object)rkProcurePaymentPagination.getPayId());
        }
        return rkProcurePaymentQueryWrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<RkProcurePaymentEntity> getTypeList(RkProcurePaymentPagination rkProcurePaymentPagination, String dataType) {
        List collect;
        List list;
        LambdaQueryWrapper relationList;
        List procureIdList;
        Object rkProcurePaymentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProcurePaymentNum = 0;
        QueryWrapper rkProcurePaymentQueryWrapper = new QueryWrapper();
        QueryWrapper rkProcurePaymentRelationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentQueryWrapper, rkProcurePaymentPagination.getMenuId(), "rk_procure_manage"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentObj)) {
                return new ArrayList<RkProcurePaymentEntity>();
            }
            rkProcurePaymentQueryWrapper = (QueryWrapper)rkProcurePaymentObj;
            ++rkProcurePaymentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProcurePaymentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProcurePaymentQueryWrapper, rkProcurePaymentPagination.getMenuId(), "rk_procure_manage"));
            if (ObjectUtil.isEmpty((Object)rkProcurePaymentObj)) {
                return new ArrayList<RkProcurePaymentEntity>();
            }
            rkProcurePaymentQueryWrapper = (QueryWrapper)rkProcurePaymentObj;
            ++rkProcurePaymentNum;
        }
        rkProcurePaymentQueryWrapper.lambda().orderByDesc(RkProcurePaymentEntity::getCreatorTime);
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getPaymentCode())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().like(RkProcurePaymentEntity::getPaymentCode, (Object)rkProcurePaymentPagination.getPaymentCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getPaymentAmount())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().eq(RkProcurePaymentEntity::getPaymentAmount, (Object)rkProcurePaymentPagination.getPaymentAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getUserId())) {
            ++rkProcurePaymentNum;
            rkProcurePaymentQueryWrapper.lambda().eq(RkProcurePaymentEntity::getCreatorUserId, (Object)rkProcurePaymentPagination.getUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getSource()) && rkProcurePaymentPagination.getSource().equals("check")) {
            ((LambdaQueryWrapper)rkProcurePaymentQueryWrapper.lambda().ne(RkProcurePaymentEntity::getCheckAmount, (Object)BigDecimal.ZERO)).eq(RkProcurePaymentEntity::getEnableMark, (Object)"complete");
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getProcureName())) {
            List<RkProcureManageEntity> byName = this.rkProcureManageService.getByName(rkProcurePaymentPagination.getProcureName());
            if (!CollectionUtil.isNotEmpty(byName)) return new ArrayList<RkProcurePaymentEntity>();
            procureIdList = byName.stream().map(name -> name.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcurePaymentEntity>();
            relationList = (LambdaQueryWrapper)rkProcurePaymentRelationQueryWrapper.lambda().in(RkProcurePaymentRelationEntity::getProcureId, procureIdList);
            list = this.rkProcurePaymentRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getPayId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcurePaymentQueryWrapper.lambda().in(RkProcurePaymentEntity::getId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkProcurePaymentPagination.getProcureCode())) {
            List<RkProcureManageEntity> byCode = this.rkProcureManageService.getByCode(rkProcurePaymentPagination.getProcureCode());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkProcurePaymentEntity>();
            procureIdList = byCode.stream().map(code -> code.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(procureIdList)) return new ArrayList<RkProcurePaymentEntity>();
            relationList = (LambdaQueryWrapper)rkProcurePaymentRelationQueryWrapper.lambda().in(RkProcurePaymentRelationEntity::getProcureId, procureIdList);
            list = this.rkProcurePaymentRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getPayId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkProcurePaymentQueryWrapper.lambda().in(RkProcurePaymentEntity::getId, collect);
            }
        }
        if (AllIdList.size() > 0) {
            rkProcurePaymentQueryWrapper.lambda().in(RkProcurePaymentEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkProcurePaymentPagination.getSidx())) {
            rkProcurePaymentQueryWrapper.lambda().orderByDesc(RkProcurePaymentEntity::getId);
        } else {
            try {
                String sidx = rkProcurePaymentPagination.getSidx();
                RkProcurePaymentEntity rkProcurePaymentEntity = new RkProcurePaymentEntity();
                Field declaredField = rkProcurePaymentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProcurePaymentQueryWrapper = "asc".equals(rkProcurePaymentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProcurePaymentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProcurePaymentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (!"0".equals(dataType)) return this.list((Wrapper)rkProcurePaymentQueryWrapper);
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProcurePaymentPagination.getCurrentPage(), rkProcurePaymentPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProcurePaymentQueryWrapper);
            return rkProcurePaymentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list2 = new ArrayList();
        return rkProcurePaymentPagination.setData(list2, list2.size());
    }

    @Override
    public RkProcurePaymentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProcurePaymentEntity::getId, (Object)id);
        return (RkProcurePaymentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProcurePaymentEntity entity) {
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean updatePayment(String id, RkProcurePaymentUpForm rkProcurePaymentUpForm) {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkProcurePaymentUpForm.setCompanyId(organizeId);
        String procureId = rkProcurePaymentUpForm.getProcureId();
        RkProcureManageEntity procureManageInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)procureId));
        rkProcurePaymentUpForm.setInvoiceAmount(rkProcurePaymentUpForm.getInvoiceAmount());
        rkProcurePaymentUpForm.setInvoiceAmountPro(MathUtils.divide(rkProcurePaymentUpForm.getInvoiceAmount(), procureManageInfo.getProcureAmount(), 4).multiply(new BigDecimal("100")));
        if (ObjectUtil.isEmpty((Object)procureManageInfo.getAccumulateInvoiceAmount())) {
            procureManageInfo.setAccumulateInvoiceAmount(new BigDecimal(0));
        }
        rkProcurePaymentUpForm.setAccumulateInvoiceAmount(procureManageInfo.getAccumulateInvoiceAmount());
        rkProcurePaymentUpForm.setAccumulateInvoicePro(MathUtils.divide(procureManageInfo.getAccumulateInvoiceAmount(), procureManageInfo.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
        rkProcurePaymentUpForm.setNotInvoiceAmount(MathUtils.substract(procureManageInfo.getProcureAmount(), rkProcurePaymentUpForm.getAccumulateInvoiceAmount()));
        rkProcurePaymentUpForm.setNotInvoicePro(MathUtils.substract(BigDecimal.valueOf(100L), rkProcurePaymentUpForm.getAccumulateInvoicePro()));
        RkProcurePaymentEntity entity = (RkProcurePaymentEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentUpForm), RkProcurePaymentEntity.class);
        entity.setCheckAmount(entity.getPaymentAmount());
        List<RkInvoiceVo> invoiceList = rkProcurePaymentUpForm.getInvoiceList();
        if (CollectionUtil.isNotEmpty(invoiceList)) {
            List jsonToList1 = JsonUtil.getJsonToList(invoiceList, RkProcureInvoiceEntity.class);
            jsonToList1.stream().forEach(invoice -> {
                RkProcureInvoiceEntity invoiceInfo = this.rkProcureInvoiceService.getInfo(invoice.getId());
                invoice.setCheckInvoice(MathUtils.substract(invoiceInfo.getInvoiceAmount(), invoice.getCheckInvoice()));
            });
            this.rkProcureInvoiceService.updateBatchById(jsonToList1);
            this.rkProcurePaymentRelationService.removeByPayId(id);
            List jsonToList = JsonUtil.getJsonToList(invoiceList, RkProcurePaymentRelationEntity.class);
            jsonToList.stream().forEach(relation -> {
                relation.setInvoiceId(relation.getId());
                relation.setPayId(rkProcurePaymentUpForm.getId());
                relation.setProcureId(procureId);
                relation.setId(RandomUtil.uuId());
                relation.setCheckInvoice(relation.getCheckInvoice());
                relation.setCreatorTime(new Date());
                relation.setCreatorUserId(userInfo.getUserId());
            });
            this.rkProcurePaymentRelationService.saveOrUpdateBatch(jsonToList);
        } else {
            RkProcurePaymentRelationEntity relationEntity = new RkProcurePaymentRelationEntity();
            relationEntity.setProcureId(procureId);
            relationEntity.setPayId(entity.getId());
            relationEntity.setId(RandomUtil.uuId());
            relationEntity.setCreatorTime(new Date());
            relationEntity.setCreatorUserId(userInfo.getUserId());
            this.rkProcurePaymentRelationService.save(relationEntity);
        }
        if (rkProcurePaymentUpForm.getEnableMark().equals("submit")) {
            if (ObjectUtil.isNotEmpty((Object)procureManageInfo)) {
                procureManageInfo.setAccumulatePaymentAmount(ObjectUtil.isEmpty((Object)procureManageInfo.getAccumulatePaymentAmount()) ? BigDecimal.valueOf(0L) : procureManageInfo.getAccumulatePaymentAmount());
                procureManageInfo.setNotPaymentAmount(MathUtils.add(procureManageInfo.getNotPaymentAmount(), rkProcurePaymentUpForm.getPaymentAmount()));
            }
            this.rkProcureManageService.updateById(procureManageInfo);
            entity.setInvoiceAmount(entity.getInvoiceAmount());
            entity.setInvoiceAmountPro(MathUtils.divide(entity.getInvoiceAmount(), procureManageInfo.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            entity.setAccumulateInvoiceAmount(procureManageInfo.getAccumulateInvoiceAmount());
            entity.setAccumulateInvoicePro(MathUtils.divide(procureManageInfo.getAccumulateInvoiceAmount(), procureManageInfo.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            entity.setNotInvoiceAmount(MathUtils.substract(procureManageInfo.getProcureAmount(), entity.getAccumulateInvoiceAmount()));
            entity.setNotInvoicePro(MathUtils.substract(BigDecimal.valueOf(100L), entity.getAccumulateInvoicePro()));
            if (procureManageInfo.getProcureAmount().compareTo(BigDecimal.ZERO) > 0) {
                List<RkProcurePaymentPlanCrForm> paymentPlanList = rkProcurePaymentUpForm.getPaymentPlanList();
                int count = 0;
                BigDecimal sum = rkProcurePaymentUpForm.getPaymentAmount();
                for (RkProcurePaymentPlanCrForm paymentPlanCrForm : paymentPlanList) {
                    paymentPlanCrForm.setOldPaidAmount(paymentPlanCrForm.getPaidAmount());
                    paymentPlanCrForm.setOldPaidRatio(paymentPlanCrForm.getPaidRatio());
                    if (paymentPlanList.size() > 1) {
                        if (sum.compareTo(paymentPlanCrForm.getPaymentAmount()) > 0) {
                            if (paymentPlanList.size() - 1 == count) {
                                paymentPlanCrForm.setPaidAmount(sum);
                                paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                                break;
                            }
                            paymentPlanCrForm.setPaidAmount(MathUtils.substract(paymentPlanCrForm.getPaymentAmount(), paymentPlanCrForm.getPaidAmount()));
                            paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                            sum = sum.subtract(paymentPlanCrForm.getPaidAmount());
                            ++count;
                            continue;
                        }
                        paymentPlanCrForm.setPaidAmount(paymentPlanCrForm.getPaidAmount().add(sum));
                        paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                        continue;
                    }
                    paymentPlanCrForm.setPaidAmount(rkProcurePaymentUpForm.getPaymentAmount().add(paymentPlanCrForm.getPaidAmount()));
                    paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                }
                List paymentPlanEntityList = JsonUtil.getJsonToList(paymentPlanList, RkProcurePaymentPlanEntity.class);
                this.rkProcurePaymentPlanService.updateBatchById(paymentPlanEntityList);
            }
        }
        return this.updateById(entity);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        RkProcurePaymentEntity entity = this.getInfo(id);
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 5 && model.getRejectAgreeStep().equals("0") || enableMark == 3) {
            List<RkProcurePaymentRelationEntity> listByProcureId = this.rkProcurePaymentRelationService.listByProcureId(entity.getId());
            listByProcureId.stream().forEach(relation -> {
                if (ObjectUtil.isNotEmpty((Object)relation.getInvoiceId())) {
                    RkProcureInvoiceEntity invoiceInfo = this.rkProcureInvoiceService.getInfo(relation.getInvoiceId());
                    invoiceInfo.setCheckInvoice(MathUtils.add(invoiceInfo.getCheckInvoice(), relation.getCheckInvoice()));
                    this.rkProcureInvoiceService.updateById(invoiceInfo);
                }
            });
            RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(entity.getProcureId());
            if (ObjectUtil.isNotEmpty((Object)entity.getAccumulateInvoiceAmount())) {
                entity.setAccumulateInvoiceAmount(MathUtils.substract(entity.getAccumulateInvoiceAmount(), entity.getInvoiceAmount()));
            } else {
                entity.setAccumulateInvoiceAmount(BigDecimal.ZERO);
            }
            procureInfo.setAccumulateInvoiceAmount(procureInfo.getAccumulateInvoiceAmount());
            entity.setInvoiceAmount(BigDecimal.ZERO);
            entity.setInvoiceAmountPro(BigDecimal.ZERO);
            entity.setNotInvoicePro(MathUtils.substract(BigDecimal.valueOf(100L), entity.getAccumulateInvoicePro()));
            this.rkProcurePaymentService.updateById(entity);
            entity.setResiduePaymentAmount(entity.getResiduePaymentAmount().add(entity.getPaymentAmount()));
            if (procureInfo.getProcureAmount().compareTo(BigDecimal.ZERO) > 0) {
                entity.setResiduePaymentPro(entity.getResiduePaymentAmount().multiply(BigDecimal.valueOf(100L)).divide(procureInfo.getProcureAmount(), 4, RoundingMode.HALF_UP));
                entity.setAccumulateInvoicePro(BigDecimal.valueOf(100L).multiply(entity.getAccumulateInvoiceAmount()).divide(procureInfo.getProcureAmount(), 4, RoundingMode.HALF_UP));
                entity.setNotInvoiceAmount(MathUtils.substract(procureInfo.getProcureAmount(), procureInfo.getAccumulateInvoiceAmount()));
            } else {
                entity.setResiduePaymentPro(entity.getPaymentProportion().add(entity.getResiduePaymentPro()));
                entity.setAccumulateInvoicePro(BigDecimal.ZERO);
                entity.setNotInvoiceAmount(BigDecimal.ZERO);
            }
            procureInfo.setNotPaymentAmount(MathUtils.substract(procureInfo.getNotPaymentAmount(), entity.getPaymentAmount()));
            this.rkProcureManageService.updateById(procureInfo);
            List<RkProcurePaymentPlanEntity> listByProcureId1 = this.rkProcurePaymentPlanService.getListByProcureId(entity.getProcureId());
            List planList = listByProcureId1.stream().filter(t -> t.getPaymentPlanFlag().equals("1")).collect(Collectors.toList());
            for (RkProcurePaymentPlanEntity paymentPlanEntity : planList) {
                paymentPlanEntity.setPaidAmount(paymentPlanEntity.getOldPaidAmount());
                paymentPlanEntity.setPaidRatio(paymentPlanEntity.getOldPaidRatio());
            }
            this.rkProcurePaymentPlanService.updateBatchById(planList);
        }
        if (enableMark == 4) {
            try {
                FlowTaskEntity f = this.flowTaskService.getDraftTaskByProcessId(id);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskNodeEntity::getState, (Object)0)).eq(FlowTaskNodeEntity::getTaskId, (Object)f.getId())).eq(FlowTaskNodeEntity::getCompletion, (Object)0)).ne(FlowTaskNodeEntity::getNodeCode, (Object)"end");
                List nodeList = this.flowTaskNodeService.list((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)nodeList)) {
                    entity.setEnableMark("unpaid");
                }
            }
            catch (WorkFlowException f) {
                // empty catch block
            }
        }
        if (enableMark == 2) {
            entity.setEnableMark("complete");
            RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)entity.getProcureId()));
            procureInfo.setNotPaymentAmount(MathUtils.substract(procureInfo.getNotPaymentAmount(), entity.getPaymentAmount()));
            procureInfo.setAccumulatePaymentAmount(MathUtils.add(procureInfo.getAccumulatePaymentAmount(), entity.getPaymentAmount()));
            this.rkProcureManageService.updateById(procureInfo);
            if (entity.getPaymentAmount().compareTo(BigDecimal.ZERO) > 0) {
                entity.setAccumulatePaymentAmount(procureInfo.getAccumulatePaymentAmount());
                if (procureInfo.getProcureAmount().compareTo(BigDecimal.ZERO) > 0) {
                    entity.setAccumulatePaymentPro(entity.getAccumulatePaymentAmount().multiply(BigDecimal.valueOf(100L)).divide(procureInfo.getProcureAmount(), 2, RoundingMode.HALF_UP));
                } else {
                    entity.setAccumulatePaymentPro(BigDecimal.ZERO);
                }
            } else {
                entity.setAccumulatePaymentAmount(entity.getAccumulatePaymentAmount().add(entity.getPaymentAmount()));
                entity.setAccumulatePaymentPro(entity.getAccumulatePaymentPro().add(entity.getPaymentProportion()));
            }
            List<RkProcurePaymentPlanEntity> paymentPlanList = this.rkProcurePaymentPlanService.getListByProcureId(entity.getProcureId());
            List filterList = paymentPlanList.stream().filter(t -> t.getPaymentPlanFlag().equals("1")).collect(Collectors.toList());
            filterList.stream().forEach(plan -> {
                if (plan.getPaymentAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (plan.getPaidAmount().compareTo(plan.getPaymentAmount()) >= 0) {
                        plan.setPaymentPlanFlag("0");
                    }
                } else if (plan.getPaidAmount().compareTo(plan.getPaymentAmount()) <= 0) {
                    plan.setPaymentPlanFlag("0");
                }
            });
            this.rkProcurePaymentPlanService.updateBatchById(filterList);
            if (procureInfo.getPaymentMethodType().equals("491973506859275781")) {
                this.insertPaymentReviewRecord(entity, procureInfo);
            }
        }
        return this.updateById(entity);
    }

    public void insertPaymentReviewRecord(RkProcurePaymentEntity entity, RkProcureManageEntity procureInfo) {
        SupplierEntity supplierEntity = this.supplierService.getInfo(procureInfo.getSupplierId());
        PaymentCategoriesVO categoriesVO = this.createPaymentCategoriesVO(entity, procureInfo, supplierEntity);
        try {
            this.paymentCategoriesService.saveRecord(categoriesVO);
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    private PaymentCategoriesVO createPaymentCategoriesVO(RkProcurePaymentEntity entity, RkProcureManageEntity procureInfo, SupplierEntity supplierEntity) {
        PaymentCategoriesVO categoriesVO = new PaymentCategoriesVO();
        categoriesVO.setPayAmount(entity.getPaymentAmount());
        categoriesVO.setCompanyId(entity.getCompanyId());
        categoriesVO.setTitle(procureInfo.getProcureName());
        categoriesVO.setSourceNumber(procureInfo.getProcureType());
        categoriesVO.setRecordType("ECS_PURCHASE_PAYMENT");
        categoriesVO.setReimbCompany(entity.getPaymentCompanyId());
        categoriesVO.setBankCardNo(supplierEntity.getSupplierAccount());
        categoriesVO.setSourceAuditNumber(entity.getPaymentCode());
        categoriesVO.setBankFirmCode(supplierEntity.getBankFirmCode());
        categoriesVO.setRcvAccName(supplierEntity.getSupplierName());
        categoriesVO.setApplyUesrId(entity.getPayId());
        categoriesVO.setBankAccountType("00");
        categoriesVO.setSourceId(entity.getId());
        return categoriesVO;
    }

    @Override
    public void delete(RkProcurePaymentEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public Map<String, Object> importPreview(List<RkProcurePaymentImportVO> fileImportList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < fileImportList.size(); ++i) {
            Map dataRowMap = new HashMap();
            RkProcurePaymentImportVO rkProcurePaymentImportVO = fileImportList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)rkProcurePaymentImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= fileImportList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", fileImportList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u53d1\u7968\u5355\u636e\u53f7");
        map.put(2, "\u672c\u6b21\u6838\u9500\u91d1\u989d");
        map.put(3, "\u4ed8\u6b3e\u7533\u8bf7\u65f6\u95f4");
        map.put(4, "\u4ed8\u6b3e\u8bf4\u660e");
        return (String)map.get(key);
    }

    @Override
    public RkProcurePaymentImportReturnVO importData(List<RkProcurePaymentImportVO> dataList) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userInfo.getDepartmentId());
        String[] departmentTree = organizeEntity.getOrganizeIdTree().split(",");
        String[] newArray = new String[departmentTree.length - 2];
        System.arraycopy(departmentTree, 2, newArray, 0, newArray.length);
        List<String> o1 = Arrays.asList(newArray);
        String ApplyDepartmentTree = o1.toString();
        String ApplyDepartmentTreeName = this.baseDataUtil.comSelectValues(ApplyDepartmentTree);
        String ApplyDepartmentOne = departmentTree[departmentTree.length - 2];
        String ApplyDepartmentOneName = this.baseDataUtil.comSelectValues(ApplyDepartmentOne);
        String ApplyDepartment = departmentTree[departmentTree.length - 1];
        String ApplyDepartmentName = this.baseDataUtil.comSelectValues(ApplyDepartment);
        HashMap dictMap = MapUtil.newHashMap();
        List<ProcureEncodeEnum> allToList = ProcureEncodeEnum.getAllToList();
        allToList.stream().forEach(fileEncodeEnum -> {
            String encode = fileEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
            dictMap.put(encode, collect);
        });
        List rkProcurePaymentEntityList = CollectionUtil.list((boolean)false);
        List rkProcurePaymentRelationEntityList = CollectionUtil.list((boolean)false);
        List allInvoiceList = this.rkProcureInvoiceService.list((Wrapper)new QueryWrapper());
        List allProcureInvoiceRelationList = this.rkProcureInvoiceRelationService.list((Wrapper)new QueryWrapper());
        List organizeList = this.organizeService.getList();
        List errorList = CollectionUtil.list((boolean)false);
        boolean successNum = false;
        int errorNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (RkProcurePaymentImportVO ImportVO : dataList) {
            String invoiceId = "";
            String procureId = "";
            RkProcureManageEntity procureEntity = new RkProcureManageEntity();
            if (StringUtil.isNotEmpty((String)ImportVO.getInvoiceId())) {
                ImportVO.setInvoiceId(StrUtil.trim((CharSequence)ImportVO.getInvoiceId()));
                List invoiceMatchList = allInvoiceList.stream().filter(a -> a.getInvoiceCode().equals(ImportVO.getInvoiceId())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(invoiceMatchList)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u53d1\u7968\u5355\u636e\u53f7\u4e0d\u5b58\u5728");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    List matchTemp;
                    invoiceId = ((RkProcureInvoiceEntity)invoiceMatchList.get(0)).getId();
                    if (!StringUtils.isEmpty((String)invoiceId) && CollectionUtil.isNotEmpty(matchTemp = allProcureInvoiceRelationList.stream().filter(a -> a.getInvoiceId().equals(((RkProcureInvoiceEntity)invoiceMatchList.get(0)).getId())).collect(Collectors.toList()))) {
                        procureId = ((RkProcureInvoiceRelationEntity)matchTemp.get(0)).getProcureId();
                        procureEntity = this.rkProcureManageService.getInfo(procureId);
                    }
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u53d1\u7968\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getCheckInvoice())) {
                ++errorNum;
                ImportVO.setErrMsg("\u672c\u6b21\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else if (!NumberUtil.isNumber((CharSequence)ImportVO.getCheckInvoice())) {
                ++errorNum;
                ImportVO.setErrMsg("\u672c\u6b21\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StringUtil.isEmpty((String)ImportVO.getPaymentIllustrate())) {
                ++errorNum;
                ImportVO.setErrMsg("\u4ed8\u6b3e\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                ImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                ImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(ImportVO);
                continue;
            }
            String payId = RandomUtil.uuId();
            String payRelationId = RandomUtil.uuId();
            RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)procureId));
            List collect = rkProcurePaymentEntityList.stream().filter(payment -> payment.getProcureId().equals(procureInfo.getId())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                RkProcurePaymentEntity firstPayment = (RkProcurePaymentEntity)collect.get(0);
                RkProcurePaymentRelationEntity rkProcurePaymentRelationEntity = (RkProcurePaymentRelationEntity)JsonUtil.getJsonToBean((Object)ImportVO, RkProcurePaymentRelationEntity.class);
                rkProcurePaymentRelationEntity.setInvoiceId(invoiceId);
                rkProcurePaymentRelationEntity.setPayId(((RkProcurePaymentEntity)collect.get(0)).getId());
                rkProcurePaymentRelationEntity.setId(payRelationId);
                rkProcurePaymentRelationEntity.setProcureId(procureEntity.getId());
                rkProcurePaymentRelationEntity.setEnableMark("import");
                rkProcurePaymentRelationEntity.setCreatorTime(new Date());
                rkProcurePaymentRelationEntity.setCheckInvoice(new BigDecimal(ImportVO.getCheckInvoice()));
                rkProcurePaymentRelationEntityList.add(rkProcurePaymentRelationEntity);
                continue;
            }
            RkProcurePaymentRelationEntity rkProcurePaymentRelationEntity = (RkProcurePaymentRelationEntity)JsonUtil.getJsonToBean((Object)ImportVO, RkProcurePaymentRelationEntity.class);
            rkProcurePaymentRelationEntity.setInvoiceId(invoiceId);
            rkProcurePaymentRelationEntity.setPayId(payId);
            rkProcurePaymentRelationEntity.setId(payRelationId);
            rkProcurePaymentRelationEntity.setProcureId(procureEntity.getId());
            rkProcurePaymentRelationEntity.setEnableMark("import");
            rkProcurePaymentRelationEntity.setCreatorTime(new Date());
            rkProcurePaymentRelationEntity.setCheckInvoice(new BigDecimal(ImportVO.getCheckInvoice()));
            rkProcurePaymentRelationEntityList.add(rkProcurePaymentRelationEntity);
            RkProcurePaymentEntity payment1 = new RkProcurePaymentEntity();
            payment1.setPaymentCode(this.baseDataUtil.getBillNumber("paymentCode", Boolean.valueOf(false)));
            payment1.setPaymentIllustrate(ImportVO.getPaymentIllustrate());
            payment1.setPaymentAmount(new BigDecimal(ImportVO.getCheckInvoice()));
            payment1.setId(payId);
            payment1.setProcureId(procureEntity.getId());
            payment1.setSalesPerson(procureEntity.getSalesPerson());
            payment1.setProjectManager(procureEntity.getProjectManager());
            payment1.setProjectManagerName(procureEntity.getProjectManagerName());
            payment1.setInvoiceAmount(payment1.getPaymentAmount());
            if (StringUtil.isNotEmpty((String)procureEntity.getId())) {
                payment1.setPaymentProportion(MathUtils.divide(payment1.getPaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                payment1.setAccumulatePaymentAmount(MathUtils.add(procureEntity.getAccumulatePaymentAmount(), payment1.getPaymentAmount()));
                payment1.setNotPaymentAmount(procureEntity.getNotPaymentAmount());
                payment1.setResiduePaymentAmount(MathUtils.substract(procureEntity.getProcureAmount(), payment1.getAccumulatePaymentAmount()));
                payment1.setAccumulatePaymentPro(MathUtils.divide(payment1.getAccumulatePaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                payment1.setNotPaymentAmountPro(MathUtils.divide(payment1.getNotPaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                payment1.setResiduePaymentPro(MathUtils.divide(payment1.getResiduePaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                payment1.setAccumulateInvoiceAmount(procureEntity.getAccumulateInvoiceAmount());
                payment1.setNotInvoiceAmount(MathUtils.substract(procureEntity.getProcureAmount(), payment1.getAccumulateInvoiceAmount()));
                payment1.setInvoiceAmountPro(MathUtils.divide(payment1.getInvoiceAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                payment1.setAccumulateInvoicePro(MathUtils.divide(payment1.getAccumulateInvoiceAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                payment1.setNotInvoicePro(MathUtils.substract(BigDecimal.valueOf(100L), payment1.getAccumulateInvoicePro()));
            }
            rkProcurePaymentEntityList.add(payment1);
            rkProcurePaymentEntityList.stream().forEach(a -> {
                a.setPayId(userInfo.getUserId());
                a.setPayName(userInfo.getRealName());
                a.setPayDepartment(userInfo.getDepartmentId());
                a.setPayDepartmentName(ApplyDepartmentName);
                a.setPayDepartmentOne(ApplyDepartmentOne);
                a.setPayDepartmentOneName(ApplyDepartmentOneName);
                a.setPayDepartmentTree(ApplyDepartmentTree);
                a.setPayDepartmentTreeName(ApplyDepartmentTreeName);
                a.setCompanyId(companyId);
                a.setEnableMark("history");
                a.setCreatorTime(new Date());
                a.setPayDate(new Date());
                a.setCreatorUserId(userInfo.getUserId());
            });
        }
        this.saveBatch(rkProcurePaymentEntityList);
        this.rkProcurePaymentRelationService.saveBatch(rkProcurePaymentRelationEntityList);
        rkProcurePaymentEntityList.stream().forEach(payment -> {
            RkProcureManageEntity procureEntity = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)payment.getProcureId()));
            List<RkProcurePaymentRelationEntity> paymentRelation = this.rkProcurePaymentRelationService.listByProcureId(payment.getId());
            BigDecimal paymentAmount = BigDecimal.ZERO;
            paymentAmount = paymentRelation.stream().map(RkProcurePaymentRelationEntity::getCheckInvoice).reduce(BigDecimal.ZERO, BigDecimal::add);
            payment.setPaymentAmount(paymentAmount);
            payment.setPaymentProportion(MathUtils.divide(payment.getPaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            payment.setAccumulatePaymentAmount(MathUtils.add(procureEntity.getAccumulatePaymentAmount(), payment.getPaymentAmount()));
            payment.setNotPaymentAmount(procureEntity.getNotPaymentAmount());
            payment.setResiduePaymentAmount(MathUtils.substract(procureEntity.getProcureAmount(), payment.getAccumulatePaymentAmount()));
            payment.setAccumulatePaymentPro(MathUtils.divide(payment.getAccumulatePaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            payment.setNotPaymentAmountPro(MathUtils.divide(payment.getNotPaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            payment.setResiduePaymentPro(MathUtils.divide(payment.getResiduePaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            this.rkProcurePaymentService.updateById(payment);
        });
        rkProcurePaymentRelationEntityList.stream().forEach(a -> {
            RkProcureManageEntity procureEntity = this.rkProcureManageService.getInfo(a.getProcureId());
            procureEntity.setAccumulatePaymentAmount(MathUtils.add(procureEntity.getAccumulatePaymentAmount(), a.getCheckInvoice()));
            procureEntity.setAccumulatePaymentPro(MathUtils.divide(procureEntity.getAccumulatePaymentAmount(), procureEntity.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
            this.rkProcureManageService.updateById(procureEntity);
            RkProcureInvoiceEntity invoiceEntity = this.rkProcureInvoiceService.getInfo(a.getInvoiceId());
            invoiceEntity.setCheckInvoice(MathUtils.substract(invoiceEntity.getCheckInvoice(), a.getCheckInvoice()));
            this.rkProcureInvoiceService.updateById(invoiceEntity);
        });
        RkProcurePaymentImportReturnVO vo = new RkProcurePaymentImportReturnVO();
        vo.setSnum(rkProcurePaymentEntityList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, RkProcurePaymentImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }
}

