/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectPlanChangeEntity;
import com.bringspring.contract.entity.RkProjectPlanDetailEntity;
import com.bringspring.contract.mapper.RkProjectPlanDetailMapper;
import com.bringspring.contract.model.rkprojectplanchange.RkProjectPlanChangeCrForm;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectPlanChangeService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.utils.ProjectPlanChangeEnum;
import com.bringspring.contract.utils.ProjectPlanExecutionResultEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProjectPlanDetailServiceImpl
extends ServiceImpl<RkProjectPlanDetailMapper, RkProjectPlanDetailEntity>
implements RkProjectPlanDetailService {
    @Autowired
    private RkProjectPlanChangeService rkProjectPlanChangeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public List<RkProjectPlanDetailEntity> listByPlanId(String planId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkProjectPlanDetailEntity::getPlanId, (Object)planId)).eq(RkProjectPlanDetailEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByAsc(RkProjectPlanDetailEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProjectPlanDetailEntity> listByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkProjectPlanDetailEntity::getProjectId, (Object)projectId)).eq(RkProjectPlanDetailEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByAsc(RkProjectPlanDetailEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void planChange(RkProjectPlanChangeCrForm projectPlanChangeCrForm) {
        RkProjectPlanDetailEntity byId = (RkProjectPlanDetailEntity)this.getById((Serializable)((Object)projectPlanChangeCrForm.getPlanDetailId()));
        if (CollectionUtil.isNotEmpty(projectPlanChangeCrForm.getChangeTime())) {
            projectPlanChangeCrForm.setChangeStartTime(projectPlanChangeCrForm.getChangeTime().get(0));
            projectPlanChangeCrForm.setChangeEndTime(projectPlanChangeCrForm.getChangeTime().get(1));
        }
        if (StrUtil.equals((CharSequence)projectPlanChangeCrForm.getChangeType(), (CharSequence)ProjectPlanChangeEnum.CHANGE_TYPE.getChange())) {
            if (CollectionUtil.isNotEmpty(projectPlanChangeCrForm.getChangeTime())) {
                byId.setChangeStartTime((Date)DateUtil.date((long)projectPlanChangeCrForm.getChangeTime().get(0)));
                byId.setChangeEndTime((Date)DateUtil.date((long)projectPlanChangeCrForm.getChangeTime().get(1)));
            }
        } else {
            byId.setExecutionResult(projectPlanChangeCrForm.getChangeType());
            if (StrUtil.equals((CharSequence)projectPlanChangeCrForm.getChangeType(), (CharSequence)ProjectPlanChangeEnum.COMPLETE_TYPE.getChange())) {
                byId.setActStartTime(ObjectUtil.isNull((Object)byId.getChangeStartTime()) ? byId.getPlanStartTime() : byId.getChangeStartTime());
                byId.setActEndTime((Date)DateUtil.date((long)projectPlanChangeCrForm.getCompleteTime()));
            }
        }
        byId.setExecutionDesc(projectPlanChangeCrForm.getDescription());
        this.updateById(byId);
        projectPlanChangeCrForm.setProjectId(byId.getProjectId());
        projectPlanChangeCrForm.setPlanId(byId.getPlanId());
        RkProjectPlanChangeEntity jsonToBean = (RkProjectPlanChangeEntity)JsonUtil.getJsonToBean((Object)projectPlanChangeCrForm, RkProjectPlanChangeEntity.class);
        jsonToBean.setId(RandomUtil.uuId());
        this.rkProjectPlanChangeService.save(jsonToBean);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractProjectEntity::getProjectPlanRatio, (Object)projectPlanChangeCrForm.getProjectPlanRatio())).eq(RkContractProjectEntity::getId, (Object)projectPlanChangeCrForm.getProjectId());
        this.rkContractProjectService.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateStop(String projectId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkProjectPlanDetailEntity::getExecutionResult, (Object)ProjectPlanExecutionResultEnum.stop.getResult())).eq(RkProjectPlanDetailEntity::getProjectId, (Object)projectId)).isNull(RkProjectPlanDetailEntity::getExecutionResult);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateStart(String projectId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkProjectPlanDetailEntity::getExecutionResult, null)).eq(RkProjectPlanDetailEntity::getProjectId, (Object)projectId)).eq(RkProjectPlanDetailEntity::getExecutionResult, (Object)ProjectPlanExecutionResultEnum.stop.getResult());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectPlanDetailEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public RkProjectPlanDetailEntity getInfo(String id) {
        return (RkProjectPlanDetailEntity)this.getById((Serializable)((Object)id));
    }

    @Override
    public void delete(RkProjectPlanDetailEntity entity) {
        this.removeById(entity);
    }

    @Override
    public List<RkProjectPlanDetailEntity> getSubPlan(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectPlanDetailEntity::getSubPlanId, (Object)id);
        queryWrapper.lambda().orderByAsc(RkProjectPlanDetailEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProjectPlanDetailEntity templateDetailEntity) {
        this.save(templateDetailEntity);
    }
}

