/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.contract.entity.RkProjectProductEntity;
import com.bringspring.contract.mapper.RkProjectProductMapper;
import com.bringspring.contract.service.RkProjectProductService;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProjectProductServiceImpl
extends ServiceImpl<RkProjectProductMapper, RkProjectProductEntity>
implements RkProjectProductService {
    @Autowired
    private CrmProductService crmProductService;

    @Override
    public List<RkProjectProductEntity> getListByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectProductEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProjectProductEntity> getListByProjectId(String projectId, boolean needReturnName) {
        List<RkProjectProductEntity> list = this.getListByProjectId(projectId);
        if (needReturnName) {
            list.stream().forEach(x -> {
                CrmProductEntity byId = (CrmProductEntity)this.crmProductService.getById((Serializable)((Object)x.getProductId()));
                if (!ObjectUtil.isEmpty((Object)byId)) {
                    x.setProductName(byId.getProductName());
                }
            });
        }
        return list;
    }

    @Override
    public void removeByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectProductEntity::getProjectId, (Object)projectId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProjectProductEntity> getListByProductIdList(List<String> productList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(RkProjectProductEntity::getProductId, productList);
        return this.list((Wrapper)queryWrapper);
    }
}

