/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectQuestionEntity;
import com.bringspring.contract.mapper.RkProjectQuestionMapper;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionAssignCrForm;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionDealCrForm;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionListVO;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionPagination;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.contract.service.RkProjectQuestionTrendsService;
import com.bringspring.contract.utils.ProjectQuestionStateEnum;
import com.bringspring.contract.utils.ProjectQuestionTrendsTypeEnum;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.utils.CustomizeSortWrapper;
import com.bringspring.utils.MessageUtils;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProjectQuestionServiceImpl
extends ServiceImpl<RkProjectQuestionMapper, RkProjectQuestionEntity>
implements RkProjectQuestionService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProjectQuestionTrendsService rkProjectQuestionTrendsService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public List<RkProjectQuestionEntity> getList(RkProjectQuestionPagination rkProjectQuestionPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkProjectQuestionQueryWrapper = this.appendWhere(rkProjectQuestionPagination);
        if (ObjectUtil.isNull(rkProjectQuestionQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkProjectQuestionPagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            rkProjectQuestionQueryWrapper.lambda().in(RkProjectQuestionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkProjectQuestionPagination.getSidx())) {
            rkProjectQuestionQueryWrapper.lambda().orderByDesc(RkProjectQuestionEntity::getId);
        } else {
            try {
                QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(rkProjectQuestionPagination, new RkProjectQuestionListVO(), rkProjectQuestionQueryWrapper);
                if (ObjectUtil.isNull((Object)customSortWrapper)) {
                    String sidx = rkProjectQuestionPagination.getSidx();
                    RkContractEntity rkContractEntity = new RkContractEntity();
                    Field declaredField = rkContractEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    rkProjectQuestionQueryWrapper = "asc".equals(rkProjectQuestionPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProjectQuestionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectQuestionQueryWrapper.orderByDesc((Object)value);
                } else {
                    rkProjectQuestionQueryWrapper = customSortWrapper;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProjectQuestionPagination.getCurrentPage(), rkProjectQuestionPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectQuestionQueryWrapper);
            return rkProjectQuestionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkProjectQuestionPagination.setData(list, list.size());
    }

    private QueryWrapper<RkProjectQuestionEntity> appendWhere(RkProjectQuestionPagination rkProjectQuestionPagination) {
        Long sec;
        Long fir;
        List<String> StartDateList;
        Object rkContractObj;
        boolean isPc;
        QueryWrapper rkProjectQuestionQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)rkProjectQuestionPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
        }
        if ((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectQuestionQueryWrapper, rkProjectQuestionPagination.getMenuId(), "rk_project_question"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkProjectQuestionQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectQuestionQueryWrapper, rkProjectQuestionPagination.getMenuId(), "rk_project_question"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkProjectQuestionQueryWrapper = (QueryWrapper)rkContractObj;
        }
        rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getDeleteFlag, (Object)0);
        rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getEnabledMark, (Object)1);
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getCustomerId())) {
            rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getCustomerId, (Object)rkProjectQuestionPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getDevelopState())) {
            rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getDevelopState, (Object)rkProjectQuestionPagination.getDevelopState());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectQuestionPagination.getQuestionCode())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getQuestionCode, (Object)rkProjectQuestionPagination.getQuestionCode().replaceAll("\\s", ""));
        }
        if (CollectionUtil.isNotEmpty(rkProjectQuestionPagination.getCreatorUserIdList())) {
            rkProjectQuestionQueryWrapper.lambda().in(RkProjectQuestionEntity::getCreatorUserId, rkProjectQuestionPagination.getCreatorUserIdList());
        }
        if (CollectionUtil.isNotEmpty(rkProjectQuestionPagination.getCategoryIdList())) {
            rkProjectQuestionQueryWrapper.lambda().in(RkProjectQuestionEntity::getProductCatagory, rkProjectQuestionPagination.getCategoryIdList());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getProductIdList())) {
            List<String> list = Arrays.asList(rkProjectQuestionPagination.getProductIdList().split(","));
            rkProjectQuestionQueryWrapper.lambda().in(RkProjectQuestionEntity::getProductId, list);
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getProjectId())) {
            rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getProjectId, (Object)rkProjectQuestionPagination.getProjectId().replaceAll("\\s", ""));
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getProjectName())) {
            List<RkContractProjectEntity> listByNameLike = this.rkContractProjectService.getListByNameLike(rkProjectQuestionPagination.getProjectName());
            if (CollectionUtil.isEmpty(listByNameLike)) {
                return null;
            }
            List collect = listByNameLike.stream().map(RkContractProjectEntity::getId).collect(Collectors.toList());
            rkProjectQuestionQueryWrapper.lambda().in(RkProjectQuestionEntity::getProjectId, collect);
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getType())) {
            rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getType, (Object)rkProjectQuestionPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getPriority())) {
            rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getPriority, (Object)rkProjectQuestionPagination.getPriority());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getState())) {
            rkProjectQuestionQueryWrapper.lambda().eq(RkProjectQuestionEntity::getState, (Object)rkProjectQuestionPagination.getState());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getKeyword())) {
            rkProjectQuestionQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(RkProjectQuestionEntity::getDescription, (Object)rkProjectQuestionPagination.getKeyword().replaceAll("\\s", ""))).or()).like(RkProjectQuestionEntity::getCustomerName, (Object)rkProjectQuestionPagination.getKeyword().replaceAll("\\s", "")));
        }
        if (StringUtils.isNotEmpty(rkProjectQuestionPagination.getStartDate())) {
            StartDateList = rkProjectQuestionPagination.getStartDate();
            fir = Long.valueOf(StartDateList.get(0));
            sec = Long.valueOf(StartDateList.get(1));
            ((LambdaQueryWrapper)rkProjectQuestionQueryWrapper.lambda().ge(RkProjectQuestionEntity::getStartDate, (Object)new Date(fir))).le(RkProjectQuestionEntity::getStartDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(rkProjectQuestionPagination.getCreateTime())) {
            StartDateList = rkProjectQuestionPagination.getCreateTime();
            fir = Long.valueOf(StartDateList.get(0));
            sec = Long.valueOf(StartDateList.get(1));
            ((LambdaQueryWrapper)rkProjectQuestionQueryWrapper.lambda().ge(RkProjectQuestionEntity::getCreatorTime, (Object)new Date(fir))).le(RkProjectQuestionEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getDescription())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getDescription, (Object)rkProjectQuestionPagination.getDescription().replaceAll("\\s", ""));
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getProcessedUser())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getProcessedUser, (Object)rkProjectQuestionPagination.getProcessedUser());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getDealUser())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getDealUser, (Object)rkProjectQuestionPagination.getDealUser());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getCustomerName())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getCustomerName, (Object)rkProjectQuestionPagination.getCustomerName().replaceAll("\\s", ""));
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getCompanyId())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getCompanyId, (Object)rkProjectQuestionPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getIsResolved())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getIsResolved, (Object)rkProjectQuestionPagination.getIsResolved());
        }
        if (StringUtils.isNotEmpty((String)rkProjectQuestionPagination.getDeleteFlag())) {
            rkProjectQuestionQueryWrapper.lambda().like(RkProjectQuestionEntity::getDeleteFlag, (Object)rkProjectQuestionPagination.getDeleteFlag());
        }
        if (StringUtils.isNotEmpty(rkProjectQuestionPagination.getDealTime())) {
            List<String> DealTimeList = rkProjectQuestionPagination.getDealTime();
            fir = Long.valueOf(DealTimeList.get(0));
            sec = Long.valueOf(DealTimeList.get(1));
            ((LambdaQueryWrapper)rkProjectQuestionQueryWrapper.lambda().ge(RkProjectQuestionEntity::getDealTime, (Object)new Date(fir))).le(RkProjectQuestionEntity::getDealTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        return rkProjectQuestionQueryWrapper;
    }

    @Override
    public List<RkProjectQuestionEntity> getTypeList(RkProjectQuestionPagination rkProjectQuestionPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean rkProjectQuestionNum = false;
        QueryWrapper rkProjectQuestionQueryWrapper = this.appendWhere(rkProjectQuestionPagination);
        if (ObjectUtil.isNull(rkProjectQuestionQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkProjectQuestionPagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            rkProjectQuestionQueryWrapper.lambda().in(RkProjectQuestionEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkProjectQuestionPagination.getSidx())) {
            rkProjectQuestionQueryWrapper.lambda().orderByDesc(RkProjectQuestionEntity::getId);
        } else {
            try {
                String sidx = rkProjectQuestionPagination.getSidx();
                RkProjectQuestionEntity rkProjectQuestionEntity = new RkProjectQuestionEntity();
                Field declaredField = rkProjectQuestionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProjectQuestionQueryWrapper = "asc".equals(rkProjectQuestionPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProjectQuestionQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectQuestionQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkProjectQuestionPagination.getCurrentPage(), rkProjectQuestionPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectQuestionQueryWrapper);
                return rkProjectQuestionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkProjectQuestionPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkProjectQuestionQueryWrapper);
    }

    @Override
    public RkProjectQuestionEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectQuestionEntity::getId, (Object)id);
        return (RkProjectQuestionEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProjectQuestionEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkProjectQuestionEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkProjectQuestionEntity entity) {
        if (entity != null) {
            entity.setDeleteFlag(1);
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void assginQuestion(RkProjectQuestionAssignCrForm assignCrForm) throws PermissionException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectQuestionEntity byId = (RkProjectQuestionEntity)this.getById((Serializable)((Object)assignCrForm.getId()));
        if (ObjectUtil.isNull((Object)byId)) {
            throw new PermissionException("\u95ee\u9898\u4e0d\u5b58\u5728");
        }
        byId.setProcessedUser(assignCrForm.getProcessedUser());
        byId.setState(ProjectQuestionStateEnum.STATE_ASSIGN.getState());
        this.update(assignCrForm.getId(), byId);
        RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)byId.getProjectId()));
        try {
            UserEntity userEntity = (UserEntity)this.userService.getById((Serializable)((Object)assignCrForm.getProcessedUser()));
            String nodeDesc = userInfo.getUserName() + "\u3010\u5206\u6d3e\u7ed9\u3011" + userEntity.getRealName();
            this.rkProjectQuestionTrendsService.saveTrends(byId.getProjectId(), byId.getId(), ProjectQuestionTrendsTypeEnum.ASSIGN_TYPE.getType(), nodeDesc, assignCrForm.getProcessedUser(), assignCrForm.getDescription());
            if (StringUtil.isNotEmpty((String)assignCrForm.getProcessedUser())) {
                String title = userInfo.getUserName() + "\u7ed9\u60a8\u5206\u6d3e\u9879\u76ee\u95ee\u9898\uff0c\u8bf7\u5904\u7406\uff01";
                String content = assignCrForm.getDescription();
                String description = byId.getDescription();
                this.pushToAssgin(title, content, assignCrForm.getProcessedUser(), assignCrForm.getDescription(), assignCrForm.getId(), projectEntity.getProjectName(), userInfo.getUserName(), description);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pushToAssgin(String title, String content, String userId, String assignReamrk, String id, String projectName, String assignUser, String description) throws Exception {
        String taskCode = MessageTypeEnum.PROJECT_QUESTION_ASSIGN_TEMPLATE.getMessage();
        String sendCode = MessageTypeEnum.PROJECT_QUESTION_ASSIGN_TEMPLATE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        keys.put("projectName", projectName);
        keys.put("assignUser", assignUser);
        keys.put("assignReamrk", assignReamrk);
        keys.put("description", description);
        keys.put("messageTime", DateUtil.getNow());
        String appUrl = "/#/pages/project/projectQuestion/form?jurisdictionType=btn_detail&id=" + id;
        String pcUrl = "/#/contract/project/question?id=" + id + "&applicationId=all";
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userId, termType, null);
    }

    private void pushToCreateor(String title, String content, String userId, String dealUser, String dealReamrk, String id, String projectName, String description) throws Exception {
        String taskCode = MessageTypeEnum.PROJECT_QUESTION_DEAL_TEMPLATE.getMessage();
        String sendCode = MessageTypeEnum.PROJECT_QUESTION_DEAL_TEMPLATE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        keys.put("projectName", projectName);
        keys.put("description", description);
        keys.put("dealUser", dealUser);
        keys.put("dealReamrk", dealReamrk);
        keys.put("messageTime", DateUtil.getNow());
        String appUrl = "/#/pages/project/projectList/detail?menuId=550237317701308421&jurisdictionType=btn_detail&id=" + id;
        String pcUrl = "/#/contract/project/question?id=" + id + "&applicationId=all";
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userId, termType, null);
    }

    @Override
    @DSTransactional
    public void dealQuestion(RkProjectQuestionDealCrForm dealCrForm) throws PermissionException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectQuestionEntity byId = (RkProjectQuestionEntity)this.getById((Serializable)((Object)dealCrForm.getId()));
        if (ObjectUtil.isNull((Object)byId)) {
            throw new PermissionException("\u95ee\u9898\u4e0d\u5b58\u5728");
        }
        String result = "";
        if (dealCrForm.getIsResolved() == 2) {
            byId.setState(ProjectQuestionStateEnum.STATE_DOCKED.getState());
            result = "\u672a\u5b8c\u6210";
        } else {
            byId.setState(ProjectQuestionStateEnum.STATE_RESOLVED.getState());
            result = "\u5df2\u5b8c\u6210";
        }
        byId.setDealDesc(dealCrForm.getDescription());
        byId.setDealUser(userInfo.getUserId());
        byId.setDealTime(DateUtil.getNowDate());
        byId.setIsResolved(dealCrForm.getIsResolved());
        byId.setSolution(dealCrForm.getSolution());
        byId.setEstimatedTime(dealCrForm.getEstimatedTime());
        this.update(dealCrForm.getId(), byId);
        RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)byId.getProjectId()));
        try {
            String nodeDesc = userInfo.getUserName() + "\u3010\u89e3\u51b3\u3011\u95ee\u9898";
            this.rkProjectQuestionTrendsService.saveTrends(byId.getProjectId(), byId.getId(), ProjectQuestionTrendsTypeEnum.DEAL_TYPE.getType(), nodeDesc, "", dealCrForm.getDescription());
            String title = "\u60a8\u63d0\u4ea4\u7684\u9879\u76ee\u95ee\u9898\u5df2\u5904\u7406\u3002";
            String content = dealCrForm.getDescription();
            String dealUser = userInfo.getUserName();
            this.pushToCreateor(title, content, byId.getCreatorUserId(), dealUser, dealCrForm.getDescription(), dealCrForm.getId(), projectEntity.getProjectName(), byId.getDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long countByProjectId(String projectId, String customerId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkProjectQuestionEntity::getProjectId, (Object)projectId)).eq(RkProjectQuestionEntity::getDeleteFlag, (Object)0)).eq(RkProjectQuestionEntity::getEnabledMark, (Object)1)).or()).eq(RkProjectQuestionEntity::getCustomerId, (Object)customerId);
        return this.count((Wrapper)queryWrapper);
    }
}

