/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectStopRecordEntity;
import com.bringspring.contract.mapper.RkProjectStopRecordMapper;
import com.bringspring.contract.model.rkcontractproject.RkProjectAssignedForm;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectStopRecordService;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProjectStopRecordServiceImpl
extends ServiceImpl<RkProjectStopRecordMapper, RkProjectStopRecordEntity>
implements RkProjectStopRecordService {
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProjectStopRecordService rkProjectStopRecordService;

    @Override
    public void create(RkProjectStopRecordEntity entity) {
        this.save(entity);
    }

    @Override
    public RkProjectStopRecordEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectStopRecordEntity::getId, (Object)id);
        return (RkProjectStopRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(RkProjectStopRecordEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    @FlowCallBackMethod(fullName="\u9879\u76ee\u6682\u505c\u6d41\u7a0b")
    @DSTransactional
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) throws JsonProcessingException {
        if (StrUtil.isBlank((CharSequence)id)) {
            return false;
        }
        RkProjectStopRecordEntity info = this.rkProjectStopRecordService.getInfo(id);
        if (ObjectUtil.isNull((Object)info)) {
            return false;
        }
        if (enableMark == 2) {
            RkProjectAssignedForm assignedForm = new RkProjectAssignedForm();
            assignedForm.setId(info.getProjectId());
            assignedForm.setType("stop");
            this.rkContractProjectService.startOrStopProject(assignedForm);
            RkContractProjectEntity entity = this.rkContractProjectService.getInfo(info.getProjectId());
            if (ObjectUtil.isNotEmpty((Object)entity)) {
                entity.setStopApplyId("");
            }
            this.rkContractProjectService.updateById(entity);
        }
        return true;
    }

    @Override
    public boolean update(String id, RkProjectStopRecordEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<RkProjectStopRecordEntity> getByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectStopRecordEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectStopRecordEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }
}

