/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.entity.RkProjectTaskDetailEntity;
import com.bringspring.contract.mapper.RkProjectTaskDetailMapper;
import com.bringspring.contract.model.RkProjectTaskDetailCrForm;
import com.bringspring.contract.model.RkProjectTaskDetailPagination;
import com.bringspring.contract.service.RkProjectTaskDetailService;
import com.bringspring.visit.utils.DateUtil;
import com.bringspring.visit.utils.HolidayUtil;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RkProjectTaskDetailServiceImpl
extends ServiceImpl<RkProjectTaskDetailMapper, RkProjectTaskDetailEntity>
implements RkProjectTaskDetailService {
    @Override
    public void create(RkProjectTaskDetailCrForm rkProjectTaskDetailCrForm) {
        String mainId = RandomUtil.uuId();
        RkProjectTaskDetailEntity entity = (RkProjectTaskDetailEntity)JsonUtil.getJsonToBean((Object)rkProjectTaskDetailCrForm, RkProjectTaskDetailEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public List<RkProjectTaskDetailEntity> getByProjectIdList(RkProjectTaskDetailPagination rkProjectTaskDetailPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectTaskDetailEntity::getCreatorUserId, (Object)rkProjectTaskDetailPagination.getUserId());
        queryWrapper.lambda().between(RkProjectTaskDetailEntity::getCreatorTime, (Object)HolidayUtil.getBeginDayOfWeek(DateUtil.daFormat(rkProjectTaskDetailPagination.getDailyPaperDate())), (Object)HolidayUtil.getEndDayOfWeek(DateUtil.daFormat(rkProjectTaskDetailPagination.getDailyPaperDate())));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkProjectTaskDetailEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectTaskDetailEntity::getId, (Object)id);
        return (RkProjectTaskDetailEntity)this.getOne((Wrapper)queryWrapper);
    }
}

