/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectTaskEntity;
import com.bringspring.contract.mapper.RkProjectTaskMapper;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskInfoVO;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskPagination;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectTaskService;
import com.bringspring.contract.utils.ProjectTaskStateEnum;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProjectTaskServiceImpl
extends ServiceImpl<RkProjectTaskMapper, RkProjectTaskEntity>
implements RkProjectTaskService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    private Consumer<QueryWrapper<RkProjectTaskEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<RkProjectTaskEntity>>(){

            @Override
            public void accept(QueryWrapper<RkProjectTaskEntity> rkProjectTaskEntityQueryWrapper) {
                rkProjectTaskEntityQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkProjectTaskEntity::getExecutorUser, (Object)userId)).or()).eq(RkProjectTaskEntity::getAssistantsUser, (Object)userId)).or()).eq(RkProjectTaskEntity::getProjectHeader, (Object)userId)).or()).like(RkProjectTaskEntity::getProjectAssistantsUser, (Object)userId)).or()).eq(RkProjectTaskEntity::getRegionalHead, (Object)userId));
            }
        };
    }

    @Override
    public List<RkProjectTaskEntity> getList(RkProjectTaskPagination rkProjectTaskPagination) {
        String sec;
        String fir;
        Object rkProjectTaskObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProjectTaskNum = 0;
        QueryWrapper rkProjectTaskQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProjectTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectTaskQueryWrapper, rkProjectTaskPagination.getMenuId(), "rk_project_task"));
            if (ObjectUtil.isEmpty((Object)rkProjectTaskObj)) {
                rkProjectTaskQueryWrapper.and(this.defaultWrapper());
            } else {
                rkProjectTaskQueryWrapper = (QueryWrapper)rkProjectTaskObj;
                ++rkProjectTaskNum;
            }
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProjectTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectTaskQueryWrapper, rkProjectTaskPagination.getMenuId(), "rk_project_task"));
            if (ObjectUtil.isEmpty((Object)rkProjectTaskObj)) {
                rkProjectTaskQueryWrapper.and(this.defaultWrapper());
            } else {
                rkProjectTaskQueryWrapper = (QueryWrapper)rkProjectTaskObj;
                ++rkProjectTaskNum;
            }
        }
        rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getEnabledMark, (Object)1);
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getCompanyId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getCompanyId, (Object)rkProjectTaskPagination.getCompanyId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getProjectId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getProjectId, (Object)rkProjectTaskPagination.getProjectId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getPlanId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getPlanId, (Object)rkProjectTaskPagination.getPlanId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getPlanDetailId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getPlanDetailId, (Object)rkProjectTaskPagination.getPlanDetailId());
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getPlanStartTime())) {
            ++rkProjectTaskNum;
            List<String> PlanStartTimeList = rkProjectTaskPagination.getPlanStartTime();
            fir = PlanStartTimeList.get(0);
            sec = PlanStartTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getPlanStartTime, (Object)fir)).le(RkProjectTaskEntity::getPlanStartTime, (Object)sec);
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getPlanEndTime())) {
            ++rkProjectTaskNum;
            List<String> PlanEndTimeList = rkProjectTaskPagination.getPlanEndTime();
            fir = PlanEndTimeList.get(0);
            sec = PlanEndTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getPlanEndTime, (Object)fir)).le(RkProjectTaskEntity::getPlanEndTime, (Object)sec);
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getActStartTime())) {
            ++rkProjectTaskNum;
            List<String> ActStartTimeList = rkProjectTaskPagination.getActStartTime();
            fir = ActStartTimeList.get(0);
            sec = ActStartTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getActStartTime, (Object)fir)).le(RkProjectTaskEntity::getActStartTime, (Object)sec);
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getActEndTime())) {
            ++rkProjectTaskNum;
            List<String> ActEndTimeList = rkProjectTaskPagination.getActEndTime();
            fir = ActEndTimeList.get(0);
            sec = ActEndTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getActEndTime, (Object)fir)).le(RkProjectTaskEntity::getActEndTime, (Object)sec);
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getExecutorUser())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getExecutorUser, (Object)rkProjectTaskPagination.getExecutorUser());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getAssistantsUser())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getAssistantsUser, (Object)rkProjectTaskPagination.getAssistantsUser());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getEtimatedWorkHours())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getEtimatedWorkHours, (Object)rkProjectTaskPagination.getEtimatedWorkHours());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getType())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getType, (Object)rkProjectTaskPagination.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getState())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getState, (Object)rkProjectTaskPagination.getState());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getDescription())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getDescription, (Object)rkProjectTaskPagination.getDescription());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getKeyword())) {
            ++rkProjectTaskNum;
            List<RkContractProjectEntity> listByNameLike = this.rkContractProjectService.getListByNameLike(rkProjectTaskPagination.getKeyword());
            List collect = listByNameLike.stream().map(RkContractProjectEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(collect)) {
                rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getDescription, (Object)rkProjectTaskPagination.getKeyword().replaceAll("\\s+", ""));
            } else {
                rkProjectTaskQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(RkProjectTaskEntity::getDescription, (Object)rkProjectTaskPagination.getKeyword().replaceAll("\\s+", ""))).or()).in(RkProjectTaskEntity::getProjectId, (Collection)collect));
            }
        }
        if (AllIdList.size() > 0) {
            rkProjectTaskQueryWrapper.lambda().in(RkProjectTaskEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)rkProjectTaskPagination.getSidx())) {
            rkProjectTaskQueryWrapper.lambda().orderByDesc(RkProjectTaskEntity::getId);
        } else {
            try {
                String sidx = rkProjectTaskPagination.getSidx();
                RkProjectTaskEntity rkProjectTaskEntity = new RkProjectTaskEntity();
                Field declaredField = rkProjectTaskEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProjectTaskQueryWrapper = "asc".equals(rkProjectTaskPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProjectTaskQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectTaskQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProjectTaskPagination.getCurrentPage(), rkProjectTaskPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectTaskQueryWrapper);
            return rkProjectTaskPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkProjectTaskPagination.setData(list, list.size());
    }

    @Override
    public List<RkProjectTaskEntity> getTypeList(RkProjectTaskPagination rkProjectTaskPagination, String dataType) {
        String sec;
        String fir;
        Object rkProjectTaskObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkProjectTaskNum = 0;
        QueryWrapper rkProjectTaskQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProjectTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectTaskQueryWrapper, rkProjectTaskPagination.getMenuId(), "rkProjectTask"));
            if (ObjectUtil.isEmpty((Object)rkProjectTaskObj)) {
                return new ArrayList<RkProjectTaskEntity>();
            }
            rkProjectTaskQueryWrapper = (QueryWrapper)rkProjectTaskObj;
            ++rkProjectTaskNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkProjectTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectTaskQueryWrapper, rkProjectTaskPagination.getMenuId(), "rkProjectTask"));
            if (ObjectUtil.isEmpty((Object)rkProjectTaskObj)) {
                return new ArrayList<RkProjectTaskEntity>();
            }
            rkProjectTaskQueryWrapper = (QueryWrapper)rkProjectTaskObj;
            ++rkProjectTaskNum;
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getProjectId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getProjectId, (Object)rkProjectTaskPagination.getProjectId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getPlanId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getPlanId, (Object)rkProjectTaskPagination.getPlanId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getPlanDetailId())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getPlanDetailId, (Object)rkProjectTaskPagination.getPlanDetailId());
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getPlanStartTime())) {
            ++rkProjectTaskNum;
            List<String> PlanStartTimeList = rkProjectTaskPagination.getPlanStartTime();
            fir = PlanStartTimeList.get(0);
            sec = PlanStartTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getPlanStartTime, (Object)fir)).le(RkProjectTaskEntity::getPlanStartTime, (Object)sec);
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getPlanEndTime())) {
            ++rkProjectTaskNum;
            List<String> PlanEndTimeList = rkProjectTaskPagination.getPlanEndTime();
            fir = PlanEndTimeList.get(0);
            sec = PlanEndTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getPlanEndTime, (Object)fir)).le(RkProjectTaskEntity::getPlanEndTime, (Object)sec);
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getActStartTime())) {
            ++rkProjectTaskNum;
            List<String> ActStartTimeList = rkProjectTaskPagination.getActStartTime();
            fir = ActStartTimeList.get(0);
            sec = ActStartTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getActStartTime, (Object)fir)).le(RkProjectTaskEntity::getActStartTime, (Object)sec);
        }
        if (CollectionUtil.isNotEmpty(rkProjectTaskPagination.getActEndTime())) {
            ++rkProjectTaskNum;
            List<String> ActEndTimeList = rkProjectTaskPagination.getActEndTime();
            fir = ActEndTimeList.get(0);
            sec = ActEndTimeList.get(1);
            ((LambdaQueryWrapper)rkProjectTaskQueryWrapper.lambda().ge(RkProjectTaskEntity::getActEndTime, (Object)fir)).le(RkProjectTaskEntity::getActEndTime, (Object)sec);
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getExecutorUser())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getExecutorUser, (Object)rkProjectTaskPagination.getExecutorUser());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getAssistantsUser())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getAssistantsUser, (Object)rkProjectTaskPagination.getAssistantsUser());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getEtimatedWorkHours())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getEtimatedWorkHours, (Object)rkProjectTaskPagination.getEtimatedWorkHours());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getType())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().eq(RkProjectTaskEntity::getType, (Object)rkProjectTaskPagination.getType());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkProjectTaskPagination.getDescription())) {
            ++rkProjectTaskNum;
            rkProjectTaskQueryWrapper.lambda().like(RkProjectTaskEntity::getDescription, (Object)rkProjectTaskPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            rkProjectTaskQueryWrapper.lambda().in(RkProjectTaskEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)rkProjectTaskPagination.getSidx())) {
            rkProjectTaskQueryWrapper.lambda().orderByDesc(RkProjectTaskEntity::getId);
        } else {
            try {
                String sidx = rkProjectTaskPagination.getSidx();
                RkProjectTaskEntity rkProjectTaskEntity = new RkProjectTaskEntity();
                Field declaredField = rkProjectTaskEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProjectTaskQueryWrapper = "asc".equals(rkProjectTaskPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProjectTaskQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectTaskQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkProjectTaskPagination.getCurrentPage(), rkProjectTaskPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectTaskQueryWrapper);
                return rkProjectTaskPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkProjectTaskPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkProjectTaskQueryWrapper);
    }

    @Override
    public List<RkProjectTaskEntity> listByPlanDetailId(String planDetailId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectTaskEntity::getPlanDetailId, (Object)planDetailId);
        queryWrapper.lambda().eq(RkProjectTaskEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkProjectTaskEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectTaskEntity::getId, (Object)id);
        return (RkProjectTaskEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProjectTaskEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkProjectTaskEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkProjectTaskEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void updateTaskState() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().notIn(RkProjectTaskEntity::getState, (Collection)CollectionUtil.list((boolean)false, (Object[])new String[]{ProjectTaskStateEnum.stop.getResult(), ProjectTaskStateEnum.cancel.getResult(), ProjectTaskStateEnum.complete.getResult()}))).or()).isNull(RkProjectTaskEntity::getState);
        List list = this.list((Wrapper)queryWrapper);
        List updateList = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            list.stream().forEach(vo -> {
                String oldState = vo.getState();
                Date startTime = vo.getPlanStartTime();
                Date endTime = vo.getPlanEndTime();
                vo.setState(ProjectTaskStateEnum.ing.getResult());
                if (DateUtil.date().before(startTime)) {
                    vo.setState(ProjectTaskStateEnum.not_start.getResult());
                }
                if (DateUtil.date().after(endTime)) {
                    vo.setState(ProjectTaskStateEnum.overdue.getResult());
                }
                if (!StrUtil.equals((CharSequence)vo.getState(), (CharSequence)oldState)) {
                    updateList.add(vo);
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)updateList)) {
            this.updateBatchById(updateList);
        }
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkProjectTaskEntity::getProjectId, (Object)projectId)).eq(RkProjectTaskEntity::getEnabledMark, (Object)1);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProjectTaskInfoVO> getTaskDetail(List<RkProjectTaskEntity> rkProjectTaskEntities) {
        List taskInfoVOList = JsonUtil.getJsonToList(rkProjectTaskEntities, RkProjectTaskInfoVO.class);
        for (int i = 0; i < taskInfoVOList.size(); ++i) {
            RkProjectTaskInfoVO vo = (RkProjectTaskInfoVO)taskInfoVOList.get(i);
            vo.setIndex(i + 1);
            vo.setType(this.baseDataUtil.getDictName(vo.getType(), "projectTaskType"));
            vo.setExecutorUser(this.baseDataUtil.userSelectValue(vo.getExecutorUser()));
            vo.setAssistantsUser(this.baseDataUtil.userSelectValue(vo.getAssistantsUser()));
            if (!StrUtil.isBlank((CharSequence)vo.getState())) continue;
            Long startTime = null;
            Long endTime = null;
            if (ObjectUtil.isNotNull((Object)vo.getPlanStartTime()) && vo.getPlanStartTime() > 0L) {
                startTime = vo.getPlanStartTime();
            }
            if (ObjectUtil.isNotNull((Object)vo.getPlanEndTime()) && vo.getPlanEndTime() > 0L) {
                endTime = vo.getPlanEndTime();
            }
            if (ObjectUtil.isNotNull(startTime) && startTime > DateUtil.date().getTime()) {
                vo.setState(ProjectTaskStateEnum.not_start.getResult());
                continue;
            }
            if (ObjectUtil.isNotNull(endTime) && endTime < DateUtil.date().getTime()) {
                vo.setState(ProjectTaskStateEnum.overdue.getResult());
                continue;
            }
            if (!ObjectUtil.isNotNull((Object)startTime)) continue;
            vo.setState(ProjectTaskStateEnum.ing.getResult());
        }
        return taskInfoVOList;
    }
}

