/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkPurchaseApplyEntity;
import com.bringspring.contract.entity.RkPurchaseApplyListEntity;
import com.bringspring.contract.mapper.RkPurchaseApplyListMapper;
import com.bringspring.contract.model.rkpurchaseapply.RkPurchaseApplyExcelModel;
import com.bringspring.contract.model.rkpurchaseapply.RkPurchaseApplyListImportVO;
import com.bringspring.contract.model.rkpurchaseapply.RkPurchaseApplyListPagination;
import com.bringspring.contract.model.rkpurchaseapplydetaillist.RkPurchaseApplyDetailListImportVO;
import com.bringspring.contract.service.CrmErpMaterialService;
import com.bringspring.contract.service.RkPurchaseApplyListService;
import com.bringspring.contract.utils.DictEncodeEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RkPurchaseApplyListServiceImpl
extends ServiceImpl<RkPurchaseApplyListMapper, RkPurchaseApplyListEntity>
implements RkPurchaseApplyListService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmErpMaterialService crmErpMaterialService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkPurchaseApplyListService rkPurchaseApplyListService;

    @Override
    public RkPurchaseApplyListImportVO importData(List<RkPurchaseApplyExcelModel> dt) {
        List<String> codeList = this.crmErpMaterialService.getInfoList();
        HashSet<String> codeSet = new HashSet<String>(codeList);
        HashMap dictMap = MapUtil.newHashMap();
        List<DictEncodeEnum> allToList = DictEncodeEnum.getAllToList();
        allToList.stream().forEach(dictEncodeEnum -> {
            String encode = dictEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            if (StrUtil.equals((CharSequence)encode, (CharSequence)DictEncodeEnum.ENABLEMARK_DICT.getEncode())) {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
                dictMap.put(encode, collect);
            } else {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
                dictMap.put(encode, collect);
            }
        });
        List userList = this.userService.getList();
        HashMap<String, String> userMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (UserEntity user : userList) {
                userMap.put(user.getRealName(), user.getId());
            }
        }
        int sum = 0;
        int num = 0;
        List errorList = CollectionUtil.list((boolean)false);
        List errorMsgList = CollectionUtil.list((boolean)false);
        String msg = "";
        for (RkPurchaseApplyExcelModel model : dt) {
            String code = StringUtils.trim((String)model.getMaterialCode());
            if (ObjectUtil.isEmpty((Object)code)) {
                ++num;
                model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                errorMsgList.add(model.getErrMsg());
            } else {
                if (!codeSet.contains(code)) {
                    ++num;
                    model.setErrMsg("\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(model.getErrMsg());
                }
                String baseUserRealName = model.getApplyBuyer();
                UserEntity info = this.userService.getInfo(baseUserRealName);
                if (ObjectUtil.isNotEmpty((Object)baseUserRealName)) {
                    String userKey = info.getRealName();
                    if (userMap.containsKey(userKey)) {
                        model.setApplyBuyer((String)userMap.get(userKey));
                    } else {
                        ++num;
                        model.setErrMsg("\u91c7\u8d2d\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4");
                        errorMsgList.add(model.getErrMsg());
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)model.getApplyTaxRate())) {
                    Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.CONTRACT_RATE_DICT.getEncode());
                    String s = (String)stringStringMap.get(model.getApplyTaxRate());
                    if (StrUtil.isEmpty((CharSequence)s)) {
                        ++num;
                        model.setErrMsg("\u5408\u540c\u7a0e\u7387\u4e0d\u5b58\u5728");
                        errorMsgList.add(model.getErrMsg());
                    } else {
                        model.setApplyTaxRate(s);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                model.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                model.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(model);
                continue;
            }
            ++sum;
        }
        RkPurchaseApplyListImportVO vo = new RkPurchaseApplyListImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, RkPurchaseApplyDetailListImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public Map<String, Object> importPreview(List<RkPurchaseApplyExcelModel> pList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        List userList = this.userService.getList();
        HashMap<String, String> userMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (UserEntity user : userList) {
                userMap.put(user.getRealName(), user.getId());
            }
        }
        if (pList != null) {
            int i;
            String msg = "";
            for (i = 0; i < pList.size(); ++i) {
                HashMap<String, Object> dataRowMap = new HashMap<String, Object>();
                RkPurchaseApplyExcelModel model = pList.get(i);
                dataRowMap.put("materialName", model.getMaterialName());
                dataRowMap.put("materialCode", model.getMaterialCode());
                dataRowMap.put("materialCategoryName", model.getMaterialCategoryName());
                dataRowMap.put("materialPropertyName", model.getMaterialPropertyName());
                dataRowMap.put("materialBrand", model.getMaterialBrand());
                dataRowMap.put("materialModel", model.getMaterialModel());
                dataRowMap.put("measureUnit", model.getMeasureUnit());
                dataRowMap.put("applyCount", model.getApplyCount());
                dataRowMap.put("description", model.getDescription());
                dataRowMap.put("arrivalLocation", model.getArrivalLocation());
                dataRowMap.put("arrivalDate", model.getArrivalDate());
                dataRowMap.put("arrivalContactPerson", model.getArrivalContactPerson());
                dataRowMap.put("arrivalContactTel", model.getArrivalContactTel());
                dataRowMap.put("warrantyPeriod", model.getWarrantyPeriod());
                dataRowMap.put("applyPrice", model.getApplyPrice());
                dataRowMap.put("supplierName", model.getSupplierName());
                dataRowMap.put("supplierPerson", model.getSupplierPerson());
                dataRowMap.put("supplierTel", model.getSupplierTel());
                dataRowMap.put("remarks", model.getRemarks());
                dataRowMap.put("applyTaxRate", model.getApplyTaxRate());
                String baseUserRealName = model.getApplyBuyer();
                if (ObjectUtil.isNotEmpty((Object)baseUserRealName)) {
                    String userKey = baseUserRealName;
                    if (userMap.containsKey(userKey)) {
                        dataRowMap.put("applyBuyer", userMap.get(userKey));
                    } else {
                        throw new IllegalArgumentException(msg + "\uff0c\u91c7\u8d2d\u5458\u4e0d\u5b58\u5728\u3002" + baseUserRealName);
                    }
                }
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 16; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", pList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u7269\u6599\u540d\u79f0");
        map.put(2, "\u7269\u6599\u7f16\u7801");
        map.put(3, "\u7269\u6599\u5206\u7c7b");
        map.put(4, "\u7269\u6599\u5c5e\u6027");
        map.put(5, "\u7269\u6599\u54c1\u724c");
        map.put(6, "\u8ba1\u91cf\u5355\u4f4d");
        map.put(7, "\u7269\u6599\u578b\u53f7");
        map.put(8, "\u6570\u91cf");
        map.put(9, "\u8be6\u7ec6\u63cf\u8ff0");
        map.put(10, "\u5230\u8d27\u5730\u70b9");
        map.put(11, "\u5230\u8d27\u65e5\u671f");
        map.put(12, "\u5230\u8d27\u8054\u7cfb\u4eba");
        map.put(13, "\u5230\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd");
        map.put(14, "\u8d28\u4fdd\u671f\uff08\u6708\uff09");
        map.put(15, "\u5355\u4ef7\uff08\u5143\uff09");
        map.put(16, "\u4f9b\u5e94\u5546\u540d\u79f0");
        map.put(17, "\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba");
        map.put(18, "\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd");
        map.put(19, "\u5907\u6ce8");
        map.put(20, "\u7a0e\u7387\uff08%\uff09");
        map.put(21, "\u91c7\u8d2d\u5458");
        return (String)map.get(key);
    }

    @Override
    public String maxApplyCode(String ApplyCode) {
        String pclCode = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkPurchaseApplyListEntity::getApplyCode, (Object)ApplyCode);
        List list = this.list((Wrapper)queryWrapper);
        pclCode = ApplyCode + "-" + String.format("%03d", list.size() + 1);
        return pclCode;
    }

    @Override
    public List<RkPurchaseApplyListEntity> getList(RkPurchaseApplyListPagination rkPurchaseApplyPagination) {
        Object contractpurchaseapplyObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int contractpurchaseapplyNum = 0;
        QueryWrapper contractpurchaseapplyQueryWrapper = new QueryWrapper();
        boolean contractpurchaseapplylistNum = false;
        QueryWrapper contractpurchaseapplylistQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue() && !ObjectUtil.isEmpty((Object)(contractpurchaseapplyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(contractpurchaseapplyQueryWrapper, rkPurchaseApplyPagination.getMenuId(), "purchase_apply_list"))))) {
            contractpurchaseapplyQueryWrapper = (QueryWrapper)contractpurchaseapplyObj;
            ++contractpurchaseapplyNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkPurchaseApplyPagination.getMaterialCode())) {
            ++contractpurchaseapplyNum;
            contractpurchaseapplylistQueryWrapper.lambda().like(RkPurchaseApplyListEntity::getMaterialCode, (Object)rkPurchaseApplyPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkPurchaseApplyPagination.getXsCode())) {
            ++contractpurchaseapplyNum;
            contractpurchaseapplylistQueryWrapper.lambda().like(RkPurchaseApplyListEntity::getXsCode, (Object)rkPurchaseApplyPagination.getXsCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkPurchaseApplyPagination.getXsName())) {
            ++contractpurchaseapplyNum;
            contractpurchaseapplylistQueryWrapper.lambda().like(RkPurchaseApplyListEntity::getXsName, (Object)rkPurchaseApplyPagination.getXsName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkPurchaseApplyPagination.getXmjl())) {
            ++contractpurchaseapplyNum;
            contractpurchaseapplylistQueryWrapper.lambda().eq(RkPurchaseApplyListEntity::getXmjl, (Object)rkPurchaseApplyPagination.getXmjl());
        }
        contractpurchaseapplylistQueryWrapper.lambda().eq(RkPurchaseApplyListEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        if (AllIdList.size() > 0) {
            contractpurchaseapplyQueryWrapper.lambda().in(RkPurchaseApplyEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkPurchaseApplyPagination.getSidx())) {
            contractpurchaseapplylistQueryWrapper.lambda().orderByDesc(RkPurchaseApplyListEntity::getId);
        } else {
            try {
                String sidx = rkPurchaseApplyPagination.getSidx();
                RkPurchaseApplyEntity rkPurchaseApplyEntity = new RkPurchaseApplyEntity();
                Field declaredField = rkPurchaseApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                contractpurchaseapplyQueryWrapper = "asc".equals(rkPurchaseApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)contractpurchaseapplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)contractpurchaseapplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkPurchaseApplyPagination.getCurrentPage(), rkPurchaseApplyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)contractpurchaseapplylistQueryWrapper);
            return rkPurchaseApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkPurchaseApplyPagination.setData(list, list.size());
    }

    @Override
    public RkPurchaseApplyListEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkPurchaseApplyListEntity::getId, (Object)id);
        return (RkPurchaseApplyListEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, Object o) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)o, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }

    @Override
    public List<RkPurchaseApplyListEntity> getListForAssets(RkPurchaseApplyListPagination rkPurchaseApplyPagination) {
        boolean contractpurchaseapplyNum = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkPurchaseApplyListEntity::getParentId, (Object)rkPurchaseApplyPagination.getParentId());
        queryWrapper.lambda().eq(RkPurchaseApplyListEntity::getMaterialCode, (Object)rkPurchaseApplyPagination.getMaterialCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkPurchaseApplyListEntity> getListByConsumingId(String consumingId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkPurchaseApplyListEntity::getConsumingDetailId, (Object)consumingId);
        queryWrapper.lambda().eq(RkPurchaseApplyListEntity::getMainFlowStatus, (Object)FlowTaskStatusEnum.Draft.getCode());
        return this.list((Wrapper)queryWrapper);
    }
}

