/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanSalerEntity;
import com.bringspring.contract.mapper.RkReturnPlanSalerMapper;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerCrForm;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerPagination;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerUpForm;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkReturnPlanSalerService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkReturnPlanSalerServiceImpl
extends ServiceImpl<RkReturnPlanSalerMapper, RkReturnPlanSalerEntity>
implements RkReturnPlanSalerService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public List<RkReturnPlanSalerEntity> getList(RkReturnPlanSalerPagination rkReturnPlanSalerPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkReturnPlanSalerNum = 0;
        QueryWrapper rkReturnPlanSalerQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerPagination.getSalerId())) {
            ++rkReturnPlanSalerNum;
            rkReturnPlanSalerQueryWrapper.lambda().eq(RkReturnPlanSalerEntity::getSalerId, (Object)rkReturnPlanSalerPagination.getSalerId());
        }
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerPagination.getDescription())) {
            ++rkReturnPlanSalerNum;
            rkReturnPlanSalerQueryWrapper.lambda().like(RkReturnPlanSalerEntity::getDescription, (Object)rkReturnPlanSalerPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerPagination.getPlanId())) {
            ++rkReturnPlanSalerNum;
            rkReturnPlanSalerQueryWrapper.lambda().like(RkReturnPlanSalerEntity::getPlanId, (Object)rkReturnPlanSalerPagination.getPlanId());
        }
        if (AllIdList.size() > 0) {
            rkReturnPlanSalerQueryWrapper.lambda().in(RkReturnPlanSalerEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkReturnPlanSalerPagination.getSidx())) {
            rkReturnPlanSalerQueryWrapper.lambda().orderByDesc(RkReturnPlanSalerEntity::getId);
        } else {
            try {
                String sidx = rkReturnPlanSalerPagination.getSidx();
                RkReturnPlanSalerEntity rkReturnPlanSalerEntity = new RkReturnPlanSalerEntity();
                Field declaredField = rkReturnPlanSalerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkReturnPlanSalerQueryWrapper = "asc".equals(rkReturnPlanSalerPagination.getSort().toLowerCase()) ? (QueryWrapper)rkReturnPlanSalerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkReturnPlanSalerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkReturnPlanSalerPagination.getCurrentPage(), rkReturnPlanSalerPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkReturnPlanSalerQueryWrapper);
            return rkReturnPlanSalerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkReturnPlanSalerPagination.setData(list, list.size());
    }

    @Override
    public List<RkReturnPlanSalerEntity> getTypeList(RkReturnPlanSalerPagination rkReturnPlanSalerPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkReturnPlanSalerNum = 0;
        QueryWrapper rkReturnPlanSalerQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerPagination.getSalerId())) {
            ++rkReturnPlanSalerNum;
            rkReturnPlanSalerQueryWrapper.lambda().eq(RkReturnPlanSalerEntity::getSalerId, (Object)rkReturnPlanSalerPagination.getSalerId());
        }
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerPagination.getDescription())) {
            ++rkReturnPlanSalerNum;
            rkReturnPlanSalerQueryWrapper.lambda().like(RkReturnPlanSalerEntity::getDescription, (Object)rkReturnPlanSalerPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerPagination.getPlanId())) {
            ++rkReturnPlanSalerNum;
            rkReturnPlanSalerQueryWrapper.lambda().like(RkReturnPlanSalerEntity::getPlanId, (Object)rkReturnPlanSalerPagination.getPlanId());
        }
        if (AllIdList.size() > 0) {
            rkReturnPlanSalerQueryWrapper.lambda().in(RkReturnPlanSalerEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkReturnPlanSalerPagination.getSidx())) {
            rkReturnPlanSalerQueryWrapper.lambda().orderByDesc(RkReturnPlanSalerEntity::getId);
        } else {
            try {
                String sidx = rkReturnPlanSalerPagination.getSidx();
                RkReturnPlanSalerEntity rkReturnPlanSalerEntity = new RkReturnPlanSalerEntity();
                Field declaredField = rkReturnPlanSalerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkReturnPlanSalerQueryWrapper = "asc".equals(rkReturnPlanSalerPagination.getSort().toLowerCase()) ? (QueryWrapper)rkReturnPlanSalerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkReturnPlanSalerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkReturnPlanSalerPagination.getCurrentPage(), rkReturnPlanSalerPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkReturnPlanSalerQueryWrapper);
                return rkReturnPlanSalerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkReturnPlanSalerPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkReturnPlanSalerQueryWrapper);
    }

    @Override
    public RkReturnPlanSalerEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkReturnPlanSalerEntity::getId, (Object)id);
        return (RkReturnPlanSalerEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(RkReturnPlanSalerCrForm rkReturnPlanSalerCrForm) {
        if (StringUtils.isNotEmpty((String)rkReturnPlanSalerCrForm.getPlanId())) {
            String[] planIdArray = rkReturnPlanSalerCrForm.getPlanId().split(",");
            List<String> planIdList = Arrays.asList(planIdArray);
            for (String planId : planIdList) {
                RkContractReturnPlanEntity byId = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)planId));
                if (!ObjectUtil.isNotNull((Object)byId)) continue;
                String mainId = RandomUtil.uuId();
                RkReturnPlanSalerEntity entity = (RkReturnPlanSalerEntity)JsonUtil.getJsonToBean((Object)rkReturnPlanSalerCrForm, RkReturnPlanSalerEntity.class);
                entity.setId(mainId);
                entity.setPlanId(planId);
                entity.setBeforeSaler(byId.getSalerId());
                entity.setBeforeSalerName(byId.getSalerName());
                entity.setSalerId(rkReturnPlanSalerCrForm.getSalerId());
                entity.setSalerName(this.baseDataUtil.userSelectValues(rkReturnPlanSalerCrForm.getSalerId()));
                entity.setCompanyId(byId.getCompanyId());
                String userCompany = this.userService.getUserCompany(entity.getSalerId());
                this.save(entity);
                byId.setSalerId(rkReturnPlanSalerCrForm.getSalerId());
                byId.setSalerName(this.baseDataUtil.userSelectValues(rkReturnPlanSalerCrForm.getSalerId()));
                byId.setSalerCompanyId(userCompany);
                this.rkContractReturnPlanService.updateById(byId);
            }
        }
    }

    @Override
    public void updateSaler(String id, RkReturnPlanSalerUpForm rkReturnPlanSalerUpForm) {
        RkReturnPlanSalerEntity entity = this.getInfo(id);
        if (entity != null) {
            RkReturnPlanSalerEntity subentity = (RkReturnPlanSalerEntity)JsonUtil.getJsonToBean((Object)rkReturnPlanSalerUpForm, RkReturnPlanSalerEntity.class);
            this.updateById(entity);
        }
    }

    @Override
    public void delete(RkReturnPlanSalerEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

