/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractCollectionRecordEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkSaleGoalTemplateEntity;
import com.bringspring.contract.entity.RkSalePlanEntity;
import com.bringspring.contract.entity.RkSalePlanItemEntity;
import com.bringspring.contract.mapper.RkSalePlanMapper;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rksaleplan.RkSalePlanCrForm;
import com.bringspring.contract.model.rksaleplan.RkSalePlanDetailVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanExportListVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanInfoVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanListVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanPagination;
import com.bringspring.contract.model.rksaleplan.RkSalePlanPaginationExportModel;
import com.bringspring.contract.model.rksaleplan.RkSalePlanQ1ExportVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanQ2ExportVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanQ3ExportVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanQ4ExportVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanYearExportVO;
import com.bringspring.contract.model.rksaleplanitem.RkSalePlanItemModel;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkSaleGoalTemplateService;
import com.bringspring.contract.service.RkSalePlanItemService;
import com.bringspring.contract.service.RkSalePlanService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkSalePlanServiceImpl
extends ServiceImpl<RkSalePlanMapper, RkSalePlanEntity>
implements RkSalePlanService {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkSalePlanItemService rkSalePlanItemService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractCollectionRecordService rkContractCollectionRecordService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private RkSaleGoalTemplateService rkSaleGoalTemplateService;

    @Override
    public List<RkSalePlanEntity> getList(RkSalePlanPagination rkSalePlanPagination) {
        Object rkContractObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkSalePlanNum = 0;
        QueryWrapper rkSalePlanQueryWrapper = new QueryWrapper();
        boolean rkSalePlanItemNum = false;
        QueryWrapper rkSalePlanItemQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkSalePlanQueryWrapper, rkSalePlanPagination.getMenuId(), "rk_sale_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkSalePlanQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkSalePlanQueryWrapper, rkSalePlanPagination.getMenuId(), "rk_sale_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkSalePlanQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (StringUtil.isNotEmpty((String)rkSalePlanPagination.getPlanYear())) {
            ++rkSalePlanNum;
            String templateYear = rkSalePlanPagination.getPlanYear();
            Date date = DateUtil.daFormatDate((Long)Long.valueOf(templateYear));
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getPlanYear, (Object)date);
        }
        if (StringUtil.isNotEmpty((String)rkSalePlanPagination.getSaleUserId())) {
            ++rkSalePlanNum;
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getSaleUserId, (Object)rkSalePlanPagination.getSaleUserId());
        }
        if (StringUtil.isNotEmpty((String)rkSalePlanPagination.getUserDepartmentId())) {
            ++rkSalePlanNum;
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getUserDepartmentId, (Object)rkSalePlanPagination.getUserDepartmentId());
        }
        if (StringUtil.isNotEmpty((String)rkSalePlanPagination.getCompanyId())) {
            ++rkSalePlanNum;
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getCompanyId, (Object)rkSalePlanPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(rkSalePlanPagination.getCompanyIdList())) {
            ++rkSalePlanNum;
            rkSalePlanQueryWrapper.lambda().in(RkSalePlanEntity::getCompanyId, rkSalePlanPagination.getCompanyIdList());
        }
        if (AllIdList.size() > 0) {
            rkSalePlanQueryWrapper.lambda().in(RkSalePlanEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkSalePlanPagination.getSidx())) {
            rkSalePlanQueryWrapper.lambda().orderByDesc(RkSalePlanEntity::getId);
        } else {
            try {
                String sidx = rkSalePlanPagination.getSidx();
                RkSalePlanEntity rkSalePlanEntity = new RkSalePlanEntity();
                Field declaredField = rkSalePlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkSalePlanQueryWrapper = "asc".equals(rkSalePlanPagination.getSort().toLowerCase()) ? (QueryWrapper)rkSalePlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkSalePlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkSalePlanPagination.getCurrentPage(), rkSalePlanPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkSalePlanQueryWrapper);
            return rkSalePlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkSalePlanPagination.setData(list, list.size());
    }

    @Override
    public List<RkSalePlanEntity> getTypeList(RkSalePlanPagination rkSalePlanPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkSalePlanNum = 0;
        QueryWrapper rkSalePlanQueryWrapper = new QueryWrapper();
        boolean rkSalePlanItemNum = false;
        QueryWrapper rkSalePlanItemQueryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)rkSalePlanPagination.getPlanYear())) {
            ++rkSalePlanNum;
            String templateYear = rkSalePlanPagination.getPlanYear();
            Date date = DateUtil.daFormatDate((Long)Long.valueOf(templateYear));
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getPlanYear, (Object)date);
        }
        if (StringUtil.isNotEmpty((String)rkSalePlanPagination.getSaleUserId())) {
            ++rkSalePlanNum;
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getSaleUserId, (Object)rkSalePlanPagination.getSaleUserId());
        }
        if (StringUtil.isNotEmpty((String)rkSalePlanPagination.getUserDepartmentId())) {
            ++rkSalePlanNum;
            rkSalePlanQueryWrapper.lambda().eq(RkSalePlanEntity::getUserDepartmentId, (Object)rkSalePlanPagination.getUserDepartmentId());
        }
        if (AllIdList.size() > 0) {
            rkSalePlanQueryWrapper.lambda().in(RkSalePlanEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkSalePlanPagination.getSidx())) {
            rkSalePlanQueryWrapper.lambda().orderByDesc(RkSalePlanEntity::getId);
        } else {
            try {
                String sidx = rkSalePlanPagination.getSidx();
                RkSalePlanEntity rkSalePlanEntity = new RkSalePlanEntity();
                Field declaredField = rkSalePlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkSalePlanQueryWrapper = "asc".equals(rkSalePlanPagination.getSort().toLowerCase()) ? (QueryWrapper)rkSalePlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkSalePlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkSalePlanPagination.getCurrentPage(), rkSalePlanPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkSalePlanQueryWrapper);
                return rkSalePlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkSalePlanPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkSalePlanQueryWrapper);
    }

    @Override
    public RkSalePlanEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkSalePlanEntity::getId, (Object)id);
        return (RkSalePlanEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkSalePlanEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkSalePlanEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkSalePlanEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<RkSalePlanItemEntity> GetRkSalePlanItemList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkSalePlanItemEntity::getPlanId, (Object)id);
        return this.rkSalePlanItemService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkSalePlanListVO> getParentListAndChildren(List<RkSalePlanListVO> rkSalePlanEntities) {
        for (RkSalePlanListVO rkSalePlanEntity : rkSalePlanEntities) {
            List<RkSalePlanItemEntity> rkSalePlanItemEntities = this.GetRkSalePlanItemList(rkSalePlanEntity.getId());
            if (ObjectUtil.isNotEmpty(rkSalePlanItemEntities)) {
                for (RkSalePlanItemEntity salePlanEntity : rkSalePlanItemEntities) {
                    if (salePlanEntity.getQuarter().equals("1")) {
                        rkSalePlanEntity.setQuarter1(salePlanEntity.getRatio());
                    }
                    if (salePlanEntity.getQuarter().equals("2")) {
                        rkSalePlanEntity.setQuarter2(salePlanEntity.getRatio());
                    }
                    if (salePlanEntity.getQuarter().equals("3")) {
                        rkSalePlanEntity.setQuarter3(salePlanEntity.getRatio());
                    }
                    if (!salePlanEntity.getQuarter().equals("4")) continue;
                    rkSalePlanEntity.setQuarter4(salePlanEntity.getRatio());
                }
            }
            rkSalePlanEntity.setCreatorUserIdCode(rkSalePlanEntity.getCreatorUserId());
            rkSalePlanEntity.setUserDepartmentId(this.baseDataUtil.comSelectValues(rkSalePlanEntity.getUserDepartmentId()));
            rkSalePlanEntity.setSaleUserId(this.baseDataUtil.userSelectValues(rkSalePlanEntity.getSaleUserId()));
            rkSalePlanEntity.setCreatorUserName(this.baseDataUtil.userSelectValues(rkSalePlanEntity.getCreatorUserId()));
            rkSalePlanEntity.setPlanYearStr(DateUtil.daFormat((Date)rkSalePlanEntity.getPlanYear()).substring(0, 4));
        }
        return rkSalePlanEntities;
    }

    @Override
    public List<RkSalePlanExportListVO> getExportParentListAndChildren(List<RkSalePlanListVO> rkSalePlanEntities) {
        RkContractCollectionRecordPagination rkSalePlanPagination = new RkContractCollectionRecordPagination();
        List<String> userIdList = rkSalePlanEntities.stream().map(RkSalePlanListVO::getSaleUserId).collect(Collectors.toList());
        rkSalePlanPagination.setSalerIds(userIdList);
        List<RkContractEntity> contractListByUserIds = this.rkContractService.getListBy(rkSalePlanPagination);
        List<Object> recordListByContractIdList = new ArrayList();
        if (ObjectUtil.isNotEmpty(contractListByUserIds)) {
            recordListByContractIdList = this.rkContractCollectionRecordService.getListByContractIdList(contractListByUserIds.stream().map(RkContractEntity::getId).collect(Collectors.toList()));
        }
        List<RkProjectReportingEntity> projectReportingList = this.rkProjectReportingService.getListByUserAndDate(userIdList, new ArrayList<Date>());
        List exportListVO = JsonUtil.getJsonToList(rkSalePlanEntities, RkSalePlanExportListVO.class);
        for (RkSalePlanExportListVO rkSalePlanEntity : exportListVO) {
            Date planYear = rkSalePlanEntity.getPlanYear();
            String year = DateUtil.format((Date)planYear, (String)"yyyy");
            Date nextYearTime = DateUtil.getYearLast((int)Integer.parseInt(year));
            List<Object> userContractList = new ArrayList();
            if (ObjectUtil.isNotEmpty(contractListByUserIds)) {
                userContractList = contractListByUserIds.stream().filter(i -> i.getSalerId().equals(rkSalePlanEntity.getSaleUserId()) && i.getSignDate().after(planYear) && i.getSignDate().before(nextYearTime)).collect(Collectors.toList());
            }
            List contractIdList = userContractList.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            List<Object> recordEntities = new ArrayList();
            if (ObjectUtil.isNotEmpty(recordListByContractIdList)) {
                recordEntities = recordListByContractIdList.stream().filter(i -> contractIdList.contains(i.getContractId())).collect(Collectors.toList());
            }
            List<Object> projectListByDate = new ArrayList();
            if (ObjectUtil.isNotEmpty(projectReportingList)) {
                projectListByDate = projectReportingList.stream().filter(item -> item.getCreatorUserId().equals(rkSalePlanEntity.getSaleUserId()) && item.getCreatorTime().after(planYear) && item.getCreatorTime().before(nextYearTime)).collect(Collectors.toList());
            }
            if (ObjectUtil.isNotEmpty(userContractList)) {
                BigDecimal saleAmount = BigDecimal.ZERO;
                Object profitAmount = BigDecimal.ZERO;
                for (Object rkContractEntity2 : userContractList) {
                    saleAmount = MathUtils.add(saleAmount, ((RkContractEntity)rkContractEntity2).getContractAmount());
                    profitAmount = MathUtils.add((BigDecimal)profitAmount, ((RkContractEntity)rkContractEntity2).getProfit());
                }
                rkSalePlanEntity.setSalesAmountCompleted(String.valueOf(saleAmount));
                rkSalePlanEntity.setTargetMarginCompleted(String.valueOf(profitAmount));
                rkSalePlanEntity.setContractAmountCompleted(String.valueOf(userContractList.size()));
            }
            if (ObjectUtil.isNotEmpty(recordEntities)) {
                BigDecimal returnMoney = BigDecimal.ZERO;
                for (Object rkContractEntity : recordEntities) {
                    returnMoney = MathUtils.add(returnMoney, ((RkContractCollectionRecordEntity)rkContractEntity).getReturnAmount());
                }
                rkSalePlanEntity.setReturnedAmountCompleted(String.valueOf(returnMoney));
            }
            if (ObjectUtil.isNotEmpty(projectListByDate)) {
                Object rkContractEntity;
                Integer saleChanceAmount = projectListByDate.size();
                BigDecimal saleChanceMoney = BigDecimal.ZERO;
                rkContractEntity = projectListByDate.iterator();
                while (rkContractEntity.hasNext()) {
                    Object rkContractEntity2;
                    rkContractEntity2 = (RkProjectReportingEntity)rkContractEntity.next();
                    saleChanceMoney = MathUtils.add(saleChanceMoney, ((RkProjectReportingEntity)rkContractEntity2).getEstimatedSigningAmount());
                }
                rkSalePlanEntity.setSuccessOpportunityMoneyCompleted(String.valueOf(saleChanceMoney));
                rkSalePlanEntity.setSuccessOpportunityAmountCompleted(String.valueOf(saleChanceAmount));
            }
            ArrayList<RkSalePlanYearExportVO> yearTargetList = new ArrayList<RkSalePlanYearExportVO>();
            yearTargetList.add((RkSalePlanYearExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanYearExportVO.class));
            rkSalePlanEntity.setYearTarget(yearTargetList);
            List<RkSalePlanItemEntity> rkSalePlanItemEntities = this.GetRkSalePlanItemList(rkSalePlanEntity.getId());
            HashMap startAndEndDayOfSeason = DateUtil.getStartAndEndDayOfSeason((Date)planYear, (Date)nextYearTime);
            if (ObjectUtil.isNotEmpty(rkSalePlanItemEntities)) {
                for (RkSalePlanItemEntity salePlanEntity : rkSalePlanItemEntities) {
                    RkProjectReportingEntity rkContractEntity5;
                    Object saleChanceMoney;
                    Integer saleChanceAmount;
                    List projectListByQuarter;
                    List rkReturnMoneyList;
                    Iterator rkContractEntity32;
                    Object rkContractEntity42;
                    List rkContractList;
                    List dateList;
                    if (salePlanEntity.getQuarter().equals("1")) {
                        List projectListByQuarter2;
                        List rkReturnMoneyList2;
                        rkSalePlanEntity.setSalesAmountQ1(salePlanEntity.getSalesAmount());
                        rkSalePlanEntity.setContractAmountQ1(salePlanEntity.getContractAmount());
                        rkSalePlanEntity.setReturnedAmountQ1(salePlanEntity.getReturnedAmount());
                        rkSalePlanEntity.setTargetMarginQ1(salePlanEntity.getTargetMargin());
                        rkSalePlanEntity.setSuccessOpportunityMoneyQ1(salePlanEntity.getSuccessOpportunityMoney());
                        rkSalePlanEntity.setSuccessOpportunityAmountQ1(salePlanEntity.getSuccessOpportunityAmount());
                        dateList = (List)startAndEndDayOfSeason.get("1");
                        if (ObjectUtil.isNotEmpty(userContractList) && ObjectUtil.isNotEmpty(rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal contractAmountQ1 = BigDecimal.ZERO;
                            Object profitAmountQ1 = BigDecimal.ZERO;
                            for (Object rkContractEntity42 : rkContractList) {
                                contractAmountQ1 = MathUtils.add(contractAmountQ1, ((RkContractEntity)rkContractEntity42).getContractAmount());
                                profitAmountQ1 = MathUtils.add((BigDecimal)profitAmountQ1, ((RkContractEntity)rkContractEntity42).getProfit());
                            }
                            rkSalePlanEntity.setContractAmountCompletedQ1(String.valueOf(rkContractList.size()));
                            rkSalePlanEntity.setSalesAmountCompletedQ1(String.valueOf(contractAmountQ1));
                            rkSalePlanEntity.setTargetMarginCompletedQ1(String.valueOf(profitAmountQ1));
                        }
                        if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList2 = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal returnMoneyQ1 = BigDecimal.ZERO;
                            for (Iterator rkContractEntity32 : rkReturnMoneyList2) {
                                returnMoneyQ1 = MathUtils.add(returnMoneyQ1, ((RkContractCollectionRecordEntity)((Object)rkContractEntity32)).getReturnAmount());
                            }
                            rkSalePlanEntity.setReturnedAmountCompletedQ1(String.valueOf(returnMoneyQ1));
                        }
                        if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter2 = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after((Date)dateList.get(0)) && item.getExpectedSigningDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            Integer saleChanceAmount2 = projectListByQuarter2.size();
                            BigDecimal saleChanceMoney2 = BigDecimal.ZERO;
                            rkContractEntity32 = projectListByQuarter2.iterator();
                            while (rkContractEntity32.hasNext()) {
                                rkContractEntity42 = (RkProjectReportingEntity)rkContractEntity32.next();
                                saleChanceMoney2 = MathUtils.add(saleChanceMoney2, ((RkProjectReportingEntity)rkContractEntity42).getEstimatedSigningAmount());
                            }
                            rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ1(String.valueOf(saleChanceMoney2));
                            rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ1(String.valueOf(saleChanceAmount2));
                        }
                        ArrayList<RkSalePlanQ1ExportVO> q1TargetList = new ArrayList<RkSalePlanQ1ExportVO>();
                        q1TargetList.add((RkSalePlanQ1ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ1ExportVO.class));
                        rkSalePlanEntity.setQ1Target(q1TargetList);
                    }
                    if (salePlanEntity.getQuarter().equals("2")) {
                        rkSalePlanEntity.setSalesAmountQ2(salePlanEntity.getSalesAmount());
                        rkSalePlanEntity.setContractAmountQ2(salePlanEntity.getContractAmount());
                        rkSalePlanEntity.setReturnedAmountQ2(salePlanEntity.getReturnedAmount());
                        rkSalePlanEntity.setTargetMarginQ2(salePlanEntity.getTargetMargin());
                        rkSalePlanEntity.setSuccessOpportunityMoneyQ2(salePlanEntity.getSuccessOpportunityMoney());
                        rkSalePlanEntity.setSuccessOpportunityAmountQ2(salePlanEntity.getSuccessOpportunityAmount());
                        dateList = (List)startAndEndDayOfSeason.get("2");
                        rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(rkContractList)) {
                            BigDecimal contractAmountQ2 = BigDecimal.ZERO;
                            BigDecimal profitAmountQ2 = BigDecimal.ZERO;
                            rkContractEntity32 = userContractList.iterator();
                            while (rkContractEntity32.hasNext()) {
                                rkContractEntity42 = (RkContractEntity)rkContractEntity32.next();
                                contractAmountQ2 = MathUtils.add(contractAmountQ2, ((RkContractEntity)rkContractEntity42).getContractAmount());
                                profitAmountQ2 = MathUtils.add(profitAmountQ2, ((RkContractEntity)rkContractEntity42).getProfit());
                            }
                            rkSalePlanEntity.setContractAmountCompletedQ2(String.valueOf(rkContractList.size()));
                            rkSalePlanEntity.setSalesAmountCompletedQ2(String.valueOf(contractAmountQ2));
                            rkSalePlanEntity.setTargetMarginCompletedQ2(String.valueOf(profitAmountQ2));
                        }
                        if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal returnMoneyQ2 = BigDecimal.ZERO;
                            rkContractEntity32 = rkReturnMoneyList.iterator();
                            while (rkContractEntity32.hasNext()) {
                                rkContractEntity42 = (RkContractCollectionRecordEntity)rkContractEntity32.next();
                                returnMoneyQ2 = MathUtils.add(returnMoneyQ2, ((RkContractCollectionRecordEntity)rkContractEntity42).getReturnAmount());
                            }
                            rkSalePlanEntity.setReturnedAmountCompletedQ2(String.valueOf(returnMoneyQ2));
                        }
                        if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after((Date)dateList.get(0)) && item.getExpectedSigningDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            saleChanceAmount = projectListByQuarter.size();
                            saleChanceMoney = BigDecimal.ZERO;
                            rkContractEntity42 = projectListByQuarter.iterator();
                            while (rkContractEntity42.hasNext()) {
                                rkContractEntity5 = (RkProjectReportingEntity)rkContractEntity42.next();
                                saleChanceMoney = MathUtils.add((BigDecimal)saleChanceMoney, rkContractEntity5.getEstimatedSigningAmount());
                            }
                            rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ2(String.valueOf(saleChanceMoney));
                            rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ2(String.valueOf(saleChanceAmount));
                        }
                        ArrayList<RkSalePlanQ2ExportVO> q2TargetList = new ArrayList<RkSalePlanQ2ExportVO>();
                        q2TargetList.add((RkSalePlanQ2ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ2ExportVO.class));
                        rkSalePlanEntity.setQ2Target(q2TargetList);
                    }
                    if (salePlanEntity.getQuarter().equals("3")) {
                        rkSalePlanEntity.setSalesAmountQ3(salePlanEntity.getSalesAmount());
                        rkSalePlanEntity.setContractAmountQ3(salePlanEntity.getContractAmount());
                        rkSalePlanEntity.setReturnedAmountQ3(salePlanEntity.getReturnedAmount());
                        rkSalePlanEntity.setTargetMarginQ3(salePlanEntity.getTargetMargin());
                        rkSalePlanEntity.setSuccessOpportunityMoneyQ3(salePlanEntity.getSuccessOpportunityMoney());
                        rkSalePlanEntity.setSuccessOpportunityAmountQ3(salePlanEntity.getSuccessOpportunityAmount());
                        dateList = (List)startAndEndDayOfSeason.get("3");
                        rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(rkContractList)) {
                            BigDecimal contractAmountQ3 = BigDecimal.ZERO;
                            BigDecimal profitAmountQ3 = BigDecimal.ZERO;
                            for (Object rkContractEntity42 : userContractList) {
                                contractAmountQ3 = MathUtils.add(contractAmountQ3, ((RkContractEntity)rkContractEntity42).getContractAmount());
                                profitAmountQ3 = MathUtils.add(profitAmountQ3, ((RkContractEntity)rkContractEntity42).getProfit());
                            }
                            rkSalePlanEntity.setContractAmountCompletedQ3(String.valueOf(rkContractList.size()));
                            rkSalePlanEntity.setSalesAmountCompletedQ3(String.valueOf(contractAmountQ3));
                            rkSalePlanEntity.setTargetMarginCompletedQ3(String.valueOf(profitAmountQ3));
                        }
                        if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal returnMoneyQ3 = BigDecimal.ZERO;
                            for (Object rkContractEntity42 : rkReturnMoneyList) {
                                returnMoneyQ3 = MathUtils.add(returnMoneyQ3, ((RkContractCollectionRecordEntity)rkContractEntity42).getReturnAmount());
                            }
                            rkSalePlanEntity.setReturnedAmountCompletedQ3(String.valueOf(returnMoneyQ3));
                        }
                        if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after((Date)dateList.get(0)) && item.getExpectedSigningDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            saleChanceAmount = projectListByQuarter.size();
                            saleChanceMoney = BigDecimal.ZERO;
                            rkContractEntity42 = projectListByQuarter.iterator();
                            while (rkContractEntity42.hasNext()) {
                                rkContractEntity5 = (RkProjectReportingEntity)rkContractEntity42.next();
                                saleChanceMoney = MathUtils.add((BigDecimal)saleChanceMoney, rkContractEntity5.getEstimatedSigningAmount());
                            }
                            rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ3(String.valueOf(saleChanceMoney));
                            rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ3(String.valueOf(saleChanceAmount));
                        }
                        ArrayList<RkSalePlanQ3ExportVO> q3TargetList = new ArrayList<RkSalePlanQ3ExportVO>();
                        q3TargetList.add((RkSalePlanQ3ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ3ExportVO.class));
                        rkSalePlanEntity.setQ3Target(q3TargetList);
                    }
                    if (!salePlanEntity.getQuarter().equals("4")) continue;
                    rkSalePlanEntity.setSalesAmountQ4(salePlanEntity.getSalesAmount());
                    rkSalePlanEntity.setContractAmountQ4(salePlanEntity.getContractAmount());
                    rkSalePlanEntity.setReturnedAmountQ4(salePlanEntity.getReturnedAmount());
                    rkSalePlanEntity.setTargetMarginQ4(salePlanEntity.getTargetMargin());
                    rkSalePlanEntity.setSuccessOpportunityMoneyQ4(salePlanEntity.getSuccessOpportunityMoney());
                    rkSalePlanEntity.setSuccessOpportunityAmountQ4(salePlanEntity.getSuccessOpportunityAmount());
                    dateList = (List)startAndEndDayOfSeason.get("4");
                    rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList());
                    if (ObjectUtil.isNotEmpty(rkContractList)) {
                        BigDecimal contractAmountQ4 = BigDecimal.ZERO;
                        BigDecimal profitAmountQ4 = BigDecimal.ZERO;
                        for (Object rkContractEntity42 : userContractList) {
                            contractAmountQ4 = MathUtils.add(contractAmountQ4, ((RkContractEntity)rkContractEntity42).getContractAmount());
                            profitAmountQ4 = MathUtils.add(profitAmountQ4, ((RkContractEntity)rkContractEntity42).getProfit());
                        }
                        rkSalePlanEntity.setContractAmountCompletedQ4(String.valueOf(rkContractList.size()));
                        rkSalePlanEntity.setSalesAmountCompletedQ4(String.valueOf(contractAmountQ4));
                        rkSalePlanEntity.setTargetMarginCompletedQ4(String.valueOf(profitAmountQ4));
                    }
                    if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                        BigDecimal returnMoneyQ4 = BigDecimal.ZERO;
                        for (Object rkContractEntity42 : rkReturnMoneyList) {
                            returnMoneyQ4 = MathUtils.add(returnMoneyQ4, ((RkContractCollectionRecordEntity)rkContractEntity42).getReturnAmount());
                        }
                        rkSalePlanEntity.setReturnedAmountCompletedQ4(String.valueOf(returnMoneyQ4));
                    }
                    if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after((Date)dateList.get(0)) && item.getExpectedSigningDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                        saleChanceAmount = projectListByQuarter.size();
                        saleChanceMoney = BigDecimal.ZERO;
                        for (RkProjectReportingEntity rkContractEntity5 : projectListByQuarter) {
                            saleChanceMoney = MathUtils.add((BigDecimal)saleChanceMoney, rkContractEntity5.getEstimatedSigningAmount());
                        }
                        rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ4(String.valueOf(saleChanceMoney));
                        rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ4(String.valueOf(saleChanceAmount));
                    }
                    ArrayList<RkSalePlanQ4ExportVO> q4TargetList = new ArrayList<RkSalePlanQ4ExportVO>();
                    q4TargetList.add((RkSalePlanQ4ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ4ExportVO.class));
                    rkSalePlanEntity.setQ4Target(q4TargetList);
                }
            }
            rkSalePlanEntity.setCreatorUserIdCode(rkSalePlanEntity.getCreatorUserId());
            rkSalePlanEntity.setUserDepartmentId(this.baseDataUtil.comSelectValues(rkSalePlanEntity.getUserDepartmentId()));
            rkSalePlanEntity.setSaleUserId(this.baseDataUtil.userSelectValues(rkSalePlanEntity.getSaleUserId()));
            rkSalePlanEntity.setCreatorUserName(this.baseDataUtil.userSelectValues(rkSalePlanEntity.getCreatorUserId()));
            rkSalePlanEntity.setPlanYearStr(DateUtil.daFormat((Date)rkSalePlanEntity.getPlanYear()).substring(0, 4));
        }
        return exportListVO;
    }

    @Override
    public DownloadVO exportData(RkSalePlanPaginationExportModel rkSalePlanPaginationExportModel) {
        RkSalePlanPagination rkSalePlanPagination = (RkSalePlanPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkSalePlanPaginationExportModel), RkSalePlanPagination.class));
        List<RkSalePlanEntity> list = this.getTypeList(rkSalePlanPagination, rkSalePlanPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkSalePlanListVO.class);
        List<RkSalePlanExportListVO> parentListAndChildren = this.getExportParentListAndChildren(listVO);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(parentListAndChildren, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkSalePlanPaginationExportModel.getSelectKey()) ? rkSalePlanPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    @Override
    public List<RkSalePlanEntity> getListByYear(Date date) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkSalePlanEntity::getPlanYear, (Object)date);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkSalePlanEntity> getListById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkSalePlanEntity::getTemplateId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkSalePlanEntity> getWhetherRepeatByYear(RkSalePlanEntity rkSalePlanUpForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkSalePlanEntity::getTemplateId, (Object)rkSalePlanUpForm.getTemplateId())).eq(RkSalePlanEntity::getPlanYear, (Object)rkSalePlanUpForm.getPlanYear())).eq(RkSalePlanEntity::getSaleUserId, (Object)rkSalePlanUpForm.getSaleUserId());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean createEntity(RkSalePlanCrForm rkSalePlanCrForm) {
        RkSalePlanEntity rkSalePlanUpForm = (RkSalePlanEntity)JsonUtil.getJsonToBean((Object)rkSalePlanCrForm, RkSalePlanEntity.class);
        List<RkSalePlanEntity> whetherRepeatByYear = this.getWhetherRepeatByYear(rkSalePlanUpForm);
        if (ObjectUtil.isNotEmpty(whetherRepeatByYear) && whetherRepeatByYear.size() > 1) {
            return false;
        }
        return true;
    }

    @Override
    public RkSalePlanInfoVO whetherCompleteTarget(String id) {
        RkSalePlanEntity entity = this.getInfo(id);
        ArrayList<RkSalePlanEntity> list = new ArrayList<RkSalePlanEntity>();
        list.add(entity);
        List exportListVO = JsonUtil.getJsonToList(list, RkSalePlanListVO.class);
        List<RkSalePlanExportListVO> userTargetsituation = this.getExportParentListAndChildren(exportListVO);
        RkSalePlanDetailVO vo = new RkSalePlanDetailVO();
        if (ObjectUtil.isNotEmpty(userTargetsituation)) {
            RkSalePlanExportListVO rkSalePlanExportListVO = userTargetsituation.get(0);
            vo = (RkSalePlanDetailVO)JsonUtil.getJsonToBean((Object)rkSalePlanExportListVO, RkSalePlanDetailVO.class);
            Boolean salesAmountFlag = this.compareNumber(rkSalePlanExportListVO.getSalesAmount(), rkSalePlanExportListVO.getSalesAmountCompleted(), true);
            vo.setSalesAmountFlag(salesAmountFlag);
            Boolean contractAmountFlag = this.compareNumber(rkSalePlanExportListVO.getContractAmount(), rkSalePlanExportListVO.getContractAmountCompleted(), false);
            vo.setContractAmountFlag(contractAmountFlag);
            Boolean returnedAmountFlag = this.compareNumber(rkSalePlanExportListVO.getReturnedAmount(), rkSalePlanExportListVO.getReturnedAmountCompleted(), true);
            vo.setReturnedAmountFlag(returnedAmountFlag);
            Boolean targetMarginFlag = this.compareNumber(rkSalePlanExportListVO.getTargetMargin(), rkSalePlanExportListVO.getTargetMarginCompleted(), true);
            vo.setTargetMarginFlag(targetMarginFlag);
            Boolean successOpportunityMoneyFlag = this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityMoney(), rkSalePlanExportListVO.getSuccessOpportunityMoneyCompleted(), true);
            vo.setSuccessOpportunityMoneyFlag(successOpportunityMoneyFlag);
            Boolean successOpportunityAmountFlag = this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityAmount(), rkSalePlanExportListVO.getSuccessOpportunityAmountCompleted(), false);
            vo.setSuccessOpportunityAmountFlag(successOpportunityAmountFlag);
            vo.setSalesAmountFlagQ1(this.compareNumber(rkSalePlanExportListVO.getSalesAmountQ1(), rkSalePlanExportListVO.getSalesAmountCompletedQ1(), true));
            vo.setContractAmountFlagQ1(this.compareNumber(rkSalePlanExportListVO.getContractAmountQ1(), rkSalePlanExportListVO.getContractAmountCompletedQ1(), false));
            vo.setReturnedAmountFlagQ1(this.compareNumber(rkSalePlanExportListVO.getReturnedAmountQ1(), rkSalePlanExportListVO.getReturnedAmountCompletedQ1(), true));
            vo.setTargetMarginFlagQ1(this.compareNumber(rkSalePlanExportListVO.getTargetMarginQ1(), rkSalePlanExportListVO.getTargetMarginCompletedQ1(), true));
            vo.setSuccessOpportunityMoneyFlagQ1(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityMoneyQ1(), rkSalePlanExportListVO.getSuccessOpportunityMoneyCompletedQ1(), true));
            vo.setSuccessOpportunityAmountFlagQ1(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityAmountQ1(), rkSalePlanExportListVO.getSuccessOpportunityAmountCompletedQ1(), false));
            vo.setSalesAmountFlagQ2(this.compareNumber(rkSalePlanExportListVO.getSalesAmountQ2(), rkSalePlanExportListVO.getSalesAmountCompletedQ2(), true));
            vo.setContractAmountFlagQ2(this.compareNumber(rkSalePlanExportListVO.getContractAmountQ2(), rkSalePlanExportListVO.getContractAmountCompletedQ2(), false));
            vo.setReturnedAmountFlagQ2(this.compareNumber(rkSalePlanExportListVO.getReturnedAmountQ2(), rkSalePlanExportListVO.getReturnedAmountCompletedQ2(), true));
            vo.setTargetMarginFlagQ2(this.compareNumber(rkSalePlanExportListVO.getTargetMarginQ2(), rkSalePlanExportListVO.getTargetMarginCompletedQ2(), true));
            vo.setSuccessOpportunityMoneyFlagQ2(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityMoneyQ2(), rkSalePlanExportListVO.getSuccessOpportunityMoneyCompletedQ2(), true));
            vo.setSuccessOpportunityAmountFlagQ2(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityAmountQ2(), rkSalePlanExportListVO.getSuccessOpportunityAmountCompletedQ2(), false));
            vo.setSalesAmountFlagQ3(this.compareNumber(rkSalePlanExportListVO.getSalesAmountQ3(), rkSalePlanExportListVO.getSalesAmountCompletedQ3(), true));
            vo.setContractAmountFlagQ3(this.compareNumber(rkSalePlanExportListVO.getContractAmountQ3(), rkSalePlanExportListVO.getContractAmountCompletedQ3(), false));
            vo.setReturnedAmountFlagQ3(this.compareNumber(rkSalePlanExportListVO.getReturnedAmountQ3(), rkSalePlanExportListVO.getReturnedAmountCompletedQ3(), true));
            vo.setTargetMarginFlagQ3(this.compareNumber(rkSalePlanExportListVO.getTargetMarginQ3(), rkSalePlanExportListVO.getTargetMarginCompletedQ3(), true));
            vo.setSuccessOpportunityMoneyFlagQ3(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityMoneyQ3(), rkSalePlanExportListVO.getSuccessOpportunityMoneyCompletedQ3(), true));
            vo.setSuccessOpportunityAmountFlagQ3(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityAmountQ3(), rkSalePlanExportListVO.getSuccessOpportunityAmountCompletedQ3(), false));
            vo.setSalesAmountFlagQ4(this.compareNumber(rkSalePlanExportListVO.getSalesAmountQ4(), rkSalePlanExportListVO.getSalesAmountCompletedQ4(), true));
            vo.setContractAmountFlagQ4(this.compareNumber(rkSalePlanExportListVO.getContractAmountQ4(), rkSalePlanExportListVO.getContractAmountCompletedQ4(), false));
            vo.setReturnedAmountFlagQ4(this.compareNumber(rkSalePlanExportListVO.getReturnedAmountQ4(), rkSalePlanExportListVO.getReturnedAmountCompletedQ4(), true));
            vo.setTargetMarginFlagQ4(this.compareNumber(rkSalePlanExportListVO.getTargetMarginQ4(), rkSalePlanExportListVO.getTargetMarginCompletedQ4(), true));
            vo.setSuccessOpportunityMoneyFlagQ4(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityMoneyQ4(), rkSalePlanExportListVO.getSuccessOpportunityMoneyCompletedQ4(), true));
            vo.setSuccessOpportunityAmountFlagQ4(this.compareNumber(rkSalePlanExportListVO.getSuccessOpportunityAmountQ4(), rkSalePlanExportListVO.getSuccessOpportunityAmountCompletedQ4(), false));
        }
        List<RkSalePlanItemEntity> rkSalePlanItemList = this.GetRkSalePlanItemList(id);
        List rkSalePlanItemModelList = JsonUtil.getJsonToList(rkSalePlanItemList, RkSalePlanItemModel.class);
        RkSaleGoalTemplateEntity templateEntity = this.rkSaleGoalTemplateService.getInfo(entity.getTemplateId());
        if (ObjectUtil.isNotEmpty((Object)templateEntity)) {
            vo.setTemplateName(templateEntity.getName());
        }
        for (RkSalePlanItemModel rkSalePlanItemModel : rkSalePlanItemModelList) {
            if (rkSalePlanItemModel.getQuarter().equals("1")) {
                rkSalePlanItemModel.setSalesAmountCompleted(vo.getSalesAmountCompletedQ1());
                rkSalePlanItemModel.setContractAmountCompleted(vo.getContractAmountCompletedQ1());
                rkSalePlanItemModel.setReturnedAmountCompleted(vo.getReturnedAmountCompletedQ1());
                rkSalePlanItemModel.setTargetMarginCompleted(vo.getTargetMarginCompletedQ1());
                rkSalePlanItemModel.setSuccessOpportunityAmountCompleted(vo.getSuccessOpportunityAmountCompletedQ1());
                rkSalePlanItemModel.setSuccessOpportunityMoneyCompleted(vo.getSuccessOpportunityMoneyCompletedQ1());
            }
            if (rkSalePlanItemModel.getQuarter().equals("2")) {
                rkSalePlanItemModel.setSalesAmountCompleted(vo.getSalesAmountCompletedQ2());
                rkSalePlanItemModel.setContractAmountCompleted(vo.getContractAmountCompletedQ2());
                rkSalePlanItemModel.setReturnedAmountCompleted(vo.getReturnedAmountCompletedQ2());
                rkSalePlanItemModel.setTargetMarginCompleted(vo.getTargetMarginCompletedQ2());
                rkSalePlanItemModel.setSuccessOpportunityAmountCompleted(vo.getSuccessOpportunityAmountCompletedQ2());
                rkSalePlanItemModel.setSuccessOpportunityMoneyCompleted(vo.getSuccessOpportunityMoneyCompletedQ2());
            }
            if (rkSalePlanItemModel.getQuarter().equals("3")) {
                rkSalePlanItemModel.setSalesAmountCompleted(vo.getSalesAmountCompletedQ3());
                rkSalePlanItemModel.setContractAmountCompleted(vo.getContractAmountCompletedQ3());
                rkSalePlanItemModel.setReturnedAmountCompleted(vo.getReturnedAmountCompletedQ3());
                rkSalePlanItemModel.setTargetMarginCompleted(vo.getTargetMarginCompletedQ3());
                rkSalePlanItemModel.setSuccessOpportunityAmountCompleted(vo.getSuccessOpportunityAmountCompletedQ3());
                rkSalePlanItemModel.setSuccessOpportunityMoneyCompleted(vo.getSuccessOpportunityMoneyCompletedQ3());
            }
            if (!rkSalePlanItemModel.getQuarter().equals("4")) continue;
            rkSalePlanItemModel.setSalesAmountCompleted(vo.getSalesAmountCompletedQ4());
            rkSalePlanItemModel.setContractAmountCompleted(vo.getContractAmountCompletedQ4());
            rkSalePlanItemModel.setReturnedAmountCompleted(vo.getReturnedAmountCompletedQ4());
            rkSalePlanItemModel.setTargetMarginCompleted(vo.getTargetMarginCompletedQ4());
            rkSalePlanItemModel.setSuccessOpportunityAmountCompleted(vo.getSuccessOpportunityAmountCompletedQ4());
            rkSalePlanItemModel.setSuccessOpportunityMoneyCompleted(vo.getSuccessOpportunityMoneyCompletedQ4());
        }
        vo.setRkSalePlanItemList(rkSalePlanItemModelList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity yearTarget = new ExcelExportEntity("\u5e74\u5ea6", (Object)"yearTarget");
        ArrayList<ExcelExportEntity> yearEntity = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "planYear": {
                        entitys.add(new ExcelExportEntity("\u5e74\u4efd", (Object)"planYearStr"));
                        continue block30;
                    }
                    case "userDepartmentId": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"userDepartmentId"));
                        continue block30;
                    }
                    case "saleUserId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"saleUserId"));
                        continue block30;
                    }
                    case "salesAmount": {
                        entitys.add(new ExcelExportEntity("\u5e74\u5ea6\u9500\u552e\u989d\uff08\u4e07\u5143\uff09", (Object)"salesAmount"));
                        yearEntity.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u5e74\u5ea6\u9500\u552e\u989d\uff08\u5143\uff09", (Object)"salesAmountCompleted"));
                        continue block30;
                    }
                    case "contractAmount": {
                        yearEntity.add(new ExcelExportEntity("\u5408\u540c\u6570\u91cf", (Object)"contractAmount"));
                        yearEntity.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u5408\u540c\u6570\u91cf", (Object)"contractAmountCompleted"));
                        continue block30;
                    }
                    case "returnedAmount": {
                        yearEntity.add(new ExcelExportEntity("\u56de\u6b3e\u989d\uff08\u4e07\u5143\uff09", (Object)"returnedAmount"));
                        yearEntity.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u56de\u6b3e\u989d\uff08\u5143\uff09", (Object)"returnedAmountCompleted"));
                        continue block30;
                    }
                    case "targetMargin": {
                        yearEntity.add(new ExcelExportEntity("\u76ee\u6807\u6bdb\u5229\uff08\u4e07\u5143\uff09", (Object)"targetMargin"));
                        yearEntity.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u76ee\u6807\u6bdb\u5229\uff08\u5143\uff09", (Object)"targetMarginCompleted"));
                        continue block30;
                    }
                    case "successOpportunityMoney": {
                        yearEntity.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u4e07\u5143\uff09", (Object)"successOpportunityMoney"));
                        yearEntity.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"successOpportunityMoneyCompleted"));
                        continue block30;
                    }
                    case "successOpportunityAmount": {
                        yearEntity.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmount"));
                        yearEntity.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountCompleted"));
                        continue block30;
                    }
                }
            }
        }
        yearTarget.setList(yearEntity);
        yearTarget.setNeedMerge(true);
        entitys.add(yearTarget);
        ArrayList<ExcelExportEntity> Q1List = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity Q1 = new ExcelExportEntity("Q1", (Object)"q1Target");
        Q1List.add(new ExcelExportEntity("\u9500\u552e\u989d\uff08\u4e07\u5143\uff09", (Object)"salesAmountQ1"));
        Q1List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u9500\u552e\u989d\uff08\u5143\uff09", (Object)"salesAmountCompletedQ1"));
        Q1List.add(new ExcelExportEntity("\u5408\u540c\u6570\u91cf", (Object)"contractAmountQ1"));
        Q1List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u5408\u540c\u6570\u91cf", (Object)"contractAmountCompletedQ1"));
        Q1List.add(new ExcelExportEntity("\u56de\u6b3e\u989d\uff08\u4e07\u5143\uff09", (Object)"returnedAmountQ1"));
        Q1List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u56de\u6b3e\u989d\uff08\u5143\uff09", (Object)"returnedAmountCompletedQ1"));
        Q1List.add(new ExcelExportEntity("\u76ee\u6807\u6bdb\u5229\uff08\u4e07\u5143\uff09", (Object)"targetMarginQ1"));
        Q1List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u76ee\u6807\u6bdb\u5229\uff08\u5143\uff09", (Object)"targetMarginCompletedQ1"));
        Q1List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u4e07\u5143\uff09", (Object)"successOpportunityMoneyQ1"));
        Q1List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"successOpportunityMoneyCompletedQ1"));
        Q1List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountQ1"));
        Q1List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountCompletedQ1"));
        Q1.setList(Q1List);
        Q1.setNeedMerge(true);
        entitys.add(Q1);
        ArrayList<ExcelExportEntity> Q2List = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity Q2 = new ExcelExportEntity("Q2", (Object)"q2Target");
        Q2List.add(new ExcelExportEntity("\u9500\u552e\u989d\uff08\u4e07\u5143\uff09", (Object)"salesAmountQ2"));
        Q2List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u9500\u552e\u989d\uff08\u5143\uff09", (Object)"salesAmountCompletedQ2"));
        Q2List.add(new ExcelExportEntity("\u5408\u540c\u6570\u91cf", (Object)"contractAmountQ2"));
        Q2List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u5408\u540c\u6570\u91cf", (Object)"contractAmountCompletedQ2"));
        Q2List.add(new ExcelExportEntity("\u56de\u6b3e\u989d\uff08\u4e07\u5143\uff09", (Object)"returnedAmountQ2"));
        Q2List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u56de\u6b3e\u989d\uff08\u5143\uff09", (Object)"returnedAmountCompletedQ2"));
        Q2List.add(new ExcelExportEntity("\u76ee\u6807\u6bdb\u5229\uff08\u4e07\u5143\uff09", (Object)"targetMarginQ2"));
        Q2List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u76ee\u6807\u6bdb\u5229\uff08\u5143\uff09", (Object)"targetMarginCompletedQ2"));
        Q2List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u4e07\u5143\uff09", (Object)"successOpportunityMoneyQ2"));
        Q2List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"successOpportunityMoneyCompletedQ2"));
        Q2List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountQ2"));
        Q2List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountCompletedQ2"));
        Q2.setList(Q2List);
        Q2.setNeedMerge(true);
        entitys.add(Q2);
        ArrayList<ExcelExportEntity> Q3List = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity Q3 = new ExcelExportEntity("Q3", (Object)"q3Target");
        Q3List.add(new ExcelExportEntity("\u9500\u552e\u989d\uff08\u4e07\u5143\uff09", (Object)"salesAmountQ3"));
        Q3List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u9500\u552e\u989d\uff08\u5143\uff09", (Object)"salesAmountCompletedQ3"));
        Q3List.add(new ExcelExportEntity("\u5408\u540c\u6570\u91cf", (Object)"contractAmountQ3"));
        Q3List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u5408\u540c\u6570\u91cf", (Object)"contractAmountCompletedQ3"));
        Q3List.add(new ExcelExportEntity("\u56de\u6b3e\u989d\uff08\u4e07\u5143\uff09", (Object)"returnedAmountQ3"));
        Q3List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u56de\u6b3e\u989d\uff08\u5143\uff09", (Object)"returnedAmountCompletedQ3"));
        Q3List.add(new ExcelExportEntity("\u76ee\u6807\u6bdb\u5229\uff08\u4e07\u5143\uff09", (Object)"targetMarginQ3"));
        Q3List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u76ee\u6807\u6bdb\u5229\uff08\u5143\uff09", (Object)"targetMarginCompletedQ3"));
        Q3List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u4e07\u5143\uff09", (Object)"successOpportunityMoneyQ3"));
        Q3List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"successOpportunityMoneyCompletedQ3"));
        Q3List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountQ3"));
        Q3List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountCompletedQ3"));
        Q3.setList(Q3List);
        Q3.setNeedMerge(true);
        entitys.add(Q3);
        ArrayList<ExcelExportEntity> Q4List = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity Q4 = new ExcelExportEntity("Q4", (Object)"q4Target");
        Q4List.add(new ExcelExportEntity("\u9500\u552e\u989d\uff08\u4e07\u5143\uff09", (Object)"salesAmountQ4"));
        Q4List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u9500\u552e\u989d\uff08\u5143\uff09", (Object)"salesAmountCompletedQ4"));
        Q4List.add(new ExcelExportEntity("\u5408\u540c\u6570\u91cf", (Object)"contractAmountQ4"));
        Q4List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u5408\u540c\u6570\u91cf", (Object)"contractAmountCompletedQ4"));
        Q4List.add(new ExcelExportEntity("\u56de\u6b3e\u989d\uff08\u4e07\u5143\uff09", (Object)"returnedAmountQ4"));
        Q4List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u56de\u6b3e\u989d\uff08\u5143\uff09", (Object)"returnedAmountCompletedQ4"));
        Q4List.add(new ExcelExportEntity("\u76ee\u6807\u6bdb\u5229\uff08\u4e07\u5143\uff09", (Object)"targetMarginQ4"));
        Q4List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u76ee\u6807\u6bdb\u5229\uff08\u5143\uff09", (Object)"targetMarginCompletedQ4"));
        Q4List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u4e07\u5143\uff09", (Object)"successOpportunityMoneyQ4"));
        Q4List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u91d1\u989d\uff08\u5143\uff09", (Object)"successOpportunityMoneyCompletedQ4"));
        Q4List.add(new ExcelExportEntity("\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountQ4"));
        Q4List.add(new ExcelExportEntity("\u5df2\u5b8c\u6210\u8d62\u5355\u5546\u673a\u6570", (Object)"successOpportunityAmountCompletedQ4"));
        Q4.setList(Q4List);
        Q4.setNeedMerge(true);
        entitys.add(Q4);
        entitys.add(new ExcelExportEntity("\u5f55\u5165\u65f6\u95f4", (Object)"creatorTime"));
        entitys.add(new ExcelExportEntity("\u5f55\u5165\u4eba", (Object)"creatorUserName"));
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9500\u552e\u8ba1\u5212" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Throwable)e);
            e.printStackTrace();
        }
        return vo;
    }

    public static void main(String[] args) {
        String startTime = "2022-01-01";
        String endTime = "2022-12-31";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(startTime);
            endDate = sdf.parse(endTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int quarters = (endCal.get(1) - startCal.get(1)) * 4 + (endCal.get(2) / 3 - startCal.get(2) / 3) + 1;
        for (int i = 0; i < quarters; ++i) {
            int quarterStartMonth = 0;
            quarterStartMonth = i == 0 ? i : i * 3;
            startCal.set(2, quarterStartMonth);
            startCal.set(5, startCal.getActualMinimum(5));
            int quarterEndMonth = quarterStartMonth + 2;
            endCal.set(2, quarterEndMonth);
            endCal.set(5, endCal.getActualMaximum(5));
            String quarterStartDate = sdf.format(startCal.getTime());
            String quarterEndDate = sdf.format(endCal.getTime());
            System.out.println("Quarter " + (i + 1) + ": " + quarterStartDate + " - " + quarterEndDate);
        }
    }

    public List<RkSalePlanExportListVO> getUserTargetsituation(List<RkSalePlanListVO> rkSalePlanEntities) {
        RkContractCollectionRecordPagination rkSalePlanPagination = new RkContractCollectionRecordPagination();
        List<String> userIdList = rkSalePlanEntities.stream().map(RkSalePlanListVO::getSaleUserId).collect(Collectors.toList());
        rkSalePlanPagination.setSalerIds(userIdList);
        List<RkContractEntity> contractListByUserIds = this.rkContractService.getListBy(rkSalePlanPagination);
        List<RkContractCollectionRecordEntity> recordListByContractIdList = this.rkContractCollectionRecordService.getListByContractIdList(contractListByUserIds.stream().map(RkContractEntity::getId).collect(Collectors.toList()));
        List<RkProjectReportingEntity> projectReportingList = this.rkProjectReportingService.getListByUserAndDate(userIdList, new ArrayList<Date>());
        List exportListVO = JsonUtil.getJsonToList(rkSalePlanEntities, RkSalePlanExportListVO.class);
        for (RkSalePlanExportListVO rkSalePlanEntity : exportListVO) {
            Date planYear = rkSalePlanEntity.getPlanYear();
            String year = DateUtil.format((Date)planYear, (String)"yyyy");
            Date nextYearTime = DateUtil.getYearLast((int)Integer.parseInt(year));
            List<Object> userContractList = new ArrayList();
            if (ObjectUtil.isNotEmpty(contractListByUserIds)) {
                userContractList = contractListByUserIds.stream().filter(i -> i.getSalerId().equals(rkSalePlanEntity.getSaleUserId()) && i.getSignDate().after(planYear) && i.getSignDate().before(nextYearTime)).collect(Collectors.toList());
            }
            List contractIdList = userContractList.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            List<Object> recordEntities = new ArrayList();
            if (ObjectUtil.isNotEmpty(recordListByContractIdList)) {
                recordEntities = recordListByContractIdList.stream().filter(i -> contractIdList.contains(i)).collect(Collectors.toList());
            }
            List<Object> projectListByDate = new ArrayList();
            if (ObjectUtil.isNotEmpty(projectReportingList)) {
                projectListByDate = projectReportingList.stream().filter(item -> item.getCreatorUserId().equals(rkSalePlanEntity.getSaleUserId()) && item.getCreatorTime().after(planYear) && item.getCreatorTime().before(nextYearTime)).collect(Collectors.toList());
            }
            if (ObjectUtil.isNotEmpty(userContractList)) {
                BigDecimal contractAmount = BigDecimal.ZERO;
                Object profitAmount = BigDecimal.ZERO;
                for (Object rkContractEntity2 : userContractList) {
                    contractAmount = MathUtils.add(contractAmount, ((RkContractEntity)rkContractEntity2).getContractAmount());
                    profitAmount = MathUtils.add((BigDecimal)profitAmount, ((RkContractEntity)rkContractEntity2).getProfit());
                }
                rkSalePlanEntity.setContractAmountCompleted(String.valueOf(contractAmount));
                rkSalePlanEntity.setTargetMarginCompleted(String.valueOf(profitAmount));
            }
            if (ObjectUtil.isNotEmpty(recordEntities)) {
                BigDecimal returnMoney = BigDecimal.ZERO;
                for (Object rkContractEntity : recordEntities) {
                    returnMoney = MathUtils.add(returnMoney, ((RkContractCollectionRecordEntity)rkContractEntity).getReturnAmount());
                }
                rkSalePlanEntity.setContractAmountCompleted(String.valueOf(returnMoney));
            }
            if (ObjectUtil.isNotEmpty(projectListByDate)) {
                Object rkContractEntity;
                Integer saleChanceAmount = projectListByDate.size();
                BigDecimal saleChanceMoney = BigDecimal.ZERO;
                rkContractEntity = projectListByDate.iterator();
                while (rkContractEntity.hasNext()) {
                    Object rkContractEntity2;
                    rkContractEntity2 = (RkProjectReportingEntity)rkContractEntity.next();
                    saleChanceMoney = MathUtils.add(saleChanceMoney, ((RkProjectReportingEntity)rkContractEntity2).getEstimatedSigningAmount());
                }
                rkSalePlanEntity.setSuccessOpportunityMoneyCompleted(String.valueOf(saleChanceMoney));
                rkSalePlanEntity.setSuccessOpportunityAmountCompleted(String.valueOf(saleChanceAmount));
            }
            ArrayList<RkSalePlanYearExportVO> yearTargetList = new ArrayList<RkSalePlanYearExportVO>();
            yearTargetList.add((RkSalePlanYearExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanYearExportVO.class));
            rkSalePlanEntity.setYearTarget(yearTargetList);
            List<RkSalePlanItemEntity> rkSalePlanItemEntities = this.GetRkSalePlanItemList(rkSalePlanEntity.getId());
            HashMap startAndEndDayOfSeason = DateUtil.getStartAndEndDayOfSeason((Date)planYear, (Date)nextYearTime);
            if (ObjectUtil.isNotEmpty(rkSalePlanItemEntities)) {
                for (RkSalePlanItemEntity salePlanEntity : rkSalePlanItemEntities) {
                    RkProjectReportingEntity rkContractEntity5;
                    Object saleChanceMoney;
                    Integer saleChanceAmount;
                    List projectListByQuarter;
                    List rkReturnMoneyList;
                    Iterator rkContractEntity32;
                    Object rkContractEntity42;
                    List rkContractList;
                    List dateList;
                    if (salePlanEntity.getQuarter().equals("1")) {
                        List projectListByQuarter2;
                        List rkReturnMoneyList2;
                        rkSalePlanEntity.setSalesAmountQ1(salePlanEntity.getSalesAmount());
                        rkSalePlanEntity.setContractAmountQ1(salePlanEntity.getContractAmount());
                        rkSalePlanEntity.setReturnedAmountQ1(salePlanEntity.getReturnedAmount());
                        rkSalePlanEntity.setTargetMarginQ1(salePlanEntity.getTargetMargin());
                        rkSalePlanEntity.setSuccessOpportunityMoneyQ1(salePlanEntity.getSuccessOpportunityMoney());
                        rkSalePlanEntity.setSuccessOpportunityAmountQ1(salePlanEntity.getSuccessOpportunityAmount());
                        dateList = (List)startAndEndDayOfSeason.get("1");
                        if (ObjectUtil.isNotEmpty(userContractList) && ObjectUtil.isNotEmpty(rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal contractAmountQ1 = BigDecimal.ZERO;
                            Object profitAmountQ1 = BigDecimal.ZERO;
                            for (Object rkContractEntity42 : rkContractList) {
                                contractAmountQ1 = MathUtils.add(contractAmountQ1, ((RkContractEntity)rkContractEntity42).getContractAmount());
                                profitAmountQ1 = MathUtils.add((BigDecimal)profitAmountQ1, ((RkContractEntity)rkContractEntity42).getProfit());
                            }
                            rkSalePlanEntity.setContractAmountCompletedQ1(String.valueOf(contractAmountQ1));
                            rkSalePlanEntity.setTargetMarginCompletedQ1(String.valueOf(profitAmountQ1));
                        }
                        if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList2 = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal returnMoneyQ1 = BigDecimal.ZERO;
                            for (Iterator rkContractEntity32 : rkReturnMoneyList2) {
                                returnMoneyQ1 = MathUtils.add(returnMoneyQ1, ((RkContractCollectionRecordEntity)((Object)rkContractEntity32)).getReturnAmount());
                            }
                            rkSalePlanEntity.setReturnedAmountCompletedQ1(String.valueOf(returnMoneyQ1));
                        }
                        if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter2 = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after(planYear) && item.getExpectedSigningDate().before(nextYearTime)).collect(Collectors.toList()))) {
                            Integer saleChanceAmount2 = projectListByDate.size();
                            BigDecimal saleChanceMoney2 = BigDecimal.ZERO;
                            rkContractEntity32 = projectListByQuarter2.iterator();
                            while (rkContractEntity32.hasNext()) {
                                rkContractEntity42 = (RkProjectReportingEntity)rkContractEntity32.next();
                                saleChanceMoney2 = MathUtils.add(saleChanceMoney2, ((RkProjectReportingEntity)rkContractEntity42).getEstimatedSigningAmount());
                            }
                            rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ1(String.valueOf(saleChanceMoney2));
                            rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ1(String.valueOf(saleChanceAmount2));
                        }
                        ArrayList<RkSalePlanQ1ExportVO> q1TargetList = new ArrayList<RkSalePlanQ1ExportVO>();
                        q1TargetList.add((RkSalePlanQ1ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ1ExportVO.class));
                        rkSalePlanEntity.setQ1Target(q1TargetList);
                    }
                    if (salePlanEntity.getQuarter().equals("2")) {
                        rkSalePlanEntity.setSalesAmountQ2(salePlanEntity.getSalesAmount());
                        rkSalePlanEntity.setContractAmountQ2(salePlanEntity.getContractAmount());
                        rkSalePlanEntity.setReturnedAmountQ2(salePlanEntity.getReturnedAmount());
                        rkSalePlanEntity.setTargetMarginQ2(salePlanEntity.getTargetMargin());
                        rkSalePlanEntity.setSuccessOpportunityMoneyQ2(salePlanEntity.getSuccessOpportunityMoney());
                        rkSalePlanEntity.setSuccessOpportunityAmountQ2(salePlanEntity.getSuccessOpportunityAmount());
                        dateList = (List)startAndEndDayOfSeason.get("2");
                        rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(rkContractList)) {
                            BigDecimal contractAmountQ2 = BigDecimal.ZERO;
                            BigDecimal profitAmountQ2 = BigDecimal.ZERO;
                            rkContractEntity32 = userContractList.iterator();
                            while (rkContractEntity32.hasNext()) {
                                rkContractEntity42 = (RkContractEntity)rkContractEntity32.next();
                                contractAmountQ2 = MathUtils.add(contractAmountQ2, ((RkContractEntity)rkContractEntity42).getContractAmount());
                                profitAmountQ2 = MathUtils.add(profitAmountQ2, ((RkContractEntity)rkContractEntity42).getProfit());
                            }
                            rkSalePlanEntity.setContractAmountCompletedQ2(String.valueOf(contractAmountQ2));
                            rkSalePlanEntity.setTargetMarginCompletedQ2(String.valueOf(profitAmountQ2));
                        }
                        if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal returnMoneyQ2 = BigDecimal.ZERO;
                            rkContractEntity32 = rkReturnMoneyList.iterator();
                            while (rkContractEntity32.hasNext()) {
                                rkContractEntity42 = (RkContractCollectionRecordEntity)rkContractEntity32.next();
                                returnMoneyQ2 = MathUtils.add(returnMoneyQ2, ((RkContractCollectionRecordEntity)rkContractEntity42).getReturnAmount());
                            }
                            rkSalePlanEntity.setReturnedAmountCompletedQ2(String.valueOf(returnMoneyQ2));
                        }
                        if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after(planYear) && item.getExpectedSigningDate().before(nextYearTime)).collect(Collectors.toList()))) {
                            saleChanceAmount = projectListByDate.size();
                            saleChanceMoney = BigDecimal.ZERO;
                            rkContractEntity42 = projectListByQuarter.iterator();
                            while (rkContractEntity42.hasNext()) {
                                rkContractEntity5 = (RkProjectReportingEntity)rkContractEntity42.next();
                                saleChanceMoney = MathUtils.add((BigDecimal)saleChanceMoney, rkContractEntity5.getEstimatedSigningAmount());
                            }
                            rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ2(String.valueOf(saleChanceMoney));
                            rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ2(String.valueOf(saleChanceAmount));
                        }
                        ArrayList<RkSalePlanQ2ExportVO> q2TargetList = new ArrayList<RkSalePlanQ2ExportVO>();
                        q2TargetList.add((RkSalePlanQ2ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ2ExportVO.class));
                        rkSalePlanEntity.setQ2Target(q2TargetList);
                    }
                    if (salePlanEntity.getQuarter().equals("3")) {
                        rkSalePlanEntity.setSalesAmountQ3(salePlanEntity.getSalesAmount());
                        rkSalePlanEntity.setContractAmountQ3(salePlanEntity.getContractAmount());
                        rkSalePlanEntity.setReturnedAmountQ3(salePlanEntity.getReturnedAmount());
                        rkSalePlanEntity.setTargetMarginQ3(salePlanEntity.getTargetMargin());
                        rkSalePlanEntity.setSuccessOpportunityMoneyQ3(salePlanEntity.getSuccessOpportunityMoney());
                        rkSalePlanEntity.setSuccessOpportunityAmountQ3(salePlanEntity.getSuccessOpportunityAmount());
                        dateList = (List)startAndEndDayOfSeason.get("3");
                        rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(rkContractList)) {
                            BigDecimal contractAmountQ3 = BigDecimal.ZERO;
                            BigDecimal profitAmountQ3 = BigDecimal.ZERO;
                            for (Object rkContractEntity42 : userContractList) {
                                contractAmountQ3 = MathUtils.add(contractAmountQ3, ((RkContractEntity)rkContractEntity42).getContractAmount());
                                profitAmountQ3 = MathUtils.add(profitAmountQ3, ((RkContractEntity)rkContractEntity42).getProfit());
                            }
                            rkSalePlanEntity.setContractAmountCompletedQ3(String.valueOf(contractAmountQ3));
                            rkSalePlanEntity.setTargetMarginCompletedQ3(String.valueOf(profitAmountQ3));
                        }
                        if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                            BigDecimal returnMoneyQ3 = BigDecimal.ZERO;
                            for (Object rkContractEntity42 : rkReturnMoneyList) {
                                returnMoneyQ3 = MathUtils.add(returnMoneyQ3, ((RkContractCollectionRecordEntity)rkContractEntity42).getReturnAmount());
                            }
                            rkSalePlanEntity.setReturnedAmountCompletedQ3(String.valueOf(returnMoneyQ3));
                        }
                        if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after(planYear) && item.getExpectedSigningDate().before(nextYearTime)).collect(Collectors.toList()))) {
                            saleChanceAmount = projectListByDate.size();
                            saleChanceMoney = BigDecimal.ZERO;
                            rkContractEntity42 = projectListByQuarter.iterator();
                            while (rkContractEntity42.hasNext()) {
                                rkContractEntity5 = (RkProjectReportingEntity)rkContractEntity42.next();
                                saleChanceMoney = MathUtils.add((BigDecimal)saleChanceMoney, rkContractEntity5.getEstimatedSigningAmount());
                            }
                            rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ3(String.valueOf(saleChanceMoney));
                            rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ3(String.valueOf(saleChanceAmount));
                        }
                        ArrayList<RkSalePlanQ3ExportVO> q3TargetList = new ArrayList<RkSalePlanQ3ExportVO>();
                        q3TargetList.add((RkSalePlanQ3ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ3ExportVO.class));
                        rkSalePlanEntity.setQ3Target(q3TargetList);
                    }
                    if (!salePlanEntity.getQuarter().equals("4")) continue;
                    rkSalePlanEntity.setSalesAmountQ4(salePlanEntity.getSalesAmount());
                    rkSalePlanEntity.setContractAmountQ4(salePlanEntity.getContractAmount());
                    rkSalePlanEntity.setReturnedAmountQ4(salePlanEntity.getReturnedAmount());
                    rkSalePlanEntity.setTargetMarginQ4(salePlanEntity.getTargetMargin());
                    rkSalePlanEntity.setSuccessOpportunityMoneyQ4(salePlanEntity.getSuccessOpportunityMoney());
                    rkSalePlanEntity.setSuccessOpportunityAmountQ4(salePlanEntity.getSuccessOpportunityAmount());
                    dateList = (List)startAndEndDayOfSeason.get("4");
                    rkContractList = userContractList.stream().filter(i -> i.getSignDate().after((Date)dateList.get(0)) && i.getSignDate().before((Date)dateList.get(1))).collect(Collectors.toList());
                    if (ObjectUtil.isNotEmpty(rkContractList)) {
                        BigDecimal contractAmountQ4 = BigDecimal.ZERO;
                        BigDecimal profitAmountQ4 = BigDecimal.ZERO;
                        for (Object rkContractEntity42 : userContractList) {
                            contractAmountQ4 = MathUtils.add(contractAmountQ4, ((RkContractEntity)rkContractEntity42).getContractAmount());
                            profitAmountQ4 = MathUtils.add(profitAmountQ4, ((RkContractEntity)rkContractEntity42).getProfit());
                        }
                        rkSalePlanEntity.setContractAmountCompletedQ4(String.valueOf(contractAmountQ4));
                        rkSalePlanEntity.setTargetMarginCompletedQ4(String.valueOf(profitAmountQ4));
                    }
                    if (ObjectUtil.isNotEmpty(recordEntities) && ObjectUtil.isNotEmpty(rkReturnMoneyList = recordEntities.stream().filter(i -> i.getReturnDate().after((Date)dateList.get(0)) && i.getReturnDate().before((Date)dateList.get(1))).collect(Collectors.toList()))) {
                        BigDecimal returnMoneyQ4 = BigDecimal.ZERO;
                        for (Object rkContractEntity42 : rkReturnMoneyList) {
                            returnMoneyQ4 = MathUtils.add(returnMoneyQ4, ((RkContractCollectionRecordEntity)rkContractEntity42).getReturnAmount());
                        }
                        rkSalePlanEntity.setReturnedAmountCompletedQ4(String.valueOf(returnMoneyQ4));
                    }
                    if (ObjectUtil.isNotEmpty(projectListByDate) && ObjectUtil.isNotEmpty(projectListByQuarter = projectListByDate.stream().filter(item -> item.getExpectedSigningDate().after(planYear) && item.getExpectedSigningDate().before(nextYearTime)).collect(Collectors.toList()))) {
                        saleChanceAmount = projectListByDate.size();
                        saleChanceMoney = BigDecimal.ZERO;
                        for (RkProjectReportingEntity rkContractEntity5 : projectListByQuarter) {
                            saleChanceMoney = MathUtils.add((BigDecimal)saleChanceMoney, rkContractEntity5.getEstimatedSigningAmount());
                        }
                        rkSalePlanEntity.setSuccessOpportunityMoneyCompletedQ4(String.valueOf(saleChanceMoney));
                        rkSalePlanEntity.setSuccessOpportunityAmountCompletedQ4(String.valueOf(saleChanceAmount));
                    }
                    ArrayList<RkSalePlanQ4ExportVO> q4TargetList = new ArrayList<RkSalePlanQ4ExportVO>();
                    q4TargetList.add((RkSalePlanQ4ExportVO)JsonUtil.getJsonToBean((Object)rkSalePlanEntity, RkSalePlanQ4ExportVO.class));
                    rkSalePlanEntity.setQ4Target(q4TargetList);
                }
            }
            rkSalePlanEntity.setCreatorUserIdCode(rkSalePlanEntity.getCreatorUserId());
            rkSalePlanEntity.setUserDepartmentId(this.baseDataUtil.comSelectValues(rkSalePlanEntity.getUserDepartmentId()));
            rkSalePlanEntity.setSaleUserId(this.baseDataUtil.userSelectValues(rkSalePlanEntity.getSaleUserId()));
            rkSalePlanEntity.setCreatorUserName(this.baseDataUtil.userSelectValues(rkSalePlanEntity.getCreatorUserId()));
            rkSalePlanEntity.setPlanYearStr(DateUtil.daFormat((Date)rkSalePlanEntity.getPlanYear()).substring(0, 4));
        }
        return exportListVO;
    }

    public Boolean compareNumber(String targetNumber, String completedNumber, Boolean firstTrue) {
        Boolean flag = false;
        if (StrUtil.isBlank((CharSequence)targetNumber) || StrUtil.isBlank((CharSequence)completedNumber)) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(10000);
        BigDecimal target = new BigDecimal(targetNumber);
        BigDecimal completed = new BigDecimal(completedNumber);
        if (firstTrue.booleanValue()) {
            target = target.multiply(bigDecimal);
        }
        if (completed.compareTo(target) >= 0) {
            flag = true;
        }
        return flag;
    }
}

