/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectCostEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectAcceptEntity;
import com.bringspring.contract.entity.SaleConfirmIncomeEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.RkContractProjectCostMapper;
import com.bringspring.contract.mapper.SaleConfirmIncomeMapper;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeCrForm;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeInfoVO;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeListQuery;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomePagination;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeUpForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectAcceptService;
import com.bringspring.contract.service.SaleConfirmIncomeService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProjectConfirmIncomeStatus;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.crm.entity.CrmCustomerCompanyRelationEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.ecs.docking.entity.vo.ConfirmIncomeRequest;
import com.bringspring.ecs.docking.service.VoucherPushService;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkMarketLogProjectDataEntity;
import com.bringspring.visit.service.RkMarketLogProjectDataService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleConfirmIncomeServiceImpl
extends ServiceImpl<SaleConfirmIncomeMapper, SaleConfirmIncomeEntity>
implements SaleConfirmIncomeService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractProjectCostMapper rkContractProjectCostMapper;
    @Autowired
    private RkMarketLogProjectDataService rkMarketLogProjectDataService;
    @Autowired
    private RkProjectAcceptService rkProjectAcceptService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmCustomerCompanyRelationService crmCustomerCompanyRelationService;
    @Autowired
    private VoucherPushService voucherPushService;

    @Override
    public List<SaleConfirmIncomeEntity> getList(SaleConfirmIncomePagination saleConfirmIncomePagination) {
        QueryWrapper<SaleConfirmIncomeEntity> saleConfirmIncomeQueryWrapper = this.appendWrapper(saleConfirmIncomePagination);
        Page page = new Page(saleConfirmIncomePagination.getCurrentPage(), saleConfirmIncomePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)saleConfirmIncomeQueryWrapper);
        return saleConfirmIncomePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleConfirmIncomeEntity> appendWrapper(SaleConfirmIncomePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        boolean permission = true;
        if (ObjectUtil.equals((Object)pagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "sale_confirm_income"));
            if (ObjectUtil.isEmpty((Object)object)) {
                queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getCreatorUserId, (Object)userId);
            } else {
                queryWrapper = (QueryWrapper)object;
            }
        }
        queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getEnabledMark, (Object)1);
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getProjectName())) {
            queryWrapper.lambda().like(SaleConfirmIncomeEntity::getProjectName, (Object)pagination.getProjectName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCustomerId())) {
            queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getCustomerId, (Object)pagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSaleId())) {
            queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getSalerId, (Object)pagination.getSaleId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCreatorUserId())) {
            queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getCreatorUserId, (Object)pagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> creatorTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(creatorTimeList.get(0));
            Long sec = Long.valueOf(creatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleConfirmIncomeEntity::getCreatorTime, (Object)new Date(fir))).le(SaleConfirmIncomeEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getConfirmIncomeStatus())) {
            queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getConfirmIncomeStatus, (Object)pagination.getConfirmIncomeStatus());
        }
        if (pagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)pagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(SaleConfirmIncomeEntity::getId);
            } else {
                try {
                    String sidx = pagination.getSidx();
                    SaleConfirmIncomeEntity saleConfirmIncomeEntity = new SaleConfirmIncomeEntity();
                    Field declaredField = saleConfirmIncomeEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public List<SaleConfirmIncomeEntity> getTypeList(SaleConfirmIncomePagination saleConfirmIncomePagination, String dataType) {
        QueryWrapper<SaleConfirmIncomeEntity> saleConfirmIncomeQueryWrapper = this.appendWrapper(saleConfirmIncomePagination);
        if ("0".equals(dataType)) {
            Page page = new Page(saleConfirmIncomePagination.getCurrentPage(), saleConfirmIncomePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleConfirmIncomeQueryWrapper);
            return saleConfirmIncomePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleConfirmIncomeQueryWrapper);
    }

    @Override
    public SaleConfirmIncomeInfoVO initData(String projectId) {
        List<RkAttachmentEntity> contractAttachmentList;
        CrmCustomerEntity customer;
        Object contract;
        SaleConfirmIncomeInfoVO vo = new SaleConfirmIncomeInfoVO();
        vo.setProjectId(projectId);
        RkContractProjectEntity project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)projectId));
        if (null != project) {
            RkProjectAcceptEntity accept;
            UserEntity user;
            vo.setProjectName(project.getProjectName());
            vo.setContractId(project.getContractId());
            vo.setNoContractId(project.getNoContractId());
            Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
            vo.setProjectCode(project.getProjectCode());
            vo.setProjectStatus(project.getState());
            vo.setProjectStatusName(StringUtils.isEmpty((String)project.getState()) ? "" : allToMap.get(project.getState()).getDesc());
            vo.setReceivedAmount(project.getReceivedAmount());
            vo.setInvoiceAmount(project.getInvoiceAmount());
            vo.setAcceptanceTime(DateUtil.getTime((Date)project.getAcceptanceTime()) * 1000L);
            vo.setAcceptedUser(project.getAcceptedBy());
            if (StringUtils.isNotEmpty((String)project.getAcceptedBy()) && null != (user = (UserEntity)this.userService.getById((Serializable)((Object)project.getAcceptedBy())))) {
                vo.setAcceptedUserName(user.getRealName());
                vo.setAcceptedDept(user.getOrganizeId());
                OrganizeEntity organize = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)user.getOrganizeId()));
                if (null != organize) {
                    vo.setAcceptedDeptName(organize.getFullName());
                }
            }
            vo.setAcceptIsArchived(null == project.getAcceptIsArchived() ? 0 : project.getAcceptIsArchived());
            vo.setTaxRate(project.getTaxRate());
            vo.setTaxRateName(this.baseDataUtil.getDictName(vo.getTaxRate(), "projectTaxRate"));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().eq(RkMarketLogProjectDataEntity::getProjectId, (Object)project.getId());
            wrapper.lambda().eq(RkMarketLogProjectDataEntity::getState, (Object)"1");
            BigDecimal workDay = BigDecimal.ZERO;
            BigDecimal workHour = BigDecimal.ZERO;
            List list = this.rkMarketLogProjectDataService.list((Wrapper)wrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                for (RkMarketLogProjectDataEntity data : list) {
                    workDay = workDay.add(ConvertUtil.toBigDecimal((Object)data.getWorkDay(), (BigDecimal)BigDecimal.ZERO));
                    workHour = workHour.add(ConvertUtil.toBigDecimal((Object)data.getManHour(), (BigDecimal)BigDecimal.ZERO));
                }
            }
            vo.setProjectWorkDay(workDay);
            vo.setProjectCost(workHour);
            vo.setProjectAmount(project.getProjectAmount());
            vo.setSureIncome(project.getSureIncome());
            vo.setAllConfirmIncome(project.getAllConfirmIncome());
            vo.setToBeConfirmedIncome(MathUtils.substract(vo.getSureIncome(), vo.getAllConfirmIncome()));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(RkContractProjectCostEntity::getProjectId, (Object)project.getId());
            queryWrapper.lambda().eq(RkContractProjectCostEntity::getState, (Object)"1");
            List rkContractProjectCostEntities = this.rkContractProjectCostMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)rkContractProjectCostEntities)) {
                BigDecimal sum = rkContractProjectCostEntities.stream().map(RkContractProjectCostEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setProjectCost(sum);
            }
            if (null != (accept = this.rkProjectAcceptService.getByProjectId(project.getId()))) {
                List<RkAttachmentEntity> acceptAttachmentList = this.rkAttachmentService.getListByObjId(accept.getId());
                vo.setAcceptAttachmentList(acceptAttachmentList);
            }
        }
        if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
            contract = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
            if (null != contract) {
                vo.setCustomerId(((RkContractEntity)contract).getCustomerId());
                customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)((RkContractEntity)contract).getCustomerId()));
                if (null != customer) {
                    vo.setCustomerName(customer.getName());
                }
                vo.setContractCode(((RkContractEntity)contract).getContractCode());
                vo.setContractName(((RkContractEntity)contract).getContractName());
                vo.setContractType(((RkContractEntity)contract).getContractType());
                vo.setContractTypeName(this.baseDataUtil.getDictName(((RkContractEntity)contract).getContractType(), "contractType"));
                vo.setContractStatus(((RkContractEntity)contract).getEnableMark());
                vo.setContractStatusName(this.baseDataUtil.getDictName(((RkContractEntity)contract).getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
                contractAttachmentList = this.rkAttachmentService.getListByContractId(vo.getContractId());
                vo.setContractAttachmentList(contractAttachmentList);
            }
        } else if (!StrUtil.isBlank((CharSequence)vo.getNoContractId()) && null != (contract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId())))) {
            vo.setCustomerId(((SaleNoContractEntity)contract).getCustomerId());
            customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)((SaleNoContractEntity)contract).getCustomerId()));
            if (null != customer) {
                vo.setCustomerName(customer.getName());
            }
            vo.setContractCode(((SaleNoContractEntity)contract).getContractCode());
            vo.setContractName(((SaleNoContractEntity)contract).getContractName());
            vo.setContractType(((SaleNoContractEntity)contract).getContractType());
            vo.setContractTypeName(this.baseDataUtil.getDictName(((SaleNoContractEntity)contract).getContractType(), "contractType"));
            vo.setContractStatus(((SaleNoContractEntity)contract).getStatus());
            vo.setContractStatusName(this.baseDataUtil.getDictName(((SaleNoContractEntity)contract).getStatus(), "noContractStatus"));
            contractAttachmentList = this.rkAttachmentService.getListByContractId(vo.getNoContractId());
            vo.setContractAttachmentList(contractAttachmentList);
        }
        vo.setConfirmDate(vo.getAcceptanceTime());
        return vo;
    }

    @Override
    public void insertInfo(SaleConfirmIncomeCrForm saleConfirmIncomeCrForm) {
        String mainId = RandomUtil.uuId();
        SaleConfirmIncomeEntity entity = (SaleConfirmIncomeEntity)JsonUtil.getJsonToBean((Object)saleConfirmIncomeCrForm, SaleConfirmIncomeEntity.class);
        entity.setId(mainId);
        UserInfo userInfo = this.userProvider.get();
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setCreatorDeptId(userInfo.getDepartmentId());
        RkContractProjectEntity project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
        entity.setProjectName(project.getProjectName());
        entity.setCustomerId(project.getCustomerId());
        entity.setSalerId(project.getSalerId());
        this.save(entity);
        project.setAllConfirmIncome(ConvertUtil.toBigDecimal((Object)project.getAllConfirmIncome(), (BigDecimal)BigDecimal.ZERO).add(ConvertUtil.toBigDecimal((Object)entity.getConfirmAmount(), (BigDecimal)BigDecimal.ZERO)));
        if (project.getAllConfirmIncome().compareTo(ConvertUtil.toBigDecimal((Object)project.getSureIncome(), (BigDecimal)BigDecimal.ZERO)) == 0) {
            project.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.CONFIRMED.getStatus());
        } else if (project.getAllConfirmIncome().compareTo(BigDecimal.ZERO) == 0) {
            project.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.TO_BE_CONFIRMED.getStatus());
        } else {
            project.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.CONFIRMING.getStatus());
        }
        project.setConfirmIncomeDate(DateUtil.getNowDate());
        this.rkContractProjectService.updateById(project);
    }

    @Override
    public void editInfo(SaleConfirmIncomeUpForm saleConfirmIncomeUpForm) {
        SaleConfirmIncomeEntity entity = (SaleConfirmIncomeEntity)JsonUtil.getJsonToBean((Object)saleConfirmIncomeUpForm, SaleConfirmIncomeEntity.class);
        RkContractProjectEntity project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
        entity.setProjectName(project.getProjectName());
        entity.setCustomerId(project.getCustomerId());
        entity.setSalerId(project.getSalerId());
        this.save(entity);
        project.setAllConfirmIncome(ConvertUtil.toBigDecimal((Object)project.getAllConfirmIncome(), (BigDecimal)BigDecimal.ZERO).add(ConvertUtil.toBigDecimal((Object)entity.getConfirmAmount(), (BigDecimal)BigDecimal.ZERO)));
        if (project.getAllConfirmIncome().compareTo(ConvertUtil.toBigDecimal((Object)project.getSureIncome(), (BigDecimal)BigDecimal.ZERO)) == 0) {
            project.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.CONFIRMED.getStatus());
        } else if (project.getAllConfirmIncome().compareTo(BigDecimal.ZERO) == 0) {
            project.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.TO_BE_CONFIRMED.getStatus());
        } else {
            project.setConfirmIncomeStatus(ProjectConfirmIncomeStatus.CONFIRMING.getStatus());
        }
        project.setConfirmIncomeDate(DateUtil.getNowDate());
        this.rkContractProjectService.updateById(project);
    }

    @Override
    public void removeInfo(String id) {
        SaleConfirmIncomeEntity entity = (SaleConfirmIncomeEntity)this.getById((Serializable)((Object)id));
        if (null != entity) {
            entity.setEnabledMark(0);
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.updateById(entity);
        }
    }

    @Override
    public SaleConfirmIncomeInfoVO detailInfo(String id) {
        SaleConfirmIncomeEntity entity = this.getInfo(id);
        SaleConfirmIncomeInfoVO saleConfirmIncomeInfoVO = this.appendVo(entity);
        return saleConfirmIncomeInfoVO;
    }

    @Override
    public SaleConfirmIncomeInfoVO queryInfo(String id) {
        SaleConfirmIncomeEntity entity = this.getInfo(id);
        SaleConfirmIncomeInfoVO saleConfirmIncomeInfoVO = this.appendVo(entity);
        return saleConfirmIncomeInfoVO;
    }

    private SaleConfirmIncomeInfoVO appendVo(SaleConfirmIncomeEntity entity) {
        List<RkAttachmentEntity> contractAttachmentList;
        Object contract;
        CrmCustomerEntity customer;
        SaleConfirmIncomeInfoVO vo = (SaleConfirmIncomeInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleConfirmIncomeInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && null != (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId())))) {
            vo.setCustomerName(customer.getName());
        }
        vo.setToBeConfirmedIncome(MathUtils.substract(vo.getSureIncome(), vo.getAllConfirmIncome()));
        if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
            contract = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
            if (null != contract) {
                vo.setContractCode(((RkContractEntity)contract).getContractCode());
                vo.setContractName(((RkContractEntity)contract).getContractName());
                vo.setContractType(((RkContractEntity)contract).getContractType());
                vo.setContractTypeName(this.baseDataUtil.getDictName(((RkContractEntity)contract).getContractType(), "contractType"));
                vo.setContractStatus(((RkContractEntity)contract).getEnableMark());
                vo.setContractStatusName(this.baseDataUtil.getDictName(((RkContractEntity)contract).getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
                contractAttachmentList = this.rkAttachmentService.getListByContractId(vo.getContractId());
                vo.setContractAttachmentList(contractAttachmentList);
            }
        } else if (!StrUtil.isBlank((CharSequence)vo.getNoContractId()) && null != (contract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId())))) {
            vo.setContractCode(((SaleNoContractEntity)contract).getContractCode());
            vo.setContractName(((SaleNoContractEntity)contract).getContractName());
            vo.setContractType(((SaleNoContractEntity)contract).getContractType());
            vo.setContractTypeName(this.baseDataUtil.getDictName(((SaleNoContractEntity)contract).getContractType(), "contractType"));
            vo.setContractStatus(((SaleNoContractEntity)contract).getStatus());
            vo.setContractStatusName(this.baseDataUtil.getDictName(((SaleNoContractEntity)contract).getStatus(), "noContractStatus"));
            contractAttachmentList = this.rkAttachmentService.getListByContractId(vo.getNoContractId());
            vo.setContractAttachmentList(contractAttachmentList);
        }
        RkContractProjectEntity project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
        if (null != project) {
            UserEntity user;
            vo.setProjectName(project.getProjectName());
            Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
            vo.setProjectCode(project.getProjectCode());
            vo.setProjectStatus(project.getState());
            vo.setProjectStatusName(StringUtils.isEmpty((String)project.getState()) ? "" : allToMap.get(project.getState()).getDesc());
            vo.setAcceptanceTime(DateUtil.getTime((Date)project.getAcceptanceTime()) * 1000L);
            vo.setAcceptedUser(project.getAcceptedBy());
            if (StringUtils.isNotEmpty((String)project.getAcceptedBy()) && null != (user = (UserEntity)this.userService.getById((Serializable)((Object)project.getAcceptedBy())))) {
                vo.setAcceptedUserName(user.getRealName());
                vo.setAcceptedDept(user.getOrganizeId());
                OrganizeEntity organize = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)user.getOrganizeId()));
                if (null != organize) {
                    vo.setAcceptedDeptName(organize.getFullName());
                }
            }
            vo.setAcceptIsArchived(null == project.getAcceptIsArchived() ? 0 : project.getAcceptIsArchived());
            vo.setTaxRate(project.getTaxRate());
            vo.setTaxRateName(this.baseDataUtil.getDictName(vo.getTaxRate(), "projectTaxRate"));
            RkProjectAcceptEntity accept = this.rkProjectAcceptService.getByProjectId(project.getId());
            if (null != accept) {
                List<RkAttachmentEntity> acceptAttachmentList = this.rkAttachmentService.getListByObjId(accept.getId());
                vo.setAcceptAttachmentList(acceptAttachmentList);
            }
        }
        return vo;
    }

    @Override
    public List<RkContractProjectEntity> getProjectList(SaleConfirmIncomePagination pagination) {
        QueryWrapper<RkContractProjectEntity> queryWrapper = this.appendProjectWrapper(pagination);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userIPage = this.rkContractProjectService.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public SaleConfirmIncomeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleConfirmIncomeEntity::getId, (Object)id);
        return (SaleConfirmIncomeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(SaleConfirmIncomeEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    private QueryWrapper<RkContractProjectEntity> appendProjectWrapper(SaleConfirmIncomePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        boolean permission = true;
        if (ObjectUtil.equals((Object)pagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)object)) {
                queryWrapper.lambda().eq(RkContractProjectEntity::getCreatorUserId, (Object)userId);
            } else {
                queryWrapper = (QueryWrapper)object;
            }
        }
        queryWrapper.lambda().eq(RkContractProjectEntity::getIsAcceptance, (Object)1);
        if (StringUtils.isNotEmpty((String)pagination.getProjectName())) {
            queryWrapper.lambda().like(RkContractProjectEntity::getProjectName, (Object)pagination.getProjectName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCustomerId())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)pagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSaleId())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getSalerId, (Object)pagination.getSaleId());
        }
        if (StringUtils.isNotEmpty(pagination.getAcceptanceTimeList())) {
            List<String> acceptanceTimeList = pagination.getAcceptanceTimeList();
            Long fir = Long.valueOf(acceptanceTimeList.get(0));
            Long sec = Long.valueOf(acceptanceTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(RkContractProjectEntity::getAcceptanceTime, (Object)new Date(fir))).le(RkContractProjectEntity::getAcceptanceTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getConfirmIncomeStatus()) && !"all".equals(pagination.getConfirmIncomeStatus())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getConfirmIncomeStatus, (Object)pagination.getConfirmIncomeStatus());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (pagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)pagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(RkContractProjectEntity::getId);
            } else {
                try {
                    String sidx = pagination.getSidx();
                    SaleConfirmIncomeEntity saleConfirmIncomeEntity = new SaleConfirmIncomeEntity();
                    Field declaredField = saleConfirmIncomeEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public Map<String, Integer> countProjectByStatus(SaleConfirmIncomePagination pagination) {
        pagination.setIsSort(false);
        QueryWrapper<RkContractProjectEntity> queryWrapper = this.appendProjectWrapper(pagination);
        queryWrapper.select(new String[]{"count(1) as count, confirm_income_status"});
        queryWrapper.groupBy((Object)"confirm_income_status");
        List maps = this.rkContractProjectService.listMaps((Wrapper)queryWrapper);
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        int allCount = 0;
        for (Map map : maps) {
            allCount += Integer.parseInt(map.get("count").toString());
            returnMap.put(ConvertUtil.toStr(map.get("confirm_income_status"), (String)""), Integer.parseInt(map.get("count").toString()));
        }
        returnMap.put("all", allCount);
        return returnMap;
    }

    @Override
    public void createContractIncome(List<String> contractIds) throws DataException {
        if (CollectionUtil.isEmpty(contractIds)) {
            throw new DataException("\u8bf7\u9009\u62e9\u8981\u521b\u5efa\u786e\u8ba4\u6536\u5165\u7684\u5408\u540c");
        }
        UserInfo userInfo = this.userProvider.get();
        List contractList = this.rkContractService.listByIds(contractIds);
        ArrayList<SaleConfirmIncomeEntity> needSaveList = new ArrayList<SaleConfirmIncomeEntity>();
        for (RkContractEntity rkContractEntity : contractList) {
            String mainId = RandomUtil.uuId();
            SaleConfirmIncomeEntity entity = new SaleConfirmIncomeEntity();
            entity.setId(mainId);
            String incomeNumber = this.baseDataUtil.getBillNumber("confirmIncomeNumber", Boolean.valueOf(false));
            entity.setIncomeNumber(incomeNumber);
            entity.setContractId(rkContractEntity.getId());
            entity.setCustomerId(rkContractEntity.getCustomerId());
            entity.setSalerId(rkContractEntity.getSalerId());
            BigDecimal allConfirmIncomeAmount = rkContractEntity.getAllConfirmIncome() == null ? BigDecimal.ZERO : rkContractEntity.getAllConfirmIncome();
            entity.setProjectAmount(rkContractEntity.getContractAmount());
            entity.setSureIncome(rkContractEntity.getContractAmount().subtract(allConfirmIncomeAmount));
            entity.setAllConfirmIncome(allConfirmIncomeAmount);
            entity.setCompanyId(userInfo.getOrganizeId());
            entity.setCreatorDeptId(userInfo.getDepartmentId());
            entity.setConfirmIncomeStatus("businessConfirming");
            needSaveList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(needSaveList)) {
            this.saveBatch(needSaveList);
        }
    }

    @Override
    public void contractIncomeUpdate(SaleConfirmIncomeUpForm saleConfirmIncomeUpForm) {
        SaleConfirmIncomeEntity entity = (SaleConfirmIncomeEntity)JsonUtil.getJsonToBean((Object)saleConfirmIncomeUpForm, SaleConfirmIncomeEntity.class);
        entity.setConfirmIncomeStatus("toBePushVoucher");
        this.updateById(entity);
        String contractId = entity.getContractId();
        RkContractEntity byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)contractId));
        RkContractEntity updateEntity = new RkContractEntity();
        updateEntity.setId(contractId);
        updateEntity.setAllConfirmIncome(ConvertUtil.toBigDecimal((Object)byId.getAllConfirmIncome(), (BigDecimal)BigDecimal.ZERO).add(ConvertUtil.toBigDecimal((Object)entity.getConfirmAmount(), (BigDecimal)BigDecimal.ZERO)));
        this.rkContractService.updateById(updateEntity);
    }

    @Override
    public SaleConfirmIncomeInfoVO contractIncomeInfo(String id) {
        RkContractEntity contract;
        SaleConfirmIncomeEntity entity = this.getInfo(id);
        String contractId = entity.getContractId();
        if (StringUtils.isNotEmpty((String)contractId) && null != (contract = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)contractId)))) {
            SaleConfirmIncomeInfoVO vo = (SaleConfirmIncomeInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleConfirmIncomeInfoVO.class);
            vo.setContractCode(contract.getContractCode());
            vo.setContractName(contract.getContractName());
            vo.setContractType(contract.getContractType());
            vo.setContractTypeName(this.baseDataUtil.getDictName(contract.getContractType(), "contractType"));
            vo.setContractStatus(contract.getEnableMark());
            vo.setContractStatusName(this.baseDataUtil.getDictName(contract.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            List<RkAttachmentEntity> contractAttachmentList = this.rkAttachmentService.getListByContractId(vo.getContractId());
            vo.setContractAttachmentList(contractAttachmentList);
            return vo;
        }
        return null;
    }

    @Override
    public Map<String, Integer> countVoucherByStatus(SaleConfirmIncomePagination pagination) {
        pagination.setIsSort(false);
        QueryWrapper<SaleConfirmIncomeEntity> queryWrapper = this.appendWrapper(pagination);
        queryWrapper.select(new String[]{"count(1) as count, confirm_income_status"});
        queryWrapper.groupBy((Object)"confirm_income_status");
        queryWrapper.lambda().isNotNull(SaleConfirmIncomeEntity::getConfirmIncomeStatus);
        List maps = this.listMaps((Wrapper)queryWrapper);
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        int allCount = 0;
        for (Map map : maps) {
            allCount += Integer.parseInt(map.get("count").toString());
            returnMap.put(ConvertUtil.toStr(map.get("confirm_income_status"), (String)""), Integer.parseInt(map.get("count").toString()));
        }
        returnMap.put("all", allCount);
        return returnMap;
    }

    @Override
    public List<RkContractEntity> getContractList(SaleConfirmIncomePagination pagination) {
        QueryWrapper<RkContractEntity> queryWrapper = this.appendContractWrapper(pagination);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userIPage = this.rkContractService.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<RkContractEntity> appendContractWrapper(SaleConfirmIncomePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        boolean permission = true;
        if (ObjectUtil.equals((Object)pagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object object = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "rk_contract"));
            if (ObjectUtil.isEmpty((Object)object)) {
                queryWrapper.lambda().eq(RkContractEntity::getCreatorUserId, (Object)userId);
            } else {
                queryWrapper = (QueryWrapper)object;
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getContractCode())) {
            queryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)pagination.getContractCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getContractName())) {
            queryWrapper.lambda().like(RkContractEntity::getContractName, (Object)pagination.getContractName());
        }
        queryWrapper.lambda().eq(RkContractEntity::getContractType, (Object)"620585813704463173");
        return queryWrapper;
    }

    @Override
    public void contractBatchConfirm(SaleConfirmIncomeListQuery query) throws DataException {
        try {
            List<String> ids = query.getIds();
            List saleConfirmIncomeEntities = this.listByIds(ids);
            for (SaleConfirmIncomeEntity saleConfirmIncomeEntity : saleConfirmIncomeEntities) {
                saleConfirmIncomeEntity.setConfirmIncomeStatus(query.getStatus());
            }
            this.updateBatchById(saleConfirmIncomeEntities);
        }
        catch (Exception e) {
            throw new DataException("\u6279\u91cf\u786e\u8ba4\u6536\u5165\u5931\u8d25");
        }
    }

    @Override
    public void batchPushVoucher(SaleConfirmIncomeListQuery query) throws VoucherPushException {
        HashMap<String, String> rateMapCache = new HashMap<String, String>();
        ArrayList<ConfirmIncomeRequest> requests = new ArrayList<ConfirmIncomeRequest>();
        List<String> ids = query.getIds();
        List saleConfirmIncomeEntities = this.listByIds(ids);
        List contractIds = saleConfirmIncomeEntities.stream().map(SaleConfirmIncomeEntity::getContractId).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List rkContractEntities = this.rkContractService.listByIds(contractIds);
        Map<String, RkContractEntity> contractEntityMap = rkContractEntities.stream().collect(Collectors.toMap(RkContractEntity::getId, v -> v));
        for (SaleConfirmIncomeEntity saleConfirmIncomeEntity : saleConfirmIncomeEntities) {
            BigDecimal confirmAmount = saleConfirmIncomeEntity.getConfirmAmount();
            String contractId = saleConfirmIncomeEntity.getContractId();
            RkContractEntity rkContractEntity = contractEntityMap.get(contractId);
            ConfirmIncomeRequest request = new ConfirmIncomeRequest();
            request.setId(rkContractEntity.getId());
            request.setIncomeCode(saleConfirmIncomeEntity.getIncomeNumber());
            request.setContractNumber(rkContractEntity.getContractCode());
            request.setCompanyId(rkContractEntity.getCompanyId());
            String taxRateName = "";
            if (rateMapCache.get(rkContractEntity.getContractTaxRate()) == null) {
                taxRateName = this.baseDataUtil.getDictName(rkContractEntity.getContractTaxRate(), "contractRate");
                rateMapCache.put(rkContractEntity.getContractTaxRate(), taxRateName);
            } else {
                taxRateName = (String)rateMapCache.get(rkContractEntity.getContractTaxRate());
            }
            String customerCode = "";
            String customerName = "";
            if (rkContractEntity.getIsAgent() == 1) {
                String agentId = rkContractEntity.getAgentId();
                RkAgentEntity rkAgent = (RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)agentId));
                customerCode = rkAgent.getNcCode();
                customerName = rkAgent.getName();
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmCustomerCompanyRelationEntity::getCustomerId, (Object)rkContractEntity.getCustomerId())).eq(CrmCustomerCompanyRelationEntity::getCompanyId, (Object)rkContractEntity.getCompanyId());
                CrmCustomerCompanyRelationEntity one = (CrmCustomerCompanyRelationEntity)this.crmCustomerCompanyRelationService.getOne((Wrapper)queryWrapper);
                CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractEntity.getCustomerId()));
                customerCode = one.getNcCode();
                customerName = byId.getName();
            }
            request.setCustomerName(customerName);
            request.setCustomerCode(customerCode);
            request.setContractName(rkContractEntity.getContractName());
            request.setContractCode(rkContractEntity.getNcCode());
            request.setDeptId(rkContractEntity.getDepartment());
            request.setTaxRate(taxRateName);
            request.setNoTaxAmount(confirmAmount);
            BigDecimal tax = confirmAmount.multiply(this.calculateTaxRate(taxRateName));
            request.setConfirmAmount(tax.add(confirmAmount));
            requests.add(request);
            saleConfirmIncomeEntity.setConfirmIncomeStatus("end");
            saleConfirmIncomeEntity.setVoucherPushTime(new Date());
        }
        if (!CollectionUtil.isEmpty(requests)) {
            for (ConfirmIncomeRequest request : requests) {
                this.voucherPushService.pushRevenueVoucher(request);
            }
            this.updateBatchById(saleConfirmIncomeEntities);
        }
    }

    private BigDecimal calculateTaxRate(String percentStr) {
        if (percentStr == null || !percentStr.endsWith("%")) {
            return BigDecimal.ZERO;
        }
        String numberStr = percentStr.replaceAll("%", "").replaceAll(" ", "").trim();
        BigDecimal number = new BigDecimal(numberStr);
        return number.divide(BigDecimal.valueOf(100L));
    }
}

