/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.SaleContractCustomerEntity;
import com.bringspring.contract.mapper.SaleContractCustomerMapper;
import com.bringspring.contract.model.salecontractcustomer.SaleContractCustomerCrForm;
import com.bringspring.contract.model.salecontractcustomer.SaleContractCustomerPagination;
import com.bringspring.contract.model.salecontractcustomer.SaleContractCustomerUpForm;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleContractCustomerServiceImpl
extends ServiceImpl<SaleContractCustomerMapper, SaleContractCustomerEntity>
implements SaleContractCustomerService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<SaleContractCustomerEntity> getList(SaleContractCustomerPagination saleContractCustomerPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean saleContractCustomerNum = false;
        QueryWrapper saleContractCustomerQueryWrapper = new QueryWrapper();
        if (AllIdList.size() > 0) {
            saleContractCustomerQueryWrapper.lambda().in(SaleContractCustomerEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)saleContractCustomerPagination.getSidx())) {
            saleContractCustomerQueryWrapper.lambda().orderByDesc(SaleContractCustomerEntity::getId);
        } else {
            try {
                String sidx = saleContractCustomerPagination.getSidx();
                SaleContractCustomerEntity saleContractCustomerEntity = new SaleContractCustomerEntity();
                Field declaredField = saleContractCustomerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                saleContractCustomerQueryWrapper = "asc".equals(saleContractCustomerPagination.getSort().toLowerCase()) ? (QueryWrapper)saleContractCustomerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)saleContractCustomerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(saleContractCustomerPagination.getCurrentPage(), saleContractCustomerPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleContractCustomerQueryWrapper);
            return saleContractCustomerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return saleContractCustomerPagination.setData(list, list.size());
    }

    @Override
    public List<SaleContractCustomerEntity> getTypeList(SaleContractCustomerPagination saleContractCustomerPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean saleContractCustomerNum = false;
        QueryWrapper saleContractCustomerQueryWrapper = new QueryWrapper();
        if (AllIdList.size() > 0) {
            saleContractCustomerQueryWrapper.lambda().in(SaleContractCustomerEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)saleContractCustomerPagination.getSidx())) {
            saleContractCustomerQueryWrapper.lambda().orderByDesc(SaleContractCustomerEntity::getId);
        } else {
            try {
                String sidx = saleContractCustomerPagination.getSidx();
                SaleContractCustomerEntity saleContractCustomerEntity = new SaleContractCustomerEntity();
                Field declaredField = saleContractCustomerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                saleContractCustomerQueryWrapper = "asc".equals(saleContractCustomerPagination.getSort().toLowerCase()) ? (QueryWrapper)saleContractCustomerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)saleContractCustomerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(saleContractCustomerPagination.getCurrentPage(), saleContractCustomerPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)saleContractCustomerQueryWrapper);
                return saleContractCustomerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return saleContractCustomerPagination.setData(list, list.size());
        }
        return this.list((Wrapper)saleContractCustomerQueryWrapper);
    }

    @Override
    public SaleContractCustomerEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleContractCustomerEntity::getId, (Object)id);
        return (SaleContractCustomerEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(SaleContractCustomerCrForm saleContractCustomerCrForm) {
        String mainId = RandomUtil.uuId();
        SaleContractCustomerEntity entity = (SaleContractCustomerEntity)JsonUtil.getJsonToBean((Object)saleContractCustomerCrForm, SaleContractCustomerEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, SaleContractCustomerUpForm saleContractCustomerUpForm) {
        UserInfo userInfo = this.userProvider.get();
        SaleContractCustomerEntity entity = this.getInfo(id);
        if (entity != null) {
            SaleContractCustomerEntity subentity = (SaleContractCustomerEntity)JsonUtil.getJsonToBean((Object)saleContractCustomerUpForm, SaleContractCustomerEntity.class);
            subentity.setContractId(DateUtil.getNow());
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(SaleContractCustomerEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<SaleContractCustomerEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleContractCustomerEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public String getCustomerNamesByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleContractCustomerEntity::getContractId, (Object)contractId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.stream().map(SaleContractCustomerEntity::getCustomerName).collect(Collectors.joining(","));
        }
        return "";
    }

    @Override
    public void removeByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleContractCustomerEntity::getContractId, (Object)contractId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleContractCustomerEntity> insertListByCustomerIds(String contractId, String customerIds) {
        if (StringUtils.isNotEmpty((String)contractId) && StringUtils.isNotEmpty((String)customerIds)) {
            ArrayList<SaleContractCustomerEntity> entityList = new ArrayList<SaleContractCustomerEntity>();
            List<String> customerList = Arrays.asList(customerIds.split(","));
            SaleContractCustomerEntity entity = null;
            CrmCustomerEntity customer = null;
            List addressList = null;
            for (String customerId : customerList) {
                entity = new SaleContractCustomerEntity();
                entity.setId(RandomUtil.uuId());
                entity.setContractId(contractId);
                entity.setCustomerId(customerId);
                customer = this.crmCustomerService.getInfo(customerId);
                if (null != customer) {
                    entity.setCustomerName(customer.getName());
                    entity.setAddress(customer.getAddress());
                    entity.setAddressName(this.baseDataUtil.provinceData(entity.getAddress()));
                    if (StringUtils.isNotEmpty((String)customer.getAddress())) {
                        addressList = JSON.parseArray((String)customer.getAddress(), String.class);
                        if (!addressList.isEmpty()) {
                            entity.setRegion((String)addressList.get(0));
                            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
                        }
                        if (addressList.size() > 1) {
                            entity.setProv((String)addressList.get(1));
                            entity.setProvName(this.baseDataUtil.provinceData(entity.getProv()));
                        }
                        if (addressList.size() > 2) {
                            entity.setCity((String)addressList.get(2));
                            entity.setCityName(this.baseDataUtil.provinceData(entity.getCity()));
                        }
                    }
                }
                entityList.add(entity);
            }
            this.saveBatch(entityList);
        }
        return Collections.emptyList();
    }
}

