/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.SaleFrameworkAgreementEntity;
import com.bringspring.contract.mapper.SaleFrameworkAgreementMapper;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementCrForm;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementPagination;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementUpForm;
import com.bringspring.contract.service.SaleFrameworkAgreementService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleFrameworkAgreementServiceImpl
extends ServiceImpl<SaleFrameworkAgreementMapper, SaleFrameworkAgreementEntity>
implements SaleFrameworkAgreementService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<SaleFrameworkAgreementEntity> getList(SaleFrameworkAgreementPagination saleFrameworkAgreementPagination) {
        QueryWrapper<SaleFrameworkAgreementEntity> queryWrapper = this.appendWrapper(saleFrameworkAgreementPagination, true);
        Page page = new Page(saleFrameworkAgreementPagination.getCurrentPage(), saleFrameworkAgreementPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return saleFrameworkAgreementPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleFrameworkAgreementEntity> appendWrapper(SaleFrameworkAgreementPagination pagination, Boolean isSort) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        boolean permission = true;
        if (ObjectUtil.equals((Object)pagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object afterSalesQuestionObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "sale_framework_agreement"));
            if (ObjectUtil.isEmpty((Object)afterSalesQuestionObj)) {
                queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getCreatorUserId, (Object)userId);
            } else {
                queryWrapper = (QueryWrapper)afterSalesQuestionObj;
            }
        }
        queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getEnabledMark, (Object)1);
        if (StringUtils.isNotEmpty((String)pagination.getContractName())) {
            queryWrapper.lambda().like(SaleFrameworkAgreementEntity::getContractName, (Object)pagination.getContractName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getContractCode())) {
            queryWrapper.lambda().like(SaleFrameworkAgreementEntity::getContractCode, (Object)pagination.getContractCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(pagination.getCreatorTime())) {
            List<String> creatorTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(creatorTimeList.get(0));
            Long sec = Long.valueOf(creatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleFrameworkAgreementEntity::getCreatorTime, (Object)new Date(fir))).le(SaleFrameworkAgreementEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getStatus())) {
            queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getStatus, (Object)pagination.getStatus());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCreatorUserId())) {
            queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getCreatorUserId, (Object)pagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSalesId())) {
            queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getSalesId, (Object)pagination.getSalesId());
        }
        if (isSort.booleanValue()) {
            if (StringUtils.isEmpty((String)pagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(SaleFrameworkAgreementEntity::getId);
            } else {
                try {
                    String sidx = pagination.getSidx();
                    SaleFrameworkAgreementEntity SaleFrameworkAgreementEntity2 = new SaleFrameworkAgreementEntity();
                    Field declaredField = SaleFrameworkAgreementEntity2.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public List<SaleFrameworkAgreementEntity> getTypeList(SaleFrameworkAgreementPagination saleFrameworkAgreementPagination, String dataType) {
        QueryWrapper<SaleFrameworkAgreementEntity> saleNoContractQueryWrapper = this.appendWrapper(saleFrameworkAgreementPagination, true);
        if ("0".equals(dataType)) {
            Page page = new Page(saleFrameworkAgreementPagination.getCurrentPage(), saleFrameworkAgreementPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleNoContractQueryWrapper);
            return saleFrameworkAgreementPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleNoContractQueryWrapper);
    }

    @Override
    public SaleFrameworkAgreementEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleFrameworkAgreementEntity::getId, (Object)id);
        return (SaleFrameworkAgreementEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SaleFrameworkAgreementCrForm saleFrameworkAgreementCrForm) {
        String mainId = RandomUtil.uuId();
        SaleFrameworkAgreementEntity entity = (SaleFrameworkAgreementEntity)JsonUtil.getJsonToBean((Object)saleFrameworkAgreementCrForm, SaleFrameworkAgreementEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void update(String id, SaleFrameworkAgreementUpForm saleFrameworkAgreementUpForm) {
        UserInfo userInfo = this.userProvider.get();
        SaleFrameworkAgreementEntity entity = (SaleFrameworkAgreementEntity)this.getById((Serializable)((Object)id));
        if (entity != null) {
            SaleFrameworkAgreementEntity subentity = (SaleFrameworkAgreementEntity)JsonUtil.getJsonToBean((Object)saleFrameworkAgreementUpForm, SaleFrameworkAgreementEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void delete(String id) {
        SaleFrameworkAgreementEntity entity = (SaleFrameworkAgreementEntity)this.getById((Serializable)((Object)id));
        if (entity != null) {
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setEnabledMark(0);
            this.updateById(entity);
        }
    }

    @Override
    public Map<String, Integer> countByStatus(SaleFrameworkAgreementPagination pagination) {
        QueryWrapper<SaleFrameworkAgreementEntity> queryWrapper = this.appendWrapper(pagination, false);
        queryWrapper.select(new String[]{"count(1) as count, status"});
        queryWrapper.groupBy((Object)"status");
        List maps = this.listMaps((Wrapper)queryWrapper);
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        int allCount = 0;
        for (Map map : maps) {
            allCount += Integer.parseInt(map.get("count").toString());
            returnMap.put(map.get("status").toString(), Integer.parseInt(map.get("count").toString()));
        }
        returnMap.put("all", allCount);
        return returnMap;
    }
}

