/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.RkProjectStartEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.RkContractVerifyMapper;
import com.bringspring.contract.mapper.SaleNoContractMapper;
import com.bringspring.contract.model.salenocontract.SaleNoContractCrForm;
import com.bringspring.contract.model.salenocontract.SaleNoContractInfoVO;
import com.bringspring.contract.model.salenocontract.SaleNoContractPagination;
import com.bringspring.contract.model.salenocontract.SaleNoContractUpForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.RkProjectStartService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.SaleNoContractStatusEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.entity.OaPurchasePlanEntity;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitDetailEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.model.salequotation.SaleQuotationListVO;
import com.bringspring.quotation.model.salequotationprofit.SaleQuotationProfitListVO;
import com.bringspring.quotation.service.SaleQuotationProfitDetailService;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.RkReportingProductPriceEntity;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingListVO;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceListVO;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.RkReportingProductPriceItemService;
import com.bringspring.visit.service.RkReportingProductPriceService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleNoContractServiceImpl
extends ServiceImpl<SaleNoContractMapper, SaleNoContractEntity>
implements SaleNoContractService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractVerifyMapper rkContractVerifyMapper;
    @Autowired
    private RkProjectStartService rkProjectStartService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private RkReportingProductPriceService rkReportingProductPriceService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private SaleQuotationProfitDetailService salequotationprofitdetailService;
    @Autowired
    private RkReportingProductPriceItemService rkReportingProductPriceItemService;

    @Override
    public List<SaleNoContractEntity> getList(SaleNoContractPagination saleNoContractPagination) {
        QueryWrapper<SaleNoContractEntity> saleNoContractQueryWrapper = this.appendWrapper(saleNoContractPagination, false);
        Page page = new Page(saleNoContractPagination.getCurrentPage(), saleNoContractPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)saleNoContractQueryWrapper);
        return saleNoContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleNoContractEntity> appendWrapper(SaleNoContractPagination saleNoContractPagination, boolean onlyWhere) {
        QueryWrapper saleNoContractQueryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        boolean permission = true;
        if (ObjectUtil.equals((Object)saleNoContractPagination.getIsAuth(), (Object)0)) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object afterSalesQuestionObj = this.authorizeService.getCondition(new AuthorizeConditionModel(saleNoContractQueryWrapper, saleNoContractPagination.getMenuId(), "sale_no_contract"));
            if (ObjectUtil.isEmpty((Object)afterSalesQuestionObj)) {
                saleNoContractQueryWrapper.and(this.defaultWrapper());
            } else {
                saleNoContractQueryWrapper = (QueryWrapper)afterSalesQuestionObj;
            }
        }
        saleNoContractQueryWrapper.lambda().eq(SaleNoContractEntity::getDeleteFlag, (Object)"0");
        if (StringUtils.isNotEmpty((String)saleNoContractPagination.getContractName())) {
            saleNoContractQueryWrapper.lambda().like(SaleNoContractEntity::getContractName, (Object)saleNoContractPagination.getContractName());
        }
        if (StringUtils.isNotEmpty((String)saleNoContractPagination.getContractCode())) {
            saleNoContractQueryWrapper.lambda().like(SaleNoContractEntity::getContractCode, (Object)saleNoContractPagination.getContractCode());
        }
        if (StringUtils.isNotEmpty((String)saleNoContractPagination.getCompanyId())) {
            saleNoContractQueryWrapper.lambda().eq(SaleNoContractEntity::getCompanyId, (Object)saleNoContractPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleNoContractPagination.getCreatorTime())) {
            List<String> creatorTimeList = saleNoContractPagination.getCreatorTime();
            Long fir = Long.valueOf(creatorTimeList.get(0));
            Long sec = Long.valueOf(creatorTimeList.get(1));
            ((LambdaQueryWrapper)saleNoContractQueryWrapper.lambda().ge(SaleNoContractEntity::getCreatorTime, (Object)new Date(fir))).le(SaleNoContractEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)saleNoContractPagination.getStatus()) && !"all".equals(saleNoContractPagination.getStatus())) {
            saleNoContractQueryWrapper.lambda().eq(SaleNoContractEntity::getStatus, (Object)saleNoContractPagination.getStatus());
        }
        if (StringUtils.isNotEmpty((String)saleNoContractPagination.getCreatorUserId())) {
            saleNoContractQueryWrapper.lambda().eq(SaleNoContractEntity::getCreatorUserId, (Object)saleNoContractPagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty((String)saleNoContractPagination.getSalerId())) {
            saleNoContractQueryWrapper.lambda().eq(SaleNoContractEntity::getSalerId, (Object)saleNoContractPagination.getSalerId());
        }
        if (CollectionUtil.isNotEmpty(saleNoContractPagination.getSalerCompanyIdList())) {
            saleNoContractQueryWrapper.lambda().in(SaleNoContractEntity::getSalerCompanyId, saleNoContractPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(saleNoContractPagination.getCompanyIdList())) {
            saleNoContractQueryWrapper.lambda().in(SaleNoContractEntity::getCompanyId, saleNoContractPagination.getCompanyIdList());
        }
        if (!onlyWhere) {
            if (StringUtils.isEmpty((String)saleNoContractPagination.getSidx())) {
                saleNoContractQueryWrapper.lambda().orderByDesc(SaleNoContractEntity::getId);
            } else {
                try {
                    String sidx = saleNoContractPagination.getSidx();
                    SaleNoContractEntity saleNoContractEntity = new SaleNoContractEntity();
                    Field declaredField = saleNoContractEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    saleNoContractQueryWrapper = "asc".equals(saleNoContractPagination.getSort().toLowerCase()) ? (QueryWrapper)saleNoContractQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)saleNoContractQueryWrapper.orderByDesc((Object)value);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return saleNoContractQueryWrapper;
    }

    private Consumer<QueryWrapper<SaleNoContractEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<SaleNoContractEntity>>(){

            @Override
            public void accept(QueryWrapper<SaleNoContractEntity> saleQuotationTemplateQueryWrapper) {
                saleQuotationTemplateQueryWrapper.lambda().eq(SaleNoContractEntity::getCreatorUserId, (Object)userId);
            }
        };
    }

    @Override
    public List<SaleNoContractEntity> getTypeList(SaleNoContractPagination saleNoContractPagination, String dataType) {
        QueryWrapper<SaleNoContractEntity> saleNoContractQueryWrapper = this.appendWrapper(saleNoContractPagination, false);
        if ("0".equals(dataType)) {
            Page page = new Page(saleNoContractPagination.getCurrentPage(), saleNoContractPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleNoContractQueryWrapper);
            return saleNoContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleNoContractQueryWrapper);
    }

    @Override
    public SaleNoContractEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleNoContractEntity::getId, (Object)id);
        return (SaleNoContractEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SaleNoContractCrForm saleNoContractCrForm) {
        String mainId = RandomUtil.uuId();
        SaleNoContractEntity entity = (SaleNoContractEntity)JsonUtil.getJsonToBean((Object)saleNoContractCrForm, SaleNoContractEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void update(String id, SaleNoContractUpForm saleNoContractUpForm) {
        UserInfo userInfo = this.userProvider.get();
        SaleNoContractEntity entity = this.getInfo(id);
        if (entity != null) {
            SaleNoContractEntity subentity = (SaleNoContractEntity)JsonUtil.getJsonToBean((Object)saleNoContractUpForm, SaleNoContractEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void delete(SaleNoContractEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public Map<String, Integer> countByStatus(SaleNoContractPagination saleNoContractPagination) {
        QueryWrapper<SaleNoContractEntity> queryWrapper = this.appendWrapper(saleNoContractPagination, true);
        queryWrapper.select(new String[]{"count(1) as count, status"});
        queryWrapper.groupBy((Object)"status");
        List maps = this.listMaps((Wrapper)queryWrapper);
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        int allCount = 0;
        for (Map map : maps) {
            allCount += Integer.parseInt(map.get("count").toString());
            returnMap.put(map.get("status").toString(), Integer.parseInt(map.get("count").toString()));
        }
        returnMap.put("all", allCount);
        return returnMap;
    }

    @Override
    public SaleNoContractInfoVO getSimpleAndProjectCount(String noContractId) {
        SaleNoContractEntity entity = (SaleNoContractEntity)this.getById((Serializable)((Object)noContractId));
        SaleNoContractInfoVO vo = (SaleNoContractInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleNoContractInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getContractType())) {
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
        }
        vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.saleContractCustomerService.getListByContractId(vo.getId()));
        }
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId())) {
            RkAgentEntity agent = this.agentService.getInfo(vo.getAgentId());
            if (null != agent) {
                vo.setAgentName(agent.getName());
            }
        } else {
            vo.setAgentName(vo.getCustomerNames());
        }
        List<RkContractProjectEntity> list = this.rkContractProjectService.getListByNoContractId(noContractId);
        List<RkContractProjectEntity> projectEntityList = this.rkContractProjectService.getListByNoContractIdHaveDel(noContractId);
        BigDecimal reduce = list.stream().filter(project -> !ObjectUtil.isEmpty((Object)project.getProjectAmount())).map(RkContractProjectEntity::getProjectAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setProjectCount(list.size());
        vo.setProjectCountHaveDel(projectEntityList.size());
        vo.setProjectAmount(MathUtils.substract(vo.getExpectedContractAmount(), reduce));
        BigDecimal divide = MathUtils.divide(MathUtils.multiply(vo.getProjectAmount(), new BigDecimal(100)), vo.getExpectedContractAmount(), 2);
        vo.setProjectRatio(divide);
        return vo;
    }

    @Override
    public void writeOff(String id, String contractId) throws DataException {
        RkContractEntity contract = this.rkContractService.getInfo(contractId);
        if (null == contract) {
            throw new DataException("\u5408\u540c\u4e0d\u5b58\u5728");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractVerifyEntity::getNoContractId, (Object)id);
        queryWrapper.lambda().ne(RkContractVerifyEntity::getId, (Object)contractId);
        RkContractVerifyEntity contractVerify = (RkContractVerifyEntity)this.rkContractVerifyService.getOne((Wrapper)queryWrapper);
        if (null != contractVerify) {
            throw new DataException("\u5f53\u524d\u65e0\u5408\u540c\u5df2\u88ab\u3010" + contractVerify.getContractName() + "\u3011\u5173\u8054\uff0c\u8bf7\u5148\u89e3\u7ed1");
        }
        SaleNoContractEntity noContract = this.getInfo(id);
        if (null != noContract) {
            List<OaPurchasePlanEntity> purchasePlanList;
            List<RkProjectStartEntity> projectStartList;
            Integer num;
            noContract.setContractId(contract.getId());
            noContract.setStatus(SaleNoContractStatusEnum.VERIFIED_OFF_STATUS.getStatus());
            List<RkContractProjectEntity> list = this.rkContractProjectService.getListByNoContractIdHaveDel(noContract.getId());
            if (CollectionUtil.isNotEmpty(list)) {
                list.stream().forEach(item -> {
                    item.setContractId(contract.getId());
                    item.setSalerId(contract.getSalerId());
                    item.setSalerName(contract.getSalerName());
                    this.afterSalesMaintenanceService.updateStatusByContractId((RkContractProjectEntity)item);
                });
                this.rkContractProjectService.updateBatchById(list);
            }
            if ((num = this.rkContractVerifyMapper.updateProjectStartByNoContractId(noContract.getId(), contract.getId())) > 0 && CollectionUtil.isNotEmpty(projectStartList = this.rkProjectStartService.getListByContractId(noContract.getId()))) {
                projectStartList.stream().forEach(item -> item.setContractId(contract.getId()));
                this.rkProjectStartService.updateBatchById(projectStartList);
            }
            if (CollectionUtil.isNotEmpty(purchasePlanList = this.oaPurchasePlanService.getByNoContractId(id))) {
                purchasePlanList.stream().forEach(item -> item.setContractId(contract.getId()));
                this.oaPurchasePlanService.updateBatchById(purchasePlanList);
            }
        }
        contract.setNoContractId(noContract.getId());
        contract.setSpecialType(noContract.getSpecialType());
        this.rkContractService.updateById(contract);
        this.updateById(noContract);
    }

    @Override
    public void removeInfo(String id) {
        SaleNoContractEntity entity = this.getInfo(id);
        if (entity != null) {
            entity.setDeleteFlag("1");
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.updateById(entity);
        }
    }

    @Override
    public void insertInfo(SaleNoContractCrForm saleNoContractCrForm) {
        List<OaContractPurchasePlanEntity> purchasePlanList;
        List<RkAttachmentEntity> attachmentList;
        SaleNoContractEntity entity = (SaleNoContractEntity)JsonUtil.getJsonToBean((Object)saleNoContractCrForm, SaleNoContractEntity.class);
        entity.setCreatorCompanyId(this.userProvider.get().getOrganizeId());
        entity.setSalerCompanyId(this.getUserCompanyId(entity.getSalerId()));
        if (StringUtils.isNotEmpty((String)saleNoContractCrForm.getCustomerAddress())) {
            List addressList = JSON.parseArray((String)saleNoContractCrForm.getCustomerAddress(), String.class);
            if (!addressList.isEmpty()) {
                entity.setCustomerRegion((String)addressList.get(0));
                entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
            }
            if (addressList.size() > 1) {
                entity.setCustomerProv((String)addressList.get(1));
                entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
            }
            if (addressList.size() > 2) {
                entity.setCustomerCity((String)addressList.get(2));
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
            this.saleContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
        }
        entity.setDeleteFlag("0");
        if (saleNoContractCrForm.getStatus() == 0) {
            entity.setStatus(SaleNoContractStatusEnum.DRAFT_STATUS.getStatus());
        } else {
            entity.setStatus(SaleNoContractStatusEnum.UNRECOGNIZED_STATUS.getStatus());
        }
        this.save(entity);
        List<RkContractProductEntity> productList = saleNoContractCrForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            productList.stream().forEach(product -> {
                product.setId(RandomUtil.uuId());
                product.setContractId(entity.getId());
            });
            this.rkContractProductService.saveBatch(productList);
        }
        if (CollectionUtil.isNotEmpty(attachmentList = saleNoContractCrForm.getAttachmentList())) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(entity.getId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
        if (ObjectUtil.isNotEmpty(purchasePlanList = saleNoContractCrForm.getPurchasePlanList())) {
            for (OaContractPurchasePlanEntity p : purchasePlanList) {
                p.setNoContractId(entity.getId());
                p.setId(RandomUtil.uuId());
                p.setCompanyId(entity.getSalerCompanyId());
                p.setContractCode(saleNoContractCrForm.getContractCode());
                p.setContractName(saleNoContractCrForm.getContractName());
                p.setCustomerId(saleNoContractCrForm.getCustomerId());
                p.setSalerId(saleNoContractCrForm.getSalerId());
            }
            this.oaContractPurchasePlanService.saveBatch(purchasePlanList);
            this.oaContractPurchasePlanService.insertPlan(purchasePlanList);
        }
    }

    @Override
    public void editInfo(SaleNoContractUpForm saleNoContractUpForm) {
        SaleNoContractEntity entity = (SaleNoContractEntity)JsonUtil.getJsonToBean((Object)saleNoContractUpForm, SaleNoContractEntity.class);
        entity.setSalerCompanyId(this.getUserCompanyId(entity.getSalerId()));
        if (StringUtils.isNotEmpty((String)saleNoContractUpForm.getCustomerAddress())) {
            List addressList = JSON.parseArray((String)saleNoContractUpForm.getCustomerAddress(), String.class);
            if (!addressList.isEmpty()) {
                entity.setCustomerRegion((String)addressList.get(0));
                entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
            }
            if (addressList.size() > 1) {
                entity.setCustomerProv((String)addressList.get(1));
                entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
            }
            if (addressList.size() > 2) {
                entity.setCustomerCity((String)addressList.get(2));
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        } else {
            entity.setCustomerRegion("");
            entity.setCustomerRegionName("");
            entity.setCustomerProv("");
            entity.setCustomerProvName("");
            entity.setCustomerCity("");
            entity.setCustomerCityName("");
        }
        this.saleContractCustomerService.removeByContractId(entity.getId());
        if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
            this.saleContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
        }
        if (saleNoContractUpForm.getStatus() == 0) {
            entity.setStatus(SaleNoContractStatusEnum.DRAFT_STATUS.getStatus());
        } else {
            entity.setStatus(SaleNoContractStatusEnum.UNRECOGNIZED_STATUS.getStatus());
        }
        this.updateById(entity);
        this.rkContractProductService.deleteByContractId(saleNoContractUpForm.getId());
        List<RkContractProductEntity> productList = saleNoContractUpForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            productList.stream().forEach(product -> {
                product.setId(RandomUtil.uuId());
                product.setContractId(entity.getId());
            });
            this.rkContractProductService.saveBatch(productList);
        }
        this.rkAttachmentService.deleteByContractId(saleNoContractUpForm.getId(), AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
        List<RkAttachmentEntity> attachmentList = saleNoContractUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(entity.getId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.NO_CONTRACT_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
        this.oaContractPurchasePlanService.deleteByNoContractId(saleNoContractUpForm.getId());
        this.oaPurchasePlanService.deleteByNoContractId(saleNoContractUpForm.getId());
        List<OaContractPurchasePlanEntity> purchasePlanList = saleNoContractUpForm.getPurchasePlanList();
        if (ObjectUtil.isNotEmpty(purchasePlanList)) {
            for (OaContractPurchasePlanEntity p : purchasePlanList) {
                p.setNoContractId(entity.getId());
                if (StrUtil.equals((CharSequence)"add", (CharSequence)p.getIsAdd())) {
                    p.setId(RandomUtil.uuId());
                }
                p.setCompanyId(entity.getSalerCompanyId());
                p.setContractCode(saleNoContractUpForm.getContractCode());
                p.setContractName(saleNoContractUpForm.getContractName());
                p.setCustomerId(saleNoContractUpForm.getCustomerId());
                p.setSalerId(saleNoContractUpForm.getSalerId());
            }
            this.oaContractPurchasePlanService.saveOrUpdateBatch(purchasePlanList);
            this.oaContractPurchasePlanService.insertPlan(purchasePlanList);
        }
    }

    @Override
    public String getUserCompanyId(String salerId) {
        OrganizeEntity organizeEntity;
        UserEntity userEntity;
        if (StrUtil.isNotEmpty((CharSequence)salerId) && null != (userEntity = this.userService.getInfo(salerId)) && null != (organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId()))) {
            return organizeEntity.getOrganizeId();
        }
        return "";
    }

    @Override
    public SaleNoContractInfoVO getNoContractForContract(String noContractId) {
        SaleNoContractEntity entity = this.getInfo(noContractId);
        SaleNoContractInfoVO vo = null;
        if (null != entity) {
            SaleQuotationProfitEntity profit;
            CrmCustomerEntity crmCustomerEntity;
            SaleQuotationEntity quotation;
            RkReportingProductPriceEntity reportingProductPrice;
            RkProjectReportingEntity reporting;
            vo = (SaleNoContractInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleNoContractInfoVO.class);
            if (StringUtil.isNotEmpty((String)vo.getOpportunityId()) && null != (reporting = this.rkProjectReportingService.getInfo(vo.getOpportunityId()))) {
                vo.setOpportunityName(reporting.getReportingProject());
                RkProjectReportingListVO opportunityInfo = (RkProjectReportingListVO)JsonUtil.getJsonToBean((Object)reporting, RkProjectReportingListVO.class);
                vo.setOpportunityInfo(opportunityInfo);
            }
            if (StringUtil.isNotEmpty((String)vo.getReportingProductPriceId()) && null != (reportingProductPrice = this.rkReportingProductPriceService.getInfo(vo.getReportingProductPriceId()))) {
                RkReportingProductPriceListVO reportingProductPriceInfo = (RkReportingProductPriceListVO)JsonUtil.getJsonToBean((Object)reportingProductPrice, RkReportingProductPriceListVO.class);
                reportingProductPriceInfo.setProductPriceItemList(this.rkReportingProductPriceItemService.queryByPriceId(reportingProductPriceInfo.getId()));
                vo.setReportingProductPriceInfo(reportingProductPriceInfo);
            }
            if (StringUtil.isNotEmpty((String)vo.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(vo.getQuotationId()))) {
                SaleQuotationListVO quotationInfo = (SaleQuotationListVO)JsonUtil.getJsonToBean((Object)quotation, SaleQuotationListVO.class);
                if (!StrUtil.isBlank((CharSequence)quotationInfo.getCustomerId())) {
                    crmCustomerEntity = this.crmCustomerService.getInfo(quotationInfo.getCustomerId());
                    quotationInfo.setCustomerName(ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "");
                }
                vo.setQuotationInfo(quotationInfo);
            }
            if (StringUtil.isNotEmpty((String)vo.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(vo.getQuotationProfitId()))) {
                SaleQuotationProfitDetailEntity profitDetail;
                SaleQuotationProfitListVO profitInfo = (SaleQuotationProfitListVO)JsonUtil.getJsonToBean((Object)profit, SaleQuotationProfitListVO.class);
                if (!StrUtil.isBlank((CharSequence)profitInfo.getCustomerId())) {
                    crmCustomerEntity = this.crmCustomerService.getInfo(profitInfo.getCustomerId());
                    profitInfo.setCustomerName(ObjectUtil.isNotEmpty((Object)crmCustomerEntity) ? crmCustomerEntity.getName() : "");
                }
                if (null != (profitDetail = this.salequotationprofitdetailService.queryByProfitAndOptionId(profitInfo.getId(), "softProfit"))) {
                    profitInfo.setSoftProfit(ConvertUtil.toBigDecimal((Object)profitDetail.getOptionValue()));
                }
                if (null != (profitDetail = this.salequotationprofitdetailService.queryByProfitAndOptionId(profitInfo.getId(), "hardProfit"))) {
                    profitInfo.setSoftProfit(MathUtils.add(profitInfo.getSoftProfit(), ConvertUtil.toBigDecimal((Object)profitDetail.getOptionValue())));
                }
                if (null != (profitDetail = this.salequotationprofitdetailService.queryByProfitAndOptionId(profitInfo.getId(), "softProfitRate"))) {
                    profitInfo.setSoftProfitRate(ConvertUtil.toBigDecimal((Object)profitDetail.getOptionValue()));
                }
                vo.setQuotationProfitInfo(profitInfo);
            }
        }
        return vo;
    }
}

