/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseUpForm;
import com.bringspring.contract.service.RkContractVerifyFileResponseService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractHttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(ContractHttpClientUtil.class);
    @Value(value="${contract.url}")
    private String baseUrl;
    @Value(value="${contract.header.Authorization}")
    private String Authorization;
    @Autowired
    private RkContractVerifyFileResponseService rkContractVerifyFileResponseService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sendRequest(String fileUrl, String attId) {
        String responseXml = "";
        String responseEntity = "";
        String realURL = this.baseUrl;
        String realAuthorization = "Bearer " + this.Authorization;
        int responseCode = -1;
        HashMap<String, Object> temp = new HashMap<String, Object>();
        try {
            JsonObject jsonObject = new JsonObject();
            JsonObject inputsObject = new JsonObject();
            JsonObject fileObject = new JsonObject();
            fileObject.addProperty("url", fileUrl);
            fileObject.addProperty("type", "document");
            fileObject.addProperty("transfer_method", "remote_url");
            inputsObject.add("file", (JsonElement)fileObject);
            jsonObject.addProperty("user", "admin");
            jsonObject.addProperty("response_type", "blocking");
            jsonObject.add("inputs", (JsonElement)inputsObject);
            log.info("\u8bf7\u6c42\u4f53: {}", (Object)jsonObject.toString());
            HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)realURL).header("Content-type", "application/json")).header("Authorization", realAuthorization)).header("User-Agent", "Mozilla/5.0")).body(jsonObject.toString()).execute();
            responseCode = response.getStatus();
            if (responseCode == 200) {
                responseEntity = JsonUtil.getObjectToString((Object)this.getEntity(response.body(), responseCode, attId));
            } else {
                log.info("\u8fde\u63a5\u5931\u8d25:{}", (Object)responseCode);
            }
        }
        finally {
            temp.put("responseCode", responseCode);
            temp.put("responseXml", responseEntity);
            this.recordPushLog(responseEntity, responseCode, attId);
            log.info("\u8bf7\u6c42\u7ed3\u675f\uff0c\u54cd\u5e94\u7ed3\u679c: {}", (Object)responseXml);
        }
        return temp;
    }

    private RkContractVerifyFileResponseUpForm getEntity(String responseXml, int responseCode, String attId) {
        try {
            JSONObject jsonObject = JSONUtil.parseObj((String)responseXml);
            String data = jsonObject.getStr((Object)"data");
            String errorMsg = jsonObject.getStr((Object)"error");
            JSONObject dataJsonObject = JSONUtil.parseObj((String)data);
            String id = dataJsonObject.getStr((Object)"id");
            String status = dataJsonObject.getStr((Object)"status");
            JSONObject outputs = dataJsonObject.getJSONObject((Object)"outputs");
            RkContractVerifyFileResponseUpForm outputEntity = (RkContractVerifyFileResponseUpForm)JsonUtil.getJsonToBean((Object)outputs.getJSONObject((Object)"text"), RkContractVerifyFileResponseUpForm.class);
            outputEntity.setId(id);
            outputEntity.setStatusMsg(status);
            outputEntity.setErrorMsg(errorMsg);
            outputEntity.setAttId(attId);
            return outputEntity;
        }
        catch (NullPointerException e) {
            log.error("\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            RkContractVerifyFileResponseUpForm outputEntity = new RkContractVerifyFileResponseUpForm();
            outputEntity.setStatusMsg("error");
            outputEntity.setErrorMsg("\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
            outputEntity.setAttId(attId);
            outputEntity.setResponseXml(responseXml);
            return outputEntity;
        }
    }

    private RkContractVerifyFileResponseUpForm recordPushLog(String responseXml, int responseCode, String attId) {
        if (responseCode == 200) {
            try {
                RkContractVerifyFileResponseUpForm outputEntity = (RkContractVerifyFileResponseUpForm)JsonUtil.getJsonToBean((Object)JSONUtil.parse((Object)responseXml), RkContractVerifyFileResponseUpForm.class);
                outputEntity.setResponseXml(responseXml);
                this.rkContractVerifyFileResponseService.insertInfo(outputEntity);
                return outputEntity;
            }
            catch (Exception e) {
                RkContractVerifyFileResponseUpForm outputEntity = new RkContractVerifyFileResponseUpForm();
                outputEntity.setStatusMsg("error");
                outputEntity.setErrorMsg("\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage());
                outputEntity.setAttId(attId);
                outputEntity.setResponseXml(responseXml);
                this.rkContractVerifyFileResponseService.insertInfo(outputEntity);
                return outputEntity;
            }
        }
        RkContractVerifyFileResponseUpForm outputEntity = new RkContractVerifyFileResponseUpForm();
        outputEntity.setStatusMsg("error");
        outputEntity.setErrorMsg("\u8bf7\u6c42\u5931\u8d25");
        outputEntity.setAttId(attId);
        this.rkContractVerifyFileResponseService.insertInfo(outputEntity);
        return outputEntity;
    }
}

