/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanListVO;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.ReturnPlanOverdueDayEnum;
import java.util.Date;
import java.util.Map;

public class ContractReturnPlanUilts {
    public static boolean checkIsOverdue(RkContractReturnPlanEntity planEntity) {
        Date checkDate = planEntity.getActualDueDate();
        if (!StrUtil.equals((CharSequence)planEntity.getCompanyId(), (CharSequence)CompanyIdEnum.MiJIAN.getId())) {
            checkDate = planEntity.getDueDate();
        }
        return ObjectUtil.isNotNull((Object)checkDate) && !checkDate.after(DateUtil.getDayBegin());
    }

    public static Date getCheckIsOverdueDate(String companyId) {
        Map<String, ReturnPlanOverdueDayEnum> allToMap = ReturnPlanOverdueDayEnum.getAllToMap();
        ReturnPlanOverdueDayEnum dayEnum = allToMap.get(companyId);
        long overdueDay = 0L;
        if (ObjectUtil.isNotNull((Object)((Object)dayEnum))) {
            overdueDay = dayEnum.getOverdueDay();
        }
        return DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)(Integer.parseInt(overdueDay + "") * -1));
    }

    public static String getCheckIsOverdueStrDate(String companyId) {
        Date checkIsOverdueDate = ContractReturnPlanUilts.getCheckIsOverdueDate(companyId);
        return DateUtil.format((Date)checkIsOverdueDate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static void checkReturnPlanOverdue(RkContractReturnPlanListVO rkContractReturnPlanVO, Map<String, String> arrearsYearCollect) {
        rkContractReturnPlanVO.setIsOverdue(0);
        Date checkDate = rkContractReturnPlanVO.getActualDueDate();
        if (!StrUtil.equals((CharSequence)rkContractReturnPlanVO.getCompanyId(), (CharSequence)CompanyIdEnum.MiJIAN.getId())) {
            checkDate = rkContractReturnPlanVO.getDueDate();
        }
        if (ObjectUtil.isNotNull((Object)checkDate) && !checkDate.after(DateUtil.getDayBegin())) {
            rkContractReturnPlanVO.setDueAccountsReceivableBalance(MathUtils.substract(rkContractReturnPlanVO.getReceivableAmount(), rkContractReturnPlanVO.getReturnAmount()));
        }
        if (ObjectUtil.notEqual((Object)rkContractReturnPlanVO.getReturnState(), (Object)ReturnPlanEnum.END.getState())) {
            Map<String, ReturnPlanOverdueDayEnum> allToMap = ReturnPlanOverdueDayEnum.getAllToMap();
            ReturnPlanOverdueDayEnum dayEnum = allToMap.get(rkContractReturnPlanVO.getCompanyId());
            long overdueDay = 0L;
            if (ObjectUtil.isNotNull((Object)((Object)dayEnum))) {
                overdueDay = dayEnum.getOverdueDay();
            }
            if (!ObjectUtil.isEmpty((Object)checkDate)) {
                long l = DateUtil.getDiffDays((Date)DateUtil.getDayBegin(), (Date)checkDate);
                if (l < 0L) {
                    rkContractReturnPlanVO.setOverdueDays(l * -1L);
                }
                if (l + overdueDay < 0L) {
                    rkContractReturnPlanVO.setIsOverdue(1);
                    rkContractReturnPlanVO.setArrearsAmount(MathUtils.substract(rkContractReturnPlanVO.getReceivableAmount(), rkContractReturnPlanVO.getReturnAmount()));
                }
            }
            if (rkContractReturnPlanVO.getIsOverdue() == 1) {
                rkContractReturnPlanVO.setOverdueDaysYear(Integer.parseInt(rkContractReturnPlanVO.getOverdueDays() + "") / 365 + 1);
                if (CollectionUtil.isNotEmpty(arrearsYearCollect)) {
                    if (rkContractReturnPlanVO.getOverdueDaysYear() > 6) {
                        rkContractReturnPlanVO.setOverdueDaysYear(6);
                    }
                    String arrearsYearStr = arrearsYearCollect.get(rkContractReturnPlanVO.getOverdueDaysYear() + "");
                    rkContractReturnPlanVO.setOverdueDaysYearDesc(arrearsYearStr);
                }
            } else {
                String arrearsYearStr = arrearsYearCollect.get("0");
                rkContractReturnPlanVO.setOverdueDaysYearDesc(arrearsYearStr);
            }
        } else {
            String arrearsYearStr = arrearsYearCollect.get("0");
            rkContractReturnPlanVO.setOverdueDaysYearDesc(arrearsYearStr);
        }
    }
}

