/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;

public class MathUtils {
    private static final int DEFAULT_DIV_SCALE = 5;

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).doubleValue();
    }

    public static String add(String v1, String v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = "0";
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).toString();
    }

    public static BigDecimal add(BigDecimal v1, BigDecimal v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = BigDecimal.ZERO;
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = BigDecimal.ZERO;
        }
        return v1.add(v2);
    }

    public static BigDecimal add2(String v1, String v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = "0";
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2);
    }

    public static double subtract(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).doubleValue();
    }

    public static String substract(String v1, String v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = "0";
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).toString();
    }

    public static BigDecimal substract(BigDecimal v1, BigDecimal v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = BigDecimal.ZERO;
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = BigDecimal.ZERO;
        }
        return v1.subtract(v2);
    }

    public static BigDecimal substract2(String v1, String v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = "0";
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2);
    }

    public static double multiply(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).doubleValue();
    }

    public static String multiply(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).toString();
    }

    public static BigDecimal multiply(BigDecimal v1, BigDecimal v2) {
        if (ObjectUtil.isEmpty((Object)v1)) {
            v1 = BigDecimal.ZERO;
        }
        if (ObjectUtil.isEmpty((Object)v2)) {
            v2 = BigDecimal.ZERO;
        }
        return v1.multiply(v2);
    }

    public static double divide(double v1, double v2) {
        return MathUtils.divide(v1, v2, 5);
    }

    public static double divide(double v1, double v2, int scale) {
        return MathUtils.divide(v1, v2, scale, 4);
    }

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2, int scale) {
        if (BigDecimal.ZERO.compareTo(v2) == 0) {
            return new BigDecimal(100);
        }
        return v1.divide(v2, scale, 4);
    }

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2, int scale, BigDecimal defaultValue) {
        if (BigDecimal.ZERO.compareTo(v2) == 0) {
            return defaultValue;
        }
        return v1.divide(v2, scale, 4);
    }

    public static double divide(double v1, double v2, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, round_mode).doubleValue();
    }

    public static String divide(String v1, String v2) {
        return MathUtils.divide(v1, v2, 5);
    }

    public static String divide(String v1, String v2, int scale) {
        return MathUtils.divide(v1, v2, scale, 4);
    }

    public static String divide(String v1, String v2, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, scale, round_mode).toString();
    }

    public static double round(double v, int scale) {
        return MathUtils.round(v, scale, 4);
    }

    public static double round(double v, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        return b.setScale(scale, round_mode).doubleValue();
    }

    public static String round(String v, int scale) {
        return MathUtils.round(v, scale, 4);
    }

    public static String round(String v, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        return b.setScale(scale, round_mode).toString();
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (ObjectUtil.isEmpty((Object)o)) {
            o = "0";
        }
        return new BigDecimal(StrUtil.trim((CharSequence)o.toString()));
    }

    public static void main(String[] args) {
        String s = "624950 ";
        String trim = s.toString().trim();
        s.toString().trim();
        System.out.println(trim);
    }
}

