/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.DateUtil;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkProjectAuthorizationBussEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectAuthorizationBussService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.visit.constant.MessageTypeConst;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageTask {
    Logger logger = LoggerFactory.getLogger(MessageTask.class);
    @Autowired
    private RkContractService contractService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkProjectAuthorizationBussService rkProjectAuthorizationBussService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @JsbosTask(fullName="\u9879\u76ee\u6388\u6743\u8fc7\u671f\u63d0\u524d\u63d0\u9192", description="\u9879\u76ee\u6388\u6743\u8fc7\u671f\u63d0\u524d\u63d0\u9192", cron="0 30 9 * * ?")
    public void getFileReturn() throws BaseException {
        List<RkProjectAuthorizationBussEntity> list = this.rkProjectAuthorizationBussService.getReturnTask();
        this.logger.info("\u9879\u76ee\u6388\u6743:{}" + list.size(), (Object)"\u5b9a\u65f6\u9879\u76ee\u6388\u6743\uff0c,\u5f53\u524d\u65f6\u95f4:{}", (Object)LocalDateTime.now());
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(entity -> {
                try {
                    this.returnTaskAttachmentMessage((RkProjectAuthorizationBussEntity)entity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void returnTaskAttachmentMessage(RkProjectAuthorizationBussEntity entity) throws Exception {
        String messageTime = DateUtil.dateFormat((Date)new Date());
        try {
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(entity.getProjectId());
            String userId = entity.getCreatorUserId() + "," + info.getSalerId() + "," + info.getProjectHeader();
            String taskCode = MessageTypeEnum.PROJECT_AUTHORIZATION_TEMPLATE.getMessage();
            String sendCode = MessageTypeEnum.PROJECT_AUTHORIZATION_TEMPLATE.getTemplateCode();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            HashMap keys = MapUtil.newHashMap();
            keys.put("title", entity.getProjectName() + "\u9879\u76ee\u6388\u6743\u8fc7\u671f\u63d0\u9192");
            keys.put("content", "\u9879\u76ee\u540d\u79f0\uff1a" + entity.getProjectName() + "\n\u6388\u6743\u5f00\u59cb\u65f6\u95f4\uff1a" + sdf.format(entity.getActualStartDate()) + "\n\u6388\u6743\u7ed3\u675f\u65f6\u95f4\uff1a" + sdf.format(entity.getActualEndDate()) + "\n\u5269\u4f59\u5929\u6570\uff1a" + entity.getRemainingDays());
            String pcUrl = "/#/contract/project/authorizationBuss";
            String termType = TermTypeEnum.TERM_PC.getCode();
            String termTypeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
            this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, null, pcUrl, userId, termType, termTypeDesc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u63d0\u9192\u4e0a\u4f20\u5408\u540c\u9644\u4ef6", description="\u5b9a\u65f6\u63d0\u9192\u4e0a\u4f20\u5408\u540c\u9644\u4ef6", cron="0 0 10 * * ?")
    public void noticeNotHaveAttachment() {
        Date nowDate = DateUtil.getDayBegin();
        List<RkContractEntity> list = this.contractService.getListNotHaveAttachmentAndArrivalExpectedReturnTime(nowDate);
        this.logger.info("\u672a\u4e0a\u4f20\u9644\u4ef6\uff0c\u9700\u8981\u901a\u77e5\u7684\u6570\u91cf:{}", (Object)list.size());
        list.stream().forEach(entity -> this.sendNotHaveAttachmentMessage((RkContractEntity)entity));
    }

    private void sendNotHaveAttachmentMessage(RkContractEntity entity) {
        RkAgentEntity byId1;
        List toUserIds = CollectionUtil.list((boolean)false, (Object[])new String[]{entity.getCreatorUserId(), entity.getSalerId()});
        SentMessageForm sentMessageForm = this.getMessageForm(MessageTypeConst.NOTHAVEATTACHMENT.getType(), Constants.NOT_HAVEATTACHMENT_MESSAGE_TEMPLATECODE);
        if (ObjectUtil.isEmpty((Object)sentMessageForm)) {
            return;
        }
        sentMessageForm.setToUserIds(toUserIds);
        sentMessageForm.setTitle("\u6709\u5408\u540c\u5230\u8fbe\u9884\u8ba1\u8fd4\u56de\u65f6\u95f4\uff0c\u4f46\u672a\u4e0a\u4f20\u9644\u4ef6");
        sentMessageForm.setContent("\u6709\u5408\u540c\u5230\u8fbe\u9884\u8ba1\u8fd4\u56de\u65f6\u95f4\uff0c\u4f46\u672a\u4e0a\u4f20\u9644\u4ef6");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getContent());
        map.put("id", entity.getId());
        map.put("contractName", entity.getContractName());
        CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
        String customerName = "";
        if (!ObjectUtil.isEmpty((Object)byId)) {
            customerName = byId.getName();
        }
        map.put("customerName", customerName);
        String agentName = "";
        if (!ObjectUtil.isEmpty((Object)entity.getIsAgent()) && entity.getIsAgent() == 1 && !ObjectUtil.isEmpty((Object)(byId1 = (RkAgentEntity)this.agentService.getById((Serializable)((Object)entity.getAgentId()))))) {
            agentName = byId1.getName();
        }
        String messageTime = DateUtil.dateFormat((Date)new Date());
        map.put("MessageTime", messageTime);
        StringBuffer contentWechat = new StringBuffer();
        contentWechat.append(sentMessageForm.getContent()).append("\n\u5408\u540c\u540d\u79f0:" + entity.getContractName());
        if (!ObjectUtil.isEmpty((Object)customerName)) {
            contentWechat.append("\n\u6700\u7ec8\u5ba2\u6237:" + customerName);
        }
        if (!ObjectUtil.isEmpty((Object)agentName)) {
            contentWechat.append("\n\u5408\u540c\u5bf9\u8c61:" + agentName);
        }
        contentWechat.append("\n\u6d88\u606f\u65f6\u95f4:" + messageTime);
        map.put("content", contentWechat.toString());
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    @JsbosTask(fullName="\u56de\u6b3e\u8ba1\u5212\u63d0\u9192", description="\u56de\u6b3e\u8ba1\u5212\u63d0\u9192", cron="0 0 9 * * ?")
    public void noticeReturnPlan() {
        List<RkContractEntity> listByEnableMark = this.contractService.getListByEnableMark(ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark());
        List<String> contractIdList = listByEnableMark.stream().map(RkContractEntity::getId).collect(Collectors.toList());
        Date nowDay = DateUtil.getDayBegin();
        Date after7Day = DateUtil.dateAddDays((Date)nowDay, (int)7);
        List<RkContractReturnPlanEntity> after7DayPlanList = this.contractReturnPlanService.getPlanAndStateAndEndDueTime(contractIdList, after7Day);
        after7DayPlanList.stream().forEach(plan -> this.sendReturnPlanMessage((RkContractReturnPlanEntity)plan, "\u5373\u5c06\u5230\u671f\u63d0\u9192", "\u8fd8\u67097\u5929\u5373\u5c06\u5230\u671f\uff0c\u8bf7\u9500\u552e\u4eba\u5458\u5173\u6ce8!"));
        List<RkContractReturnPlanEntity> nowDayPlanList = this.contractReturnPlanService.getPlanAndStateAndEndDueTime(contractIdList, nowDay);
        nowDayPlanList.stream().forEach(plan -> this.sendReturnPlanMessage((RkContractReturnPlanEntity)plan, "\u5230\u671f\u63d0\u9192", "\u4eca\u65e5\u662f\u6700\u540e\u7684\u56de\u6b3e\u671f\u9650\uff0c\u8bf7\u9500\u552e\u4eba\u5458\u542f\u52a8\u50ac\u6b3e\u5de5\u4f5c!"));
        RkContractReturnPlanEntity overdueMax = this.contractReturnPlanService.getOverdueMax(contractIdList);
        int diffDays = DateUtil.getDiffDays((Date)nowDay, (Date)overdueMax.getDueDate());
        this.logger.info("\u6700\u5927\u8d85\u671f\u65f6\u95f4\u5927\u4e8e\u4eca\u5929:{}", (Object)diffDays);
        String divide = MathUtils.divide(String.valueOf(diffDays), "14", 0, 1);
        int i = 1;
        while (i <= Integer.parseInt(divide)) {
            this.logger.info("\u67e5\u8be2\u8d85\u671f:{}\u5929\u7684\u56de\u6b3e\u8ba1\u5212", (Object)(i * 14));
            Date searchDate = DateUtil.dateAddDays((Date)nowDay, (int)(i * 14 * -1));
            List<RkContractReturnPlanEntity> searchPlanList = this.contractReturnPlanService.getPlanAndStateAndEndDueTime(contractIdList, searchDate);
            int finalI = i++;
            searchPlanList.stream().forEach(plan -> this.sendReturnPlanMessage((RkContractReturnPlanEntity)plan, "\u8d85\u671f\u63d0\u9192", "\u5df2\u8d85\u671f" + finalI * 14 + "\u5929\uff0c\u8bf7\u9500\u552e\u4eba\u5458\u8fdb\u884c\u50ac\u6b3e!"));
        }
    }

    public static void main(String[] args) {
        int diffDays = 68;
        String divide = MathUtils.divide(String.valueOf(diffDays), "14", 0, 1);
        System.out.println(divide);
        for (int i = 1; i <= Integer.parseInt(divide); ++i) {
            System.out.println("\u503c:" + i * 14);
        }
    }

    private void sendReturnPlanMessage(RkContractReturnPlanEntity plan, String title, String content) {
        RkAgentEntity byId1;
        SentMessageForm sentMessageForm = this.getMessageForm(MessageTypeConst.RETURN_PLAN.getType(), Constants.RETURN_PLAN_MESSAGE_TEMPLATECODE);
        if (ObjectUtil.isEmpty((Object)sentMessageForm)) {
            return;
        }
        RkContractEntity contractEntity = (RkContractEntity)this.contractService.getById((Serializable)((Object)plan.getContractId()));
        List toUserIds = CollectionUtil.list((boolean)false, (Object[])new String[]{contractEntity.getSalerId(), plan.getCreatorUserId()});
        sentMessageForm.setToUserIds(toUserIds);
        sentMessageForm.setTitle(title);
        sentMessageForm.setContent(content);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getContent());
        map.put("id", plan.getId());
        map.put("contractName", contractEntity.getContractName());
        CrmCustomerEntity crmCustomerEntity = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)contractEntity.getCustomerId()));
        String customerName = "";
        if (!ObjectUtil.isEmpty((Object)crmCustomerEntity)) {
            customerName = crmCustomerEntity.getName();
        }
        map.put("customerName", customerName);
        String agentName = "";
        if (!ObjectUtil.isEmpty((Object)contractEntity.getIsAgent()) && contractEntity.getIsAgent() == 1 && !ObjectUtil.isEmpty((Object)(byId1 = (RkAgentEntity)this.agentService.getById((Serializable)((Object)contractEntity.getAgentId()))))) {
            agentName = byId1.getName();
        }
        String messageTime = DateUtil.dateFormat((Date)new Date());
        map.put("MessageTime", messageTime);
        String dicName = this.baseDataUtil.getDictName(plan.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID);
        StringBuffer contentWechat = new StringBuffer();
        String returnAmount = ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0.00" : plan.getReturnAmount().toString();
        contentWechat.append(sentMessageForm.getContent()).append("\n\u5408\u540c\u540d\u79f0:" + contractEntity.getContractName()).append("\n\u6b3e\u9879:" + dicName).append("\n\u5e94\u56de\u6b3e:" + plan.getReceivableAmount() + "\u5143").append("\n\u5b9e\u9645\u56de\u6b3e:" + returnAmount + "\u5143").append("\n\u5269\u4f59\u5e94\u56de\u6b3e:" + MathUtils.substract(plan.getReceivableAmount().toString(), returnAmount) + "\u5143");
        if (!ObjectUtil.isEmpty((Object)customerName)) {
            contentWechat.append("\n\u6700\u7ec8\u5ba2\u6237:" + customerName);
        }
        if (!ObjectUtil.isEmpty((Object)agentName)) {
            contentWechat.append("\n\u5408\u540c\u5bf9\u8c61:" + agentName);
        }
        contentWechat.append("\n\u6d88\u606f\u65f6\u95f4:" + messageTime);
        map.put("content", contentWechat.toString());
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isEmpty((Object)one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }
}

