/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.exception.DataException;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectAuthorizationBussService;
import com.bringspring.contract.service.RkProjectTaskService;
import com.bringspring.system.base.entity.BillRuleEntity;
import com.bringspring.system.base.mapper.BillRuleMapper;
import com.bringspring.system.base.service.BillRuleService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectScheduledTask {
    Logger logger = LoggerFactory.getLogger(ProjectScheduledTask.class);
    @Autowired
    private RkProjectTaskService projectTaskService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProjectAuthorizationBussService rkProjectAuthorizationBussService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private BillRuleMapper billRuleMapper;

    @JsbosTask(fullName="\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u4efb\u52a1\u72b6\u6001", description="\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u4efb\u52a1\u72b6\u6001", cron="0 0/1 * * * ?")
    public void updateTaskState() {
        this.logger.info("\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u4efb\u52a1\u72b6\u6001");
        this.projectTaskService.updateTaskState();
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u7ed3\u675f\u72b6\u6001", description="\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u7ed3\u675f\u72b6\u6001", cron="0 0 0 * * ?")
    public void updateProjectEnd() {
        this.logger.info("\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u7ed3\u675f\u72b6\u6001");
        this.rkContractProjectService.updateStateEnd();
        this.logger.info("\u66f4\u65b0\u552e\u540e\u9879\u76ee\u8d28\u4fdd\u72b6\u6001");
        this.afterSalesProjectsService.updateStateEnd();
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u6388\u6743\u5269\u4f59\u5929\u6570\u53ca\u5269\u4f59\u7b49\u7ea7", description="\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u6388\u6743\u5269\u4f59\u5929\u6570\u53ca\u5269\u4f59\u7b49\u7ea7", cron="0 30 1 * * ?")
    public void setAuthorizationRemainingDays() {
        this.logger.info("\u5b9a\u65f6\u66f4\u65b0\u9879\u76ee\u6388\u6743\u5269\u4f59\u5929\u6570\u53ca\u5269\u4f59\u7b49\u7ea7");
        this.rkProjectAuthorizationBussService.setAuthorizationRemainingDays();
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u6bcf\u6708\u66f4\u65b0\u7c73\u5065\u5546\u673a\u62a5\u5907\u7f16\u7801", description="\u5b9a\u65f6\u6bcf\u6708\u66f4\u65b0\u7c73\u5065\u5546\u673a\u62a5\u5907\u7f16\u7801", cron="0 0 1 1 1-12 ? *")
    public void reportingBillRuleCode() throws DataException {
        LocalDate today = LocalDate.of(2024, 12, 1);
        if (today.isEqual(today.with(TemporalAdjusters.firstDayOfMonth()))) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BillRuleEntity::getEnCode, (Object)"mj_Business");
            BillRuleEntity billRuleEntity = (BillRuleEntity)this.billRuleMapper.selectOne((Wrapper)queryWrapper);
            billRuleEntity.setOutputNumber(new String());
            billRuleEntity.setThisNumber(Integer.valueOf(-1));
            this.billRuleService.update(billRuleEntity.getId(), billRuleEntity);
        }
    }
}

