/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.constant.UserRelationObjectTypeEnum;
import com.bringspring.system.base.util.UserAuthAreaUtils;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleUtils {
    private static final Logger log = LoggerFactory.getLogger(RoleUtils.class);
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;

    public HashMap canSeeUserId(UserInfo userInfo) {
        HashMap map = MapUtil.newHashMap();
        map.put("isAll", false);
        map.put("idList", CollectionUtil.list((boolean)false));
        if (userInfo.getUserId().equals("admin")) {
            map.put("isAll", true);
            return map;
        }
        List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
        List roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(roleIds)) {
            List listByObjectId = this.userRelationService.getListByUserId(userInfo.getUserId(), "Role");
            roleIds = listByObjectId.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            log.info("\u91cd\u65b0\u67e5\u8be2roleId\uff1a", (Object)JsonUtil.getObjectToString(roleIds));
        }
        List listByIds = this.roleService.getListByIds(roleIds);
        List collect = listByIds.stream().map(PermissionEntityBase::getEnCode).collect(Collectors.toList());
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"14") && (collect.contains("SManager") || collect.contains("contractAdministrator") || collect.contains("SubsidiaryAdmin"))) {
            map.put("isAll", true);
            return map;
        }
        if (StrUtil.equals((CharSequence)userInfo.getOrganizeId(), (CharSequence)"2") && (collect.contains("RManager") || collect.contains("productRole"))) {
            map.put("isAll", true);
            return map;
        }
        List returnUserIdList = CollectionUtil.list((boolean)false);
        returnUserIdList.add(userInfo.getUserId());
        if (collect.contains("SalesManager") || collect.contains("ZYHeader") || collect.contains("Channel")) {
            List searchUserIdList = UserAuthAreaUtils.getHaveSameAuthAreaAndRoleTypeWithMe((String)UserRelationObjectTypeEnum.SALE_AREA.getObjectType());
            returnUserIdList.addAll(searchUserIdList);
        }
        map.put("idList", returnUserIdList);
        return map;
    }
}

