/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordListVO;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.service.SaleQuotationService;
import java.io.Serializable;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SettlementRate {
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private RkContractService rkContractService;

    public void getServiceFee(RkContractListVO rkContractListVO) {
        if (StrUtil.equals((CharSequence)rkContractListVO.getCompanyId(), (CharSequence)CompanyIdEnum.RONGKE.getId())) {
            rkContractListVO.setBaseFeeRate(BigDecimal.valueOf(0.14));
        } else if (StrUtil.equals((CharSequence)rkContractListVO.getCompanyId(), (CharSequence)CompanyIdEnum.SHIHAN.getId())) {
            rkContractListVO.setBaseFeeRate(BigDecimal.valueOf(0.11));
        } else if (StrUtil.equals((CharSequence)rkContractListVO.getCompanyId(), (CharSequence)CompanyIdEnum.JINCHUANG.getId())) {
            rkContractListVO.setBaseFeeRate(BigDecimal.valueOf(0.1));
        } else if (StrUtil.equals((CharSequence)rkContractListVO.getCompanyId(), (CharSequence)CompanyIdEnum.MiJIAN.getId())) {
            rkContractListVO.setBaseFeeRate(BigDecimal.valueOf(0.11));
        }
    }

    public void getCommissionRate(RkContractCollectionRecordListVO rkContractCollectionRecordListVO, BigDecimal shiHanGPM) {
        RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)rkContractCollectionRecordListVO.getContractId()));
        if (StrUtil.equals((CharSequence)rkContractCollectionRecordListVO.getCompanyId(), (CharSequence)CompanyIdEnum.RONGKE.getId())) {
            rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.06));
        } else if (StrUtil.equals((CharSequence)rkContractCollectionRecordListVO.getCompanyId(), (CharSequence)CompanyIdEnum.JINCHUANG.getId())) {
            SaleQuotationEntity quotationEntity = (SaleQuotationEntity)this.saleQuotationService.getById((Serializable)((Object)contractEntity.getQuotationId()));
            if (ObjectUtil.isNotEmpty((Object)quotationEntity)) {
                if (quotationEntity.getAllMiniAmount().compareTo(contractEntity.getContractAmount()) > 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.05));
                } else {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.04));
                }
            } else {
                rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.ZERO);
            }
        } else if (StrUtil.equals((CharSequence)rkContractCollectionRecordListVO.getCompanyId(), (CharSequence)CompanyIdEnum.SHIHAN.getId())) {
            if (ObjectUtil.isNotEmpty((Object)shiHanGPM) && rkContractCollectionRecordListVO.getIsReturnSettlement().equals("1")) {
                if (shiHanGPM.compareTo(BigDecimal.valueOf(0.3)) >= 0 && shiHanGPM.compareTo(BigDecimal.valueOf(0.35)) <= 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.02));
                } else if (shiHanGPM.compareTo(BigDecimal.valueOf(0.35)) >= 0 && shiHanGPM.compareTo(BigDecimal.valueOf(0.4)) < 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.03));
                } else if (shiHanGPM.compareTo(BigDecimal.valueOf(0.4)) >= 0 && shiHanGPM.compareTo(BigDecimal.valueOf(0.45)) < 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.04));
                } else if (shiHanGPM.compareTo(BigDecimal.valueOf(0.45)) >= 0 && shiHanGPM.compareTo(BigDecimal.valueOf(0.5)) < 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.05));
                } else if (shiHanGPM.compareTo(BigDecimal.valueOf(0.5)) >= 0 && shiHanGPM.compareTo(BigDecimal.valueOf(0.55)) < 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.06));
                } else if (shiHanGPM.compareTo(BigDecimal.valueOf(0.55)) >= 0) {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.07));
                } else {
                    rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.01));
                }
            }
        } else if (StrUtil.equals((CharSequence)rkContractCollectionRecordListVO.getCompanyId(), (CharSequence)CompanyIdEnum.MiJIAN.getId()) && ObjectUtil.isNotEmpty((Object)contractEntity.getProfitAmount())) {
            BigDecimal profit = new BigDecimal(contractEntity.getProfitAmount());
            if (profit.compareTo(BigDecimal.ZERO) >= 0 && profit.compareTo(BigDecimal.valueOf(10L)) <= 0) {
                rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.01));
            } else if (profit.compareTo(BigDecimal.valueOf(11L)) > 0 && profit.compareTo(BigDecimal.valueOf(20L)) <= 0) {
                rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.03));
            } else if (profit.compareTo(BigDecimal.valueOf(21L)) > 0 && profit.compareTo(BigDecimal.valueOf(50L)) <= 0) {
                rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.04));
            } else if (profit.compareTo(BigDecimal.valueOf(51L)) > 0 && profit.compareTo(BigDecimal.valueOf(100L)) <= 0) {
                rkContractCollectionRecordListVO.setCommissionRate(BigDecimal.valueOf(0.05));
            }
        }
    }
}

