/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmAuthorizationModuleEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModuleCrForm;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModuleInfoVO;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModuleListVO;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModulePagination;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModulePaginationExportModel;
import com.bringspring.crm.model.crmAuthorizationModule.CrmAuthorizationModuleUpForm;
import com.bringspring.crm.service.CrmAuthorizationModuleService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6388\u6743\u6a21\u5757"}, value="crm")
@RequestMapping(value={"/api/crm/CrmAuthorizationModule"})
public class CrmAuthorizationModuleController {
    private static final Logger log = LoggerFactory.getLogger(CrmAuthorizationModuleController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmAuthorizationModuleService crmAuthorizationModuleService;
    @Autowired
    private CrmProductService crmProductService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmAuthorizationModulePagination crmAuthorizationModulePagination) throws IOException {
        List<CrmAuthorizationModuleEntity> list = this.crmAuthorizationModuleService.getList(crmAuthorizationModulePagination);
        for (CrmAuthorizationModuleEntity crmAuthorizationModuleEntity : list) {
            crmAuthorizationModuleEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmAuthorizationModuleEntity.getCreatorUserId()));
            crmAuthorizationModuleEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmAuthorizationModuleEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmAuthorizationModuleListVO.class);
        for (CrmAuthorizationModuleListVO crmAuthorizationModuleVO : listVO) {
            crmAuthorizationModuleVO.setCompanyName(this.baseDataUtil.getDictName(crmAuthorizationModuleVO.getCompanyId(), "companyName"));
            List<CrmProductEntity> productEntities = this.crmProductService.getInfoByListId(crmAuthorizationModuleVO.getProductId());
            if (!CollectionUtil.isNotEmpty(productEntities)) continue;
            crmAuthorizationModuleVO.setProductId(productEntities.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmAuthorizationModulePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getProductList"})
    public ActionResult getProductList(@RequestBody CrmAuthorizationModulePagination crmAuthorizationModulePagination) throws IOException {
        List<CrmAuthorizationModuleEntity> list = this.crmAuthorizationModuleService.getProductList(crmAuthorizationModulePagination);
        for (CrmAuthorizationModuleEntity entity : list) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmAuthorizationModuleListVO.class);
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmAuthorizationModuleCrForm crmAuthorizationModuleCrForm) throws DataException {
        this.crmAuthorizationModuleService.create(crmAuthorizationModuleCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmAuthorizationModulePaginationExportModel crmAuthorizationModulePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmAuthorizationModulePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmAuthorizationModulePagination crmAuthorizationModulePagination = (CrmAuthorizationModulePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmAuthorizationModulePaginationExportModel), CrmAuthorizationModulePagination.class));
        List<CrmAuthorizationModuleEntity> list = this.crmAuthorizationModuleService.getTypeList(crmAuthorizationModulePagination, crmAuthorizationModulePaginationExportModel.getDataType());
        for (CrmAuthorizationModuleEntity crmAuthorizationModuleEntity : list) {
            crmAuthorizationModuleEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmAuthorizationModuleEntity.getCreatorUserId()));
            crmAuthorizationModuleEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmAuthorizationModuleEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmAuthorizationModuleListVO.class);
        for (CrmAuthorizationModuleListVO crmAuthorizationModuleListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmAuthorizationModulePaginationExportModel.getSelectKey()) ? crmAuthorizationModulePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "productId": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"productId"));
                        continue block30;
                    }
                    case "moduleName": {
                        entitys.add(new ExcelExportEntity("\u6a21\u5757\u540d\u79f0", (Object)"moduleName"));
                        continue block30;
                    }
                    case "encode": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"encode"));
                        continue block30;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block30;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block30;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block30;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmAuthorizationModuleInfoVO> info(@PathVariable(value="id") String id) {
        List<CrmProductEntity> productEntities;
        CrmAuthorizationModuleEntity entity = this.crmAuthorizationModuleService.getInfo(id);
        CrmAuthorizationModuleInfoVO vo = (CrmAuthorizationModuleInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmAuthorizationModuleInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        if (CollectionUtil.isNotEmpty(productEntities = this.crmProductService.getInfoByListId(vo.getProductId()))) {
            vo.setProductName(productEntities.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmAuthorizationModuleInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmAuthorizationModuleEntity entity = this.crmAuthorizationModuleService.getInfo(id);
        CrmAuthorizationModuleInfoVO vo = (CrmAuthorizationModuleInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmAuthorizationModuleInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        List<CrmProductEntity> productEntities = this.crmProductService.getInfoByListId(vo.getProductId());
        if (CollectionUtil.isNotEmpty(productEntities)) {
            vo.setProductName(productEntities.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmAuthorizationModuleUpForm crmAuthorizationModuleUpForm) throws DataException {
        this.crmAuthorizationModuleService.update(id, crmAuthorizationModuleUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmAuthorizationModuleEntity entity = this.crmAuthorizationModuleService.getInfo(id);
        if (entity != null) {
            this.crmAuthorizationModuleService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

