/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentInfoVO;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.model.crmclueinfo.CrmClueAssignUpForm;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoCrForm;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoInfoVO;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoListVO;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoPagination;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoPaginationExportModel;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoUpForm;
import com.bringspring.crm.model.crmclueinfo.CrmClueNullifyUpForm;
import com.bringspring.crm.model.crmclueinfo.StatisticsSalePagination;
import com.bringspring.crm.model.crmclueinfo.StatisticsSalePaginationExportModel;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.util.CrmClueStateEnum;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.utils.SalesRoleUtils;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u7ebf\u7d22"}, value="crm")
@RequestMapping(value={"/api/crm/CrmClueInfo"})
public class CrmClueInfoController {
    private static final Logger log = LoggerFactory.getLogger(CrmClueInfoController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SalesRoleUtils salesRoleUtils;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmClueInfoPagination crmClueInfoPagination) throws IOException {
        HashMap iCanWho;
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.equals((CharSequence)crmClueInfoPagination.getSearchType(), (CharSequence)"subordinate") && !((Boolean)(iCanWho = this.salesRoleUtils.getICanWho(userInfo)).get("isAll")).booleanValue()) {
            List userIdList = (List)iCanWho.get("idList");
            crmClueInfoPagination.setUserIdList(userIdList);
        }
        List<CrmClueInfoEntity> list = this.crmClueInfoService.getList(crmClueInfoPagination);
        for (CrmClueInfoEntity crmClueInfoEntity : list) {
            crmClueInfoEntity.setSource(this.baseDataUtil.getDictName(crmClueInfoEntity.getSource(), "crmClueSource"));
            crmClueInfoEntity.setCustomerType(this.baseDataUtil.getDictName(crmClueInfoEntity.getCustomerType(), "classification"));
            crmClueInfoEntity.setAddress(this.baseDataUtil.provinceData(crmClueInfoEntity.getAddress()));
            crmClueInfoEntity.setProjectStages(this.baseDataUtil.getDictName(crmClueInfoEntity.getProjectStages(), "ReportingProjectStage"));
            crmClueInfoEntity.setInvestWay(this.baseDataUtil.getDictName(crmClueInfoEntity.getInvestWay(), "investWay"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmClueInfoListVO.class);
        for (CrmClueInfoListVO crmClueInfoVO : listVO) {
            List<String> productList;
            List categoryEntityList;
            crmClueInfoVO.setCreatorUserId(this.baseDataUtil.userSelectValue(crmClueInfoVO.getCreatorUserId()));
            crmClueInfoVO.setStateDesc(this.baseDataUtil.getDictName(crmClueInfoVO.getState(), "crmClueState"));
            crmClueInfoVO.setFollowUserName(this.baseDataUtil.userSelectValue(crmClueInfoVO.getFollowUser()));
            if (!StrUtil.isNotBlank((CharSequence)crmClueInfoVO.getProductType()) || !CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(productList = Arrays.asList(crmClueInfoVO.getProductType().split(",")))))) continue;
            String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            crmClueInfoVO.setProductType(join);
        }
        for (CrmClueInfoListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmClueInfoPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    public ActionResult getMyClue(@RequestBody CrmClueInfoPagination crmClueInfoPagination) {
        List<CrmClueInfoEntity> list = this.crmClueInfoService.getList(crmClueInfoPagination);
        return ActionResult.success();
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmClueInfoPaginationExportModel crmClueInfoPaginationExportModel) throws IOException {
        if (StrUtil.isEmpty((CharSequence)crmClueInfoPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmClueInfoPagination crmClueInfoPagination = (CrmClueInfoPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmClueInfoPaginationExportModel), CrmClueInfoPagination.class));
        List<CrmClueInfoEntity> list = this.crmClueInfoService.getTypeList(crmClueInfoPagination, crmClueInfoPaginationExportModel.getDataType());
        for (CrmClueInfoEntity crmClueInfoEntity : list) {
            crmClueInfoEntity.setSource(this.baseDataUtil.getDictName(crmClueInfoEntity.getSource(), "crmClueSource"));
            crmClueInfoEntity.setCustomerType(this.baseDataUtil.getDictName(crmClueInfoEntity.getCustomerType(), "classification"));
            crmClueInfoEntity.setAddress(this.baseDataUtil.provinceData(crmClueInfoEntity.getAddress()));
            crmClueInfoEntity.setProjectStages(this.baseDataUtil.getDictName(crmClueInfoEntity.getProjectStages(), "ReportingProjectStage"));
            crmClueInfoEntity.setInvestWay(this.baseDataUtil.getDictName(crmClueInfoEntity.getInvestWay(), "investWay"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmClueInfoListVO.class);
        for (CrmClueInfoListVO crmClueInfoVO : listVO) {
            List<String> productList;
            List categoryEntityList;
            if (StrUtil.isNotBlank((CharSequence)crmClueInfoVO.getProductType()) && CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(productList = Arrays.asList(crmClueInfoVO.getProductType().split(",")))))) {
                String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
                crmClueInfoVO.setProductType(join);
            }
            if (!StringUtils.isNotEmpty((String)crmClueInfoVO.getIsSecondarySale())) continue;
            crmClueInfoVO.setIsSecondarySale("1".equals(crmClueInfoVO.getIsSecondarySale()) ? "\u662f" : "\u5426");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StrUtil.isEmpty((CharSequence)crmClueInfoPaginationExportModel.getSelectKey()) ? crmClueInfoPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u7ebf\u7d22\u540d\u79f0", (Object)"name"));
                        continue block48;
                    }
                    case "source": {
                        entitys.add(new ExcelExportEntity("\u7ebf\u7d22\u6765\u6e90", (Object)"source"));
                        continue block48;
                    }
                    case "customerType": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7c7b\u578b", (Object)"customerType"));
                        continue block48;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block48;
                    }
                    case "customerContacts": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u8054\u7cfb\u4eba", (Object)"customerContacts"));
                        continue block48;
                    }
                    case "contactsPhone": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u8054\u7cfb\u65b9\u5f0f", (Object)"contactsPhone"));
                        continue block48;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u5730\u5740", (Object)"address"));
                        continue block48;
                    }
                    case "productType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"productType"));
                        continue block48;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5408\u540c\u91d1\u989d", (Object)"contractAmount"));
                        continue block48;
                    }
                    case "projectStages": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9636\u6bb5", (Object)"projectStages"));
                        continue block48;
                    }
                    case "competitor": {
                        entitys.add(new ExcelExportEntity("\u7ade\u4e89\u5bf9\u624b", (Object)"competitor"));
                        continue block48;
                    }
                    case "hospitalBudget": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u9884\u7b97", (Object)"hospitalBudget"));
                        continue block48;
                    }
                    case "isSecondarySale": {
                        entitys.add(new ExcelExportEntity("\u9996\u6b21\u9500\u552e", (Object)"isSecondarySale"));
                        continue block48;
                    }
                    case "investWay": {
                        entitys.add(new ExcelExportEntity("\u8d44\u91d1\u6765\u6e90", (Object)"investWay"));
                        continue block48;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u540d\u79f0", (Object)"agentName"));
                        continue block48;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block48;
                    }
                    case "agentContacts": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u4eba", (Object)"agentContacts"));
                        continue block48;
                    }
                    case "agentContactsTel": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u65b9\u5f0f", (Object)"agentContactsTel"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u7ebf\u7d22\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid CrmClueInfoCrForm crmClueInfoCrForm) throws DataException, WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        String flowEngineId = "550287967722159173";
        if (StrUtil.isNotBlank((CharSequence)crmClueInfoCrForm.getFlowId())) {
            flowEngineId = crmClueInfoCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        CrmClueInfoEntity entity = (CrmClueInfoEntity)JsonUtil.getJsonToBean((Object)((Object)crmClueInfoCrForm), CrmClueInfoEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setFollowUser(userInfo.getUserId());
        if (ObjectUtil.isNotNull((Object)crmClueInfoCrForm.getStatus()) && crmClueInfoCrForm.getStatus() == FlowTaskStatusEnum.Draft.getCode()) {
            entity.setState(CrmClueStateEnum.DRAFT_STATE.getState());
        }
        this.crmClueInfoService.save(entity);
        List jsonToList = JsonUtil.getJsonToList(crmClueInfoCrForm.getAttachmentList(), RkAttachmentEntity.class);
        if (CollectionUtil.isNotEmpty((Collection)jsonToList)) {
            jsonToList.stream().forEach(att -> {
                att.setId(RandomUtil.uuId());
                att.setObjId(mainId);
                att.setFileType(AttachmentTypeEnum.CRM_CLUE_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(jsonToList);
        }
        FlowUtil.saveOrSubmit((String)crmClueInfoCrForm.getTaskId(), (String)flowEngineId, (String)crmClueInfoCrForm.getTemplateId(), (String)mainId, (Object)((Object)crmClueInfoCrForm), (Integer)crmClueInfoCrForm.getStatus(), (String)entity.getName());
        if (crmClueInfoCrForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @PostMapping(value={"countByState"})
    public ActionResult countByState(@RequestBody CrmClueInfoPagination crmClueInfoPagination) {
        UserInfo userInfo = this.userProvider.get();
        crmClueInfoPagination.setState(CrmClueStateEnum.UNASSIGNED_STATE.getState());
        long unassigned = this.crmClueInfoService.countByState(crmClueInfoPagination);
        crmClueInfoPagination.setState(CrmClueStateEnum.ASSIGNED_STATE.getState());
        long assigned = this.crmClueInfoService.countByState(crmClueInfoPagination);
        crmClueInfoPagination.setState(CrmClueStateEnum.TRANSFERRED_STATE.getState());
        long transferred = this.crmClueInfoService.countByState(crmClueInfoPagination);
        crmClueInfoPagination.setState(CrmClueStateEnum.NULLIFY_STATE.getState());
        long nullify = this.crmClueInfoService.countByState(crmClueInfoPagination);
        crmClueInfoPagination.setState("");
        HashMap iCanWho = this.salesRoleUtils.getICanWho(userInfo);
        crmClueInfoPagination.setCompanyId(userInfo.getOrganizeId());
        if (!((Boolean)iCanWho.get("isAll")).booleanValue()) {
            List userIdList = (List)iCanWho.get("idList");
            crmClueInfoPagination.setUserIdList(userIdList);
        }
        long subordinate = this.crmClueInfoService.countByState(crmClueInfoPagination);
        crmClueInfoPagination.setCompanyId("");
        crmClueInfoPagination.setUserId(userInfo.getUserId());
        long my = this.crmClueInfoService.countByState(crmClueInfoPagination);
        crmClueInfoPagination.setCompanyId("");
        crmClueInfoPagination.setUserId("");
        long all = this.crmClueInfoService.countByState(crmClueInfoPagination);
        HashMap map = MapUtil.newHashMap();
        map.put("unassigned", unassigned);
        map.put("assigned", assigned);
        map.put("transferred", transferred);
        map.put("all", all);
        map.put("my", my);
        map.put("subordinate", subordinate);
        map.put("nullify", nullify);
        return ActionResult.success((Object)map);
    }

    @PostMapping(value={"countAmount"})
    public ActionResult countAmount(@RequestBody CrmClueInfoPagination crmClueInfoPagination) {
        long all = this.crmClueInfoService.countByState(crmClueInfoPagination);
        BigDecimal amount = this.crmClueInfoService.countAmount(crmClueInfoPagination);
        HashMap map = MapUtil.newHashMap();
        map.put("count", all);
        map.put("amount", amount);
        return ActionResult.success((Object)map);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmClueInfoInfoVO> info(@PathVariable(value="id") String id) {
        List<String> productList;
        List categoryEntityList;
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(id);
        CrmClueInfoInfoVO vo = (CrmClueInfoInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmClueInfoInfoVO.class);
        if (StrUtil.isNotBlank((CharSequence)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(productList = Arrays.asList(vo.getProductType().split(",")))))) {
            String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductTypeName(join);
        }
        List<RkAttachmentEntity> listByObjId = this.rkAttachmentService.getListByObjId(id);
        List jsonToList = JsonUtil.getJsonToList(listByObjId, RkAttachmentInfoVO.class);
        vo.setAttachmentList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmClueInfoInfoVO> detailInfo(@PathVariable(value="id") String id) {
        List<String> productList;
        List categoryEntityList;
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(id);
        CrmClueInfoInfoVO vo = (CrmClueInfoInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmClueInfoInfoVO.class);
        vo.setSource(this.baseDataUtil.getDictName(vo.getSource(), "crmClueSource"));
        vo.setCustomerType(this.baseDataUtil.getDictName(vo.getCustomerType(), "classification"));
        vo.setAddress(this.baseDataUtil.provinceData(vo.getAddress()));
        vo.setProjectStages(this.baseDataUtil.getDictName(vo.getProjectStages(), "ReportingProjectStage"));
        vo.setInvestWay(this.baseDataUtil.getDictName(vo.getInvestWay(), "investWay"));
        vo.setStateDesc(this.baseDataUtil.getDictName(vo.getState(), "crmClueState"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (StrUtil.isNotBlank((CharSequence)vo.getProductType()) && CollectionUtil.isNotEmpty((Collection)(categoryEntityList = this.crmProductCategoryService.listByIds(productList = Arrays.asList(vo.getProductType().split(",")))))) {
            String join = categoryEntityList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            vo.setProductType(join);
        }
        List<RkAttachmentEntity> listByObjId = this.rkAttachmentService.getListByObjId(id);
        List jsonToList = JsonUtil.getJsonToList(listByObjId, RkAttachmentInfoVO.class);
        vo.setAttachmentList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmClueInfoUpForm crmClueInfoUpForm) throws DataException, WorkFlowException {
        CrmClueInfoEntity entity;
        String flowEngineId = "550287967722159173";
        if (StrUtil.isNotBlank((CharSequence)crmClueInfoUpForm.getFlowId())) {
            flowEngineId = crmClueInfoUpForm.getFlowId();
        }
        if ((entity = this.crmClueInfoService.getInfo(id)) != null) {
            CrmClueInfoEntity subentity = (CrmClueInfoEntity)JsonUtil.getJsonToBean((Object)((Object)crmClueInfoUpForm), CrmClueInfoEntity.class);
            this.crmClueInfoService.update(id, subentity);
            this.rkAttachmentService.deleteByObjId(id);
            List jsonToList = JsonUtil.getJsonToList(crmClueInfoUpForm.getAttachmentList(), RkAttachmentEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)jsonToList)) {
                jsonToList.stream().forEach(att -> {
                    att.setId(RandomUtil.uuId());
                    att.setObjId(id);
                    att.setFileType(AttachmentTypeEnum.CRM_CLUE_TYPE.getType());
                });
                this.rkAttachmentService.saveBatch(jsonToList);
            }
            FlowUtil.saveOrSubmit((String)crmClueInfoUpForm.getTaskId(), (String)flowEngineId, (String)crmClueInfoUpForm.getTemplateId(), (String)id, (Object)((Object)crmClueInfoUpForm), (Integer)crmClueInfoUpForm.getStatus(), (String)subentity.getName());
            if (crmClueInfoUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.crmClueInfoService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"/edit/{id}"})
    public ActionResult edit(@PathVariable(value="id") String id, @RequestBody @Valid CrmClueInfoUpForm crmClueInfoUpForm) {
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(id);
        if (entity != null) {
            crmClueInfoUpForm.setId(id);
            CrmClueInfoEntity subentity = (CrmClueInfoEntity)JsonUtil.getJsonToBean((Object)((Object)crmClueInfoUpForm), CrmClueInfoEntity.class);
            this.crmClueInfoService.update(id, subentity);
            this.rkAttachmentService.deleteByObjId(id);
            List jsonToList = JsonUtil.getJsonToList(crmClueInfoUpForm.getAttachmentList(), RkAttachmentEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)jsonToList)) {
                jsonToList.stream().forEach(att -> {
                    att.setId(RandomUtil.uuId());
                    att.setObjId(id);
                    att.setFileType(AttachmentTypeEnum.CRM_CLUE_TYPE.getType());
                });
                this.rkAttachmentService.saveBatch(jsonToList);
            }
        } else {
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"/follow/{id}"})
    public ActionResult follow(@PathVariable(value="id") String id, @RequestBody @Valid CrmClueInfoUpForm crmClueInfoUpForm) {
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u8ddf\u8fdb\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        crmClueInfoUpForm.setId(id);
        this.crmClueInfoService.follow(crmClueInfoUpForm);
        return ActionResult.success((String)"\u8ddf\u8fdb\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"/assign/{id}"})
    public ActionResult assign(@PathVariable(value="id") String id, @RequestBody @Valid CrmClueAssignUpForm crmClueAssignUpForm) {
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u5206\u6d3e\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        crmClueAssignUpForm.setId(id);
        this.crmClueInfoService.assign(crmClueAssignUpForm);
        return ActionResult.success((String)"\u5206\u6d3e\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"nullify"})
    public ActionResult nullify(@RequestBody @Valid CrmClueNullifyUpForm crmClueNullifyUpForm) {
        CrmClueInfoEntity entity = this.crmClueInfoService.getInfo(crmClueNullifyUpForm.getId());
        if (entity == null) {
            return ActionResult.fail((String)"\u4f5c\u5e9f\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.crmClueInfoService.nullify(crmClueNullifyUpForm);
        return ActionResult.success((String)"\u4f5c\u5e9f\u6210\u529f");
    }

    @PostMapping(value={"statisticsSale"})
    public ActionResult statisticsSale(@RequestBody @Valid StatisticsSalePagination pagination) {
        List statisticsSale = this.crmClueInfoService.getStatisticsSale(pagination);
        for (Map vo : statisticsSale) {
            if (!StringUtils.isNotEmpty((String)vo.get("companyId").toString())) continue;
            vo.put("companyName", this.organizeService.getInfo(vo.get("companyId").toString()).getShortName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(statisticsSale);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"statisticsSale/export"})
    public ActionResult statisticsSale(@RequestBody @Valid StatisticsSalePaginationExportModel exportModel) {
        StatisticsSalePagination pagination = (StatisticsSalePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), StatisticsSalePagination.class));
        List statisticsSale = this.crmClueInfoService.getStatisticsSale(pagination);
        for (Map vo : statisticsSale) {
            if (!StringUtils.isNotEmpty((String)vo.get("companyId").toString())) continue;
            vo.put("companyName", this.organizeService.getInfo(vo.get("companyId").toString()).getShortName());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)statisticsSale, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StrUtil.isEmpty((CharSequence)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatSaleModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatSaleModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block36;
                    }
                    case "reallyName": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"reallyName"));
                        continue block36;
                    }
                    case "orgName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"orgName"));
                        continue block36;
                    }
                    case "clueTrendNum": {
                        ExcelExportEntity excelExportEntity11 = new ExcelExportEntity("\u8ddf\u8fdb\u7ebf\u7d22\u4e2a\u6570", (Object)"clueTrendNum");
                        excelExportEntity11.setType(10);
                        entitys.add(excelExportEntity11);
                        continue block36;
                    }
                    case "clueTrendTimes": {
                        ExcelExportEntity excelExportEntity1 = new ExcelExportEntity("\u8ddf\u8fdb\u7ebf\u7d22\u6b21\u6570", (Object)"clueTrendTimes");
                        excelExportEntity1.setType(10);
                        entitys.add(excelExportEntity1);
                        continue block36;
                    }
                    case "clueNum": {
                        ExcelExportEntity excelExportEntity2 = new ExcelExportEntity("\u65b0\u589e\u7ebf\u7d22\u4e2a\u6570", (Object)"clueNum");
                        excelExportEntity2.setType(10);
                        entitys.add(excelExportEntity2);
                        continue block36;
                    }
                    case "reportingTrendNum": {
                        ExcelExportEntity excelExportEntity3 = new ExcelExportEntity("\u8ddf\u8fdb\u5546\u673a\u4e2a\u6570", (Object)"reportingTrendNum");
                        excelExportEntity3.setType(10);
                        entitys.add(excelExportEntity3);
                        continue block36;
                    }
                    case "reportingTrendTimes": {
                        ExcelExportEntity excelExportEntity4 = new ExcelExportEntity("\u8ddf\u8fdb\u5546\u673a\u6b21\u6570", (Object)"reportingTrendTimes");
                        excelExportEntity4.setType(10);
                        entitys.add(excelExportEntity4);
                        continue block36;
                    }
                    case "reportingNum": {
                        ExcelExportEntity excelExportEntity5 = new ExcelExportEntity("\u65b0\u589e\u5546\u673a\u4e2a\u6570", (Object)"reportingNum");
                        excelExportEntity5.setType(10);
                        entitys.add(excelExportEntity5);
                        continue block36;
                    }
                    case "followNum": {
                        ExcelExportEntity excelExportEntity6 = new ExcelExportEntity("\u5916\u51fa\u62dc\u8bbf\u6b21\u6570", (Object)"followNum");
                        excelExportEntity6.setType(10);
                        entitys.add(excelExportEntity6);
                        continue block36;
                    }
                    case "dayNum": {
                        ExcelExportEntity excelExportEntity7 = new ExcelExportEntity("\u65e5\u62a5\u6b21\u6570", (Object)"dayNum");
                        excelExportEntity7.setType(10);
                        entitys.add(excelExportEntity7);
                        continue block36;
                    }
                    case "weekNum": {
                        ExcelExportEntity excelExportEntity8 = new ExcelExportEntity("\u5468\u62a5\u6b21\u6570", (Object)"weekNum");
                        excelExportEntity8.setType(10);
                        entitys.add(excelExportEntity8);
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u9500\u552e\u884c\u4e3a\u7edf\u8ba1");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9500\u552e\u884c\u4e3a\u7edf\u8ba1" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

