/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmClueTrendsEntity;
import com.bringspring.crm.model.crmcluetrends.CrmClueTrendsCrForm;
import com.bringspring.crm.model.crmcluetrends.CrmClueTrendsInfoVO;
import com.bringspring.crm.model.crmcluetrends.CrmClueTrendsListVO;
import com.bringspring.crm.model.crmcluetrends.CrmClueTrendsPagination;
import com.bringspring.crm.model.crmcluetrends.CrmClueTrendsUpForm;
import com.bringspring.crm.service.CrmClueTrendsService;
import com.bringspring.crm.util.CrmClueTrendsTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u7ebf\u7d22\u52a8\u6001"}, value="crm")
@RequestMapping(value={"/api/crm/CrmClueTrends"})
public class CrmClueTrendsController {
    private static final Logger log = LoggerFactory.getLogger(CrmClueTrendsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmClueTrendsService crmClueTrendsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmClueTrendsPagination crmClueTrendsPagination) throws IOException {
        List<CrmClueTrendsEntity> list = this.crmClueTrendsService.getList(crmClueTrendsPagination);
        for (CrmClueTrendsEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmClueTrendsListVO.class);
        for (CrmClueTrendsListVO crmClueTrendsListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmClueTrendsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getByClueId"})
    public ActionResult getByClueId(@RequestBody CrmClueTrendsPagination pagination) throws IOException {
        List<CrmClueTrendsEntity> list = this.crmClueTrendsService.getList(pagination);
        Map<String, CrmClueTrendsTypeEnum> allToMap = CrmClueTrendsTypeEnum.getAllToMap();
        List listVO = JsonUtil.getJsonToList(list, CrmClueTrendsListVO.class);
        for (CrmClueTrendsListVO crmClueTrendsVO : listVO) {
            String dicName = this.baseDataUtil.getDictName(crmClueTrendsVO.getFollowMethod(), "followMethod");
            if (StrUtil.isNotEmpty((CharSequence)dicName)) {
                crmClueTrendsVO.setFollowMethodName(dicName);
            }
            Integer trendType = StrUtil.equals((CharSequence)crmClueTrendsVO.getType(), (CharSequence)CrmClueTrendsTypeEnum.FOLLOW_TYPE.getType()) ? 1 : 100;
            crmClueTrendsVO.setTrendsType(trendType);
            if (ObjectUtil.equal((Object)crmClueTrendsVO.getTrendsType(), (Object)100)) {
                crmClueTrendsVO.setStageChangeDesc(crmClueTrendsVO.getDescription());
                crmClueTrendsVO.setDescription("");
            }
            if (ObjectUtil.isNotNull((Object)((Object)allToMap.get(crmClueTrendsVO.getType())))) {
                crmClueTrendsVO.setType(allToMap.get(crmClueTrendsVO.getType()).getDesc());
            }
            crmClueTrendsVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(crmClueTrendsVO.getCreatorUserId()));
        }
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid CrmClueTrendsCrForm crmClueTrendsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmClueTrendsEntity entity = (CrmClueTrendsEntity)JsonUtil.getJsonToBean((Object)crmClueTrendsCrForm, CrmClueTrendsEntity.class);
        entity.setId(mainId);
        this.crmClueTrendsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmClueTrendsInfoVO> info(@PathVariable(value="id") String id) {
        CrmClueTrendsEntity entity = this.crmClueTrendsService.getInfo(id);
        CrmClueTrendsInfoVO vo = (CrmClueTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmClueTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmClueTrendsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmClueTrendsEntity entity = this.crmClueTrendsService.getInfo(id);
        CrmClueTrendsInfoVO vo = (CrmClueTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmClueTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmClueTrendsUpForm crmClueTrendsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmClueTrendsEntity entity = this.crmClueTrendsService.getInfo(id);
        if (entity != null) {
            CrmClueTrendsEntity subentity = (CrmClueTrendsEntity)JsonUtil.getJsonToBean((Object)crmClueTrendsUpForm, CrmClueTrendsEntity.class);
            this.crmClueTrendsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmClueTrendsEntity entity = this.crmClueTrendsService.getInfo(id);
        if (entity != null) {
            this.crmClueTrendsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

