/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmCompetitorEntity;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorCrForm;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorInfoVO;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorListVO;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorPagination;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorPaginationExportModel;
import com.bringspring.crm.model.crmcompetitor.CrmCompetitorUpForm;
import com.bringspring.crm.service.CrmCompetitorService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ade\u4e89\u5bf9\u624b\u5e93"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCompetitor"})
public class CrmCompetitorController {
    private static final Logger log = LoggerFactory.getLogger(CrmCompetitorController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCompetitorService crmCompetitorService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCompetitorPagination crmCompetitorPagination) throws IOException {
        List<CrmCompetitorEntity> list = this.crmCompetitorService.getList(crmCompetitorPagination);
        for (CrmCompetitorEntity entity : list) {
            entity.setAdvantageState(this.baseDataUtil.getDictName(entity.getAdvantageState(), "advantageState"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCompetitorListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCompetitorPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCompetitorCrForm crmCompetitorCrForm) throws DataException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCompetitorEntity::getCompetitorName, (Object)crmCompetitorCrForm.getCompetitorName());
        queryWrapper.lambda().eq(CrmCompetitorEntity::getDeleteFlag, (Object)0);
        if (this.crmCompetitorService.getOne((Wrapper)queryWrapper) != null) {
            return ActionResult.fail((String)"\u7ade\u4e89\u5bf9\u624b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.crmCompetitorService.create(crmCompetitorCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmCompetitorPaginationExportModel crmCompetitorPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmCompetitorPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmCompetitorPagination crmCompetitorPagination = (CrmCompetitorPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmCompetitorPaginationExportModel), CrmCompetitorPagination.class));
        List<CrmCompetitorEntity> list = this.crmCompetitorService.getTypeList(crmCompetitorPagination, crmCompetitorPaginationExportModel.getDataType());
        for (CrmCompetitorEntity entity : list) {
            entity.setAdvantageState(this.baseDataUtil.getDictName(entity.getAdvantageState(), "advantageState"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCompetitorListVO.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmCompetitorPaginationExportModel.getSelectKey()) ? crmCompetitorPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            ExcelExportEntity entity = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "competitorName": {
                        entity = new ExcelExportEntity("\u7ade\u4e89\u5bf9\u624b\u540d\u79f0", (Object)"competitorName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block16;
                    }
                    case "advantageState": {
                        entity = new ExcelExportEntity("\u4f18\u52a3\u52bf", (Object)"advantageState");
                        entitys.add(entity);
                        continue block16;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCompetitorInfoVO> info(@PathVariable(value="id") String id) {
        CrmCompetitorEntity entity = this.crmCompetitorService.getInfo(id);
        CrmCompetitorInfoVO vo = (CrmCompetitorInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCompetitorInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCompetitorInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCompetitorEntity entity = this.crmCompetitorService.getInfo(id);
        CrmCompetitorInfoVO vo = (CrmCompetitorInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCompetitorInfoVO.class);
        vo.setAdvantageState(this.baseDataUtil.getDictName(vo.getAdvantageState(), "advantageState"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCompetitorUpForm crmCompetitorUpForm) throws DataException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCompetitorEntity::getCompetitorName, (Object)crmCompetitorUpForm.getCompetitorName());
        queryWrapper.lambda().eq(CrmCompetitorEntity::getDeleteFlag, (Object)0);
        queryWrapper.lambda().ne(CrmCompetitorEntity::getId, (Object)id);
        if (this.crmCompetitorService.getOne((Wrapper)queryWrapper) != null) {
            return ActionResult.fail((String)"\u7ade\u4e89\u5bf9\u624b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.crmCompetitorService.update(id, crmCompetitorUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCompetitorEntity entity = this.crmCompetitorService.getInfo(id);
        if (entity != null) {
            entity.setDeleteFlag(1);
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.crmCompetitorService.updateById(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

