/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmCopyrightEntity;
import com.bringspring.crm.entity.CrmFileEntity;
import com.bringspring.crm.model.crmcopyright.CrmCopyrightCrForm;
import com.bringspring.crm.model.crmcopyright.CrmCopyrightInfoVO;
import com.bringspring.crm.model.crmcopyright.CrmCopyrightListVO;
import com.bringspring.crm.model.crmcopyright.CrmCopyrightPagination;
import com.bringspring.crm.model.crmcopyright.CrmCopyrightPaginationExportModel;
import com.bringspring.crm.model.crmcopyright.CrmCopyrightUpForm;
import com.bringspring.crm.service.CrmCopyrightService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8457\u4f5c\u6743"}, value="example")
@RequestMapping(value={"/api/example/CrmCopyright"})
public class CrmCopyrightController {
    private static final Logger log = LoggerFactory.getLogger(CrmCopyrightController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCopyrightService crmCopyrightService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCopyrightPagination crmCopyrightPagination) throws IOException {
        List<CrmCopyrightEntity> list = this.crmCopyrightService.getList(crmCopyrightPagination);
        for (CrmCopyrightEntity crmCopyrightEntity : list) {
            crmCopyrightEntity.setDevelopmentManagerId(this.baseDataUtil.userSelectValues(crmCopyrightEntity.getDevelopmentManagerId()));
            crmCopyrightEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmCopyrightEntity.getCreatorUserId()));
            crmCopyrightEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmCopyrightEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCopyrightListVO.class);
        for (CrmCopyrightListVO vo : listVO) {
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getCompanyId(), "companyName"));
        }
        for (CrmCopyrightListVO crmCopyrightVO : listVO) {
            List attList = JsonUtil.getJsonToList((String)crmCopyrightVO.getAttachments(), CrmFileEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)attList)) {
                crmCopyrightVO.setAttachmentsStatus("\u5df2\u4e0a\u4f20");
                continue;
            }
            crmCopyrightVO.setAttachmentsStatus("\u672a\u4e0a\u4f20");
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCopyrightPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmCopyrightCrForm crmCopyrightCrForm) throws DataException {
        this.crmCopyrightService.create(crmCopyrightCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmCopyrightPaginationExportModel crmCopyrightPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmCopyrightPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmCopyrightPagination crmCopyrightPagination = (CrmCopyrightPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmCopyrightPaginationExportModel), CrmCopyrightPagination.class));
        List<CrmCopyrightEntity> list = this.crmCopyrightService.getTypeList(crmCopyrightPagination, crmCopyrightPaginationExportModel.getDataType());
        for (CrmCopyrightEntity crmCopyrightEntity : list) {
            crmCopyrightEntity.setDevelopmentManagerId(this.baseDataUtil.userSelectValues(crmCopyrightEntity.getDevelopmentManagerId()));
            crmCopyrightEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmCopyrightEntity.getCreatorUserId()));
            crmCopyrightEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmCopyrightEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCopyrightListVO.class);
        for (CrmCopyrightListVO crmCopyrightVO : listVO) {
            crmCopyrightVO.setRightsGetMethodId(this.baseDataUtil.getDictName(crmCopyrightVO.getRightsGetMethodId(), "crmCopyrightGetMethod"));
            crmCopyrightVO.setRightsRangeIds(this.baseDataUtil.getDictName(crmCopyrightVO.getRightsRangeIds(), "crmCopyrightRangeOptions"));
            List attList = JsonUtil.getJsonToList((String)crmCopyrightVO.getAttachments(), CrmFileEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)attList)) {
                crmCopyrightVO.setAttachmentsStatus("\u5df2\u4e0a\u4f20");
            } else {
                crmCopyrightVO.setAttachmentsStatus("\u672a\u4e0a\u4f20");
            }
            crmCopyrightVO.setProductIds(this.baseDataUtil.getDictName(crmCopyrightVO.getProductIds(), "JcProjectProductData"));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmCopyrightPaginationExportModel.getSelectKey()) ? crmCopyrightPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "productIds": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u540d\u79f0", (Object)"productIds"));
                        continue block54;
                    }
                    case "softwareName": {
                        entitys.add(new ExcelExportEntity("\u8f6f\u4ef6\u540d\u79f0", (Object)"softwareName"));
                        continue block54;
                    }
                    case "copyrightOwner": {
                        entitys.add(new ExcelExportEntity("\u8457\u4f5c\u6743\u4eba", (Object)"copyrightOwner"));
                        continue block54;
                    }
                    case "issueNumber": {
                        entitys.add(new ExcelExportEntity("\u8bc1\u4e66\u53f7", (Object)"issueNumber"));
                        continue block54;
                    }
                    case "issueDate": {
                        entitys.add(new ExcelExportEntity("\u53d1\u8bc1\u65e5\u671f", (Object)"issueDate"));
                        continue block54;
                    }
                    case "copyrightCount": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"copyrightCount"));
                        continue block54;
                    }
                    case "storageNumber": {
                        entitys.add(new ExcelExportEntity("\u5b58\u653e\u7f16\u53f7", (Object)"storageNumber"));
                        continue block54;
                    }
                    case "rightsGetMethodId": {
                        entitys.add(new ExcelExportEntity("\u6743\u5229\u83b7\u5f97\u65b9\u5f0f", (Object)"rightsGetMethodId"));
                        continue block54;
                    }
                    case "rightsRangeIds": {
                        entitys.add(new ExcelExportEntity("\u6743\u5229\u8303\u56f4", (Object)"rightsRangeIds"));
                        continue block54;
                    }
                    case "developmentManagerId": {
                        entitys.add(new ExcelExportEntity("\u5f00\u53d1\u8d1f\u8d23\u4eba", (Object)"developmentManagerId"));
                        continue block54;
                    }
                    case "developmentCompletionDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u53d1\u5b8c\u6210\u65e5\u671f", (Object)"developmentCompletionDate"));
                        continue block54;
                    }
                    case "publicationDate": {
                        entitys.add(new ExcelExportEntity("\u53d1\u8868\u65e5\u671f", (Object)"publicationDate"));
                        continue block54;
                    }
                    case "registrationNo": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u53f7", (Object)"registrationNo"));
                        continue block54;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block54;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u4eba", (Object)"creatorUserId"));
                        continue block54;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u65e5\u671f", (Object)"creatorTime"));
                        continue block54;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block54;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block54;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block54;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block54;
                    }
                    case "attachmentsStatus": {
                        entitys.add(new ExcelExportEntity("\u4e0a\u4f20\u72b6\u6001", (Object)"attachmentsStatus"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCopyrightInfoVO> info(@PathVariable(value="id") String id) {
        CrmCopyrightEntity entity = this.crmCopyrightService.getInfo(id);
        CrmCopyrightInfoVO vo = (CrmCopyrightInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCopyrightInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setProductName(this.baseDataUtil.getDictName(vo.getProductIds(), "JcProjectProductData"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCopyrightInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCopyrightEntity entity = this.crmCopyrightService.getInfo(id);
        CrmCopyrightInfoVO vo = (CrmCopyrightInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCopyrightInfoVO.class);
        vo.setDevelopmentManagerId(this.baseDataUtil.userSelectValues(vo.getDevelopmentManagerId()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setProductName(this.baseDataUtil.getDictName(vo.getProductIds(), "JcProjectProductData"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCopyrightUpForm crmCopyrightUpForm) throws DataException {
        this.crmCopyrightService.update(id, crmCopyrightUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCopyrightEntity entity = this.crmCopyrightService.getInfo(id);
        if (entity != null) {
            this.crmCopyrightService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

