/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerUserRelationEntity;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsCrForm;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsCrFormBatch;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsInfoVO;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsListVO;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsPagination;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsPaginationExportModel;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsUpForm;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmCustomerUserRelationService;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u8054\u7cfb\u4eba"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerContacts"})
public class CrmCustomerContactsController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerContactsController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmCustomerUserRelationService crmCustomerUserRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkAgentService rkAgentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerContactsPagination crmCustomerContactsPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List<CrmCustomerContactsEntity> list = this.crmCustomerContactsService.getList(crmCustomerContactsPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerContactsListVO.class);
        for (CrmCustomerContactsListVO crmCustomerContactsListVO : listVO) {
            CrmCustomerEntity crmCustomerEntity;
            if (!ObjectUtil.isEmpty((Object)crmCustomerContactsListVO.getCreatorUserId()) && crmCustomerContactsListVO.getCreatorUserId().equals(userInfo.getUserId())) {
                crmCustomerContactsListVO.setEnabledMark("1");
            }
            if (!ObjectUtil.isEmpty((Object)crmCustomerContactsListVO.getCustomerId()) && !ObjectUtil.isEmpty((Object)(crmCustomerEntity = this.crmCustomerContactsService.getCrmCustomer(crmCustomerContactsListVO.getCustomerId())))) {
                crmCustomerContactsListVO.setCustomerName(crmCustomerEntity.getName());
            }
            crmCustomerContactsListVO.setGender(this.baseDataUtil.getDictName(crmCustomerContactsListVO.getGender(), "sex"));
            crmCustomerContactsListVO.setCreatorUserName(this.baseDataUtil.userSelectValue(crmCustomerContactsListVO.getCreatorUserId()));
            crmCustomerContactsListVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(crmCustomerContactsListVO.getLastModifyUserId()));
            crmCustomerContactsListVO.setClassificationDesc(this.baseDataUtil.getDictName(crmCustomerContactsListVO.getClassification(), "contactClassification"));
            crmCustomerContactsListVO.setOriginalCreatorUserName(this.baseDataUtil.userSelectValue(crmCustomerContactsListVO.getOriginalCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerContactsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByCustomerId"})
    public ActionResult getListByCustomerId(@RequestBody CrmCustomerContactsPagination crmCustomerContactsPagination) throws IOException {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.equals((CharSequence)"agent", (CharSequence)crmCustomerContactsPagination.getCustomerSource())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getAgentId, (Object)crmCustomerContactsPagination.getAgentId());
        } else {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)crmCustomerContactsPagination.getCustomerId());
        }
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getIsBlock, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.eq(CrmCustomerContactsEntity::getPublicMark, (Object)DeleteMarkEnum.DELETED.getCode());
        })).or(q -> q.eq(CrmCustomerContactsEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())));
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getProjectId())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getProjectId, (Object)crmCustomerContactsPagination.getProjectId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerSource())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerSource, (Object)crmCustomerContactsPagination.getCustomerSource());
        }
        List list = this.crmCustomerContactsService.list((Wrapper)queryWrapper);
        List listVO = JsonUtil.getJsonToList((Object)list, CrmCustomerContactsListVO.class);
        for (CrmCustomerContactsListVO vo : listVO) {
            UserEntity info;
            vo.setClassificationDesc(this.baseDataUtil.getDictName(vo.getClassification(), "contactClassification"));
            vo.setNameNoDept(vo.getName());
            if (!StringUtils.isNotEmpty((String)vo.getCreatorUserId()) || !ObjectUtil.isNotEmpty((Object)(info = this.userService.getInfo(vo.getCreatorUserId())))) continue;
            vo.setCreatorUserName(info.getRealName());
        }
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/getListByProjectId/{projectId}"})
    public ActionResult getListByProjectId(@PathVariable(value="projectId") String projectId) throws IOException {
        List<CrmCustomerContactsEntity> list = this.crmCustomerContactsService.getListByProjectId(projectId);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerContactsListVO.class);
        for (CrmCustomerContactsListVO vo : listVO) {
            vo.setClassificationDesc(this.baseDataUtil.getDictName(vo.getClassification(), "contactClassification"));
        }
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerContactsCrForm crmCustomerContactsCrForm) throws DataException {
        RkAgentEntity agentEntity;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerContactsEntity entity = (CrmCustomerContactsEntity)JsonUtil.getJsonToBean((Object)crmCustomerContactsCrForm, CrmCustomerContactsEntity.class);
        entity.setId(mainId);
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setOriginalCreatorUserId(userInfo.getUserId());
        entity.setCustomerSource(ObjectUtil.isEmpty((Object)crmCustomerContactsCrForm.getCustomerSource()) ? "crm" : crmCustomerContactsCrForm.getCustomerSource());
        entity.setCompanyId(userInfo.getOrganizeId());
        if (ObjectUtil.isNotEmpty((Object)entity.getAgentId()) && ObjectUtil.isNotEmpty((Object)(agentEntity = (RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)entity.getAgentId()))))) {
            entity.setAgentManagerId(agentEntity.getParentId());
        }
        this.crmCustomerContactsService.save(entity);
        List list = this.crmCustomerUserRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmCustomerUserRelationEntity::getCustomerId, (Object)crmCustomerContactsCrForm.getCustomerId())).eq(CrmCustomerUserRelationEntity::getUserId, (Object)userInfo.getUserId()));
        if (ObjectUtil.isEmpty((Object)list)) {
            CrmCustomerUserRelationEntity attentionEntity = new CrmCustomerUserRelationEntity();
            String mainIdAttention = RandomUtil.uuId();
            attentionEntity.setId(mainIdAttention);
            attentionEntity.setCustomerId(crmCustomerContactsCrForm.getCustomerId());
            attentionEntity.setUserId(userInfo.getUserId());
            attentionEntity.setCreatorTime(DateUtil.getNowDate());
            attentionEntity.setCreatorUserId(userInfo.getUserId());
            attentionEntity.setEnabledMark(0);
            this.crmCustomerUserRelationService.save(attentionEntity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @Transactional
    @PostMapping(value={"/createLinkMan"})
    public ActionResult createLinkMan(@RequestBody @Valid CrmCustomerContactsCrForm crmCustomerContactsCrForm) throws DataException {
        if (ObjectUtil.isNotEmpty(crmCustomerContactsCrForm.getLinkManList())) {
            UserInfo userInfo = this.userProvider.get();
            List list = this.crmCustomerContactsService.listByIds(crmCustomerContactsCrForm.getLinkManList());
            if (ObjectUtil.isNotEmpty((Object)list)) {
                for (CrmCustomerContactsEntity man : list) {
                    CrmCustomerContactsEntity entity = (CrmCustomerContactsEntity)JsonUtil.getJsonToBean((Object)man, CrmCustomerContactsEntity.class);
                    entity.setId(RandomUtil.uuId());
                    entity.setProjectId(crmCustomerContactsCrForm.getProjectId());
                    entity.setCustomerId(crmCustomerContactsCrForm.getCustomerId());
                    entity.setCreatorTime(DateUtil.getNowDate());
                    entity.setCreatorUserId(userInfo.getUserId());
                    entity.setOriginalCreatorUserId(userInfo.getUserId());
                    this.crmCustomerContactsService.save(entity);
                }
            }
        }
        return ActionResult.success((String)"\u6210\u529f");
    }

    @PostMapping(value={"/batchSave"})
    @DSTransactional
    public ActionResult createBatch(@RequestBody @Valid CrmCustomerContactsCrFormBatch crmCustomerContactsCrFormBatch) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isEmpty(crmCustomerContactsCrFormBatch.getVisitcontactList())) {
            return ActionResult.fail((String)"\u8bf7\u586b\u5199\u8054\u7cfb\u4eba\u4fe1\u606f");
        }
        List contactsEntityList = JsonUtil.getJsonToList(crmCustomerContactsCrFormBatch.getVisitcontactList(), CrmCustomerContactsEntity.class);
        for (CrmCustomerContactsEntity entity : contactsEntityList) {
            entity.setId(RandomUtil.uuId());
            entity.setCreatorTime(DateUtil.getNowDate());
            entity.setCustomerSource(crmCustomerContactsCrFormBatch.getCustomerSource());
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCustomerId(crmCustomerContactsCrFormBatch.getCustomerId());
            entity.setOriginalCreatorUserId(userInfo.getUserId());
        }
        this.crmCustomerContactsService.saveBatch(contactsEntityList);
        List list = this.crmCustomerUserRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmCustomerUserRelationEntity::getCustomerId, (Object)crmCustomerContactsCrFormBatch.getCustomerId())).eq(CrmCustomerUserRelationEntity::getUserId, (Object)userInfo.getUserId()));
        if (ObjectUtil.isEmpty((Object)list)) {
            CrmCustomerUserRelationEntity attentionEntity = new CrmCustomerUserRelationEntity();
            String mainIdAttention = RandomUtil.uuId();
            attentionEntity.setId(mainIdAttention);
            attentionEntity.setCustomerId(crmCustomerContactsCrFormBatch.getCustomerId());
            attentionEntity.setUserId(userInfo.getUserId());
            attentionEntity.setCreatorTime(DateUtil.getNowDate());
            attentionEntity.setCreatorUserId(userInfo.getUserId());
            attentionEntity.setEnabledMark(0);
            this.crmCustomerUserRelationService.save(attentionEntity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmCustomerContactsPaginationExportModel crmCustomerContactsPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmCustomerContactsPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        UserInfo userInfo = this.userProvider.get();
        List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
        List roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        List listByIds = this.roleService.getListByIds(roleIds);
        List collect = listByIds.stream().map(PermissionEntityBase::getEnCode).collect(Collectors.toList());
        if (collect.contains("AfterSalesPersonnel")) {
            crmCustomerContactsPaginationExportModel.setIsAfterSalesPersonnel(1);
        }
        if (userInfo.getUserId().equals("admin")) {
            crmCustomerContactsPaginationExportModel.setIsAfterSalesPersonnel(1);
        }
        CrmCustomerContactsPagination crmCustomerContactsPagination = (CrmCustomerContactsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmCustomerContactsPaginationExportModel), CrmCustomerContactsPagination.class));
        List<CrmCustomerContactsEntity> list = this.crmCustomerContactsService.getTypeList(crmCustomerContactsPagination, crmCustomerContactsPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerContactsListVO.class);
        for (CrmCustomerContactsListVO crmCustomerContactsVO : listVO) {
            CrmCustomerEntity crmCustomerEntity;
            if (!ObjectUtil.isEmpty((Object)crmCustomerContactsVO.getCustomerId()) && !ObjectUtil.isEmpty((Object)(crmCustomerEntity = this.crmCustomerContactsService.getCrmCustomer(crmCustomerContactsVO.getCustomerId())))) {
                crmCustomerContactsVO.setCustomerId(crmCustomerEntity.getName());
            }
            crmCustomerContactsVO.setGender(this.baseDataUtil.getDictName(crmCustomerContactsVO.getGender(), "sex"));
            crmCustomerContactsVO.setCreatorUserId(this.baseDataUtil.userSelectValue(crmCustomerContactsVO.getCreatorUserId()));
            crmCustomerContactsVO.setClassification(this.baseDataUtil.getDictName(crmCustomerContactsVO.getClassification()));
            if (ObjectUtil.isEmpty((Object)crmCustomerContactsVO.getLastModifyTime())) {
                crmCustomerContactsVO.setLastModifyTime(crmCustomerContactsVO.getCreatorTime());
            }
            if (crmCustomerContactsVO.getPublicMark().equals("1")) {
                crmCustomerContactsVO.setPublicMark("\u662f");
                continue;
            }
            crmCustomerContactsVO.setPublicMark("\u5426");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmCustomerContactsPaginationExportModel.getSelectKey()) ? crmCustomerContactsPaginationExportModel.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u59d3\u540d", (Object)"name"));
                        continue block30;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237", (Object)"customerId"));
                        continue block30;
                    }
                    case "phone": {
                        entitys.add(new ExcelExportEntity("\u624b\u673a\u53f7\u7801", (Object)"phone"));
                        continue block30;
                    }
                    case "gender": {
                        entitys.add(new ExcelExportEntity("\u6027\u522b", (Object)"gender"));
                        continue block30;
                    }
                    case "post": {
                        entitys.add(new ExcelExportEntity("\u804c\u52a1", (Object)"post"));
                        continue block30;
                    }
                    case "publicMark": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u516c\u5f00", (Object)"publicMark"));
                        continue block30;
                    }
                    case "classification": {
                        entitys.add(new ExcelExportEntity("\u5206\u7c7b", (Object)"classification"));
                        continue block30;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block30;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8054\u7cfb\u4eba\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8054\u7cfb\u4eba\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerContactsInfoVO> info(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerContactsEntity entity = this.crmCustomerContactsService.getInfo(id);
        CrmCustomerContactsInfoVO vo = (CrmCustomerContactsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerContactsInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)vo.getCreatorUserId()) && vo.getCreatorUserId().equals(userInfo.getUserId())) {
            vo.setEnabledMark("1");
        }
        if (ObjectUtil.isEmpty((Object)vo.getIsInspect())) {
            vo.setIsInspect("1");
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerContactsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerContactsEntity entity = this.crmCustomerContactsService.getInfo(id);
        CrmCustomerContactsInfoVO vo = (CrmCustomerContactsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerContactsInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)vo.getCreatorUserId())) {
            vo.setCreatorUserId(this.baseDataUtil.userSelectValues(vo.getCreatorUserId()));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerContactsUpForm crmCustomerContactsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerContactsEntity entity = this.crmCustomerContactsService.getInfo(id);
        if (entity != null) {
            CrmCustomerContactsEntity subentity = (CrmCustomerContactsEntity)JsonUtil.getJsonToBean((Object)crmCustomerContactsUpForm, CrmCustomerContactsEntity.class);
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(DateUtil.getNowDate());
            this.crmCustomerContactsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/setDefault"})
    @DSTransactional
    public ActionResult setDefault(@RequestBody CrmCustomerContactsUpForm crmCustomerContactsUpForm) throws DataException {
        CrmCustomerContactsPagination crmCustomerContactsPagination = new CrmCustomerContactsPagination();
        crmCustomerContactsPagination.setCustomerId(crmCustomerContactsPagination.getCustomerId());
        List<CrmCustomerContactsEntity> list = this.crmCustomerContactsService.getList(crmCustomerContactsPagination);
        list.stream().forEach(item -> item.setPublicMark(0));
        this.crmCustomerContactsService.updateBatchById(list);
        CrmCustomerContactsEntity entity = new CrmCustomerContactsEntity();
        entity.setPublicMark(1);
        entity.setId(crmCustomerContactsUpForm.getId());
        boolean b = this.crmCustomerContactsService.updateById(entity);
        if (b) {
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerContactsEntity entity = this.crmCustomerContactsService.getInfo(id);
        if (entity != null) {
            this.crmCustomerContactsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getListByAgentId"})
    public ActionResult getListByAgentId(@RequestBody CrmCustomerContactsPagination crmCustomerContactsPagination) throws IOException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(CrmCustomerContactsEntity::getAgentId, (Object)crmCustomerContactsPagination.getAgentId())).or()).eq(CrmCustomerContactsEntity::getAgentManagerId, (Object)crmCustomerContactsPagination.getAgentId());
        });
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getIsBlock, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.eq(CrmCustomerContactsEntity::getPublicMark, (Object)DeleteMarkEnum.DELETED.getCode());
        })).or(q -> q.eq(CrmCustomerContactsEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId())));
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getProjectId())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getProjectId, (Object)crmCustomerContactsPagination.getProjectId());
        }
        if (StringUtils.isNotEmpty((String)crmCustomerContactsPagination.getCustomerSource())) {
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerSource, (Object)crmCustomerContactsPagination.getCustomerSource());
        }
        List list = this.crmCustomerContactsService.list((Wrapper)queryWrapper);
        List listVO = JsonUtil.getJsonToList((Object)list, CrmCustomerContactsListVO.class);
        for (CrmCustomerContactsListVO vo : listVO) {
            UserEntity info;
            vo.setClassificationDesc(this.baseDataUtil.getDictName(vo.getClassification(), "contactClassification"));
            vo.setNameNoDept(vo.getName());
            if (!StringUtils.isNotEmpty((String)vo.getCreatorUserId()) || !ObjectUtil.isNotEmpty((Object)(info = this.userService.getInfo(vo.getCreatorUserId())))) continue;
            vo.setCreatorUserName(info.getRealName());
        }
        return ActionResult.success((Object)listVO);
    }

    @PutMapping(value={"/connectContactResource"})
    public ActionResult connectContactResource(@RequestBody CrmDepartConnectEntity connectEntity) {
        if (ObjectUtil.isEmpty((Object)connectEntity)) {
            return ActionResult.fail((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        List<CrmCustomerContactsEntity> crmCustomerContactsEntities = this.crmCustomerContactsService.connectContactResource(connectEntity);
        if (ObjectUtil.isNotEmpty(crmCustomerContactsEntities)) {
            return ActionResult.success((String)"\u4ea4\u63a5\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4ea4\u63a5\u5931\u8d25");
    }
}

