/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.controller.CrmCustomerUserRelationController;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmCustomerCompanyRelationEntity;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerMyEntity;
import com.bringspring.crm.entity.CrmCustomerUserRelationEntity;
import com.bringspring.crm.entity.CrmFollowInformationEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.entity.UserListVoExtendUserEntity;
import com.bringspring.crm.model.authorizeaddress.PaginationUserAddress;
import com.bringspring.crm.model.authorizeaddress.UserListVOAddress;
import com.bringspring.crm.model.crm_sales_chance.CrmFollowInformationModel;
import com.bringspring.crm.model.crmcustomer.CrmCustomerCrForm;
import com.bringspring.crm.model.crmcustomer.CrmCustomerInfoVO;
import com.bringspring.crm.model.crmcustomer.CrmCustomerListVO;
import com.bringspring.crm.model.crmcustomer.CrmCustomerPagination;
import com.bringspring.crm.model.crmcustomer.CrmCustomerPaginationExportModel;
import com.bringspring.crm.model.crmcustomer.CrmCustomerUpForm;
import com.bringspring.crm.model.crmcustomer.CustomerExportVO;
import com.bringspring.crm.model.crmcustomer.CustomerImportVO;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsCrForm;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsInfoVO;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerMyService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmCustomerUserRelationService;
import com.bringspring.crm.service.CrmFollowInformationService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.util.CrmClueStateEnum;
import com.bringspring.crm.util.CrmConstants;
import com.bringspring.crm.util.LngAndLatUtil;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.model.user.page.PaginationUser;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.AMapUtils;
import com.bringspring.utils.ParamAddress;
import com.bringspring.visit.address.AdInfo;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.utils.JingWeiUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomer"})
public class CrmCustomerController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private CrmFollowInformationService crmFollowInformationService;
    @Autowired
    private CrmCustomerUserRelationController crmCustomerUserRelationController;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private CrmCustomerUserRelationService crmCustomerUserRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmCustomerCompanyRelationService crmCustomerCompanyRelationService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private CrmCustomerMyService crmCustomerMyService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private AMapUtils aMapUtils;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerPagination crmCustomerPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List<CrmCustomerEntity> list = CollectionUtil.list((boolean)false);
        list = StrUtil.isNotEmpty((CharSequence)crmCustomerPagination.getSource()) && StrUtil.equals((CharSequence)crmCustomerPagination.getSource(), (CharSequence)"app") && ObjectUtil.isEmpty((Object)crmCustomerPagination.getCreatorUserId()) ? this.crmCustomerService.getListBySql(crmCustomerPagination) : this.crmCustomerService.getList(crmCustomerPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerListVO.class);
        List listAttention = this.crmCustomerUserRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmCustomerUserRelationEntity::getUserId, (Object)userInfo.getUserId()));
        List ids = listAttention.stream().map(CrmCustomerUserRelationEntity::getCustomerId).collect(Collectors.toList());
        List<CrmCustomerMyEntity> listByUserId = this.crmCustomerMyService.getListByUserId(userInfo.getUserId());
        Set collect2 = listByUserId.stream().map(CrmCustomerMyEntity::getCustomerId).collect(Collectors.toSet());
        Map<String, Integer> collect3 = listByUserId.stream().collect(Collectors.toMap(CrmCustomerMyEntity::getCustomerId, CrmCustomerMyEntity::getCustomerType));
        List unmodifiableList = userInfo.getSubordinateIds();
        List addressList = null;
        DictionaryDataEntity dictData = null;
        for (CrmCustomerListVO vo : listVO) {
            List<CrmCustomerCompanyRelationEntity> byCustomerAndCompanyIdAndSource;
            List crmProductRelationlist;
            vo.setAddressName(this.baseDataUtil.provinceData(vo.getAddress()));
            if (StringUtils.isNotEmpty((String)vo.getAddress()) && (addressList = JSON.parseArray((String)vo.getAddress(), String.class)).size() >= 1) {
                vo.setProvSimpleName(this.provinceService.getInfo((String)addressList.get(1)).getProvSimpleName());
            }
            vo.setConduct(this.baseDataUtil.getDictName(vo.getConduct(), "EnterpriseNature"));
            vo.setGradeCode(vo.getGrade());
            if (StringUtils.isNotEmpty((String)vo.getGrade()) && null != (dictData = this.dictionaryDataService.getInfo(vo.getGrade()))) {
                vo.setGradeEnCode(dictData.getEnCode());
            }
            vo.setGrade(this.baseDataUtil.getDictName(vo.getGrade(), "CustomerGrade"));
            vo.setType(this.baseDataUtil.getDictName(vo.getType(), "CustomerType"));
            if (ids.contains(vo.getId())) {
                vo.setFlagAttention("true");
            }
            if (collect2.contains(vo.getId())) {
                vo.setMyCustomer(1);
                if (CollectionUtil.isNotEmpty(collect3) && ObjectUtil.isNotNull((Object)collect3.get(vo.getId()))) {
                    vo.setMyCustomerType(collect3.get(vo.getId()));
                }
            } else {
                vo.setMyCustomer(0);
            }
            if (!ObjectUtil.isEmpty((Object)crmCustomerPagination.getSuboId())) {
                ArrayList sboIds = new ArrayList();
                sboIds.addAll(unmodifiableList);
                List list1 = this.crmCustomerUserRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmCustomerUserRelationEntity::getCustomerId, (Object)vo.getId()));
                List listUserIds = list1.stream().map(CrmCustomerUserRelationEntity::getUserId).collect(Collectors.toList());
                boolean b = sboIds.retainAll(listUserIds);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < sboIds.size(); ++i) {
                    if (i != sboIds.size() - 1) {
                        stringBuilder.append(this.baseDataUtil.userSelectValue((String)sboIds.get(i)));
                        stringBuilder.append(",");
                        continue;
                    }
                    stringBuilder.append(this.baseDataUtil.userSelectValue((String)sboIds.get(i)));
                }
                vo.setShowAttentionUserId(stringBuilder.toString());
            }
            if (!ObjectUtil.isEmpty((Object)(crmProductRelationlist = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)vo.getId()))))) {
                List<String> collect = crmProductRelationlist.stream().map(CrmProductRelationEntity::getProductId).collect(Collectors.toList());
                List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(collect);
                String collect1 = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                vo.setRelationProduct(collect1);
                for (CrmProductRelationEntity relation : crmProductRelationlist) {
                    if (!ObjectUtil.isNotEmpty((Object)relation) || 1 != relation.getIsInspect()) continue;
                    vo.setIsInspect(relation.getIsInspect());
                }
            } else {
                vo.setRelationProduct("");
                vo.setIsInspect(0);
            }
            if (!CollectionUtil.isNotEmpty(byCustomerAndCompanyIdAndSource = this.crmCustomerCompanyRelationService.getByCustomerAndCompanyIdAndSource(vo.getId(), null, null))) continue;
            ArrayList<String> companyList = new ArrayList<String>();
            ArrayList<String> companyIdList = new ArrayList<String>();
            for (CrmCustomerCompanyRelationEntity relationEntity : byCustomerAndCompanyIdAndSource) {
                if (ObjectUtil.isEmpty((Object)relationEntity)) continue;
                companyIdList.add(relationEntity.getCompanyId());
                String key = "redis:company:" + relationEntity.getCompanyId();
                Object string = this.cacheUtil.query("tenMinutesCacheSpace", key);
                OrganizeEntity info = null;
                if (ObjectUtil.isEmpty((Object)string)) {
                    info = this.organizeService.getInfo(relationEntity.getCompanyId());
                    this.cacheUtil.insert("tenMinutesCacheSpace", key, (Object)info, 600L);
                } else {
                    info = (OrganizeEntity)JsonUtil.getJsonToBean((String)String.valueOf(string), OrganizeEntity.class);
                }
                if (ObjectUtil.isEmpty((Object)info) || !StringUtils.isNotEmpty((String)info.getPropertyJson())) continue;
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                companyList.add(jsonToBean.getShortName());
            }
            vo.setBelongCompany(companyList.stream().distinct().collect(Collectors.toList()));
            vo.setBelongCompanys(CollectionUtil.join(vo.getBelongCompany(), (CharSequence)","));
            vo.setBelongCompanyIds(CollectionUtil.join(companyIdList, (CharSequence)","));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @NotCheckLogin
    @GetMapping(value={"/listBylngAndLat"})
    public ActionResult listBylngAndLat(String lng, String lat, String keyword) {
        List<CrmCustomerEntity> list;
        AdInfo adInfo = null;
        if (StrUtil.isNotEmpty((CharSequence)lng) && StrUtil.isNotEmpty((CharSequence)lat)) {
            adInfo = JingWeiUtil.getAddress(lat, lng);
        }
        String prov = "";
        String city = "";
        if (ObjectUtil.isNotNull(adInfo)) {
            prov = adInfo.getProvinceId();
            city = adInfo.getCityId();
        }
        if (CollectionUtil.isEmpty(list = this.crmCustomerService.getListByCompanyAndProvAndCity(prov, city, lng, lat, keyword))) {
            list = this.crmCustomerService.getListByCompanyAndProvAndCity(prov, "", lng, lat, keyword);
        }
        return ActionResult.success(list);
    }

    @NotCheckLogin
    @GetMapping(value={"/listBylngAndLatTrajectory"})
    public ActionResult listBylngAndLatTrajectory(String lng, String lat, String keyword) {
        List<CrmCustomerEntity> list;
        AdInfo adInfo = null;
        if (StrUtil.isNotEmpty((CharSequence)lng) && StrUtil.isNotEmpty((CharSequence)lat)) {
            adInfo = JingWeiUtil.getAddress(lat, lng);
        }
        String prov = "";
        String city = "";
        if (ObjectUtil.isNotNull(adInfo)) {
            prov = adInfo.getProvinceId();
            city = adInfo.getCityId();
        }
        if (CollectionUtil.isEmpty(list = this.crmCustomerService.getListBylngAndLatTrajectory(prov, city, lng, lat, keyword))) {
            list = this.crmCustomerService.getListBylngAndLatTrajectory(prov, "", lng, lat, keyword);
        }
        return ActionResult.success(list);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerCrForm crmCustomerCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "361860553754283269";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerEntity entity = (CrmCustomerEntity)JsonUtil.getJsonToBean((Object)((Object)crmCustomerCrForm), CrmCustomerEntity.class);
        String[] split = entity.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
        String collectAddr = Arrays.stream(split).filter(i -> i.length() == 4).collect(Collectors.joining());
        QueryWrapper customerQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)customerQueryWrapper.lambda().likeRight(CrmCustomerEntity::getSystemCode, (Object)collectAddr)).last("order by SUBSTRING_INDEX(system_code,'-',-1)*1 desc limit 1");
        CrmCustomerEntity one = (CrmCustomerEntity)this.crmCustomerService.getOne((Wrapper)customerQueryWrapper);
        Long i2 = Long.valueOf(one.getSystemCode().replace("-", "")) + 1L;
        StringBuilder str = new StringBuilder(i2.toString());
        entity.setSystemCode(str.insert(6, "-").toString());
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setEnabledMark("resource");
        entity.setId(mainId);
        entity.setPinyin(PinyinUtil.getFirstLetter((String)entity.getName(), (String)"").toUpperCase());
        String geocode = this.aMapUtils.getGeocode(entity.getName());
        if (!StrUtil.isBlank((CharSequence)geocode)) {
            String[] split2 = geocode.split(",");
            entity.setAddressLongitude(split2[0]);
            entity.setAddressLatitude(split2[1]);
        }
        this.crmCustomerService.save(entity);
        if (!ObjectUtil.isEmpty(crmCustomerCrForm.getCrmcustomerList())) {
            List<CrmCustomerContactsCrForm> crmcustomerList = crmCustomerCrForm.getCrmcustomerList();
            List listContacts = JsonUtil.getJsonToList(crmcustomerList, CrmCustomerContactsEntity.class);
            listContacts.stream().forEach(v -> {
                v.setCustomerId(mainId);
                v.setOriginalCreatorUserId(userInfo.getUserId());
            });
            this.crmCustomerContactsService.saveOrUpdateBatch(listContacts);
        }
        if (ObjectUtil.isEmpty((Object)crmCustomerCrForm.getWetherNeedFlow())) {
            FlowUtil.saveOrSubmit((String)crmCustomerCrForm.getTaskId(), (String)flowEngineId, (String)crmCustomerCrForm.getTemplateId(), (String)mainId, (Object)((Object)crmCustomerCrForm), (Integer)crmCustomerCrForm.getStatus());
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)mainId);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List personList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, CustomerExportVO.class);
        Map<String, Object> map = this.crmCustomerService.importPreview(personList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<CustomerImportVO> ImportData(@RequestBody CustomerExportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), CustomerExportVO.class);
        List<CrmCustomerEntity> customerEntities = this.crmCustomerService.importData(dataList);
        CustomerImportVO customerImportVO = new CustomerImportVO();
        customerImportVO.setSnum(customerEntities.size());
        customerImportVO.setFnum(customerEntities.size());
        customerImportVO.setFailResult(customerEntities);
        customerImportVO.setResultType(1);
        boolean b = this.crmCustomerService.saveBatch(customerEntities, customerEntities.size());
        if (b) {
            return ActionResult.success((Object)customerImportVO);
        }
        return ActionResult.fail((String)"");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmCustomerPaginationExportModel crmCustomerPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmCustomerPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmCustomerPagination crmCustomerPagination = (CrmCustomerPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmCustomerPaginationExportModel), CrmCustomerPagination.class));
        List<CrmCustomerEntity> list = this.crmCustomerService.getTypeList(crmCustomerPagination, crmCustomerPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerListVO.class);
        for (CrmCustomerListVO vo : listVO) {
            vo.setAddressName(this.baseDataUtil.provinceData(vo.getAddress()));
            vo.setGrade(this.baseDataUtil.getDictName(vo.getGrade(), "CustomerGrade"));
            if (StrUtil.equals((CharSequence)vo.getEnabledMark(), (CharSequence)"company")) {
                List crmProductRelationlist = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getCustomerId, (Object)vo.getId()));
                if (!ObjectUtil.isEmpty((Object)crmProductRelationlist)) {
                    List<String> collect = crmProductRelationlist.stream().map(CrmProductRelationEntity::getProductId).collect(Collectors.toList());
                    List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(collect);
                    String collect1 = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                    vo.setRelationProduct(collect1);
                } else {
                    vo.setRelationProduct("\u5426");
                }
                List<CrmCustomerCompanyRelationEntity> byCustomerAndCompanyIdAndSource = this.crmCustomerCompanyRelationService.getByCustomerAndCompanyIdAndSource(vo.getId(), null, null);
                if (CollectionUtil.isNotEmpty(byCustomerAndCompanyIdAndSource)) {
                    ArrayList<String> companyList = new ArrayList<String>();
                    for (CrmCustomerCompanyRelationEntity relationEntity : byCustomerAndCompanyIdAndSource) {
                        if (ObjectUtil.isEmpty((Object)relationEntity)) continue;
                        String key = "redis:company:" + relationEntity.getCompanyId();
                        Object string = this.cacheUtil.query("tenMinutesCacheSpace", key);
                        OrganizeEntity info = null;
                        if (ObjectUtil.isEmpty((Object)string)) {
                            info = this.organizeService.getInfo(relationEntity.getCompanyId());
                            this.cacheUtil.insert("tenMinutesCacheSpace", key, (Object)info, 600L);
                        } else {
                            info = (OrganizeEntity)JsonUtil.getJsonToBean((String)String.valueOf(string), OrganizeEntity.class);
                        }
                        if (ObjectUtil.isEmpty((Object)info) || !StringUtils.isNotEmpty((String)info.getPropertyJson())) continue;
                        OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), OrganizeCrModel.class);
                        companyList.add(jsonToBean.getShortName());
                    }
                    vo.setBelongCompany(companyList.stream().distinct().collect(Collectors.toList()));
                    vo.setBelongCompanys(CollectionUtil.join(vo.getBelongCompany(), (CharSequence)","));
                }
            } else {
                vo.setRelationProduct("\u5426");
            }
            if (StringUtils.equals((CharSequence)vo.getEnabledMark(), (CharSequence)"company")) {
                vo.setEnabledMark("\u516c\u53f8\u5ba2\u6237");
            } else if (StringUtils.equals((CharSequence)vo.getEnabledMark(), (CharSequence)"lead")) {
                vo.setEnabledMark("\u6f5c\u5728\u5ba2\u6237");
            } else {
                vo.setEnabledMark("\u8d44\u6e90\u6c60\u5ba2\u6237");
            }
            if (StringUtils.equals((CharSequence)vo.getClassificationCode(), (CharSequence)"medicalUser")) {
                vo.setIsMedicalUser("\u662f");
                continue;
            }
            vo.setIsMedicalUser("\u5426");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmCustomerPaginationExportModel.getSelectKey()) ? crmCustomerPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block42: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u673a\u6784\u7f16\u7801", (Object)"code"));
                        continue block42;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"belongCompanys"));
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"name"));
                        continue block42;
                    }
                    case "isMedicalUser": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u662f\u533b\u7597\u7528\u6237", (Object)"isMedicalUser"));
                        continue block42;
                    }
                    case "relationProduct": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5173\u8054\u4ea7\u54c1", (Object)"relationProduct"));
                        continue block42;
                    }
                    case "alias": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u522b\u540d", (Object)"alias"));
                        continue block42;
                    }
                    case "aliasQuery": {
                        entitys.add(new ExcelExportEntity("\u522b\u540d\u67e5\u8be2", (Object)"aliasQuery"));
                        continue block42;
                    }
                    case "conduct": {
                        entitys.add(new ExcelExportEntity("\u7ecf\u8425\u6027\u8d28", (Object)"conduct"));
                        continue block42;
                    }
                    case "grade": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7b49\u7ea7", (Object)"grade"));
                        continue block42;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u7c7b\u578b", (Object)"type"));
                        continue block42;
                    }
                    case "contactDescripts": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u65b9\u5f0f", (Object)"contactDescripts"));
                        continue block42;
                    }
                    case "email": {
                        entitys.add(new ExcelExportEntity("\u90ae\u7bb1\u5730\u5740", (Object)"email"));
                        continue block42;
                    }
                    case "website": {
                        entitys.add(new ExcelExportEntity("\u7f51\u7ad9\u5730\u5740", (Object)"website"));
                        continue block42;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u91cd\u70b9\u63cf\u8ff0", (Object)"description"));
                        continue block42;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block42;
                    }
                    case "addressName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u5730\u5740", (Object)"addressName"));
                        continue block42;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerInfoVO> info(@PathVariable(value="id") String id) {
        String userId = this.userProvider.get().getUserId();
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return ActionResult.success((Object)new CrmCustomerInfoVO());
        }
        if (!ObjectUtil.isEmpty((Object)entity.getCreatorUserId())) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setCollaboratorId(this.baseDataUtil.userSelectValue(entity.getCollaboratorId()));
        }
        CrmCustomerInfoVO vo = (CrmCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerInfoVO.class);
        vo.setAddressName(this.selectValues.areaSelectValues(entity.getAddress()));
        List<CrmCustomerContactsEntity> contactsEntities = this.crmCustomerService.getContactByCustomeId(id);
        vo.setCrmCustomerList(JsonUtil.getJsonToList(contactsEntities, CrmCustomerContactsInfoVO.class));
        QueryWrapper queryWrapperCrmFollowInformation = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapperCrmFollowInformation.lambda().eq(CrmFollowInformationEntity::getSourceId, (Object)entity.getId())).orderByDesc(CrmFollowInformationEntity::getCreatorTime);
        List listFollow = this.crmFollowInformationService.list((Wrapper)queryWrapperCrmFollowInformation);
        if (!ObjectUtil.isEmpty((Object)listFollow)) {
            vo.setCrmFollowInformationModelList(JsonUtil.getJsonToList((Object)listFollow, CrmFollowInformationModel.class));
            vo.getCrmFollowInformationModelList().stream().forEach(item -> item.setCreatorTimeFormat(DateUtil.dateFormat((Date)item.getCreatorTime())));
        }
        vo.setConductName(this.baseDataUtil.getDictName(entity.getConduct(), "EnterpriseNature"));
        vo.setGradeCode(entity.getGrade());
        vo.setGradeName(this.baseDataUtil.getDictName(entity.getGrade(), "CustomerGrade"));
        vo.setTypeName(this.baseDataUtil.getDictName(entity.getType(), "CustomerType"));
        vo.setClassificationName(this.baseDataUtil.getDictName(entity.getClassification(), "classification"));
        List list = this.crmCustomerUserRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmCustomerUserRelationEntity::getCustomerId, (Object)entity.getId())).eq(CrmCustomerUserRelationEntity::getUserId, (Object)userId));
        if (list.size() > 0) {
            vo.setFlagAttention(true);
        } else {
            vo.setFlagAttention(false);
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        CrmCustomerInfoVO vo = (CrmCustomerInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @NotCheckLogin
    @ApiOperation(value="\u540c\u6b65\u5ba2\u6237\u7ecf\u7eac\u5ea6\u4fe1\u606f")
    @GetMapping(value={"/syncLngLat/{ajaxtimestamp}"})
    public ActionResult syncLngLat(@PathVariable(value="ajaxtimestamp") String ajaxtimestamp) {
        this.crmCustomerService.updateLongLatQuery(ajaxtimestamp);
        return ActionResult.success();
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        CrmCustomerUpForm crmCustomerUpForm = (CrmCustomerUpForm)((Object)JsonUtil.getJsonToBean(upData, CrmCustomerUpForm.class));
        String flowEngineId = "361860553754283269";
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        if (entity != null) {
            CrmCustomerEntity subentity = (CrmCustomerEntity)JsonUtil.getJsonToBean((Object)((Object)crmCustomerUpForm), CrmCustomerEntity.class);
            String geocode = this.aMapUtils.getGeocode(subentity.getName());
            if (!StrUtil.isBlank((CharSequence)geocode)) {
                String[] split2 = geocode.split(",");
                subentity.setAddressLongitude(split2[0]);
                subentity.setAddressLatitude(split2[1]);
            }
            this.crmCustomerService.update(id, subentity);
            QueryWrapper Crm_customer_contactsqueryWrapper = new QueryWrapper();
            Crm_customer_contactsqueryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)entity.getId());
            this.crmCustomerContactsService.remove((Wrapper)Crm_customer_contactsqueryWrapper);
            List Crm_customer_contactsList = JsonUtil.getJsonToList(crmCustomerUpForm.getCrmcustomerList(), CrmCustomerContactsEntity.class);
            for (CrmCustomerContactsEntity entitys : Crm_customer_contactsList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setCustomerId(entity.getId());
                entitys.setOriginalCreatorUserId(userInfo.getUserId());
                this.crmCustomerContactsService.save(entitys);
            }
            if (ObjectUtil.isEmpty((Object)crmCustomerUpForm.getWetherNeedFlow())) {
                FlowUtil.saveOrSubmit((String)crmCustomerUpForm.getTaskId(), (String)flowEngineId, (String)crmCustomerUpForm.getTemplateId(), (String)id, (Object)((Object)crmCustomerUpForm), (Integer)crmCustomerUpForm.getStatus());
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/updateSomeData/{id}"})
    @DSTransactional
    public ActionResult updateSomeData(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException {
        CrmCustomerUpForm crmCustomerUpForm = (CrmCustomerUpForm)((Object)JsonUtil.getJsonToBean(upData, CrmCustomerUpForm.class));
        String flowEngineId = "361860553754283269";
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        if (entity != null) {
            CrmCustomerEntity subentity = (CrmCustomerEntity)JsonUtil.getJsonToBean((Object)((Object)crmCustomerUpForm), CrmCustomerEntity.class);
            this.crmCustomerService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/markeCustomer/{id}"})
    @DSTransactional
    public ActionResult markeCustomer(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException {
        CrmCustomerUpForm crmCustomerUpForm = (CrmCustomerUpForm)((Object)JsonUtil.getJsonToBean(upData, CrmCustomerUpForm.class));
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        if (entity != null) {
            entity.setAddressFlag(crmCustomerUpForm.getAddressFlag());
            this.crmCustomerService.update(id, entity);
            return ActionResult.success((String)"\u6807\u8bb0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u6807\u8bb0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        boolean b = this.crmCustomerService.judgeCorrelativeData(id);
        if (b) {
            if (entity != null) {
                FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    try {
                        FlowUtil.delete((String)id);
                    }
                    catch (WorkFlowException e) {
                        e.printStackTrace();
                    }
                }
                this.crmCustomerService.delete(entity);
                QueryWrapper queryWrapperCrm_customer_contacts = new QueryWrapper();
                queryWrapperCrm_customer_contacts.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)entity.getId());
                this.crmCustomerContactsService.remove((Wrapper)queryWrapperCrm_customer_contacts);
                QueryWrapper customerRelationEntityQueryWrapper = new QueryWrapper();
                customerRelationEntityQueryWrapper.lambda().eq(CrmCustomerUserRelationEntity::getCustomerId, (Object)entity.getId());
                this.crmCustomerUserRelationService.remove((Wrapper)customerRelationEntityQueryWrapper);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ActionResult.success((String)"failed");
    }

    public void change() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.select(new String[0]).ne((Object)"code", (Object)"null")).ne((Object)"code", (Object)"None")).ne((Object)"code", (Object)"Muti");
        List list = this.crmCustomerService.list((Wrapper)queryWrapper);
        int num = 0;
        for (CrmCustomerEntity crmCustomerEntity : list) {
            boolean update = this.crmCustomerService.update(crmCustomerEntity.getId(), crmCustomerEntity);
            System.out.println(update);
            ++num;
        }
        System.out.println(num);
    }

    @PostMapping(value={"/transferCustomer"})
    public ActionResult transferCustomer(@RequestBody List<CrmCustomerCrForm> crmCustomerCrForm) throws IOException {
        List crmCustomerEntities = JsonUtil.getJsonToList(crmCustomerCrForm, CrmCustomerEntity.class);
        boolean b = this.crmCustomerService.updateBatchById(crmCustomerEntities);
        return ActionResult.success((Object)b);
    }

    @GetMapping(value={"/getInfoByCode/{code}"})
    @DSTransactional
    public ActionResult getInfoByCode(@PathVariable(value="code") String code) {
        List<CrmCustomerEntity> infoByCode = this.crmCustomerService.getInfoByCode(code);
        if (infoByCode.size() > 0) {
            return ActionResult.success((String)"replication");
        }
        return ActionResult.success((String)"failed");
    }

    @GetMapping(value={"/getInfoByName/{name}"})
    @DSTransactional
    public ActionResult getInfoByName(@PathVariable(value="name") String name) {
        List<String> infoByCode = this.crmCustomerService.getInfoByName(name);
        if (infoByCode.size() > 0) {
            return ActionResult.success((String)"replication");
        }
        return ActionResult.success((String)"failed");
    }

    @PostMapping(value={"/markCustomerAddress"})
    public ActionResult markCustomerAddress(@RequestBody HashMap<String, String> map) {
        if (ObjectUtil.isEmpty(map)) {
            return ActionResult.fail((String)"\u53c2\u6570\u9519\u8bef");
        }
        String id = map.get("id");
        String type = map.get("type");
        CrmCustomerEntity entity = this.crmCustomerService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        entity.setAddressFlag(StrUtil.equals((CharSequence)type, (CharSequence)"mark") ? 1 : 0);
        this.crmCustomerService.update(id, entity);
        return ActionResult.success((String)"\u6807\u8bb0\u6210\u529f");
    }

    @GetMapping(value={"/generateSystemCode/{address}"})
    public ActionResult generateSystemCode(@PathVariable(value="address") String address) throws IOException {
        String s = this.crmCustomerService.generateSystemCode(address);
        return ActionResult.success((String)s);
    }

    @PostMapping(value={"/lngAndLat"})
    public ActionResult lngAndLat(@RequestBody CrmCustomerPagination crmCustomerPagination) throws IOException {
        List<CrmCustomerEntity> list = this.crmCustomerService.getList(crmCustomerPagination);
        ArrayList<CrmCustomerEntity> newList = new ArrayList<CrmCustomerEntity>();
        for (CrmCustomerEntity crmCustomerEntity : list) {
            String urlContent;
            if (!StringUtils.isNotEmpty((String)crmCustomerEntity.getDetailAddress()) || StringUtils.isNull((Object)(urlContent = LngAndLatUtil.getURLContent(crmCustomerEntity.getDetailAddress()))) || urlContent.length() < 20) continue;
            String r = JSONObject.parseObject((String)urlContent).getString("result");
            System.out.println(r);
            if (StringUtils.isNull((Object)r)) continue;
            String location = JSONObject.parseObject((String)r).getString("location");
            String lng = JSONObject.parseObject((String)location).getString("lng");
            String lat = JSONObject.parseObject((String)location).getString("lat");
            String adInfo = JSONObject.parseObject((String)r).getString("ad_info");
            String adcode = JSONObject.parseObject((String)adInfo).getString("adcode");
            crmCustomerEntity.setAddressLatitude(lat);
            crmCustomerEntity.setAddressLongitude(lng);
            crmCustomerEntity.setAddressAdcode(adcode);
            newList.add(crmCustomerEntity);
        }
        System.out.println(newList);
        boolean b = this.crmCustomerService.updateBatchById(newList, newList.size());
        return ActionResult.success((String)"\u6210\u529f\uff01");
    }

    @GetMapping(value={"/authorizeAddressGetListNew"})
    public ActionResult<PageListVO<UserListVOAddress>> authorizeAddressGetListNew(@ParamAddress(field="address", multiple=false) PaginationUserAddress pagination) {
        UserInfo userInfo = this.userProvider.get();
        PaginationUser paginationUser = (PaginationUser)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationUser.class);
        List userRelationIdList = CollectionUtil.list((boolean)false);
        if (StrUtil.isNotEmpty((CharSequence)pagination.getAlreadyAuthorizeType())) {
            List listByObjectId = this.userRelationService.getListByObjectId(null, pagination.getAlreadyAuthorizeType());
            if (CollectionUtil.isEmpty((Collection)listByObjectId)) {
                PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationUser, PaginationVO.class);
                return ActionResult.page((List)CollectionUtil.list((boolean)false), (PaginationVO)paginationVO);
            }
            userRelationIdList = listByObjectId.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        }
        List userList = this.userService.authorizeAddressGetList(paginationUser, pagination.getOrganizeFlag(), Boolean.valueOf(false));
        if (CollectionUtil.isNotEmpty((Collection)userRelationIdList)) {
            List finalUserRelationIdList = userRelationIdList;
            userList = userList.stream().filter(s -> finalUserRelationIdList.contains(s.getId())).collect(Collectors.toList());
        }
        ArrayList<UserListVOAddress> list = new ArrayList<UserListVOAddress>();
        for (UserEntity userEntity : userList) {
            UserListVOAddress userVO;
            List listByObjectType;
            List arealist;
            UserListVoExtendUserEntity userListVoExtendUserEntity = (UserListVoExtendUserEntity)((Object)JsonUtil.getJsonToBean((Object)userEntity, UserListVoExtendUserEntity.class));
            if (!StrUtil.isBlank((CharSequence)pagination.getAlreadyAuthorize()) && !ObjectUtil.isEmpty((Object)(arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)pagination.getAlreadyAuthorizeType())).eq(UserRelationEntity::getUserId, (Object)userEntity.getId()))))) {
                List collect = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
                ArrayList<String> addressList = new ArrayList<String>();
                addressList.add(this.baseDataUtil.provinceGroupData(collect.toString()));
                userListVoExtendUserEntity.setAddressList(StringUtils.join(addressList, (String)","));
            }
            if (CollectionUtil.isNotEmpty((Collection)(listByObjectType = this.userRelationService.getListByObjectType(userEntity.getId(), pagination.getAlreadyAuthorizeType() + "Manager")))) {
                userListVoExtendUserEntity.setAreaManagerFlag("0");
            } else {
                userListVoExtendUserEntity.setAreaManagerFlag("1");
            }
            if (StrUtil.equals((CharSequence)pagination.getAlreadyAuthorizeType(), (CharSequence)"Area")) {
                if (StrUtil.contains((CharSequence)userListVoExtendUserEntity.getRoleId(), (CharSequence)CrmConstants.SALES_MANAGER)) {
                    userListVoExtendUserEntity.setSaleAreaManagerFlag("0");
                } else {
                    userListVoExtendUserEntity.setSaleAreaManagerFlag("1");
                }
            }
            if ((userVO = (UserListVOAddress)JsonUtil.getJsonToBean((Object)((Object)userListVoExtendUserEntity), UserListVOAddress.class)).getEnabledMark() != 0 && Objects.nonNull(userListVoExtendUserEntity.getUnlockTime()) && userListVoExtendUserEntity.getUnlockTime().getTime() > System.currentTimeMillis()) {
                userVO.setEnabledMark(2);
            }
            List orgRelationByUserId = this.userRelationService.getAllOrgRelationByUserId(userListVoExtendUserEntity.getId());
            StringBuilder organize = new StringBuilder();
            for (UserRelationEntity userRelationEntity : orgRelationByUserId) {
                String organizeIdTree;
                OrganizeEntity entity = this.organizeService.getInfo(userRelationEntity.getObjectId());
                if (entity == null || !StringUtil.isNotEmpty((String)(organizeIdTree = entity.getOrganizeIdTree()))) continue;
                String[] orgId = organizeIdTree.split(",");
                List organizeName = this.organizeService.getOrganizeNameSort(Arrays.asList(orgId));
                StringBuilder orgName = new StringBuilder();
                for (OrganizeEntity organizeEntity : organizeName) {
                    orgName.append("/" + organizeEntity.getFullName());
                }
                if (orgName.length() <= 0) continue;
                organize.append(";" + orgName.toString().replaceFirst("/", ""));
            }
            if (organize.length() > 0) {
                userVO.setOrganize(organize.toString().replaceFirst(";", ""));
            }
            list.add(userVO);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationUser, PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/authorizeAddressGetList"})
    public ActionResult<PageListVO<UserListVOAddress>> authorizeAddressGetList(PaginationUserAddress pagination) {
        UserInfo userInfo = this.userProvider.get();
        PaginationUser paginationUser = (PaginationUser)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationUser.class);
        List userList = this.userService.authorizeAddressGetList(paginationUser, pagination.getOrganizeFlag(), Boolean.valueOf(false));
        List<Object> list = new ArrayList();
        for (UserEntity userEntity : userList) {
            List arealist;
            UserListVoExtendUserEntity userListVoExtendUserEntity = (UserListVoExtendUserEntity)((Object)JsonUtil.getJsonToBean((Object)userEntity, UserListVoExtendUserEntity.class));
            if (!StrUtil.isBlank((CharSequence)pagination.getAlreadyAuthorize()) && !ObjectUtil.isEmpty((Object)(arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)userEntity.getId()))))) {
                List collect = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
                ArrayList<String> addressList = new ArrayList<String>();
                for (String s : collect) {
                    addressList.add(this.baseDataUtil.provinceData(s));
                }
                userListVoExtendUserEntity.setAddressList(StringUtils.join(addressList, (String)","));
            }
            if (StrUtil.contains((CharSequence)userListVoExtendUserEntity.getRoleId(), (CharSequence)CrmConstants.SALES_MANAGER)) {
                userListVoExtendUserEntity.setAreaManagerFlag("0");
            } else {
                userListVoExtendUserEntity.setAreaManagerFlag("1");
            }
            if (StrUtil.contains((CharSequence)userListVoExtendUserEntity.getRoleId(), (CharSequence)"501682437869490309")) {
                userListVoExtendUserEntity.setAfterAreaManagerFlag("0");
            } else {
                userListVoExtendUserEntity.setAfterAreaManagerFlag("1");
            }
            UserListVOAddress userVO = (UserListVOAddress)JsonUtil.getJsonToBean((Object)((Object)userListVoExtendUserEntity), UserListVOAddress.class);
            if (userVO.getEnabledMark() != 0 && Objects.nonNull(userListVoExtendUserEntity.getUnlockTime()) && userListVoExtendUserEntity.getUnlockTime().getTime() > System.currentTimeMillis()) {
                userVO.setEnabledMark(2);
            }
            List orgRelationByUserId = this.userRelationService.getAllOrgRelationByUserId(userListVoExtendUserEntity.getId());
            StringBuilder organize = new StringBuilder();
            for (UserRelationEntity userRelationEntity : orgRelationByUserId) {
                String organizeIdTree;
                OrganizeEntity entity = this.organizeService.getInfo(userRelationEntity.getObjectId());
                if (entity == null || !StringUtil.isNotEmpty((String)(organizeIdTree = entity.getOrganizeIdTree()))) continue;
                String[] orgId = organizeIdTree.split(",");
                List organizeName = this.organizeService.getOrganizeNameSort(Arrays.asList(orgId));
                StringBuilder orgName = new StringBuilder();
                for (OrganizeEntity organizeEntity : organizeName) {
                    orgName.append("/" + organizeEntity.getFullName());
                }
                if (orgName.length() <= 0) continue;
                organize.append(";" + orgName.toString().replaceFirst("/", ""));
            }
            if (organize.length() > 0) {
                userVO.setOrganize(organize.toString().replaceFirst(";", ""));
            }
            list.add(userVO);
        }
        if (StringUtils.equals((CharSequence)pagination.getSource(), (CharSequence)"after")) {
            if (!ObjectUtil.isEmpty(list)) {
                list = list.stream().sorted(Comparator.comparing(UserListVOAddress::getAfterAreaManagerFlag)).collect(Collectors.toList());
            }
        } else if (!(StrUtil.isBlank((CharSequence)pagination.getAlreadyAuthorize()) || StrUtil.isBlank((CharSequence)pagination.getAlreadyAuthorize()) || ObjectUtil.isEmpty(list))) {
            list = list.stream().sorted(Comparator.comparing(UserListVOAddress::getAreaManagerFlag)).collect(Collectors.toList());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationUser, PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"getClueAndReportingNameByCustomerId/{customerId}"})
    public ActionResult getClueAndReportingNameByCustomerId(@PathVariable(value="customerId") String customerId) {
        List list = CollectionUtil.list((boolean)false, (Object[])new Integer[]{-1});
        List<RkProjectReportingEntity> reportingList = this.rkProjectReportingService.getListByCustomerIdAndWinOrLoseIn(customerId, list);
        List clueStateList = CollectionUtil.list((boolean)false, (Object[])new String[]{CrmClueStateEnum.UNASSIGNED_STATE.getState(), CrmClueStateEnum.ASSIGNED_STATE.getState(), CrmClueStateEnum.TRANSFERRED_STATE.getState()});
        List<CrmClueInfoEntity> clueList = this.crmClueInfoService.getListByCustomerIdAndStateIn(customerId, clueStateList);
        List reportingName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.toList());
        List clueName = clueList.stream().map(CrmClueInfoEntity::getName).collect(Collectors.toList());
        List allList = CollectionUtil.list((boolean)false);
        allList.addAll(reportingName);
        allList.addAll(clueName);
        HashMap map = MapUtil.newHashMap();
        map.put("name", CollectionUtil.join((Iterable)allList, (CharSequence)","));
        map.put("clue", CollectionUtil.join(clueName, (CharSequence)","));
        map.put("reporting", CollectionUtil.join(reportingName, (CharSequence)","));
        return ActionResult.success((Object)map);
    }

    @GetMapping(value={"CoordinateTransform"})
    public ActionResult CoordinateTransform() {
        this.crmCustomerService.CoordinateTransform();
        return ActionResult.success();
    }
}

