/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.controller.CrmCustomerLogsController;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmCustomerFollowEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityEntity;
import com.bringspring.crm.model.crmCustomerLogs.CrmCustomerLogsCrForm;
import com.bringspring.crm.model.crmcustomerfollow.CrmCustomerFollowCrForm;
import com.bringspring.crm.model.crmcustomerfollow.CrmCustomerFollowListVO;
import com.bringspring.crm.model.crmcustomerfollow.CrmCustomerFollowPagination;
import com.bringspring.crm.model.crmcustomerfollow.CrmCustomerFollowPaginationExportModel;
import com.bringspring.crm.model.crmcustomerfollow.CrmCustomerFollowUpForm;
import com.bringspring.crm.service.CrmCustomerFollowService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ddf\u8fdb\u8bb0\u5f55"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerFollow"})
public class CrmCustomerFollowController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerFollowController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerFollowService crmCustomerFollowService;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmCustomerLogsController crmCustomerLogsController;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerFollowPagination crmCustomerFollowPagination) throws IOException {
        List<CrmCustomerFollowEntity> list = this.crmCustomerFollowService.getList(crmCustomerFollowPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerFollowListVO.class);
        listVO.stream().forEach(item -> {
            item.setCustomerName(this.selectValues.cusSelectValues(item.getCustomerId()));
            item.setSourceTypeName(this.baseDataUtil.getDictName(item.getSourceType(), "377053838701528261"));
            item.setFollowTypeName(this.baseDataUtil.getDictName(item.getFollowType(), "367315761724653573"));
            item.setFollowConName(this.selectValues.cusConSelectValues(item.getFollowUser(), (CrmCustomerFollowListVO)item));
            item.setFollowTimeFormat(DateUtil.dateFormat((Date)item.getFollowTime()));
            item.setCreatorTimeFormat(ObjectUtil.isEmpty((Object)item.getCreatorTime()) ? null : DateUtil.daFormat((Date)item.getCreatorTime()));
        });
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerFollowPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByCustomerId"})
    public ActionResult getListByCustomerId(@RequestBody CrmCustomerFollowPagination crmCustomerFollowPagination) throws IOException {
        List<CrmCustomerFollowEntity> list = this.crmCustomerFollowService.getListByCustomerId(crmCustomerFollowPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerFollowListVO.class);
        listVO.stream().forEach(item -> {
            CrmCustomerEntity byId;
            item.setFollowUserName(this.baseDataUtil.userSelectValues(item.getFollowUserId()));
            item.setAvatar(this.userService.getInfo(item.getFollowUserId()).getHeadIcon());
            item.setFollowTypeName(this.baseDataUtil.getDictName(item.getFollowType(), "367315761724653573"));
            item.setSourceTypeName(this.baseDataUtil.getDictName(item.getSourceType(), "377053838701528261"));
            if (!ObjectUtil.isEmpty((Object)item.getCreatorTime())) {
                item.setCreatorTimeFormat(DateUtil.daFormat((Date)item.getCreatorTime()));
            }
            if ("sales".equals(item.getSourceType())) {
                CrmCustomerOpportunityEntity byId2 = (CrmCustomerOpportunityEntity)this.crmCustomerOpportunityService.getById((Serializable)((Object)item.getSalesId()));
                if (!ObjectUtil.isEmpty((Object)byId2)) {
                    item.setSourceTypeNames(byId2.getCustomerId());
                }
            } else if ("customer".equals(item.getSourceType()) && !ObjectUtil.isEmpty((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)item.getCustomerId()))))) {
                item.setSourceTypeNames(byId.getName());
            }
        });
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerFollowCrForm crmCustomerFollowCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerFollowEntity entity = (CrmCustomerFollowEntity)JsonUtil.getJsonToBean((Object)crmCustomerFollowCrForm, CrmCustomerFollowEntity.class);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setFollowUserId(userInfo.getUserId());
        entity.setId(mainId);
        this.crmCustomerFollowService.save(entity);
        if ("customer".equals(crmCustomerFollowCrForm.getSourceType())) {
            CrmCustomerLogsCrForm crmCustomerLogsEntity = new CrmCustomerLogsCrForm();
            crmCustomerLogsEntity.setCustomerId(mainId);
            crmCustomerLogsEntity.setJson(JSONObject.toJSONString((Object)entity));
            crmCustomerLogsEntity.setType("10");
            String followContent = "\u65b0\u589e\u8ddf\u8fdb\uff1a" + entity.getFollowContent();
            crmCustomerLogsEntity.setDescription(followContent);
            crmCustomerLogsEntity.setEnabledMark(0);
            crmCustomerLogsEntity.setCreatorTime(new Date());
            crmCustomerLogsEntity.setCreatorUserId(userInfo.getUserId());
            this.crmCustomerLogsController.create(crmCustomerLogsEntity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmCustomerFollowPaginationExportModel crmCustomerFollowPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmCustomerFollowPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmCustomerFollowPagination crmCustomerFollowPagination = (CrmCustomerFollowPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmCustomerFollowPaginationExportModel), CrmCustomerFollowPagination.class));
        List<CrmCustomerFollowEntity> list = this.crmCustomerFollowService.getTypeList(crmCustomerFollowPagination, crmCustomerFollowPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerFollowListVO.class);
        for (CrmCustomerFollowListVO item : listVO) {
            item.setCustomerName(this.selectValues.cusSelectValues(item.getCustomerId()));
            item.setSourceTypeName(this.baseDataUtil.getDictName(item.getSourceType(), "377053838701528261"));
            item.setFollowTypeName(this.baseDataUtil.getDictName(item.getFollowType(), "367315761724653573"));
            item.setFollowConName(this.selectValues.cusConSelectValues(item.getFollowUser(), item));
            item.setFollowTimeFormat(DateUtil.dateFormat((Date)item.getFollowTime()));
            item.setCreatorTimeFormat(ObjectUtil.isEmpty((Object)item.getCreatorTime()) ? null : DateUtil.daFormat((Date)item.getCreatorTime()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmCustomerFollowPaginationExportModel.getSelectKey()) ? crmCustomerFollowPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block44;
                    }
                    case "sourceType": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u6765\u6e90(\u7ebf\u7d22\u3001\u5546\u673a\u3001\u5ba2\u6237)", (Object)"sourceType"));
                        continue block44;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u8d44\u6e90ID", (Object)"customerId"));
                        continue block44;
                    }
                    case "leadsId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u7ebf\u7d22ID", (Object)"leadsId"));
                        continue block44;
                    }
                    case "salesId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5546\u673aID", (Object)"salesId"));
                        continue block44;
                    }
                    case "followTypeName": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u7c7b\u578b", (Object)"followTypeName"));
                        continue block44;
                    }
                    case "followContent": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u5185\u5bb9", (Object)"followContent"));
                        continue block44;
                    }
                    case "followConName": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u59d3\u540d", (Object)"followConName"));
                        continue block44;
                    }
                    case "followTel": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"followTel"));
                        continue block44;
                    }
                    case "followUserId": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u4eba", (Object)"followUserId"));
                        continue block44;
                    }
                    case "followTime": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u65f6\u95f4", (Object)"followTime"));
                        continue block44;
                    }
                    case "files": {
                        entitys.add(new ExcelExportEntity("\u6587\u4ef6", (Object)"files"));
                        continue block44;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block44;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block44;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block44;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerFollowListVO> info(@PathVariable(value="id") String id) {
        CrmCustomerFollowEntity entity = this.crmCustomerFollowService.getInfo(id);
        CrmCustomerFollowListVO vo = (CrmCustomerFollowListVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerFollowListVO.class);
        vo.setSourceTypeName(this.baseDataUtil.getDictName(vo.getSourceType(), "377053838701528261"));
        vo.setFollowTypeName(this.baseDataUtil.getDictName(vo.getFollowType(), "367315761724653573"));
        vo.setFollowConName(this.selectValues.cusConSelectValues(vo.getFollowUser(), vo));
        vo.setCustomerName(this.selectValues.cusSelectValues(vo.getCustomerId()));
        vo.setFollowTimeFormat(DateUtil.dateFormat((Date)vo.getFollowTime()));
        vo.setCreatorTimeFormat(DateUtil.daFormat((Date)vo.getCreatorTime()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerFollowListVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerFollowEntity entity = this.crmCustomerFollowService.getInfo(id);
        CrmCustomerFollowListVO vo = (CrmCustomerFollowListVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerFollowListVO.class);
        vo.setSourceTypeName(this.baseDataUtil.getDictName(vo.getSourceType(), "377053838701528261"));
        vo.setFollowTypeName(this.baseDataUtil.getDictName(vo.getFollowType(), "367315761724653573"));
        vo.setFollowConName(this.selectValues.cusConSelectValues(vo.getFollowUser(), vo));
        vo.setCustomerName(this.selectValues.cusSelectValues(vo.getCustomerId()));
        vo.setFollowTimeFormat(DateUtil.dateFormat((Date)vo.getFollowTime()));
        vo.setCreatorTimeFormat(DateUtil.daFormat((Date)vo.getCreatorTime()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerFollowUpForm crmCustomerFollowUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerFollowEntity entity = this.crmCustomerFollowService.getInfo(id);
        if (entity != null) {
            CrmCustomerFollowEntity subentity = (CrmCustomerFollowEntity)JsonUtil.getJsonToBean((Object)crmCustomerFollowUpForm, CrmCustomerFollowEntity.class);
            this.crmCustomerFollowService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerFollowEntity entity = this.crmCustomerFollowService.getInfo(id);
        if (entity != null) {
            this.crmCustomerFollowService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

