/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerLogsEntity;
import com.bringspring.crm.model.crmCustomerLogs.CrmCustomerLogsCrForm;
import com.bringspring.crm.model.crmCustomerLogs.CrmCustomerLogsInfoVO;
import com.bringspring.crm.model.crmCustomerLogs.CrmCustomerLogsListVO;
import com.bringspring.crm.model.crmCustomerLogs.CrmCustomerLogsPagination;
import com.bringspring.crm.model.crmCustomerLogs.CrmCustomerLogsUpForm;
import com.bringspring.crm.service.CrmCustomerLogsService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u52a8\u6001\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerLogs"})
public class CrmCustomerLogsController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerLogsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerLogsService crmCustomerLogsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerLogsPagination crmCustomerLogsPagination) throws IOException {
        List<CrmCustomerLogsEntity> list = this.crmCustomerLogsService.getList(crmCustomerLogsPagination);
        for (CrmCustomerLogsEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerLogsListVO.class);
        for (CrmCustomerLogsListVO crmCustomerLogsListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerLogsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerLogsCrForm crmCustomerLogsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerLogsEntity entity = (CrmCustomerLogsEntity)JsonUtil.getJsonToBean((Object)crmCustomerLogsCrForm, CrmCustomerLogsEntity.class);
        entity.setId(mainId);
        this.crmCustomerLogsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerLogsInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerLogsEntity entity = this.crmCustomerLogsService.getInfo(id);
        CrmCustomerLogsInfoVO vo = (CrmCustomerLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerLogsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerLogsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerLogsEntity entity = this.crmCustomerLogsService.getInfo(id);
        CrmCustomerLogsInfoVO vo = (CrmCustomerLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerLogsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerLogsUpForm crmCustomerLogsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerLogsEntity entity = this.crmCustomerLogsService.getInfo(id);
        if (entity != null) {
            CrmCustomerLogsEntity subentity = (CrmCustomerLogsEntity)JsonUtil.getJsonToBean((Object)crmCustomerLogsUpForm, CrmCustomerLogsEntity.class);
            this.crmCustomerLogsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerLogsEntity entity = this.crmCustomerLogsService.getInfo(id);
        if (entity != null) {
            this.crmCustomerLogsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

