/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.SalesAssistantEnum;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmCustomerMyEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityTrendsEntity;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyCrForm;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyInfoVO;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyListVO;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyPagination;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyUpForm;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCustomerMyService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6211\uff08\u9500\u552e\u4eba\u5458\uff09\u7684\u5ba2\u6237"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerMy"})
public class CrmCustomerMyController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerMyController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerMyService crmCustomerMyService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerMyPagination crmCustomerMyPagination) throws IOException {
        List<CrmCustomerMyEntity> list = this.crmCustomerMyService.getList(crmCustomerMyPagination);
        for (CrmCustomerMyEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerMyListVO.class);
        for (CrmCustomerMyListVO crmCustomerMyListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerMyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid CrmCustomerMyCrForm crmCustomerMyCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isEmpty((CharSequence)crmCustomerMyCrForm.getUserId())) {
            crmCustomerMyCrForm.setUserId(userInfo.getUserId());
        }
        this.crmCustomerMyService.saveCrmCustomer(crmCustomerMyCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @RepeatSubmit
    @PutMapping(value={"remove/{customerId}"})
    public ActionResult remove(@PathVariable(value="customerId") String customerId) {
        UserInfo userInfo = this.userProvider.get();
        this.crmCustomerMyService.removeCustomerId(userInfo.getUserId(), customerId);
        return ActionResult.success((String)"\u79fb\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerMyInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerMyEntity entity = this.crmCustomerMyService.getInfo(id);
        CrmCustomerMyInfoVO vo = (CrmCustomerMyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerMyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerMyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerMyEntity entity = this.crmCustomerMyService.getInfo(id);
        CrmCustomerMyInfoVO vo = (CrmCustomerMyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerMyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerMyUpForm crmCustomerMyUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerMyEntity entity = this.crmCustomerMyService.getInfo(id);
        if (entity != null) {
            CrmCustomerMyEntity subentity = (CrmCustomerMyEntity)JsonUtil.getJsonToBean((Object)crmCustomerMyUpForm, CrmCustomerMyEntity.class);
            this.crmCustomerMyService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerMyEntity entity = this.crmCustomerMyService.getInfo(id);
        if (entity != null) {
            this.crmCustomerMyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"salesAssistant"})
    public ActionResult salesAssistant() {
        UserInfo userInfo = this.userProvider.get();
        List<CrmCustomerMyEntity> notFollowCustomerList = this.crmCustomerMyService.notFollow(userInfo.getUserId(), SalesAssistantEnum.NOT_FOLLOW_CUSTOMER.getDay());
        List<RkProjectReportingEntity> notFollowReporting = this.rkProjectReportingService.notFollowByUserIdAndDay(userInfo.getUserId(), SalesAssistantEnum.NOT_FOLLOW_REPORTING.getDay());
        List<CrmClueInfoEntity> notFollowClue = this.crmClueInfoService.notFollowByUserIdAndDay(userInfo.getUserId(), SalesAssistantEnum.NOT_FOLLOW_CLUE.getDay());
        List<RkProjectReportingEntity> expectedSigningReporting = this.rkProjectReportingService.expectedSigning(userInfo.getUserId(), SalesAssistantEnum.EXPECTED_SIGNING_REPORTING.getDay());
        String s = DateUtil.daFormat((Date)DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)((SalesAssistantEnum.NOT_FOLLOW_OPPORTUNITY.getDay() + 1) * -1)));
        List<CrmCustomerOpportunityTrendsEntity> needToNoticeSaler = this.crmCustomerOpportunityService.getNeedToNoticeSaler(s, userInfo.getUserId());
        HashMap map = MapUtil.newHashMap();
        map.put("notFollowCustomer", notFollowCustomerList.size());
        map.put("notFollowReporting", notFollowReporting.size());
        map.put("notFollowClue", notFollowClue.size());
        map.put("expectedSigningReporting", expectedSigningReporting.size());
        map.put("notFollowOpportunity", needToNoticeSaler.size());
        return ActionResult.success((Object)map);
    }
}

