/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerRemarkEntity;
import com.bringspring.crm.model.crmcustomerremark.CrmCustomerRemarkCrForm;
import com.bringspring.crm.model.crmcustomerremark.CrmCustomerRemarkInfoVO;
import com.bringspring.crm.model.crmcustomerremark.CrmCustomerRemarkUpForm;
import com.bringspring.crm.service.CrmCustomerRemarkService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u5907\u6ce8\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerRemark"})
public class CrmCustomerRemarkController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerRemarkController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerRemarkService crmCustomerRemarkService;

    @GetMapping(value={"listByCustomerId/{customerId}/{type}"})
    public ActionResult listByCustomerId(@PathVariable(value="customerId") String customerId, @PathVariable(value="type") String type) {
        return ActionResult.success(this.crmCustomerRemarkService.listByCustomerId(customerId, type));
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerRemarkCrForm crmCustomerRemarkCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerRemarkEntity entity = (CrmCustomerRemarkEntity)JsonUtil.getJsonToBean((Object)crmCustomerRemarkCrForm, CrmCustomerRemarkEntity.class);
        entity.setId(mainId);
        this.crmCustomerRemarkService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerRemarkInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerRemarkEntity entity = this.crmCustomerRemarkService.getInfo(id);
        CrmCustomerRemarkInfoVO vo = (CrmCustomerRemarkInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerRemarkInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerRemarkInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerRemarkEntity entity = this.crmCustomerRemarkService.getInfo(id);
        CrmCustomerRemarkInfoVO vo = (CrmCustomerRemarkInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerRemarkInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerRemarkUpForm crmCustomerRemarkUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerRemarkEntity entity = this.crmCustomerRemarkService.getInfo(id);
        if (entity != null) {
            CrmCustomerRemarkEntity subentity = (CrmCustomerRemarkEntity)JsonUtil.getJsonToBean((Object)crmCustomerRemarkUpForm, CrmCustomerRemarkEntity.class);
            this.crmCustomerRemarkService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerRemarkEntity entity = this.crmCustomerRemarkService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(0);
            entity.setDeleteTime(DateUtil.getNowDate());
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            this.crmCustomerRemarkService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

