/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmCustomerUserPointsEntity;
import com.bringspring.crm.model.crmcustomeruserpoints.CrmCustomerUserPointsCrForm;
import com.bringspring.crm.model.crmcustomeruserpoints.CrmCustomerUserPointsInfoVO;
import com.bringspring.crm.model.crmcustomeruserpoints.CrmCustomerUserPointsListVO;
import com.bringspring.crm.model.crmcustomeruserpoints.CrmCustomerUserPointsPagination;
import com.bringspring.crm.model.crmcustomeruserpoints.CrmCustomerUserPointsPaginationExportModel;
import com.bringspring.crm.model.crmcustomeruserpoints.CrmCustomerUserPointsUpForm;
import com.bringspring.crm.model.crmcustomeruserpointstrends.CrmCustomerUserPointsTrendsCrForm;
import com.bringspring.crm.service.CrmCustomerUserPointsService;
import com.bringspring.crm.service.CrmCustomerUserPointsTrendsService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u79ef\u5206\u53d8\u52a8\u8bb0\u5f55"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerUserPoints"})
public class CrmCustomerUserPointsController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerUserPointsController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerUserPointsService crmCustomerUserPointsService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private CrmCustomerUserPointsTrendsService crmCustomerUserPointsTrendsService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerUserPointsPagination crmCustomerUserPointsPagination) throws IOException {
        List<CrmCustomerUserPointsEntity> list = this.crmCustomerUserPointsService.getList(crmCustomerUserPointsPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerUserPointsListVO.class);
        if (!listVO.isEmpty()) {
            List<Map<String, Object>> mapGroupByEnableMarks = null;
            Map<String, Long> enabledMarkCount = null;
            for (CrmCustomerUserPointsListVO crmCustomerUserPointsVO : listVO) {
                mapGroupByEnableMarks = this.afterSalesQuestionService.getMapGroupByEnableMark(crmCustomerUserPointsVO.getOpenid());
                if (CollectionUtil.isNotEmpty(mapGroupByEnableMarks)) {
                    enabledMarkCount = mapGroupByEnableMarks.stream().collect(Collectors.toMap(entry -> String.valueOf(entry.get("enabledMark")), entry -> (Long)entry.get("markCount")));
                    crmCustomerUserPointsVO.setEnabledMarkCount(enabledMarkCount);
                }
                if (!StringUtils.isNotEmpty((String)crmCustomerUserPointsVO.getPhone())) continue;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(UserEntity::getMobilePhone, (Object)crmCustomerUserPointsVO.getPhone());
                if (null == this.userService.getOne((Wrapper)queryWrapper)) {
                    crmCustomerUserPointsVO.setIsRealCustomer("\u662f");
                    continue;
                }
                crmCustomerUserPointsVO.setIsRealCustomer("\u5426");
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerUserPointsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid CrmCustomerUserPointsCrForm crmCustomerUserPointsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerUserPointsEntity entity = (CrmCustomerUserPointsEntity)JsonUtil.getJsonToBean((Object)crmCustomerUserPointsCrForm, CrmCustomerUserPointsEntity.class);
        entity.setId(mainId);
        this.crmCustomerUserPointsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"my"})
    @NotCheckLogin
    public ActionResult customerMyInfo(String phone, String openid) {
        Object o = this.cacheUtil.query("oneWeekCacheSpace", openid);
        if (ObjectUtil.isNull((Object)o)) {
            return ActionResult.fail((Integer)ActionResultCode.WxMpAuthError.getCode(), (String)ActionResultCode.WxMpAuthError.getMessage());
        }
        this.cacheUtil.expire("oneWeekCacheSpace", openid, 604800);
        WxOAuth2UserInfo jsonToBean = (WxOAuth2UserInfo)JsonUtil.getJsonToBean((Object)JsonUtil.stringToMap((String)o.toString()), WxOAuth2UserInfo.class);
        CrmCustomerUserPointsEntity infoByPhone = this.crmCustomerUserPointsService.getInfoByOpenid(openid);
        if (StrUtil.isEmpty((CharSequence)infoByPhone.getNickName())) {
            infoByPhone.setNickName(jsonToBean.getNickname());
            infoByPhone.setHeadUrl(jsonToBean.getHeadImgUrl());
            this.crmCustomerUserPointsService.updateById(infoByPhone);
        }
        if (StrUtil.isEmpty((CharSequence)infoByPhone.getPhone())) {
            return ActionResult.fail((Integer)ActionResultCode.WxMpBindError.getCode(), (String)ActionResultCode.WxMpBindError.getMessage());
        }
        return ActionResult.success((Object)infoByPhone);
    }

    @GetMapping(value={"myUserInfo"})
    @NotCheckLogin
    public ActionResult myUserInfo(String phone, String openid) {
        CrmCustomerUserPointsEntity infoByPhone = this.crmCustomerUserPointsService.getInfoByOpenid(openid);
        if (StrUtil.isEmpty((CharSequence)infoByPhone.getPhone())) {
            return ActionResult.fail((Integer)ActionResultCode.WxMpBindError.getCode(), (String)ActionResultCode.WxMpBindError.getMessage());
        }
        return ActionResult.success((Object)infoByPhone);
    }

    @RepeatSubmit
    @NotCheckLogin
    @PostMapping(value={"bind"})
    public synchronized ActionResult bind(@RequestBody @Valid CrmCustomerUserPointsUpForm crmCustomerUserPointsUpForm) {
        CrmCustomerUserPointsEntity byId = null;
        boolean needPoints = true;
        byId = StrUtil.isNotEmpty((CharSequence)crmCustomerUserPointsUpForm.getId()) ? (CrmCustomerUserPointsEntity)this.crmCustomerUserPointsService.getById((Serializable)((Object)crmCustomerUserPointsUpForm.getId())) : this.crmCustomerUserPointsService.getInfoByOpenid(crmCustomerUserPointsUpForm.getOpenid());
        if (ObjectUtil.isNull((Object)byId)) {
            return ActionResult.success((String)"\u7ed1\u5b9a\u5931\u8d25");
        }
        if (StrUtil.isNotEmpty((CharSequence)byId.getCustomerId())) {
            needPoints = false;
        }
        byId.setDuties(crmCustomerUserPointsUpForm.getDuties());
        byId.setName(crmCustomerUserPointsUpForm.getName());
        byId.setPhone(crmCustomerUserPointsUpForm.getPhone());
        byId.setCustomerId(crmCustomerUserPointsUpForm.getCustomerId());
        byId.setCustomerName(crmCustomerUserPointsUpForm.getCustomerName());
        this.crmCustomerUserPointsService.updateById(byId);
        if (needPoints) {
            CrmCustomerUserPointsTrendsCrForm trendsCrForm = new CrmCustomerUserPointsTrendsCrForm();
            trendsCrForm.setCustomerName(crmCustomerUserPointsUpForm.getCustomerName());
            trendsCrForm.setCustomerId(crmCustomerUserPointsUpForm.getCustomerId());
            trendsCrForm.setOpenid(crmCustomerUserPointsUpForm.getOpenid());
            trendsCrForm.setPhone(crmCustomerUserPointsUpForm.getPhone());
            trendsCrForm.setPoints(80);
            trendsCrForm.setChangeType(1);
            trendsCrForm.setSourceType("40");
            trendsCrForm.setSourceParentType("register");
            this.crmCustomerUserPointsTrendsService.savePoints(trendsCrForm);
        }
        return ActionResult.success((String)"\u7ed1\u5b9a\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerUserPointsInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerUserPointsEntity entity = this.crmCustomerUserPointsService.getInfo(id);
        CrmCustomerUserPointsInfoVO vo = (CrmCustomerUserPointsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerUserPointsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerUserPointsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerUserPointsEntity entity = this.crmCustomerUserPointsService.getInfo(id);
        CrmCustomerUserPointsInfoVO vo = (CrmCustomerUserPointsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerUserPointsInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getPhone())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(UserEntity::getMobilePhone, (Object)vo.getPhone());
            if (null == this.userService.getOne((Wrapper)queryWrapper)) {
                vo.setIsRealCustomer("\u662f");
            } else {
                vo.setIsRealCustomer("\u5426");
            }
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @NotCheckLogin
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerUserPointsUpForm crmCustomerUserPointsUpForm) throws DataException {
        CrmCustomerUserPointsEntity entity = this.crmCustomerUserPointsService.getInfo(id);
        if (entity != null) {
            CrmCustomerUserPointsEntity subentity = (CrmCustomerUserPointsEntity)JsonUtil.getJsonToBean((Object)crmCustomerUserPointsUpForm, CrmCustomerUserPointsEntity.class);
            this.crmCustomerUserPointsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerUserPointsEntity entity = this.crmCustomerUserPointsService.getInfo(id);
        if (entity != null) {
            this.crmCustomerUserPointsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmCustomerUserPointsPaginationExportModel crmCustomerUserPointsPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmCustomerUserPointsPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmCustomerUserPointsPagination crmCustomerUserPointsPagination = (CrmCustomerUserPointsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmCustomerUserPointsPaginationExportModel), CrmCustomerUserPointsPagination.class));
        List<CrmCustomerUserPointsEntity> list = this.crmCustomerUserPointsService.getTypeList(crmCustomerUserPointsPagination, crmCustomerUserPointsPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerUserPointsListVO.class);
        for (CrmCustomerUserPointsListVO crmCustomerUserPointsVO : listVO) {
            if (!StringUtils.isNotEmpty((String)crmCustomerUserPointsVO.getPhone())) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(UserEntity::getMobilePhone, (Object)crmCustomerUserPointsVO.getPhone());
            if (null == this.userService.getOne((Wrapper)queryWrapper)) {
                crmCustomerUserPointsVO.setIsRealCustomer("\u662f");
                continue;
            }
            crmCustomerUserPointsVO.setIsRealCustomer("\u5426");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmCustomerUserPointsPaginationExportModel.getSelectKey()) ? crmCustomerUserPointsPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            ExcelExportEntity entity = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "openid": {
                        entity = new ExcelExportEntity("openid", (Object)"openid");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "customerName": {
                        entity = new ExcelExportEntity("\u5ba2\u6237", (Object)"customerName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"name"));
                        continue block36;
                    }
                    case "phone": {
                        entity = new ExcelExportEntity("\u624b\u673a\u53f7", (Object)"phone");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "isRealCustomer": {
                        entity = new ExcelExportEntity("\u662f\u5426\u4e3a\u771f\u5b9e\u5ba2\u6237", (Object)"isRealCustomer");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "nickName": {
                        entity = new ExcelExportEntity("\u5fae\u4fe1\u6635\u79f0", (Object)"nickName");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "duties": {
                        entity = new ExcelExportEntity("\u804c\u79f0", (Object)"duties");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "points": {
                        entitys.add(new ExcelExportEntity("\u79ef\u5206", (Object)"points"));
                        continue block36;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block36;
                    }
                    case "creatorTime": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime");
                        entity.setWidth(25.0);
                        entitys.add(entity);
                        continue block36;
                    }
                    case "headUrl": {
                        entitys.add(new ExcelExportEntity("\u5fae\u4fe1\u5934\u50cf", (Object)"headUrl"));
                        continue block36;
                    }
                    case "description": {
                        entity = new ExcelExportEntity("\u63cf\u8ff0", (Object)"description");
                        entity.setWidth(40.0);
                        entitys.add(entity);
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/getWechatUserOption"})
    public ActionResult<List<CrmCustomerUserPointsListVO>> getWechatUsers() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().isNotNull(CrmCustomerUserPointsEntity::getOpenid)).ne(CrmCustomerUserPointsEntity::getOpenid, (Object)"");
        queryWrapper.lambda().select(new SFunction[]{CrmCustomerUserPointsEntity::getId, CrmCustomerUserPointsEntity::getOpenid, CrmCustomerUserPointsEntity::getNickName});
        queryWrapper.lambda().orderByDesc(CrmCustomerUserPointsEntity::getId);
        List list = this.crmCustomerUserPointsService.list((Wrapper)queryWrapper);
        List vo = JsonUtil.getJsonToList((Object)list, CrmCustomerUserPointsListVO.class);
        return ActionResult.success((Object)vo);
    }
}

