/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerUserRelationEntity;
import com.bringspring.crm.model.crmcustomeruserrelation.CrmCustomerUserRelationCrForm;
import com.bringspring.crm.model.crmcustomeruserrelation.CrmCustomerUserRelationInfoVO;
import com.bringspring.crm.model.crmcustomeruserrelation.CrmCustomerUserRelationListVO;
import com.bringspring.crm.model.crmcustomeruserrelation.CrmCustomerUserRelationPagination;
import com.bringspring.crm.model.crmcustomeruserrelation.CrmCustomerUserRelationUpForm;
import com.bringspring.crm.service.CrmCustomerUserRelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u548c\u7528\u6237\u5173\u8054\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerUserRelation"})
public class CrmCustomerUserRelationController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerUserRelationController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerUserRelationService crmCustomerUserRelationService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerUserRelationPagination crmCustomerUserRelationPagination) throws IOException {
        List<CrmCustomerUserRelationEntity> list = this.crmCustomerUserRelationService.getList(crmCustomerUserRelationPagination);
        for (CrmCustomerUserRelationEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerUserRelationListVO.class);
        for (CrmCustomerUserRelationListVO crmCustomerUserRelationListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerUserRelationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerUserRelationCrForm crmCustomerUserRelationCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            CrmCustomerUserRelationEntity entity = (CrmCustomerUserRelationEntity)JsonUtil.getJsonToBean((Object)crmCustomerUserRelationCrForm, CrmCustomerUserRelationEntity.class);
            List<CrmCustomerUserRelationEntity> list = this.crmCustomerUserRelationService.getInfoByCustomerId(crmCustomerUserRelationCrForm.getCustomerId());
            if (CollectionUtil.isNotEmpty(list)) {
                return ActionResult.fail((String)"\u5df2\u5173\u6ce8\u8fc7\uff0c\u65e0\u9700\u91cd\u590d\u5173\u6ce8");
            }
            entity.setId(mainId);
            entity.setUserId(userInfo.getUserId());
            entity.setCreatorTime(DateUtil.getNowDate());
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setEnabledMark(0);
            this.crmCustomerUserRelationService.save(entity);
            return ActionResult.success((String)"\u5173\u6ce8\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerUserRelationInfoVO> info(@PathVariable(value="id") String id) {
        CrmCustomerUserRelationEntity entity = this.crmCustomerUserRelationService.getInfo(id);
        CrmCustomerUserRelationInfoVO vo = (CrmCustomerUserRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerUserRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmCustomerUserRelationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmCustomerUserRelationEntity entity = this.crmCustomerUserRelationService.getInfo(id);
        CrmCustomerUserRelationInfoVO vo = (CrmCustomerUserRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerUserRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerUserRelationUpForm crmCustomerUserRelationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmCustomerUserRelationEntity entity = this.crmCustomerUserRelationService.getInfo(id);
        if (entity != null) {
            CrmCustomerUserRelationEntity subentity = (CrmCustomerUserRelationEntity)JsonUtil.getJsonToBean((Object)crmCustomerUserRelationUpForm, CrmCustomerUserRelationEntity.class);
            this.crmCustomerUserRelationService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        List<CrmCustomerUserRelationEntity> list = this.crmCustomerUserRelationService.getInfoByCustomerId(id);
        list.stream().forEach(entity -> this.crmCustomerUserRelationService.delete((CrmCustomerUserRelationEntity)entity));
        return ActionResult.success((String)"\u5df2\u53d6\u6d88\u5173\u6ce8");
    }
}

