/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerVerifyEntity;
import com.bringspring.crm.model.crmCustomerVerify.CrmCustomerVerifyCrForm;
import com.bringspring.crm.model.crmCustomerVerify.CrmCustomerVerifyInfoVO;
import com.bringspring.crm.model.crmCustomerVerify.CrmCustomerVerifyListVO;
import com.bringspring.crm.model.crmCustomerVerify.CrmCustomerVerifyPagination;
import com.bringspring.crm.model.crmCustomerVerify.CrmCustomerVerifyUpForm;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsCrForm;
import com.bringspring.crm.model.crmcustomercontacts.CrmCustomerContactsInfoVO;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmCustomerVerifyService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.AMapUtils;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmCustomerVerify"})
public class CrmCustomerVerifyController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerVerifyController.class);
    @Autowired
    private AMapUtils aMapUtils;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmCustomerVerifyService crmCustomerVerifyService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmCustomerVerifyPagination crmCustomerVerifyPagination) throws IOException {
        List<CrmCustomerVerifyEntity> list = this.crmCustomerVerifyService.getList(crmCustomerVerifyPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmCustomerVerifyListVO.class);
        for (CrmCustomerVerifyListVO vo : listVO) {
            vo.setAddressName(this.baseDataUtil.provinceData(vo.getAddress()));
            vo.setGrade(this.baseDataUtil.getDictName(vo.getGrade(), "CustomerGrade"));
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmCustomerVerifyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmCustomerVerifyCrForm crmCustomerVerifyCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "417694658919943365";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        crmCustomerVerifyCrForm.setCompanyId(userInfo.getOrganizeId());
        CrmCustomerVerifyEntity entity = (CrmCustomerVerifyEntity)JsonUtil.getJsonToBean((Object)((Object)crmCustomerVerifyCrForm), CrmCustomerVerifyEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setEnabledMark(String.valueOf(crmCustomerVerifyCrForm.getStatus()));
        String geocode = this.aMapUtils.getGeocode(entity.getName());
        if (!StrUtil.isBlank((CharSequence)geocode)) {
            String[] split = geocode.split(",");
            entity.setAddressLongitude(split[0]);
            entity.setAddressLatitude(split[1]);
        }
        this.crmCustomerVerifyService.save(entity);
        if (!ObjectUtil.isEmpty(crmCustomerVerifyCrForm.getCrmcustomerList())) {
            List<CrmCustomerContactsCrForm> crmcustomerList = crmCustomerVerifyCrForm.getCrmcustomerList();
            List listContacts = JsonUtil.getJsonToList(crmcustomerList, CrmCustomerContactsEntity.class);
            listContacts.stream().forEach(v -> {
                v.setCustomerId(mainId);
                v.setOriginalCreatorUserId(userInfo.getUserId());
            });
            this.crmCustomerContactsService.saveOrUpdateBatch(listContacts);
        }
        FlowUtil.saveOrSubmit((String)crmCustomerVerifyCrForm.getTaskId(), (String)flowEngineId, (String)crmCustomerVerifyCrForm.getTemplateId(), (String)mainId, (Object)((Object)crmCustomerVerifyCrForm), (Integer)crmCustomerVerifyCrForm.getStatus());
        if (crmCustomerVerifyCrForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmCustomerVerifyInfoVO> info(@PathVariable(value="id") String id) {
        String userId = this.userProvider.get().getUserId();
        CrmCustomerVerifyEntity entity = this.crmCustomerVerifyService.getInfo(id);
        if (!ObjectUtil.isEmpty((Object)entity.getCreatorUserId())) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setCollaboratorId(this.baseDataUtil.userSelectValue(entity.getCollaboratorId()));
        }
        CrmCustomerVerifyInfoVO vo = (CrmCustomerVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmCustomerVerifyInfoVO.class);
        vo.setAddressName(this.selectValues.areaSelectValues(entity.getAddress()));
        vo.setConductName(this.baseDataUtil.getDictName(entity.getConduct(), "EnterpriseNature"));
        vo.setGradeName(this.baseDataUtil.getDictName(entity.getGrade(), "CustomerGrade"));
        vo.setTypeName(this.baseDataUtil.getDictName(entity.getType(), "CustomerType"));
        List<CrmCustomerContactsEntity> contactsEntities = this.crmCustomerVerifyService.getContactByCustomeId(id);
        vo.setCrmCustomerList(JsonUtil.getJsonToList(contactsEntities, CrmCustomerContactsInfoVO.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmCustomerVerifyUpForm crmCustomerVerifyUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "417694658919943365";
        CrmCustomerVerifyEntity entity = this.crmCustomerVerifyService.getInfo(id);
        if (entity != null) {
            CrmCustomerVerifyEntity subentity = (CrmCustomerVerifyEntity)JsonUtil.getJsonToBean((Object)((Object)crmCustomerVerifyUpForm), CrmCustomerVerifyEntity.class);
            subentity.setEnabledMark(String.valueOf(crmCustomerVerifyUpForm.getStatus()));
            String geocode = this.aMapUtils.getGeocode(subentity.getName());
            if (!StrUtil.isBlank((CharSequence)geocode)) {
                String[] split = geocode.split(",");
                subentity.setAddressLongitude(split[0]);
                subentity.setAddressLatitude(split[1]);
            }
            this.crmCustomerVerifyService.update(id, subentity);
            QueryWrapper crmCustomerContactsEntityQueryWrapper = new QueryWrapper();
            crmCustomerContactsEntityQueryWrapper.lambda().eq(CrmCustomerContactsEntity::getCustomerId, (Object)entity.getId());
            this.crmCustomerContactsService.remove((Wrapper)crmCustomerContactsEntityQueryWrapper);
            List contactsEntities = JsonUtil.getJsonToList(crmCustomerVerifyUpForm.getCrmcustomerList(), CrmCustomerContactsEntity.class);
            for (CrmCustomerContactsEntity entitys : contactsEntities) {
                entitys.setId(RandomUtil.uuId());
                entitys.setCustomerId(entity.getId());
                entitys.setOriginalCreatorUserId(this.userProvider.get().getUserId());
                this.crmCustomerContactsService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)crmCustomerVerifyUpForm.getTaskId(), (String)flowEngineId, (String)crmCustomerVerifyUpForm.getTemplateId(), (String)id, (Object)((Object)crmCustomerVerifyUpForm), (Integer)crmCustomerVerifyUpForm.getStatus());
            if (crmCustomerVerifyUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmCustomerVerifyEntity entity = this.crmCustomerVerifyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.crmCustomerVerifyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

