/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectCrForm;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectInfoVO;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectListVO;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectPagination;
import com.bringspring.crm.model.crmdepartconnect.CrmDepartConnectUpForm;
import com.bringspring.crm.service.CrmDepartConnectService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79bb\u804c\u4ea4\u63a5\u8868"}, value="depart")
@RequestMapping(value={"/api/depart/CrmDepartConnect"})
public class CrmDepartConnectController {
    private static final Logger log = LoggerFactory.getLogger(CrmDepartConnectController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmDepartConnectService crmDepartConnectService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmDepartConnectPagination crmDepartConnectPagination) throws IOException {
        List<CrmDepartConnectEntity> list = this.crmDepartConnectService.getList(crmDepartConnectPagination);
        for (CrmDepartConnectEntity crmDepartConnectEntity : list) {
            crmDepartConnectEntity.setResignUser(this.baseDataUtil.userSelectValues(crmDepartConnectEntity.getResignUser()));
            crmDepartConnectEntity.setConnectUser(this.baseDataUtil.userSelectValues(crmDepartConnectEntity.getConnectUser()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmDepartConnectListVO.class);
        for (CrmDepartConnectListVO crmDepartConnectListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmDepartConnectPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmDepartConnectCrForm crmDepartConnectCrForm) throws DataException {
        this.crmDepartConnectService.create(crmDepartConnectCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmDepartConnectInfoVO> info(@PathVariable(value="id") String id) {
        CrmDepartConnectEntity entity = this.crmDepartConnectService.getInfo(id);
        CrmDepartConnectInfoVO vo = (CrmDepartConnectInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmDepartConnectInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmDepartConnectInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmDepartConnectEntity entity = this.crmDepartConnectService.getInfo(id);
        CrmDepartConnectInfoVO vo = (CrmDepartConnectInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmDepartConnectInfoVO.class);
        vo.setResignUser(this.baseDataUtil.userSelectValues(vo.getResignUser()));
        vo.setConnectUser(this.baseDataUtil.userSelectValues(vo.getConnectUser()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmDepartConnectUpForm crmDepartConnectUpForm) throws DataException {
        this.crmDepartConnectService.update(id, crmDepartConnectUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmDepartConnectEntity entity = this.crmDepartConnectService.getInfo(id);
        if (entity != null) {
            this.crmDepartConnectService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/connectResource"})
    public ActionResult connectResource(@RequestBody CrmDepartConnectEntity connectEntity) {
        if (ObjectUtil.isEmpty((Object)connectEntity)) {
            return ActionResult.fail((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        Boolean flag = this.crmDepartConnectService.connectResource(connectEntity);
        if (flag.booleanValue()) {
            return ActionResult.success((String)"\u4ea4\u63a5\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4ea4\u63a5\u5931\u8d25");
    }
}

