/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmFileEntity;
import com.bringspring.crm.model.crmfile.CrmFileCrForm;
import com.bringspring.crm.model.crmfile.CrmFileInfoVO;
import com.bringspring.crm.model.crmfile.CrmFileListVO;
import com.bringspring.crm.model.crmfile.CrmFilePagination;
import com.bringspring.crm.model.crmfile.CrmFileUpForm;
import com.bringspring.crm.service.CrmFileService;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6587\u4ef6\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmFile"})
public class CrmFileController {
    private static final Logger log = LoggerFactory.getLogger(CrmFileController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmFileService crmFileService;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmFilePagination crmFilePagination) throws Exception {
        List<CrmFileEntity> list = this.crmFileService.getList(crmFilePagination);
        List listVO = JsonUtil.getJsonToList(list, CrmFileListVO.class);
        new SelectValues().repliceCreaterId(this.userService, listVO);
        listVO.stream().forEach(item -> item.setCreatorTimeFormat(DateUtil.dateFormat((Date)item.getCreatorTime())));
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmFilePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmFileCrForm crmFileCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmFileEntity entity = (CrmFileEntity)JsonUtil.getJsonToBean((Object)crmFileCrForm, CrmFileEntity.class);
        String[] split = entity.getFileName().split("\\.");
        entity.setFileName(split[0]);
        entity.setFileType(split[1]);
        entity.setId(mainId);
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setVersion(1);
        entity.setCreatorUserId(userInfo.getUserId());
        this.crmFileService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmFileInfoVO> info(@PathVariable(value="id") String id) {
        CrmFileEntity entity = this.crmFileService.getInfo(id);
        CrmFileInfoVO vo = (CrmFileInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmFileInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmFileInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmFileEntity entity = this.crmFileService.getInfo(id);
        CrmFileInfoVO vo = (CrmFileInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmFileInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmFileUpForm crmFileUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmFileEntity entity = this.crmFileService.getInfo(id);
        if (entity != null) {
            CrmFileEntity subentity = (CrmFileEntity)JsonUtil.getJsonToBean((Object)crmFileUpForm, CrmFileEntity.class);
            this.crmFileService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmFileEntity entity = this.crmFileService.getInfo(id);
        if (entity != null) {
            this.crmFileService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

