/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmFollowInformationEntity;
import com.bringspring.crm.model.crmfollowinformation.CrmFollowInformationInfoVO;
import com.bringspring.crm.model.crmfollowinformation.CrmFollowInformationListVO;
import com.bringspring.crm.model.crmfollowinformation.CrmFollowInformationPagination;
import com.bringspring.crm.model.crmfollowinformation.CrmFollowInformationPaginationExportModel;
import com.bringspring.crm.service.CrmFollowInformationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ddf\u8fdb\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/crm/CrmFollowInformation"})
public class CrmFollowInformationController {
    private static final Logger log = LoggerFactory.getLogger(CrmFollowInformationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmFollowInformationService crmfollowinformationService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmFollowInformationPagination crmfollowinformationPagination) throws IOException {
        List<CrmFollowInformationEntity> list = this.crmfollowinformationService.getList(crmfollowinformationPagination);
        UserInfo userInfo = this.userProvider.get();
        for (CrmFollowInformationEntity entity : list) {
            if (!ObjectUtil.isEmpty((Object)entity.getFollowPersion()) && entity.getFollowPersion().equals(userInfo.getUserId())) {
                entity.setBadge(true);
            } else {
                entity.setBadge(false);
            }
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
            entity.setFollowPersion(this.baseDataUtil.userSelectValue(entity.getFollowPersion()));
            entity.setFollowType(this.baseDataUtil.getDictName(entity.getFollowType(), "367315761724653573"));
            entity.setIntentionalDegree(this.baseDataUtil.getDictName(entity.getIntentionalDegree(), "368027709130944517"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmFollowInformationListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmfollowinformationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmFollowInformationInfoVO> info(@PathVariable(value="id") String id) {
        CrmFollowInformationEntity entity = this.crmfollowinformationService.getInfo(id);
        CrmFollowInformationInfoVO vo = (CrmFollowInformationInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmFollowInformationInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmFollowInformationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmFollowInformationEntity entity = this.crmfollowinformationService.getInfo(id);
        CrmFollowInformationInfoVO vo = (CrmFollowInformationInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmFollowInformationInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setFollowType(this.baseDataUtil.getDictName(vo.getFollowType(), "367315761724653573"));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmFollowInformationPaginationExportModel crmFollowInformationPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmFollowInformationPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmFollowInformationPagination crmFollowInformationPagination = (CrmFollowInformationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmFollowInformationPaginationExportModel), CrmFollowInformationPagination.class));
        List<CrmFollowInformationEntity> list = this.crmfollowinformationService.getTypeList(crmFollowInformationPagination, crmFollowInformationPaginationExportModel.getDataType());
        for (CrmFollowInformationEntity crmFollowInformationEntity : list) {
            crmFollowInformationEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmFollowInformationEntity.getCreatorUserId()));
            crmFollowInformationEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmFollowInformationEntity.getLastModifyUserId()));
            crmFollowInformationEntity.setFollowType(this.baseDataUtil.getDictName(crmFollowInformationEntity.getFollowType(), "367315761724653573"));
            crmFollowInformationEntity.setIntentionalDegree(this.baseDataUtil.getDictName(crmFollowInformationEntity.getIntentionalDegree(), "368027709130944517"));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmFollowInformationListVO.class);
        for (CrmFollowInformationListVO crmFollowInformationListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmFollowInformationPaginationExportModel.getSelectKey()) ? crmFollowInformationPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block38;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block38;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block38;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block38;
                    }
                    case "sourceId": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u6765\u6e90ID", (Object)"sourceId"));
                        continue block38;
                    }
                    case "followSource": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u6765\u6e90", (Object)"followSource"));
                        continue block38;
                    }
                    case "sourceName": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u6765\u6e90\u540d\u79f0", (Object)"sourceName"));
                        continue block38;
                    }
                    case "followType": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u7c7b\u578b", (Object)"followType"));
                        continue block38;
                    }
                    case "followUser": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u59d3\u540d", (Object)"followUser"));
                        continue block38;
                    }
                    case "followTel": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"followTel"));
                        continue block38;
                    }
                    case "followContent": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u5185\u5bb9", (Object)"followContent"));
                        continue block38;
                    }
                    case "intentionalDegree": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u610f\u5411\u7ed3\u679c", (Object)"intentionalDegree"));
                        continue block38;
                    }
                    case "followTime": {
                        entitys.add(new ExcelExportEntity("\u8ddf\u8fdb\u65f6\u95f4", (Object)"followTime"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

