/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmLeadSettingsEntity;
import com.bringspring.crm.model.crmleadsettings.CrmLeadSettingsInfoVO;
import com.bringspring.crm.model.crmleadsettings.CrmLeadSettingsListVO;
import com.bringspring.crm.model.crmleadsettings.CrmLeadSettingsPagination;
import com.bringspring.crm.model.crmleadsettings.CrmLeadSettingsUpForm;
import com.bringspring.crm.service.CrmLeadSettingsService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5ba2\u6237\u7ba1\u7406\u8bbe\u7f6e"}, value="crm")
@RequestMapping(value={"/api/crm/CrmLeadSettings"})
public class CrmLeadSettingsController {
    private static final Logger log = LoggerFactory.getLogger(CrmLeadSettingsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmLeadSettingsService crmleadsettingsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmLeadSettingsPagination crmleadsettingsPagination) throws IOException {
        List<CrmLeadSettingsEntity> list = this.crmleadsettingsService.getList(crmleadsettingsPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmLeadSettingsListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmleadsettingsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmLeadSettingsInfoVO> info(@PathVariable(value="id") String id) {
        CrmLeadSettingsEntity entity = this.crmleadsettingsService.getInfo(id);
        CrmLeadSettingsInfoVO vo = (CrmLeadSettingsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmLeadSettingsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmLeadSettingsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmLeadSettingsEntity entity = this.crmleadsettingsService.getInfo(id);
        CrmLeadSettingsInfoVO vo = (CrmLeadSettingsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmLeadSettingsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmLeadSettingsUpForm crmleadsettingsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmLeadSettingsEntity entity = this.crmleadsettingsService.getInfo(id);
        if (entity != null) {
            if (!ObjectUtil.isEmpty((Object)crmleadsettingsUpForm.getDicValueList())) {
                crmleadsettingsUpForm.setDicValue(crmleadsettingsUpForm.getDicValueList().toString());
            }
            CrmLeadSettingsEntity subentity = (CrmLeadSettingsEntity)JsonUtil.getJsonToBean((Object)crmleadsettingsUpForm, CrmLeadSettingsEntity.class);
            this.crmleadsettingsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

