/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductBuyCategoryEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.model.crmproductbuycategory.CrmProductBuyCategoryCrForm;
import com.bringspring.crm.model.crmproductbuycategory.CrmProductBuyCategoryInfoVO;
import com.bringspring.crm.model.crmproductbuycategory.CrmProductBuyCategoryListVO;
import com.bringspring.crm.model.crmproductbuycategory.CrmProductBuyCategoryPagination;
import com.bringspring.crm.model.crmproductbuycategory.CrmProductBuyCategoryUpForm;
import com.bringspring.crm.service.CrmProductBuyCategoryService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u4ea7\u54c1\u5206\u7c7b\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductBuyCategory"})
public class CrmProductBuyCategoryController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductBuyCategoryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductBuyCategoryService crmProductBuyCategoryService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductBuyCategoryPagination crmProductBuyCategoryPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isEmpty((CharSequence)crmProductBuyCategoryPagination.getCompanyId())) {
            crmProductBuyCategoryPagination.setCompanyId(userInfo.getOrganizeId());
        }
        List<CrmProductBuyCategoryEntity> list = this.crmProductBuyCategoryService.getList(crmProductBuyCategoryPagination);
        for (CrmProductBuyCategoryEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmProductBuyCategoryListVO.class);
        for (CrmProductBuyCategoryListVO crmProductBuyCategoryListVO : listVO) {
        }
        List<CrmProductCategoryEntity> list2 = this.crmProductCategoryService.getInfoByParentId(CollectionUtil.list((boolean)false, (Object[])new String[]{crmProductBuyCategoryPagination.getCompanyId()}));
        list2.stream().forEach(entity -> entity.setParentId("1"));
        List jsonToList = JsonUtil.getJsonToList(list2, CrmProductBuyCategoryListVO.class);
        jsonToList.stream().forEach(e -> e.setInternal(true));
        listVO.addAll(jsonToList);
        List<Object> crmParent = new ArrayList();
        crmParent = listVO.stream().filter(x -> StrUtil.equals((CharSequence)x.getParentId(), (CharSequence)"-1")).collect(Collectors.toList());
        crmParent.stream().forEach(x -> {
            if (StrUtil.equals((CharSequence)x.getId(), (CharSequence)"1")) {
                x.setInternal(true);
            }
        });
        crmProductBuyCategoryPagination.setParent(crmParent.stream().distinct().collect(Collectors.toList()));
        this.setCategoryTree(crmProductBuyCategoryPagination.getParent(), listVO);
        List<CrmProductBuyCategoryListVO> parent = crmProductBuyCategoryPagination.getParent();
        return ActionResult.success(parent);
    }

    private void setCategoryTree(List<CrmProductBuyCategoryListVO> parent, List<CrmProductBuyCategoryListVO> child) {
        if (ObjectUtil.isEmpty(parent) || ObjectUtil.isEmpty(child)) {
            return;
        }
        parent.stream().forEach(item -> {
            item.setIfParent(true);
            ArrayList children = new ArrayList();
            Integer i = 0;
            while (i < child.size()) {
                if (item.getId().equals(((CrmProductBuyCategoryListVO)child.get(i)).getParentId())) {
                    children.add(child.get(i));
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            item.setChild(children);
        });
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductBuyCategoryCrForm crmProductBuyCategoryCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmProductBuyCategoryEntity byId = (CrmProductBuyCategoryEntity)this.crmProductBuyCategoryService.getById((Serializable)((Object)crmProductBuyCategoryCrForm.getParentId()));
        if (ObjectUtil.isEmpty((Object)byId) || StrUtil.equals((CharSequence)crmProductBuyCategoryCrForm.getParentId(), (CharSequence)"1")) {
            CrmProductCategoryEntity entity = (CrmProductCategoryEntity)JsonUtil.getJsonToBean((Object)crmProductBuyCategoryCrForm, CrmProductCategoryEntity.class);
            entity.setParentId(userInfo.getOrganizeId());
            entity.setId(mainId);
            this.crmProductCategoryService.save(entity);
        } else {
            CrmProductBuyCategoryEntity entity = (CrmProductBuyCategoryEntity)JsonUtil.getJsonToBean((Object)crmProductBuyCategoryCrForm, CrmProductBuyCategoryEntity.class);
            entity.setId(mainId);
            entity.setCompanyId(userInfo.getOrganizeId());
            this.crmProductBuyCategoryService.save(entity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductBuyCategoryInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductBuyCategoryEntity entity = this.crmProductBuyCategoryService.getInfo(id);
        CrmProductBuyCategoryInfoVO vo = (CrmProductBuyCategoryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductBuyCategoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductBuyCategoryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductBuyCategoryEntity entity = this.crmProductBuyCategoryService.getInfo(id);
        CrmProductBuyCategoryInfoVO vo = (CrmProductBuyCategoryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductBuyCategoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductBuyCategoryUpForm crmProductBuyCategoryUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductBuyCategoryEntity entity = this.crmProductBuyCategoryService.getInfo(id);
        if (entity != null) {
            CrmProductBuyCategoryEntity subentity = (CrmProductBuyCategoryEntity)JsonUtil.getJsonToBean((Object)crmProductBuyCategoryUpForm, CrmProductBuyCategoryEntity.class);
            this.crmProductBuyCategoryService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductBuyCategoryEntity entity = this.crmProductBuyCategoryService.getInfo(id);
        if (entity != null) {
            this.crmProductBuyCategoryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

