/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductBuyCategoryEntity;
import com.bringspring.crm.entity.CrmProductBuyEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmproductbuy.CrmProductBuyCrForm;
import com.bringspring.crm.model.crmproductbuy.CrmProductBuyInfoVO;
import com.bringspring.crm.model.crmproductbuy.CrmProductBuyListVO;
import com.bringspring.crm.model.crmproductbuy.CrmProductBuyPagination;
import com.bringspring.crm.model.crmproductbuy.CrmProductBuyUpForm;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmProductBuyCategoryService;
import com.bringspring.crm.service.CrmProductBuyService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u4ea7\u54c1\u7ba1\u7406"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductBuy"})
public class CrmProductBuyController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductBuyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductBuyService crmProductBuyService;
    @Autowired
    private CrmProductBuyCategoryService crmProductBuyCategoryService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductBuyPagination crmProductBuyPagination) throws IOException {
        List<CrmProductBuyCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty((Object)crmProductBuyPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductBuyCategoryService.getInfoByParentId(crmProductBuyPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductBuyPagination.getCategoryIdList().addAll(collect);
        }
        crmProductBuyPagination.setCompanyId(this.userProvider.get().getOrganizeId());
        List<CrmProductBuyEntity> list = this.crmProductBuyService.getList(crmProductBuyPagination);
        for (CrmProductBuyEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmProductBuyListVO.class);
        for (CrmProductBuyListVO crmProductBuyVO : listVO) {
            List<CrmProductVersionEntity> listByProductId = this.crmProductVersionService.getListByProductId(crmProductBuyVO.getId());
            List jsonToList = JsonUtil.getJsonToList(listByProductId, CrmProductVersionListVO.class);
            crmProductBuyVO.setVersionList(jsonToList);
        }
        this.selectValues(listVO);
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductBuyPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    private void selectValues(List<CrmProductBuyListVO> outputVo) {
        if (ObjectUtil.isEmpty(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            item.setCategoryName(this.crmProductBuyCategoryService.getInfo(item.getCategoryId()).getName());
            OrganizeEntity info = this.organizeService.getInfo(item.getCompanyId());
            item.setCompanyName(info.getFullName() + "(" + info.getEnCode() + ")");
        });
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductBuyCrForm crmProductBuyCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (!ObjectUtil.isEmpty((Object)crmProductBuyCrForm.getCategoryId())) {
            OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)userInfo.getOrganizeId()));
            crmProductBuyCrForm.setProductCode(this.baseDataUtil.getBillNumber(byId.getEnCode(), Boolean.valueOf(false)));
        } else {
            crmProductBuyCrForm.setProductCode(this.baseDataUtil.getBillNumber("Other", Boolean.valueOf(false)));
        }
        String mainId = RandomUtil.uuId();
        CrmProductBuyEntity entity = (CrmProductBuyEntity)JsonUtil.getJsonToBean((Object)crmProductBuyCrForm, CrmProductBuyEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        CrmProductBuyCategoryEntity byId = (CrmProductBuyCategoryEntity)this.crmProductBuyCategoryService.getById((Serializable)((Object)crmProductBuyCrForm.getCategoryId()));
        if (ObjectUtil.isEmpty((Object)byId) || StrUtil.equals((CharSequence)crmProductBuyCrForm.getCategoryId(), (CharSequence)"1")) {
            CrmProductEntity jsonToBean = (CrmProductEntity)JsonUtil.getJsonToBean((Object)entity, CrmProductEntity.class);
            this.crmProductService.save(jsonToBean);
        } else {
            this.crmProductBuyService.save(entity);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductBuyInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductBuyEntity entity = this.crmProductBuyService.getInfo(id);
        CrmProductBuyInfoVO vo = (CrmProductBuyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductBuyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductBuyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductBuyEntity entity = this.crmProductBuyService.getInfo(id);
        CrmProductBuyInfoVO vo = (CrmProductBuyInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductBuyInfoVO.class);
        this.selectValues(vo);
        return ActionResult.success((Object)vo);
    }

    private void selectValues(CrmProductBuyInfoVO outputVo) {
        if (ObjectUtil.isEmpty((Object)outputVo)) {
            return;
        }
        outputVo.setCategoryName(this.crmProductBuyCategoryService.getInfo(outputVo.getCategoryId()).getName());
        OrganizeEntity info = this.organizeService.getInfo(outputVo.getCompanyId());
        outputVo.setCompanyName(info.getFullName() + "(" + info.getEnCode() + ")");
        outputVo.setCreatorUserName(ObjectUtil.isEmpty((Object)outputVo.getCreatorUserId()) ? null : this.baseDataUtil.userSelectValue(outputVo.getCreatorUserId()));
        outputVo.setCreatorTimeFormat(ObjectUtil.isEmpty((Object)outputVo.getCreatorTime()) ? null : DateUtil.daFormatYmd((Long)outputVo.getCreatorTime()));
        outputVo.setLastModifyUserName(ObjectUtil.isEmpty((Object)outputVo.getLastModifyUserId()) ? null : this.baseDataUtil.userSelectValue(outputVo.getLastModifyUserId()));
        outputVo.setLastModifyTimeFormat(ObjectUtil.isEmpty((Object)outputVo.getLastModifyTime()) ? null : DateUtil.daFormatYmd((Long)outputVo.getLastModifyTime()));
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductBuyUpForm crmProductBuyUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductBuyEntity entity = this.crmProductBuyService.getInfo(id);
        if (entity != null) {
            CrmProductBuyEntity subentity = (CrmProductBuyEntity)JsonUtil.getJsonToBean((Object)crmProductBuyUpForm, CrmProductBuyEntity.class);
            this.crmProductBuyService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductBuyEntity entity = this.crmProductBuyService.getInfo(id);
        if (entity != null) {
            this.crmProductBuyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

