/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmAuthorizationModuleEntity;
import com.bringspring.crm.entity.CrmProductCarryEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryCrForm;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryInfoVO;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryListVO;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryPagination;
import com.bringspring.crm.model.crmproductcarry.CrmProductCarryUpForm;
import com.bringspring.crm.service.CrmAuthorizationModuleService;
import com.bringspring.crm.service.CrmProductCarryService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u5b9e\u65bd\u5468\u671f"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductCarry"})
public class CrmProductCarryController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductCarryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductCarryService crmProductCarryService;
    @Autowired
    private CrmAuthorizationModuleService crmAuthorizationModuleService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductCarryPagination crmProductCarryPagination) throws IOException {
        List<CrmProductCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty(crmProductCarryPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductCategoryService.getInfoByParentId(crmProductCarryPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductCarryPagination.getCategoryIdList().addAll(collect);
        }
        List<CrmProductCarryEntity> list = this.crmProductCarryService.getList(crmProductCarryPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductCarryListVO.class);
        for (CrmProductCarryListVO vo : listVO) {
            vo.setContractType(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
            vo.setHospitalGrade(this.baseDataUtil.getDictName(vo.getHospitalGrade(), "CustomerGrade"));
            CrmAuthorizationModuleEntity info = this.crmAuthorizationModuleService.getInfo(vo.getAuthorizationModule());
            if (!ObjectUtil.isNotEmpty((Object)info)) continue;
            vo.setAuthorizationModuleName(info.getModuleName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductCarryPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid CrmProductCarryCrForm crmProductCarryCrForm) throws DataException {
        Boolean aBoolean = this.crmProductCarryService.create(crmProductCarryCrForm);
        if (aBoolean.booleanValue()) {
            return ActionResult.fail((String)"\u4ea7\u54c1\u6388\u6743\u5468\u671f\u91cd\u590d,\u5fc5\u987b\u8981\u6709\u9ed8\u8ba4\u6570\u636e");
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductCarryInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductCarryEntity entity = this.crmProductCarryService.getInfo(id);
        CrmProductCarryInfoVO vo = (CrmProductCarryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductCarryInfoVO.class);
        ArrayList<String> productList = new ArrayList<String>();
        productList.add(vo.getProductName());
        vo.setProductList(productList);
        ArrayList<Long> timeScope = new ArrayList<Long>();
        timeScope.add(vo.getStartDate().getTime());
        timeScope.add(vo.getEndDate().getTime());
        vo.setTimeScope(timeScope);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductCarryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductCarryEntity entity = this.crmProductCarryService.getInfo(id);
        CrmProductCarryInfoVO vo = (CrmProductCarryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductCarryInfoVO.class);
        ArrayList<String> productList = new ArrayList<String>();
        productList.add(vo.getProductName());
        vo.setProductList(productList);
        ArrayList<Long> timeScope = new ArrayList<Long>();
        timeScope.add(vo.getStartDate().getTime());
        timeScope.add(vo.getEndDate().getTime());
        vo.setTimeScope(timeScope);
        vo.setContractType(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
        vo.setHospitalGrade(this.baseDataUtil.getDictName(vo.getHospitalGrade(), "CustomerGrade"));
        CrmAuthorizationModuleEntity info = this.crmAuthorizationModuleService.getInfo(vo.getAuthorizationModule());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            vo.setAuthorizationModuleName(info.getModuleName());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductCarryUpForm crmProductCarryUpForm) throws DataException {
        Boolean update = this.crmProductCarryService.update(id, crmProductCarryUpForm);
        if (update.booleanValue()) {
            return ActionResult.fail((String)"\u4ea7\u54c1\u6388\u6743\u5468\u671f\u91cd\u590d,\u5fc5\u987b\u8981\u6709\u9ed8\u8ba4\u6570\u636e");
        }
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductCarryEntity entity = this.crmProductCarryService.getInfo(id);
        if (entity != null) {
            this.crmProductCarryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

