/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmproduct.CrmProductInfoVO;
import com.bringspring.crm.model.crmproduct.CrmProductPagination;
import com.bringspring.crm.model.crmproductcategory.CrmProductCategoryCrForm;
import com.bringspring.crm.model.crmproductcategory.CrmProductCategoryInfoVO;
import com.bringspring.crm.model.crmproductcategory.CrmProductCategoryListVO;
import com.bringspring.crm.model.crmproductcategory.CrmProductCategoryPagination;
import com.bringspring.crm.model.crmproductcategory.CrmProductCategoryUpForm;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u5206\u7c7b\u8868"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductCategory"})
public class CrmProductCategoryController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductCategoryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductCategoryPagination crmProductCategoryPagination) throws IOException {
        List<CrmProductCategoryListVO> crmParent = new ArrayList<CrmProductCategoryListVO>();
        if (StringUtil.isEmpty((String)crmProductCategoryPagination.getCompanyId())) {
            List organizeByPartentId = this.organizeService.getListByParentId("1");
            for (OrganizeEntity organizeEntity : organizeByPartentId) {
                CrmProductCategoryListVO infoVo = new CrmProductCategoryListVO();
                infoVo.setId(organizeEntity.getId());
                infoVo.setName(organizeEntity.getFullName() + "(" + organizeEntity.getEnCode() + ")");
                crmParent.add(infoVo);
            }
            if (CollectionUtil.isNotEmpty(crmParent)) {
                List collect = crmParent.stream().filter(e -> StrUtil.equals((CharSequence)e.getId(), (CharSequence)this.userProvider.get().getOrganizeId())).collect(Collectors.toList());
                List collect2 = crmParent.stream().filter(e -> !StrUtil.equals((CharSequence)e.getId(), (CharSequence)this.userProvider.get().getOrganizeId())).collect(Collectors.toList());
                crmParent = CollectionUtil.list((boolean)false);
                crmParent.addAll(collect);
                crmParent.addAll(collect2);
            }
        } else {
            OrganizeEntity organizeEntity = this.organizeService.getInfo(crmProductCategoryPagination.getCompanyId());
            CrmProductCategoryListVO infoVo = new CrmProductCategoryListVO();
            infoVo.setId(organizeEntity.getId());
            infoVo.setName(organizeEntity.getFullName() + "(" + organizeEntity.getEnCode() + ")");
            crmParent.add(infoVo);
        }
        crmProductCategoryPagination.setParent(crmParent.stream().distinct().collect(Collectors.toList()));
        List<CrmProductCategoryEntity> list = this.crmProductCategoryService.getList(crmProductCategoryPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductCategoryListVO.class);
        this.setCategoryTree(crmProductCategoryPagination.getParent(), listVO);
        return ActionResult.success(crmProductCategoryPagination.getParent());
    }

    @PostMapping(value={"/getListAll"})
    public ActionResult listAll(@RequestBody CrmProductCategoryPagination crmProductCategoryPagination) throws IOException {
        List<CrmProductCategoryListVO> crmParent = new ArrayList<CrmProductCategoryListVO>();
        if (StringUtil.isEmpty((String)crmProductCategoryPagination.getCompanyId())) {
            List organizeByPartentId = this.organizeService.getCompanyList(crmProductCategoryPagination.getMenuId());
            organizeByPartentId = organizeByPartentId.stream().filter(x -> StrUtil.equals((CharSequence)x.getParentId(), (CharSequence)"1")).collect(Collectors.toList());
            for (OrganizeEntity organizeEntity : organizeByPartentId) {
                CrmProductCategoryListVO infoVo = new CrmProductCategoryListVO();
                infoVo.setId(organizeEntity.getId());
                infoVo.setName(organizeEntity.getFullName() + "(" + organizeEntity.getEnCode() + ")");
                crmParent.add(infoVo);
            }
            if (CollectionUtil.isNotEmpty(crmParent)) {
                List collect = crmParent.stream().filter(e -> StrUtil.equals((CharSequence)e.getId(), (CharSequence)this.userProvider.get().getOrganizeId())).collect(Collectors.toList());
                List collect2 = crmParent.stream().filter(e -> !StrUtil.equals((CharSequence)e.getId(), (CharSequence)this.userProvider.get().getOrganizeId())).collect(Collectors.toList());
                crmParent = CollectionUtil.list((boolean)false);
                crmParent.addAll(collect);
                crmParent.addAll(collect2);
            }
        } else {
            OrganizeEntity organizeEntity = this.organizeService.getInfo(crmProductCategoryPagination.getCompanyId());
            CrmProductCategoryListVO infoVo = new CrmProductCategoryListVO();
            infoVo.setId(organizeEntity.getId());
            infoVo.setName(organizeEntity.getFullName() + "(" + organizeEntity.getEnCode() + ")");
            crmParent.add(infoVo);
        }
        crmProductCategoryPagination.setParent(crmParent.stream().distinct().collect(Collectors.toList()));
        List<CrmProductCategoryEntity> list = this.crmProductCategoryService.getList(crmProductCategoryPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductCategoryListVO.class);
        this.setCategoryAllTree(crmProductCategoryPagination.getParent(), listVO);
        return ActionResult.success(crmProductCategoryPagination.getParent());
    }

    @PostMapping(value={"/getAllProductList"})
    public ActionResult getAllProductList(@RequestBody CrmProductCategoryPagination crmProductCategoryPagination) throws IOException {
        ArrayList crmParent = new ArrayList();
        List companyList = this.organizeService.getList(null);
        if (!ObjectUtil.isEmpty(companyList = companyList.stream().sorted(Comparator.comparing(PermissionEntityBase::getSortCode)).collect(Collectors.toList()))) {
            companyList.stream().forEach(item -> {
                CrmProductCategoryListVO infoVo = new CrmProductCategoryListVO();
                infoVo.setId(item.getId());
                infoVo.setName(item.getFullName() + "(" + item.getEnCode() + ")");
                crmParent.add(infoVo);
            });
        }
        if (!StrUtil.isBlank((CharSequence)crmProductCategoryPagination.getParentId())) {
            crmProductCategoryPagination.setParent(crmParent.stream().distinct().filter(i -> i.getId().equals(crmProductCategoryPagination.getParentId())).collect(Collectors.toList()));
        } else {
            crmProductCategoryPagination.setParent(crmParent.stream().distinct().collect(Collectors.toList()));
        }
        if (StringUtil.isEmpty((String)crmProductCategoryPagination.getEnabledMark())) {
            crmProductCategoryPagination.setEnabledMark("1");
        }
        List<CrmProductCategoryEntity> list = this.crmProductCategoryService.getList(crmProductCategoryPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductCategoryListVO.class);
        this.setCategoryTree(crmProductCategoryPagination.getParent(), listVO);
        return ActionResult.success(crmProductCategoryPagination.getParent());
    }

    private void setCategoryTree(List<CrmProductCategoryListVO> parent, List<CrmProductCategoryListVO> child) {
        if (ObjectUtil.isEmpty(parent) || ObjectUtil.isEmpty(child)) {
            return;
        }
        parent.stream().forEach(item -> {
            item.setIfParent(true);
            ArrayList children = new ArrayList();
            Integer i = 0;
            while (i < child.size()) {
                if (item.getId().equals(((CrmProductCategoryListVO)child.get(i)).getParentId())) {
                    children.add(child.get(i));
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            item.setChild(children);
        });
    }

    private void setCategoryAllTree(List<CrmProductCategoryListVO> parent, List<CrmProductCategoryListVO> child) {
        if (ObjectUtil.isEmpty(parent) || ObjectUtil.isEmpty(child)) {
            return;
        }
        parent.stream().forEach(item -> {
            item.setIfParent(true);
            ArrayList children = new ArrayList();
            Integer i = 0;
            while (i < child.size()) {
                if (item.getId().equals(((CrmProductCategoryListVO)child.get(i)).getParentId())) {
                    CrmProductPagination crmProductPagination = new CrmProductPagination();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(((CrmProductCategoryListVO)child.get(i)).getId());
                    crmProductPagination.setCategoryIdList(list);
                    List<CrmProductInfoVO> crmProductListVo = this.getCrmProductListVo(crmProductPagination);
                    ArrayList<CrmProductCategoryListVO> categoryListVO = new ArrayList<CrmProductCategoryListVO>();
                    for (CrmProductInfoVO vo : crmProductListVo) {
                        CrmProductCategoryListVO crmProductCategoryListVO = new CrmProductCategoryListVO();
                        crmProductCategoryListVO.setId(vo.getId());
                        crmProductCategoryListVO.setName(vo.getProductName());
                        crmProductCategoryListVO.setParentId(vo.getCategoryId());
                        crmProductCategoryListVO.setSort("0");
                        categoryListVO.add(crmProductCategoryListVO);
                    }
                    ((CrmProductCategoryListVO)child.get(i)).setChild(categoryListVO);
                    children.add(child.get(i));
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            item.setChild(children);
        });
    }

    private List<CrmProductInfoVO> getCrmProductListVo(CrmProductPagination crmProductPagination) {
        List<CrmProductCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty((Object)crmProductPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductCategoryService.getInfoByParentId(crmProductPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductPagination.getCategoryIdList().addAll(collect);
        }
        crmProductPagination.setIsAuth(0);
        crmProductPagination.setDeleteFlag(1);
        List<CrmProductEntity> list = this.crmProductService.getList(crmProductPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductInfoVO.class);
        for (CrmProductInfoVO vo : listVO) {
            vo.setProductId(vo.getId());
            List<CrmProductVersionEntity> listByProductId = this.crmProductVersionService.getListByProductId(vo.getId());
            List jsonToList = JsonUtil.getJsonToList(listByProductId, CrmProductVersionListVO.class);
            vo.setVersionList(jsonToList);
        }
        this.selectValues(listVO);
        return listVO;
    }

    private void selectValues(List<CrmProductInfoVO> outputVo) {
        if (ObjectUtil.isEmpty(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(item.getCategoryId());
            if (Objects.nonNull(entity)) {
                item.setCategoryName(entity.getName());
                String parentId = entity.getParentId();
                OrganizeEntity info = this.organizeService.getInfo(parentId);
                item.setCompanyName(info.getFullName() + "(" + info.getEnCode() + ")");
            }
        });
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductCategoryCrForm crmProductCategoryCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmProductCategoryEntity entity = (CrmProductCategoryEntity)JsonUtil.getJsonToBean((Object)crmProductCategoryCrForm, CrmProductCategoryEntity.class);
        entity.setId(mainId);
        this.crmProductCategoryService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductCategoryInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(id);
        CrmProductCategoryInfoVO vo = (CrmProductCategoryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductCategoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductCategoryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(id);
        CrmProductCategoryInfoVO vo = (CrmProductCategoryInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductCategoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductCategoryUpForm crmProductCategoryUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(id);
        if (entity != null) {
            CrmProductCategoryEntity subentity = (CrmProductCategoryEntity)JsonUtil.getJsonToBean((Object)crmProductCategoryUpForm, CrmProductCategoryEntity.class);
            if ("0".equals(subentity.getEnabledMark())) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.lambda().eq(CrmProductEntity::getCategoryId, (Object)id);
                updateWrapper.lambda().set(CrmProductEntity::getEnabledMark, (Object)0);
                this.crmProductService.update((Wrapper)updateWrapper);
            }
            this.crmProductCategoryService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(id);
        List list = this.crmProductService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductEntity::getCategoryId, (Object)id));
        if (ObjectUtil.isEmpty((Object)list) && !ObjectUtil.isEmpty((Object)entity)) {
            entity.setDeleteFlag(1);
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.crmProductCategoryService.updateById(entity);
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ActionResult.success((String)"fail");
    }

    @PutMapping(value={"/enable/{id}"})
    @DSTransactional
    public ActionResult enable(@PathVariable(value="id") String id) throws DataException {
        CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark("1");
        this.crmProductCategoryService.updateById(entity);
        return ActionResult.success((String)"\u542f\u7528\u6210\u529f");
    }

    @PutMapping(value={"/disabled/{id}"})
    @DSTransactional
    public ActionResult disabled(@PathVariable(value="id") String id) throws DataException {
        CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark("0");
        this.crmProductCategoryService.updateById(entity);
        return ActionResult.success((String)"\u7981\u7528\u6210\u529f");
    }
}

