/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmproduct.CrmCompanyCategoryProductModel;
import com.bringspring.crm.model.crmproduct.CrmCompanyCategoryProductVO;
import com.bringspring.crm.model.crmproduct.CrmProductCrForm;
import com.bringspring.crm.model.crmproduct.CrmProductInfoVO;
import com.bringspring.crm.model.crmproduct.CrmProductListVO;
import com.bringspring.crm.model.crmproduct.CrmProductPagination;
import com.bringspring.crm.model.crmproduct.CrmProductPaginationExportModel;
import com.bringspring.crm.model.crmproduct.CrmProductUpForm;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u7ba1\u7406"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProduct"})
public class CrmProductController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;

    @PostMapping(value={"/getList"})
    @NotCheckLogin
    public ActionResult list(@RequestBody CrmProductPagination crmProductPagination) throws IOException {
        List<CrmProductCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty((Object)crmProductPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductCategoryService.getInfoByParentId(crmProductPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductPagination.getCategoryIdList().addAll(collect);
        }
        List<CrmProductEntity> list = this.crmProductService.getList(crmProductPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductInfoVO.class);
        for (CrmProductInfoVO vo : listVO) {
            vo.setProductId(vo.getId());
            List<CrmProductVersionEntity> listByProductId = this.crmProductVersionService.getListByProductId(vo.getId());
            List jsonToList = JsonUtil.getJsonToList(listByProductId, CrmProductVersionListVO.class);
            vo.setVersionList(jsonToList);
            vo.setVersionNumber(jsonToList.size());
            vo.setEnabledMarkName("1".equals(vo.getEnabledMark()) ? "\u662f" : "\u5426");
        }
        this.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getCusProductList"})
    public ActionResult productList(@RequestBody CrmProductPagination crmProductPagination) throws IOException {
        List<CrmProductCategoryEntity> infoByParentId;
        if (!ObjectUtil.isEmpty((Object)crmProductPagination.getCategoryIdList()) && !ObjectUtil.isEmpty(infoByParentId = this.crmProductCategoryService.getInfoByParentId(crmProductPagination.getCategoryIdList()))) {
            List collect = infoByParentId.stream().map(item -> item.getId()).collect(Collectors.toList());
            crmProductPagination.getCategoryIdList().addAll(collect);
        }
        List<CrmProductEntity> list = this.crmProductService.getCusProductList(crmProductPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductCrForm crmProductCrForm) throws DataException {
        String companyId = this.userProvider.get().getOrganizeId();
        if (!ObjectUtil.isEmpty((Object)crmProductCrForm.getCategoryId())) {
            CrmProductCategoryEntity info = this.crmProductCategoryService.getInfo(crmProductCrForm.getCategoryId());
            companyId = info.getParentId();
            OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)info.getParentId()));
            crmProductCrForm.setProductCode(this.baseDataUtil.getBillNumber(byId.getEnCode(), Boolean.valueOf(false)));
        } else {
            crmProductCrForm.setProductCode(this.baseDataUtil.getBillNumber("Other", Boolean.valueOf(false)));
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmProductEntity entity = (CrmProductEntity)JsonUtil.getJsonToBean((Object)crmProductCrForm, CrmProductEntity.class);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setId(mainId);
        entity.setCompanyId(companyId);
        this.crmProductService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmProductPaginationExportModel crmProductPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmProductPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmProductPagination crmProductPagination = (CrmProductPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmProductPaginationExportModel), CrmProductPagination.class));
        List<CrmProductEntity> list = this.crmProductService.getTypeList(crmProductPagination, crmProductPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, CrmProductListVO.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmProductPaginationExportModel.getSelectKey()) ? crmProductPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "categoryId": {
                        entitys.add(new ExcelExportEntity("\u5206\u7c7bid", (Object)"categoryId"));
                        continue block30;
                    }
                    case "productCode": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u7f16\u7801", (Object)"productCode"));
                        continue block30;
                    }
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u540d\u79f0", (Object)"productName"));
                        continue block30;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u529f\u80fd\u4ecb\u7ecd", (Object)"description"));
                        continue block30;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block30;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block30;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductEntity entity = this.crmProductService.getInfo(id);
        CrmProductInfoVO vo = (CrmProductInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductInfoVO> detailInfo(@PathVariable(value="id") String id) throws DataException {
        CrmProductEntity entity = this.crmProductService.getInfo(id);
        CrmProductInfoVO vo = (CrmProductInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductInfoVO.class);
        this.selectValues(vo);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductUpForm crmProductUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductEntity entity = this.crmProductService.getInfo(id);
        if (entity != null) {
            CrmProductEntity subentity = (CrmProductEntity)JsonUtil.getJsonToBean((Object)crmProductUpForm, CrmProductEntity.class);
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            this.crmProductService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductEntity entity = this.crmProductService.getInfo(id);
        List info = this.crmProductRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(CrmProductRelationEntity::getProductId, (Object)id));
        if (ObjectUtil.isEmpty((Object)info) && !ObjectUtil.isEmpty((Object)entity)) {
            entity.setDeleteFlag(1);
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(DateUtil.getNowDate());
            this.crmProductService.updateById(entity);
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ActionResult.success((String)"fail");
    }

    private void selectValues(List<CrmProductInfoVO> outputVo) {
        if (ObjectUtil.isEmpty(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            CrmProductCategoryEntity entity = this.crmProductCategoryService.getInfo(item.getCategoryId());
            if (Objects.nonNull(entity)) {
                item.setCategoryName(entity.getName());
                String parentId = entity.getParentId();
                OrganizeEntity info = this.organizeService.getInfo(parentId);
                item.setCompanyName(info.getFullName() + "(" + info.getEnCode() + ")");
            }
        });
    }

    private void selectValues(CrmProductInfoVO outputVo) {
        if (ObjectUtil.isEmpty((Object)outputVo)) {
            return;
        }
        outputVo.setCategoryName(this.crmProductCategoryService.getInfo(outputVo.getCategoryId()).getName());
        String parentId = this.crmProductCategoryService.getInfo(outputVo.getCategoryId()).getParentId();
        OrganizeEntity info = this.organizeService.getInfo(parentId);
        outputVo.setCompanyName(info.getFullName() + "(" + info.getEnCode() + ")");
        outputVo.setCreatorUserName(ObjectUtil.isEmpty((Object)outputVo.getCreatorUserId()) ? null : this.baseDataUtil.userSelectValue(outputVo.getCreatorUserId()));
        outputVo.setCreatorTimeFormat(ObjectUtil.isEmpty((Object)outputVo.getCreatorTime()) ? null : DateUtil.daFormatYmd((Long)outputVo.getCreatorTime()));
        outputVo.setLastModifyUserName(ObjectUtil.isEmpty((Object)outputVo.getLastModifyUserId()) ? null : this.baseDataUtil.userSelectValue(outputVo.getLastModifyUserId()));
        outputVo.setLastModifyTimeFormat(ObjectUtil.isEmpty((Object)outputVo.getLastModifyTime()) ? null : DateUtil.daFormatYmd((Long)outputVo.getLastModifyTime()));
    }

    @GetMapping(value={"/getByCompanyAndCategory/{id}/Selector/{leave}"})
    public ActionResult getByCompanyAndCategory(@PathVariable(value="id") String id, @PathVariable(value="leave") String leave, CrmProductPagination crmProductPagination) {
        if (null == crmProductPagination) {
            crmProductPagination = new CrmProductPagination();
        }
        if (StrUtil.isNotBlank((CharSequence)crmProductPagination.getCategoryIdListStr())) {
            crmProductPagination.setCategoryIdList(Arrays.asList(crmProductPagination.getCategoryIdListStr().split(",")));
        }
        if (StrUtil.equals((CharSequence)id, (CharSequence)"0") || StrUtil.equals((CharSequence)leave, (CharSequence)"0")) {
            List allCompanyList = this.organizeService.getAllCompanyList("");
            List collect = allCompanyList.stream().map(org -> {
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)org.getPropertyJson(), OrganizeCrModel.class);
                return new CrmCompanyCategoryProductVO(StrUtil.isBlank((CharSequence)jsonToBean.getShortName()) ? org.getShortName() : jsonToBean.getShortName(), org.getId(), org.getParentId(), false, "company", org.getDescription());
            }).collect(Collectors.toList());
            return ActionResult.success(collect);
        }
        if (StrUtil.equals((CharSequence)leave, (CharSequence)"1")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmProductCategoryEntity::getParentId, (Collection)CollectionUtil.list((boolean)false, (Object[])new String[]{id}));
            queryWrapper.lambda().eq(CrmProductCategoryEntity::getDeleteFlag, (Object)0);
            queryWrapper.lambda().eq(CrmProductCategoryEntity::getEnabledMark, (Object)1);
            if (CollectionUtil.isNotEmpty((Collection)crmProductPagination.getCategoryIdList())) {
                queryWrapper.lambda().in(CrmProductCategoryEntity::getId, (Collection)crmProductPagination.getCategoryIdList());
            }
            List infoByParentId = this.crmProductCategoryService.list((Wrapper)queryWrapper);
            List collect = infoByParentId.stream().map(categoryEntity -> new CrmCompanyCategoryProductVO(categoryEntity.getName(), categoryEntity.getId(), categoryEntity.getParentId(), false, "category", categoryEntity.getDescription())).collect(Collectors.toList());
            return ActionResult.success(collect);
        }
        if (StrUtil.equals((CharSequence)leave, (CharSequence)"2")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(CrmProductEntity::getCategoryId, (Object)id);
            queryWrapper.lambda().eq(CrmProductEntity::getDeleteFlag, (Object)0);
            queryWrapper.lambda().eq(CrmProductEntity::getEnabledMark, (Object)1);
            if (CollectionUtil.isNotEmpty((Collection)crmProductPagination.getCategoryIdList())) {
                queryWrapper.lambda().in(CrmProductEntity::getCategoryId, (Collection)crmProductPagination.getCategoryIdList());
            }
            List listByCategoryId = this.crmProductService.list((Wrapper)queryWrapper);
            List collect = listByCategoryId.stream().map(productEntity -> new CrmCompanyCategoryProductVO(productEntity.getProductName(), productEntity.getId(), productEntity.getCategoryId(), true, "product", productEntity.getDescription())).collect(Collectors.toList());
            return ActionResult.success(collect);
        }
        return ActionResult.success((Object)CollectionUtil.list((boolean)false));
    }

    @PostMapping(value={"/getCompanyAndCategoryInfo"})
    public ActionResult getCompanyAndCategoryInfo(@RequestBody CrmCompanyCategoryProductModel model) {
        LinkedList<List> returnList = new LinkedList<List>();
        ArrayList productList = new ArrayList();
        if (CollectionUtil.isNotEmpty(model.getIdsList())) {
            List<String> ids = model.getIdsList();
            if (CollectionUtil.isEmpty(ids)) {
                returnList.add(CollectionUtil.list((boolean)false));
                return ActionResult.success(returnList);
            }
            ids.stream().forEach(s -> {
                OrganizeEntity organizeEntity;
                CrmProductCategoryEntity categoryEntity;
                String companyId = "";
                String companyName = "";
                String categoryId = "";
                String categoryName = "";
                String productId = s;
                String productName = "";
                CrmProductEntity productEntity = (CrmProductEntity)this.crmProductService.getById((Serializable)((Object)productId));
                if (ObjectUtil.isNotNull((Object)productEntity)) {
                    productName = productEntity.getProductName();
                    categoryId = productEntity.getCategoryId();
                }
                if (StrUtil.isNotEmpty((CharSequence)categoryId) && ObjectUtil.isNotNull((Object)(categoryEntity = (CrmProductCategoryEntity)this.crmProductCategoryService.getById((Serializable)((Object)categoryId))))) {
                    categoryName = categoryEntity.getName();
                    companyId = categoryEntity.getParentId();
                }
                if (StrUtil.isNotEmpty((CharSequence)companyId) && ObjectUtil.isNotNull((Object)(organizeEntity = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)companyId))))) {
                    OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)organizeEntity.getPropertyJson(), OrganizeCrModel.class);
                    companyName = StrUtil.isNotEmpty((CharSequence)jsonToBean.getShortName()) ? jsonToBean.getShortName() : organizeEntity.getShortName();
                }
                List list = CollectionUtil.list((boolean)false, (Object[])new String[]{companyName, categoryName, productName});
                returnList.add(list);
                if ("1".equals(model.getGetProductInfo())) {
                    productList.add(productEntity != null ? productEntity : new CrmProductEntity());
                }
            });
        }
        if ("1".equals(model.getGetProductInfo())) {
            HashMap<String, AbstractList> returnMap = new HashMap<String, AbstractList>();
            returnMap.put("list", returnList);
            returnMap.put("productList", productList);
            return ActionResult.success(returnMap);
        }
        return ActionResult.success(returnList);
    }

    @PutMapping(value={"/enable/{id}"})
    @DSTransactional
    public ActionResult enable(@PathVariable(value="id") String id) throws DataException {
        CrmProductEntity entity = this.crmProductService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark(1);
        this.crmProductService.updateById(entity);
        return ActionResult.success((String)"\u542f\u7528\u6210\u529f");
    }

    @PutMapping(value={"/disabled/{id}"})
    @DSTransactional
    public ActionResult disabled(@PathVariable(value="id") String id) throws DataException {
        CrmProductEntity entity = this.crmProductService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        entity.setEnabledMark(0);
        this.crmProductService.updateById(entity);
        return ActionResult.success((String)"\u7981\u7528\u6210\u529f");
    }
}

