/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductPriceEntity;
import com.bringspring.crm.model.crmproductprice.CrmProductPriceCrForm;
import com.bringspring.crm.model.crmproductprice.CrmProductPriceInfoVO;
import com.bringspring.crm.model.crmproductprice.CrmProductPriceListVO;
import com.bringspring.crm.model.crmproductprice.CrmProductPricePagination;
import com.bringspring.crm.model.crmproductprice.CrmProductPricePaginationExportModel;
import com.bringspring.crm.model.crmproductprice.CrmProductPriceUpForm;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductPriceService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u516c\u53f8\u4ea7\u54c1\u4ef7\u683c\u5e93"}, value="product")
@RequestMapping(value={"/api/product/CrmProductPrice"})
public class CrmProductPriceController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductPriceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductPriceService crmProductPriceService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getListByProductPrice"})
    public ActionResult getListByProductPrice(@RequestBody CrmProductPricePagination crmProductPricePagination) throws IOException {
        List listByProductPrice = this.crmProductPriceService.getListByProductPrice(crmProductPricePagination);
        PageListVO vo = new PageListVO();
        vo.setList(listByProductPrice);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductPricePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductPricePagination crmProductPricePagination) throws IOException {
        List<CrmProductPriceEntity> list = this.crmProductPriceService.getList(crmProductPricePagination);
        List<CrmProductPriceListVO> listVO = this.appendVoList(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductPricePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<CrmProductPriceListVO> appendVoList(List<CrmProductPriceEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, CrmProductPriceListVO.class);
        for (CrmProductPriceListVO crmProductPriceVO : listVO) {
            if (StringUtils.isNotEmpty((String)crmProductPriceVO.getCompanyId())) {
                crmProductPriceVO.setCompanyName(this.organizeService.getInfo(crmProductPriceVO.getCompanyId()).getShortName());
            }
            crmProductPriceVO.setHospitalLevelName(this.baseDataUtil.getDictName(crmProductPriceVO.getHospitalLevel(), "CustomerGradeProduct"));
            crmProductPriceVO.setChannelTypeName(this.baseDataUtil.getDictName(crmProductPriceVO.getChannelType(), "channelType"));
            if (!StrUtil.isBlank((CharSequence)crmProductPriceVO.getProductId())) {
                CrmProductEntity crmProductEntity = this.crmProductService.getInfo(crmProductPriceVO.getProductId());
                crmProductPriceVO.setProductName(ObjectUtil.isEmpty((Object)crmProductEntity) ? "" : crmProductEntity.getProductName());
            }
            if (!StrUtil.isBlank((CharSequence)crmProductPriceVO.getCategoryId())) {
                CrmProductCategoryEntity categoryEntity = this.crmProductCategoryService.getInfo(crmProductPriceVO.getCategoryId());
                crmProductPriceVO.setCategoryName(ObjectUtil.isEmpty((Object)categoryEntity) ? "" : categoryEntity.getName());
            }
            crmProductPriceVO.setIsUnLimitUseName("1".equals(crmProductPriceVO.getIsUnLimitUse()) ? "\u662f" : "\u5426");
        }
        return listVO;
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductPriceCrForm crmProductPriceCrForm) throws DataException {
        CrmProductCategoryEntity categoryEntity;
        String mainId = RandomUtil.uuId();
        CrmProductPriceEntity entity = (CrmProductPriceEntity)JsonUtil.getJsonToBean((Object)crmProductPriceCrForm, CrmProductPriceEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(0);
        if (StringUtils.isNotEmpty((String)entity.getCategoryId()) && null != (categoryEntity = this.crmProductCategoryService.getInfo(entity.getCategoryId()))) {
            entity.setCompanyId(categoryEntity.getParentId());
        }
        if (StringUtils.isEmpty((String)entity.getCompanyId())) {
            entity.setCompanyId(this.userProvider.get().getOrganizeId());
        }
        this.crmProductPriceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmProductPricePaginationExportModel crmProductPricePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmProductPricePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmProductPricePagination crmProductPricePagination = (CrmProductPricePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmProductPricePaginationExportModel), CrmProductPricePagination.class));
        List<CrmProductPriceEntity> list = this.crmProductPriceService.getTypeList(crmProductPricePagination, crmProductPricePaginationExportModel.getDataType());
        List<CrmProductPriceListVO> listVO = this.appendVoList(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmProductPricePaginationExportModel.getSelectKey()) ? crmProductPricePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block42: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u540d\u79f0", (Object)"productName"));
                        continue block42;
                    }
                    case "categoryName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5206\u7c7b", (Object)"categoryName"));
                        continue block42;
                    }
                    case "hospitalLevelName": {
                        entitys.add(new ExcelExportEntity("\u533b\u9662\u7b49\u7ea7", (Object)"hospitalLevelName"));
                        continue block42;
                    }
                    case "channelTypeName": {
                        entitys.add(new ExcelExportEntity("\u6e20\u9053\u7c7b\u578b", (Object)"channelTypeName"));
                        continue block42;
                    }
                    case "suggestPriceScope": {
                        entitys.add(new ExcelExportEntity("\u5efa\u8bae\u4ef7\u683c\u8303\u56f4", (Object)"suggestPriceScope"));
                        continue block42;
                    }
                    case "oneAgentPrice": {
                        entitys.add(new ExcelExportEntity("\u4e00\u7ea7\u4ee3\u7406\u4ef7(\u5143)", (Object)"oneAgentPrice"));
                        continue block42;
                    }
                    case "agentPrice": {
                        entitys.add(new ExcelExportEntity("\u6e20\u9053\u4ef7\u683c(\u5143)", (Object)"agentPrice"));
                        continue block42;
                    }
                    case "ceilingPrice": {
                        entitys.add(new ExcelExportEntity("\u6700\u9ad8\u4ef7\u683c(\u5143)", (Object)"ceilingPrice"));
                        continue block42;
                    }
                    case "floorPrice": {
                        entitys.add(new ExcelExportEntity("\u6700\u4f4e\u4ef7\u683c(\u5143)", (Object)"floorPrice"));
                        continue block42;
                    }
                    case "standardPrice": {
                        entitys.add(new ExcelExportEntity("\u6807\u51c6\u4ef7\u683c(\u5143)", (Object)"standardPrice"));
                        continue block42;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block42;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block42;
                    }
                    case "isUnLimitUseName": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u65e0\u671f\u9650\u751f\u6548", (Object)"isUnLimitUseName"));
                        continue block42;
                    }
                    case "activeStartTime": {
                        entitys.add(new ExcelExportEntity("\u751f\u6548\u5f00\u59cb\u65e5\u671f", (Object)"activeStartTime"));
                        continue block42;
                    }
                    case "activeEndTime": {
                        entitys.add(new ExcelExportEntity("\u751f\u6548\u7ed3\u675f\u65e5\u671f", (Object)"activeEndTime"));
                        continue block42;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams("", "\u4e2d\u95f4\u5546\u4ef7\u683c\u5e93");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u4e2d\u95f4\u5546\u4ef7\u683c\u5e93" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Throwable)e);
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductPriceInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductPriceEntity entity = this.crmProductPriceService.getInfo(id);
        CrmProductPriceInfoVO vo = (CrmProductPriceInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductPriceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductPriceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductPriceEntity entity = this.crmProductPriceService.getInfo(id);
        CrmProductPriceInfoVO vo = (CrmProductPriceInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductPriceInfoVO.class);
        vo.setHospitalLevelName(this.baseDataUtil.getDictName(vo.getHospitalLevel(), "CustomerGradeProduct"));
        vo.setChannelTypeName(this.baseDataUtil.getDictName(vo.getChannelType(), "channelType"));
        if (!StrUtil.isBlank((CharSequence)vo.getProductId())) {
            CrmProductEntity crmProductEntity = this.crmProductService.getInfo(vo.getProductId());
            vo.setProductName(ObjectUtil.isEmpty((Object)crmProductEntity) ? "" : crmProductEntity.getProductName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getCategoryId())) {
            CrmProductCategoryEntity categoryEntity = this.crmProductCategoryService.getInfo(vo.getCategoryId());
            vo.setCategoryName(ObjectUtil.isEmpty((Object)categoryEntity) ? "" : categoryEntity.getName());
        }
        vo.setIsUnLimitUseName("1".equals(vo.getIsUnLimitUse()) ? "\u662f" : "\u5426");
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductPriceUpForm crmProductPriceUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductPriceEntity entity = this.crmProductPriceService.getInfo(id);
        if (entity != null) {
            CrmProductPriceEntity subentity = (CrmProductPriceEntity)JsonUtil.getJsonToBean((Object)crmProductPriceUpForm, CrmProductPriceEntity.class);
            this.crmProductPriceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductPriceEntity entity = this.crmProductPriceService.getInfo(id);
        if (entity != null) {
            this.crmProductPriceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

