/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.crm.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.entity.CrmProductQuoteEntity;
import com.bringspring.crm.model.crmproductquote.CrmProductQuoteCrForm;
import com.bringspring.crm.model.crmproductquote.CrmProductQuoteInfoVO;
import com.bringspring.crm.model.crmproductquote.CrmProductQuoteListVO;
import com.bringspring.crm.model.crmproductquote.CrmProductQuotePagination;
import com.bringspring.crm.model.crmproductquote.CrmProductQuotePaginationExportModel;
import com.bringspring.crm.model.crmproductquote.CrmProductQuoteUpForm;
import com.bringspring.crm.service.CrmProductQuoteService;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ea7\u54c1\u62a5\u4ef7"}, value="crm")
@RequestMapping(value={"/api/crm/CrmProductQuote"})
public class CrmProductQuoteController {
    private static final Logger log = LoggerFactory.getLogger(CrmProductQuoteController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmProductQuoteService crmProductQuoteService;
    @Autowired
    private SelectValues selectValues;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmProductQuotePagination crmProductQuotePagination) throws IOException {
        List<CrmProductQuoteEntity> list = this.crmProductQuoteService.getList(crmProductQuotePagination);
        List listVO = JsonUtil.getJsonToList(list, CrmProductQuoteListVO.class);
        for (CrmProductQuoteListVO crmProductQuoteListVO : listVO) {
            if (ObjectUtil.isEmpty((Object)crmProductQuoteListVO.getProductSpecs())) continue;
            crmProductQuoteListVO.setProductSpecs(this.baseDataUtil.getDictName(crmProductQuoteListVO.getProductSpecs(), "380735551013168837"));
            crmProductQuoteListVO.setProductNameShow(this.selectValues.proSelectValues(crmProductQuoteListVO.getProductName()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmProductQuotePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/calculateQuote"})
    public ActionResult calculateQuote(@RequestBody CrmProductQuotePagination crmProductQuotePagination) throws IOException {
        CrmProductQuoteEntity crmProductQuoteEntity = this.crmProductQuoteService.calculateQuote(crmProductQuotePagination);
        CrmProductQuoteListVO jsonToBean = (CrmProductQuoteListVO)JsonUtil.getJsonToBean((Object)crmProductQuoteEntity, CrmProductQuoteListVO.class);
        return ActionResult.success((Object)jsonToBean);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmProductQuoteCrForm crmProductQuoteCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmProductQuoteEntity entity = (CrmProductQuoteEntity)JsonUtil.getJsonToBean((Object)crmProductQuoteCrForm, CrmProductQuoteEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(DateUtil.getNowDate());
        this.crmProductQuoteService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmProductQuotePaginationExportModel crmProductQuotePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)crmProductQuotePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        CrmProductQuotePagination crmProductQuotePagination = (CrmProductQuotePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmProductQuotePaginationExportModel), CrmProductQuotePagination.class));
        List<CrmProductQuoteEntity> list = this.crmProductQuoteService.getTypeList(crmProductQuotePagination, crmProductQuotePaginationExportModel.getDataType());
        for (CrmProductQuoteEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, CrmProductQuoteListVO.class);
        for (CrmProductQuoteListVO crmProductQuoteListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)crmProductQuotePaginationExportModel.getSelectKey()) ? crmProductQuotePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block14: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "saleId": {
                        entitys.add(new ExcelExportEntity("\u5546\u673aid", (Object)"saleId"));
                        continue block14;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmProductQuoteInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductQuoteEntity entity = this.crmProductQuoteService.getInfo(id);
        CrmProductQuoteInfoVO vo = (CrmProductQuoteInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductQuoteInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmProductQuoteInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmProductQuoteEntity entity = this.crmProductQuoteService.getInfo(id);
        CrmProductQuoteInfoVO vo = (CrmProductQuoteInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmProductQuoteInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmProductQuoteUpForm crmProductQuoteUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmProductQuoteEntity entity = this.crmProductQuoteService.getInfo(id);
        if (entity != null) {
            CrmProductQuoteEntity subentity = (CrmProductQuoteEntity)JsonUtil.getJsonToBean((Object)crmProductQuoteUpForm, CrmProductQuoteEntity.class);
            this.crmProductQuoteService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmProductQuoteEntity entity = this.crmProductQuoteService.getInfo(id);
        if (entity != null) {
            this.crmProductQuoteService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

